#
# Boilerplate for building and installing a library in its various forms.
#
# Requires the following variables defined on entry:
#
#   LIB_NAME		= foo
#   LIB_VERSION		= 3.0.2
#   LIB_OBJS		= foomain.obj bar.obj baz.obj
#   LIB_IMPORTS		= omnithread$(OMNITHREAD_FILE_VERSION)\
#	omniorb$(OMNIORB_FILE_VERSION)
#
# This produces a static library called foo3.olb and a
# shared library called foo3_rt.exe.
#
# If LIB_OBJS is not defined then LIB_OBJ will be defined by
# converting $(CXXSRCS) to a list of object files of the form *.obj
# (without any dirspec).  Note that $(CXXSRCS) is required to use VMS
# file naming conventions.
#
# $(LIB_OBJS_0) through $(LIB_OBJS_9) are provided for because of MMS
# limitations.

.if .not LIB_OBJS

LIB_OBJS  =$(foreach f,$(basename $(notdir $(CXXSRCS))),$(f).obj )
LIB_OBJS_0=$(foreach f,$(basename $(notdir $(CXXSRCS_0))),$(f).obj )
LIB_OBJS_1=$(foreach f,$(basename $(notdir $(CXXSRCS_1))),$(f).obj )
LIB_OBJS_2=$(foreach f,$(basename $(notdir $(CXXSRCS_2))),$(f).obj )
LIB_OBJS_3=$(foreach f,$(basename $(notdir $(CXXSRCS_3))),$(f).obj )
LIB_OBJS_4=$(foreach f,$(basename $(notdir $(CXXSRCS_4))),$(f).obj )
LIB_OBJS_5=$(foreach f,$(basename $(notdir $(CXXSRCS_5))),$(f).obj )
LIB_OBJS_6=$(foreach f,$(basename $(notdir $(CXXSRCS_6))),$(f).obj )
LIB_OBJS_7=$(foreach f,$(basename $(notdir $(CXXSRCS_7))),$(f).obj )
LIB_OBJS_8=$(foreach f,$(basename $(notdir $(CXXSRCS_8))),$(f).obj )
LIB_OBJS_9=$(foreach f,$(basename $(notdir $(CXXSRCS_9))),$(f).obj )

.endif

tuple=$(subst ., ,$(LIB_VERSION))
major=$(word 1,$(tuple))
minor=$(word 2,$(tuple))
micro=$(word 3,$(tuple))

filename=$(LIB_NAME)$(major)

staticlib = $(CONFIG_DIR)/$(filename)$(CONFIG_SUFFIX).olb
staticlib_V = $(CONFIG_DIR_V)$(filename)$(CONFIG_SUFFIX).olb

.if USE_SHAREABLE_IMAGES

.if BUILD_PYTHON_MODULE

# Experimental results indicate that Python modules that are
# implemented as shareable images on VMS must be named MODULE.exe and
# a logical name python_module_MODULE must be defined that is
# translated as the full path to MODULE.exe.  For example, in order to
# be able to 'import _omnipy' from Python, the shareable image must be
# named _omnipy.exe and a DCL 'define python_module__omnipy
# omnilib:_omnipy.exe' should be performed.  It is not necessary to
# install the shareable image as the Python for OpenVMS documentation
# seems to indicate.

shlib_name = $(LIB_NAME)$(CONFIG_SUFFIX).exe

.else

shlib_name = $(filename)$(ShareableImageSuffix).exe

.endif

shlib = $(CONFIG_DIR)/$(shlib_name)
shlib_V = $(CONFIG_DIR_V)$(shlib_name)
ExportShareableImage=omnilib:$(shlib_name)
.endif

all :: $(staticlib_V) $(shlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

$(staticlib_V) : $(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_0))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_1))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_2))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_3))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_4))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_5))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_6))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_7))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_8))\
	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_9))
	$(VERBOSITY) if f$search("$@").eqs."" then libr/create/log $@
	$(VERBOSITY) library/replace $@ $(CONFIG_DIR_V)*.obj

export :: $(ExportShareableImage)
	! !default export action!
	$(VERBOSITY) $(CONFIG_RECURSE_)

clean ::
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.obj
	$(VERBOSITY) $(RM) $(staticlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

veryclean ::
	$(VERBOSITY) $(RM) $(CONFIG_DIR_V)*.obj
	$(VERBOSITY) $(RM) $(staticlib_V)
	$(VERBOSITY) $(CONFIG_RECURSE_)

##############################################################################
# Build Shared library
##############################################################################

.ifdef LIB_IMPORTS
shares=$(foreach lib,$(LIB_IMPORTS),$(lib)$(ShareableImageSuffix) )
empty=
space=$(empty) $(empty)
comma=,

OBJ_LIBS=$(OMNIORB_SHAREDLIB)/include=($(subst $(space),$(comma),$(strip $(shares))))\
 $(DIR_OBJ_LIBS)

OBJ_LIBS_DEPEND=$(foreach lib,$(LIB_IMPORTS),\
$(LIBPATH_V)$(lib)$(ShareableImageSuffix).exe )\
 $(DIR_LIBS_DEPEND)

.endif

$(shlib_V) : $(staticlib_V) $(OBJ_LIBS_DEPEND)
	$(VERBOSITY) $(CxxShareableImage)


$(ExportShareableImage) : $(shlib_V)
	$(VERBOSITY) $(ExportShareable)

show ::
	! staticlib_V=$(staticlib_V)
	! USE_SHAREABLE_IMAGES=$(USE_SHAREABLE_IMAGES)
	! BUILD_PYTHON_MODULE=$(BUILD_PYTHON_MODULE)
	! shlib_name=$(shlib_name)
	! shlib=$(shlib)
	! shlib_V=$(shlib_V)
	! CONFIG_DIR=$(CONFIG_DIR)
	! CONFIG_DIR_V=$(CONFIG_DIR_V)
	! shares=$(shares)
	! OBJ_LIBS=$(OBJ_LIBS)
	! OBJ_LIBS_DEPEND=$(OBJ_LIBS_DEPEND)
	! LIB_OBJS=$(LIB_OBJS)
	! LIB_OBJS_0=$(LIB_OBJS_0)
	! LIB_OBJS_1=$(LIB_OBJS_1)
	! LIB_OBJS_2=$(LIB_OBJS_2)
	! LIB_OBJS_3=$(LIB_OBJS_3)
	! LIB_OBJS_4=$(LIB_OBJS_4)
	! LIB_OBJS_5=$(LIB_OBJS_5)
	! LIB_OBJS_6=$(LIB_OBJS_6)
	! LIB_OBJS_7=$(LIB_OBJS_7)
	! LIB_OBJS_8=$(LIB_OBJS_8)
	! LIB_OBJS_9=$(LIB_OBJS_9)
	! $(staticlib_V) : $(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_0))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_1))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_2))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_3))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_4))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_5))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_6))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_7))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_8))
	!	$(patsubst *, $(CONFIG_DIR_V)*, $(LIB_OBJS_9))
	! $(shlib_V) : $(staticlib_V) $(OBJ_LIBS_DEPEND)
	! 	$(VERBOSITY) $(CxxShareableImage)
