// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef EXPRESSIONLIST_H
#define EXPRESSIONLIST_H
#include <state_exports.h>
#include <AttributeSubject.h>
#include <vector>

class Expression;

// ****************************************************************************
// Class: ExpressionList
//
// Purpose:
//    This class contains a list of expressions and some functions to manipulate them.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ExpressionList : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ExpressionList();
    ExpressionList(const ExpressionList &obj);
protected:
    // These constructors are for objects derived from this class
    ExpressionList(private_tmfs_t tmfs);
    ExpressionList(const ExpressionList &obj, private_tmfs_t tmfs);
public:
    virtual ~ExpressionList();

    virtual ExpressionList& operator = (const ExpressionList &obj);
    virtual bool operator == (const ExpressionList &obj) const;
    virtual bool operator != (const ExpressionList &obj) const;
private:
    void Init();
    void Copy(const ExpressionList &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectExpressions();

    // Property setting methods

    // Property getting methods
    const AttributeGroupVector &GetExpressions() const;
          AttributeGroupVector &GetExpressions();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Attributegroup convenience methods
    void AddExpressions(const Expression &);
    void ClearExpressions();
    void RemoveExpressions(int i);
    int  GetNumExpressions() const;
    Expression &GetExpressions(int i);
    Expression const &GetExpressions(int i) const;

    Expression &operator [] (int i);
    Expression const &operator [] (int i) const;


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    Expression const *operator[](const char *) const;
    Expression *operator[](const char *);
    const stringVector GetAllVarNames(const std::string &dbN) const;
    unsigned int GetHashVal() const;
    int IndexOf(const char *) const;
    virtual void SortExpressions(void);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_expressions = 0,
        ID__LAST
    };

protected:
    AttributeGroup *CreateSubAttributeGroup(int index);
private:
    AttributeGroupVector expressions;

    void SortNameHash(void) const;
    void resetMe(void) const;
    // Accleration structures can change in const methods
    mutable std::vector<std::pair<unsigned int, size_t> > sortedNameHash;
    mutable bool sortedNameHashNeedsSorting;
    mutable unsigned int myHashVal;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define EXPRESSIONLIST_TMFS "a*"

#endif
