// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SILARRAYATTRIBUTES_H
#define SILARRAYATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>

#include <NameschemeAttributes.h>

// ****************************************************************************
// Class: SILArrayAttributes
//
// Purpose:
//    This class contain the information needed to represent a SIL Array.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SILArrayAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SILArrayAttributes();
    SILArrayAttributes(const SILArrayAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SILArrayAttributes(private_tmfs_t tmfs);
    SILArrayAttributes(const SILArrayAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SILArrayAttributes();

    virtual SILArrayAttributes& operator = (const SILArrayAttributes &obj);
    virtual bool operator == (const SILArrayAttributes &obj) const;
    virtual bool operator != (const SILArrayAttributes &obj) const;
private:
    void Init();
    void Copy(const SILArrayAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectPrefix();
    void SelectCategory();
    void SelectNames();
    void SelectNamescheme();

    // Property setting methods
    void SetPrefix(const std::string &prefix_);
    void SetNumSets(int numSets_);
    void SetFirstSetName(int firstSetName_);
    void SetUseUniqueIDs(bool useUniqueIDs_);
    void SetFirstSet(int firstSet_);
    void SetColIndex(int colIndex_);
    void SetCategory(const std::string &category_);
    void SetRole(int role_);
    void SetColParent(int colParent_);
    void SetNames(const stringVector &names_);
    void SetNamescheme(const NameschemeAttributes &namescheme_);

    // Property getting methods
    const std::string          &GetPrefix() const;
          std::string          &GetPrefix();
    int                        GetNumSets() const;
    int                        GetFirstSetName() const;
    bool                       GetUseUniqueIDs() const;
    int                        GetFirstSet() const;
    int                        GetColIndex() const;
    const std::string          &GetCategory() const;
          std::string          &GetCategory();
    int                        GetRole() const;
    int                        GetColParent() const;
    const stringVector         &GetNames() const;
          stringVector         &GetNames();
    const NameschemeAttributes &GetNamescheme() const;
          NameschemeAttributes &GetNamescheme();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_prefix = 0,
        ID_numSets,
        ID_firstSetName,
        ID_useUniqueIDs,
        ID_firstSet,
        ID_colIndex,
        ID_category,
        ID_role,
        ID_colParent,
        ID_names,
        ID_namescheme,
        ID__LAST
    };

private:
    std::string          prefix;
    int                  numSets;
    int                  firstSetName;
    bool                 useUniqueIDs;
    int                  firstSet;
    int                  colIndex;
    std::string          category;
    int                  role;
    int                  colParent;
    stringVector         names;
    NameschemeAttributes namescheme;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SILARRAYATTRIBUTES_TMFS "siibiisiis*a"

#endif
