// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef VIEWCURVEATTRIBUTES_H
#define VIEWCURVEATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ViewCurveAttributes
//
// Purpose:
//    This class contains the curve view attributes.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API ViewCurveAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    ViewCurveAttributes();
    ViewCurveAttributes(const ViewCurveAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ViewCurveAttributes(private_tmfs_t tmfs);
    ViewCurveAttributes(const ViewCurveAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ViewCurveAttributes();

    virtual ViewCurveAttributes& operator = (const ViewCurveAttributes &obj);
    virtual bool operator == (const ViewCurveAttributes &obj) const;
    virtual bool operator != (const ViewCurveAttributes &obj) const;
private:
    void Init();
    void Copy(const ViewCurveAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectDomainCoords();
    void SelectRangeCoords();
    void SelectViewportCoords();

    // Property setting methods
    void SetDomainCoords(const double *domainCoords_);
    void SetRangeCoords(const double *rangeCoords_);
    void SetViewportCoords(const double *viewportCoords_);
    void SetDomainScale(int domainScale_);
    void SetRangeScale(int rangeScale_);

    // Property getting methods
    const double *GetDomainCoords() const;
          double *GetDomainCoords();
    const double *GetRangeCoords() const;
          double *GetRangeCoords();
    const double *GetViewportCoords() const;
          double *GetViewportCoords();
    int          GetDomainScale() const;
    int          GetRangeScale() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_domainCoords = 0,
        ID_rangeCoords,
        ID_viewportCoords,
        ID_domainScale,
        ID_rangeScale,
        ID__LAST
    };

private:
    double domainCoords[2];
    double rangeCoords[2];
    double viewportCoords[4];
    int    domainScale;
    int    rangeScale;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define VIEWCURVEATTRIBUTES_TMFS "DDDii"

#endif
