#!/usr/bin/env bash

set -e
set -x
shopt -s dotglob

readonly name="visit"
readonly ownership="VisIt Upstream <kwrobot@kitware.com>"
readonly subtree="Library/VisItLib"
readonly repo="https://gitlab.kitware.com/third-party/visit.git"
readonly tag="for/paraview-20220727-g756b0aa4ee"

readonly paths="
.gitattributes
README.kitware.md
src/CMakeLists.paraview.txt

src/CMake/testFStream.cxx
src/CMake/TestSocklenT.c
src/CMake/VisItCommon.cmake

src/avt/Database/Database/avtDatabase.*
src/avt/Database/Database/avtDatabaseFactory.*
src/avt/Database/Database/avtDatasetCollection.*
src/avt/Database/Database/avtDatasetDatabase.*
src/avt/Database/Database/avtFileDescriptorManager.*
src/avt/Database/Database/avtGenericDatabase.*
src/avt/Database/Database/avtIOInformation.*
src/avt/Database/Database/avtSILGenerator.*
src/avt/Database/Database/avtSourceFromDatabase.*
src/avt/Database/Database/avtTransformManager.*
src/avt/Database/Database/avtVariableCache.*
src/avt/Database/Database/database_exports.h
src/avt/Database/Ghost/StructuredBoundary.C
src/avt/Database/Ghost/avtDomainBoundaries.*
src/avt/Database/Ghost/avtDomainNesting.h
src/avt/Database/Ghost/avtIsenburgSGG.*
src/avt/Database/Ghost/avtLocalStructuredDomainBoundaries.*
src/avt/Database/Ghost/avtNekDomainBoundaries.*
src/avt/Database/Ghost/avtStreamingGhostGenerator.*
src/avt/Database/Ghost/avtStructuredDomainBoundaries.*
src/avt/Database/Ghost/avtStructuredDomainNesting.*
src/avt/Database/Ghost/avtUnstructuredDomainBoundaries.*
src/avt/Database/Ghost/avtUnstructuredPointBoundaries.*
src/avt/Database/Formats/avtMTMDFileFormat.*
src/avt/Database/Formats/avtSTMDFileFormat.h
src/avt/Database/Formats/avtSTSDFileFormatInterface.h
src/avt/Database/Formats/avtSTMDFileFormatInterface.h
src/avt/Database/Formats/avtMTMDFileFormatInterface.*
src/avt/Database/Formats/avtFileFormat.*
src/avt/Database/Formats/avtSTMDFileFormatInterface.*
src/avt/Database/Formats/avtSTSDFileFormat.h
src/avt/Database/Formats/avtMTSDFileFormat.*
src/avt/Database/Formats/avtSTSDFileFormatInterface.*
src/avt/Database/Formats/avtFileFormat.h
src/avt/Database/Formats/avtMTMDFileFormat.h
src/avt/Database/Formats/avtMTSDFileFormatInterface.*
src/avt/Database/Formats/avtMTSDFileFormatInterface.h
src/avt/Database/Formats/avtSTSDFileFormat.*
src/avt/Database/Formats/avtMTMDFileFormatInterface.h
src/avt/Database/Formats/avtFileFormatInterface.*
src/avt/Database/Formats/avtSTMDFileFormat.*
src/avt/Database/Formats/avtFileFormatInterface.h
src/avt/Database/Formats/avtMTSDFileFormat.h
src/avt/Database/CMakeLists.txt

src/avt/DBAtts/SIL/avtSIL.*
src/avt/DBAtts/SIL/avtSILArray.*
src/avt/DBAtts/SIL/avtSILCollection.*
src/avt/DBAtts/SIL/avtSILEnumeratedNamespace.*
src/avt/DBAtts/SIL/avtSILMatrix.*
src/avt/DBAtts/SIL/avtSILNamespace.*
src/avt/DBAtts/SIL/avtSILRangeNamespace.*
src/avt/DBAtts/SIL/avtSILRestriction.*
src/avt/DBAtts/SIL/avtSILRestrictionTraverser.*
src/avt/DBAtts/SIL/avtSILSet.*
src/avt/DBAtts/MetaData/avtArrayMetaData.*
src/avt/DBAtts/MetaData/avtBaseVarMetaData.*
src/avt/DBAtts/MetaData/avtCurveMetaData.*
src/avt/DBAtts/MetaData/avtDatabaseMetaData.*
src/avt/DBAtts/MetaData/avtDefaultPlotMetaData.*
src/avt/DBAtts/MetaData/avtExpressionTypeConversions.*
src/avt/DBAtts/MetaData/avtLabelMetaData.*
src/avt/DBAtts/MetaData/avtMatSpeciesMetaData.*
src/avt/DBAtts/MetaData/avtMaterialMetaData.*
src/avt/DBAtts/MetaData/avtMeshMetaData.*
src/avt/DBAtts/MetaData/avtScalarMetaData.*
src/avt/DBAtts/MetaData/avtSimulationCommandSpecification.*
src/avt/DBAtts/MetaData/avtSimulationInformation.*
src/avt/DBAtts/MetaData/avtSpeciesMetaData.*
src/avt/DBAtts/MetaData/avtSubsetsMetaData.*
src/avt/DBAtts/MetaData/avtSymmetricTensorMetaData.*
src/avt/DBAtts/MetaData/avtTensorMetaData.*
src/avt/DBAtts/MetaData/avtTypes.*
src/avt/DBAtts/MetaData/avtVarMetaData.*
src/avt/DBAtts/MetaData/avtVectorMetaData.*
src/avt/DBAtts/MetaData/dbatts_exports.h
src/avt/DBAtts/CMakeLists.txt

src/avt/Math/avtMatrix.*
src/avt/Math/avtMatrix.h
src/avt/Math/avtPolynomial.*
src/avt/Math/avtVector.*
src/avt/Math/math_exports.h
src/avt/Math/CMakeLists.txt

src/avt/Pipeline/Pipeline/ThreadPool.*
src/avt/Pipeline/Pipeline/avtContract.*
src/avt/Pipeline/Pipeline/avtDataObjectReader.*
src/avt/Pipeline/Pipeline/avtDataObjectString.*
src/avt/Pipeline/Pipeline/avtDataObjectWriter.*
src/avt/Pipeline/Pipeline/avtDataRequest.*
src/avt/Pipeline/Pipeline/avtDataSetReader.*
src/avt/Pipeline/Pipeline/avtDataSetWriter.*
src/avt/Pipeline/Pipeline/avtDebugDumpOptions.*
src/avt/Pipeline/Pipeline/avtExecutionManager.*
src/avt/Pipeline/Pipeline/avtImageReader.*
src/avt/Pipeline/Pipeline/avtImageWriter.*
src/avt/Pipeline/Pipeline/avtMemory.*
src/avt/Pipeline/Pipeline/avtNamedSelection.*
src/avt/Pipeline/Pipeline/avtNamedSelectionExtension.*
src/avt/Pipeline/Pipeline/avtNamedSelectionManager.*
src/avt/Pipeline/Pipeline/avtNullDataReader.*
src/avt/Pipeline/Pipeline/avtNullDataWriter.*
src/avt/Pipeline/Pipeline/avtParallel.*
src/avt/Pipeline/Pipeline/avtParallelContext.*
src/avt/Pipeline/Pipeline/avtWebpage.*
src/avt/Pipeline/Sinks/avtDataObjectSink.*
src/avt/Pipeline/Sinks/avtDatabaseWriter.*
src/avt/Pipeline/Sinks/avtDatasetSink.*
src/avt/Pipeline/Sinks/avtImageSink.*
src/avt/Pipeline/Sinks/avtMultipleInputSink.*
src/avt/Pipeline/Sinks/avtNullDataSink.*
src/avt/Pipeline/Sinks/avtTerminatingDatasetSink.*
src/avt/Pipeline/Sinks/avtTerminatingImageSink.*
src/avt/Pipeline/Sinks/avtTerminatingNullDataSink.*
src/avt/Pipeline/Sinks/avtTerminatingSink.*
src/avt/Pipeline/Data/avtCallback.*
src/avt/Pipeline/Data/avtCommonDataFunctions.*
src/avt/Pipeline/Data/avtDataAttributes.*
src/avt/Pipeline/Data/avtDataObject.*
src/avt/Pipeline/Data/avtDataObjectInformation.*
src/avt/Pipeline/Data/avtDataRepresentation.*
src/avt/Pipeline/Data/avtDataSelection.h
src/avt/Pipeline/Data/avtDataTree.*
src/avt/Pipeline/Data/avtDataValidity.*
src/avt/Pipeline/Data/avtDataset.*
src/avt/Pipeline/Data/avtDatasetExaminer.*
src/avt/Pipeline/Data/avtDatasetVerifier.*
src/avt/Pipeline/Data/avtDynamicAttribute.*
src/avt/Pipeline/Data/avtExtents.*
src/avt/Pipeline/Data/avtFacelist.*
src/avt/Pipeline/Data/avtGhostData.h
src/avt/Pipeline/Data/avtHistogramSpecification.*
src/avt/Pipeline/Data/avtIdentifierSelection.*
src/avt/Pipeline/Data/avtImage.*
src/avt/Pipeline/Data/avtImageRepresentation.*
src/avt/Pipeline/Data/avtIntervalTree.*
src/avt/Pipeline/Data/avtIsolevelsSelection.*
src/avt/Pipeline/Data/avtLogicalSelection.*
src/avt/Pipeline/Data/avtMaterial.*
src/avt/Pipeline/Data/avtMetaData.*
src/avt/Pipeline/Data/avtMixedVariable.*
src/avt/Pipeline/Data/avtMultiresSelection.*
src/avt/Pipeline/Data/avtNullData.*
src/avt/Pipeline/Data/avtPlaneSelection.*
src/avt/Pipeline/Data/avtPointSelection.*
src/avt/Pipeline/Data/avtResampleSelection.*
src/avt/Pipeline/Data/avtResolutionSelection.*
src/avt/Pipeline/Data/avtSpatialBoxSelection.*
src/avt/Pipeline/Data/avtSpecies.*
src/avt/Pipeline/Data/pipeline_exports.h
src/avt/Pipeline/Sources/avtDataObjectSource.*
src/avt/Pipeline/Sources/avtDatasetSource.*
src/avt/Pipeline/Sources/avtImageSource.*
src/avt/Pipeline/Sources/avtInlinePipelineSource.*
src/avt/Pipeline/Sources/avtNullDataSource.*
src/avt/Pipeline/Sources/avtOriginatingDatasetSource.*
src/avt/Pipeline/Sources/avtOriginatingImageSource.*
src/avt/Pipeline/Sources/avtOriginatingNullDataSource.*
src/avt/Pipeline/Sources/avtOriginatingSource.*
src/avt/Pipeline/Sources/avtQueryableSource.*
src/avt/Pipeline/Sources/avtSourceFromAVTDataset.*
src/avt/Pipeline/CMakeLists.txt
src/avt/Pipeline/AbstractFilters/avtCompactTreeFilter.*
src/avt/Pipeline/AbstractFilters/avtDataObjectToDatasetFilter.*
src/avt/Pipeline/AbstractFilters/avtDataTreeIterator.*
src/avt/Pipeline/AbstractFilters/avtDatasetToDataObjectFilter.*
src/avt/Pipeline/AbstractFilters/avtDatasetToDatasetFilter.*
src/avt/Pipeline/AbstractFilters/avtFacadeFilter.*
src/avt/Pipeline/AbstractFilters/avtFilter.*
src/avt/Pipeline/AbstractFilters/avtPluginFilter.h
src/avt/Pipeline/AbstractFilters/avtPluginSIMODataTreeIterator.h
src/avt/Pipeline/AbstractFilters/avtPluginStructuredChunkDataTreeIterator.*
src/avt/Pipeline/AbstractFilters/avtSIMODataTreeIterator.*

src/avt/VisWindow/VisWindow/VisWindowTypes.h

src/avt/CMakeLists.txt

src/common/comm/BadHostException.*
src/common/comm/BufferConnection.*
src/common/comm/CancelledConnectException.h
src/common/comm/Connection.*
src/common/comm/CouldNotConnectException.h
src/common/comm/DConvert.C
src/common/comm/FConvert.C
src/common/comm/IConvert.C
src/common/comm/IncompatibleSecurityTokenException.h
src/common/comm/IncompatibleVersionException.h
src/common/comm/LConvert.C
src/common/comm/LostConnectionException.h
src/common/comm/TypeRepresentation.*
src/common/comm/comm_exports.h
src/common/comm/convert.h

src/common/Exceptions/Database/BadPermissionException.*
src/common/Exceptions/Database/DBYieldedNoDataException.*
src/common/Exceptions/Database/DatabaseException.h
src/common/Exceptions/Database/FileDoesNotExistException.*
src/common/Exceptions/Database/InvalidDBTypeException.*
src/common/Exceptions/Database/InvalidFilesException.*
src/common/Exceptions/Database/InvalidSourceException.*
src/common/Exceptions/Database/InvalidTimeStepException.*
src/common/Exceptions/Database/InvalidVariableException.*
src/common/Exceptions/Database/InvalidZoneTypeException.*
src/common/Exceptions/Database/NonCompliantException.*
src/common/Exceptions/Database/NonCompliantFileException.*
src/common/Exceptions/Database/PointerNotInCacheException.*
src/common/Exceptions/Database/SiloException.*
src/common/Exceptions/Pipeline/AbortException.*
src/common/Exceptions/Pipeline/BadCellException.*
src/common/Exceptions/Pipeline/BadDomainException.*
src/common/Exceptions/Pipeline/BadIndexException.*
src/common/Exceptions/Pipeline/BadNodeException.*
src/common/Exceptions/Pipeline/BadVectorException.*
src/common/Exceptions/Pipeline/ExpressionException.*
src/common/Exceptions/Pipeline/GhostCellException.*
src/common/Exceptions/Pipeline/ImproperUseException.*
src/common/Exceptions/Pipeline/IncompatibleDomainListsException.*
src/common/Exceptions/Pipeline/IntervalTreeNotCalculatedException.*
src/common/Exceptions/Pipeline/InvalidCategoryException.*
src/common/Exceptions/Pipeline/InvalidCellTypeException.*
src/common/Exceptions/Pipeline/InvalidConversionException.*
src/common/Exceptions/Pipeline/InvalidDimensionsException.*
src/common/Exceptions/Pipeline/InvalidLimitsException.*
src/common/Exceptions/Pipeline/InvalidMergeException.*
src/common/Exceptions/Pipeline/InvalidSetException.*
src/common/Exceptions/Pipeline/LogicalIndexException.*
src/common/Exceptions/Pipeline/NoCurveException.*
src/common/Exceptions/Pipeline/NoDefaultVariableException.*
src/common/Exceptions/Pipeline/NoInputException.*
src/common/Exceptions/Pipeline/NonQueryableInputException.*
src/common/Exceptions/Pipeline/PipelineException.h
src/common/Exceptions/Pipeline/StubReferencedException.*
src/common/Exceptions/Pipeline/UnexpectedValueException.*
src/common/Exceptions/Pipeline/avtexception_exports.h
src/common/Exceptions/Plotter/InvalidColortableException.*
src/common/Exceptions/Plotter/LibraryNotFoundException.*
src/common/Exceptions/Plotter/PlotterException.h

src/common/expr/ExprGrammar.*
src/common/expr/ExprInit.C
src/common/expr/ExprNode.*
src/common/expr/ExprNodeFactory.h
src/common/expr/ExprParseTreeNode.*
src/common/expr/ExprParser.*
src/common/expr/ExprScanner.*
src/common/expr/ExprToken.h
src/common/expr/InvalidExpressionException.*
src/common/expr/ParsingExprList.*
src/common/expr/RecursiveExpressionException.*
src/common/expr/expr_exports.h

src/common/misc/ConfigureInfo.C.in
src/common/misc/ConfigureInfo.h
src/common/misc/DebugStream.h
src/common/misc/DebugStreamFull.*
src/common/misc/Environment.*
src/common/misc/FileFunctions.*
src/common/misc/InstallationFunctions.*
src/common/misc/StackTimer.*
src/common/misc/TimingsManager.*
src/common/misc/VisItException.*
src/common/misc/VisItInit.*
src/common/misc/legend_defines.h
src/common/misc/misc_exports.h

src/common/parser/Colors.h
src/common/parser/ConfiguratingItem.*
src/common/parser/ConfiguratingSet.*
src/common/parser/Dictionary.*
src/common/parser/Grammar.*
src/common/parser/ParseException.h
src/common/parser/ParseTreeNode.*
src/common/parser/Parser.C
src/common/parser/Pos.h
src/common/parser/Rule.*
src/common/parser/Scanner.*
src/common/parser/Sequence.*
src/common/parser/State.h
src/common/parser/Symbol.*
src/common/parser/SymbolSet.h
src/common/parser/Token.*
src/common/parser/VisItParser.h
src/common/parser/parser_exports.h

src/common/plugin/DatabasePluginInfo.*
src/common/plugin/DatabasePluginManager.*
src/common/plugin/InvalidDirectoryException.*
src/common/plugin/InvalidPluginException.*
src/common/plugin/OperatorPluginInfo.h
src/common/plugin/PluginBroadcaster.*
src/common/plugin/PluginManager.*
src/common/plugin/database_plugin_exports.h
src/common/plugin/operator_plugin_exports.h
src/common/plugin/plot_plugin_exports.h
src/common/plugin/plugin_entry_point.h
src/common/plugin/plugin_exports.h
src/common/plugin/plugin_vartypes.h

src/common/state/AttributeGroup.*
src/common/state/AttributeSubject.*
src/common/state/ColorAttribute.*
src/common/state/ColorControlPoint.*
src/common/state/ColorControlPointList.*
src/common/state/ColorTableAttributes.*
src/common/state/CompactSILRestrictionAttributes.*
src/common/state/ConfigManager.*
src/common/state/DBOptionsAttributes.*
src/common/state/DBPluginInfoAttributes.*
src/common/state/DataNode.*
src/common/state/DatabaseAttributes.*
src/common/state/Expression.*
src/common/state/ExpressionList.*
src/common/state/FileOpenOptions.*
src/common/state/GlobalAttributes.*
src/common/state/JSONNode.*
src/common/state/LightAttributes.*
src/common/state/LightList.*
src/common/state/Line.*
src/common/state/LineoutInfo.h
src/common/state/MapNode.*
src/common/state/NameschemeAttributes.*
src/common/state/NamespaceAttributes.*
src/common/state/Observer.*
src/common/state/PickAttributes.*
src/common/state/PickVarInfo.*
src/common/state/Plot.*
src/common/state/PlotInfoAttributes.*
src/common/state/QueryAttributes.*
src/common/state/QueryOverTimeAttributes.*
src/common/state/RenderingAttributes.*
src/common/state/SILArrayAttributes.*
src/common/state/SILAttributes.*
src/common/state/SILMatrixAttributes.*
src/common/state/SILRestrictionAttributes.*
src/common/state/SelectionProperties.*
src/common/state/SimpleObserver.*
src/common/state/Subject.*
src/common/state/Variant.*
src/common/state/View2DAttributes.*
src/common/state/View3DAttributes.*
src/common/state/ViewAxisArrayAttributes.*
src/common/state/ViewCurveAttributes.*
src/common/state/WindowAttributes.*
src/common/state/XMLNode.*
src/common/state/state_exports.h

src/common/utility/AtomicProperties.*
src/common/utility/BJHash.h
src/common/utility/CoordUtils.C
src/common/utility/EqualVal.h
src/common/utility/FixedLengthBitField.h
src/common/utility/Interpolator.h
src/common/utility/MRUCache.h
src/common/utility/Namescheme.*
src/common/utility/StringHash.h
src/common/utility/StringHelpers.*
src/common/utility/Utility.*
src/common/utility/VisItAtomic.h
src/common/utility/VisItStreamUtil.h
src/common/utility/array_ref_ptr.h
src/common/utility/enumtypes.h
src/common/utility/maptypes.h
src/common/utility/ref_ptr.h
src/common/utility/utility_exports.h
src/common/utility/vectortypes.h
src/common/utility/visit_gzstream.*
src/common/utility/visitstream.h
src/common/utility/void_ref_ptr.*
src/common/utility/win32-regex.*

src/common/CMakeLists.txt

src/include/visit-cmake.h.in
src/include/visit-hdf5.h

src/visit_vtk/full/visit_vtk_exports.h
src/visit_vtk/full/vtkAccessors.h
src/visit_vtk/full/vtkBinaryPartitionVolumeFromVolume.*
src/visit_vtk/full/vtkCSGCell.*
src/visit_vtk/full/vtkCSGFixedLengthBitField.h
src/visit_vtk/full/vtkCSGGrid.*
src/visit_vtk/full/vtkMultiSplitter.*
src/visit_vtk/full/vtkPolyDataOnionPeelFilter.*
src/visit_vtk/full/vtkSurfaceFromVolume.*
src/visit_vtk/full/vtkUnstructuredGridRelevantPointsFilter.*
src/visit_vtk/full/vtkVisItCellDataToPointData.*
src/visit_vtk/full/vtkVisItClipper.*
src/visit_vtk/full/vtkVisItPolyDataNormals.*
src/visit_vtk/full/vtkVisItSplitter.*
src/visit_vtk/full/vtkVolumeFromCSGVolume.*
src/visit_vtk/full/vtkVolumeFromVolume.*
src/visit_vtk/full/CMakeLists.txt

src/visit_vtk/lightweight/ClipCases.h
src/visit_vtk/lightweight/ClipCases*.C
src/visit_vtk/lightweight/visit_vtk_light_exports.h
src/visit_vtk/lightweight/vtkCellIntersections.*
src/visit_vtk/lightweight/vtkDataSetFromVolume.*
src/visit_vtk/lightweight/vtkElementLabelArray.*
src/visit_vtk/lightweight/vtkEnumThreshold.*
src/visit_vtk/lightweight/vtkPolyDataRelevantPointsFilter.*
src/visit_vtk/lightweight/vtkTriangulationTables.*
src/visit_vtk/lightweight/vtkUnstructuredGridBoundaryFilter.*
src/visit_vtk/lightweight/vtkUnstructuredGridFacelistFilter.*
src/visit_vtk/lightweight/vtkVisItCellLocator.*
src/visit_vtk/lightweight/vtkVisItPointLocator.*
src/visit_vtk/lightweight/vtkVisItUtility.*
src/visit_vtk/lightweight/CMakeLists.txt

src/visit_vtk/CMakeLists.txt
"

extract_source () {
    git_archive
    pushd "$extractdir/$name-reduced"
    find . -name "*.code" -delete
    find . -name "*.xml" -delete
    mv -v src/* .
    mv -v CMakeLists.paraview.txt CMakeLists.txt
    popd
}

. "${BASH_SOURCE%/*}/update-common.sh"
