/***************************************************************************************************
 * Copyright 2023 NVIDIA Corporation. All rights reserved.
 **************************************************************************************************/
/// \file mi/math.h
/// \brief Math API.
///
/// See \ref mi_math.

#ifndef MI_MATH_H
#define MI_MATH_H

#include <mi/base.h>
#include <mi/math/version.h>
#include <mi/math/assert.h>
#include <mi/math/function.h>
#include <mi/math/vector.h>
#include <mi/math/matrix.h>
#include <mi/math/bbox.h>
#include <mi/math/color.h>
#include <mi/math/spectrum.h>

namespace mi {

/// Namespace for the Math API.
/// \ingroup mi_math
namespace math {

/// \defgroup mi_math Math API
/// \brief Math-related functions and classes, for example, vectors and matrices.
///
/// \par Include File:
/// <tt> \#include <mi/math.h></tt>

} // namespace math

} // namespace mi

#endif // MI_MATH_H
