// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: Curve2DPluginInfo.C
// ****************************************************************************

#include <Curve2DPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(Curve2D,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(Curve2D,General)

// ****************************************************************************
//  Method: Curve2DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Curve2DGeneralPluginInfo::GetName() const
{
    return "Curve2D";
}

// ****************************************************************************
//  Method: Curve2DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Curve2DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: Curve2DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
Curve2DGeneralPluginInfo::GetID() const
{
    return "Curve2D_1.0";
}
// ****************************************************************************
//  Method: Curve2DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Curve2DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: Curve2DGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
Curve2DGeneralPluginInfo::HasWriter() const
{
    return true;
}
// ****************************************************************************
//  Method:  Curve2DGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a Curve2D database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
Curve2DGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.curve");
    defaultPatterns.push_back("*.ultra");
    defaultPatterns.push_back("*.ult");
    defaultPatterns.push_back("*.u");
    defaultPatterns.push_back("*.curve.gz");
    defaultPatterns.push_back("*.ultra.gz");
    defaultPatterns.push_back("*.ult.gz");
    defaultPatterns.push_back("*.u.gz");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  Curve2DGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a Curve2D database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Curve2DGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  Curve2DGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the Curve2D plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
Curve2DGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
