// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                            avtClawFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_Claw_FILE_FORMAT_H
#define AVT_Claw_FILE_FORMAT_H

#include <avtMTMDFileFormat.h>

#include <map>
#include <string>
#include <vector>

struct TimeHeader_t
{
    double time;
    int meqn;
    int ngrids;
    int naux;
    int ndims;
};

struct GridHeader_t
{
    int grid_number;
    int AMR_level;
    int mx, my, mz;
    double xlow, ylow, zlow;
    double dx, dy, dz;
    int charsPerLine;
    int dataOffset;
};


// ****************************************************************************
//  Class: avtClawFileFormat
//
//  Purpose:
//      Reads in Claw files as a plugin to VisIt.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Mon Sep 10 23:24:53 PST 2007
//
// ****************************************************************************

class avtClawFileFormat : public avtMTMDFileFormat
{
  public:
                           avtClawFileFormat(const char *);
    virtual               ~avtClawFileFormat() {;};

    bool                   HasInvariantMetaData(void) const { return false; };
    bool                   HasInvariantSIL(void) const { return false; };

    void                   BuildDomainAuxiliaryInfo(int timeState);

    virtual int            GetNTimesteps(void);
    virtual double         GetTime(int ts);

    virtual const char    *GetType(void)   { return "Claw"; };
    virtual void           FreeUpResources(void); 

    virtual vtkDataSet    *GetMesh(int, int, const char *);
    virtual vtkDataArray  *GetVar(int, int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, int, const char *);

  protected:
    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *, int);
    void                   GetFilenames();

  private:
    std::string                 rootDir;
    std::string                 timeScanf;
    std::string                 gridScanf;
    std::string                 timeRegex;
    std::string                 gridRegex;
    std::string                 cycleRegex;
    std::string                 optMode;
    std::vector<std::string>    timeFilenames;
    std::vector<std::string>    gridFilenames;
    std::vector<TimeHeader_t>   timeHeaders;
    std::vector<std::vector<GridHeader_t> > gridHeaders;
    std::vector<std::map<int, GridHeader_t> > gridHeaderMaps;
};


#endif
