#ifndef PBBAM_IRECORDWRITER_H
#define PBBAM_IRECORDWRITER_H

#include <pbbam/Config.h>

#include <pbbam/BamRecord.h>
#include <pbbam/BamRecordImpl.h>

namespace PacBio {
namespace BAM {

class IRecordWriter
{
public:
    virtual ~IRecordWriter();

public:
    /// \brief Try to flush any buffered data to file.
    ///
    /// \note The underlying implementation may not necessarily flush buffered
    ///       data immediately, especially in a multithreaded writer situation.
    ///       Let the writer go out of scope to fully ensure flushing.
    ///
    /// \throws std::runtime_error if flush fails
    ///
    virtual void TryFlush() {}

    /// \brief Write a record to the output %BAM file.
    ///
    /// \param[in] record BamRecord object
    ///
    /// \throws std::runtime_error on failure to write
    ///
    virtual void Write(const BamRecord& record) = 0;

    /// \brief Write a record to the output %BAM file.
    ///
    /// \param[in] recordImpl BamRecordImpl object
    ///
    /// \throws std::runtime_error on failure to write
    ///
    virtual void Write(const BamRecordImpl& recordImpl) = 0;

protected:
    IRecordWriter();
};

}  // namespace BAM
}  // namespace PacBio

#endif  // PBBAM_IRECORDWRITER_H
