EXEC_PROGRAM(${CMAKE_C_COMPILER} ARGS -v OUTPUT_VARIABLE CMAKE_COMPILER_OUTPUT RETURN_VALUE CMAKE_COMPILER_RETURN)
MESSAGE( STATUS "Intel C Compiler found, ${CMAKE_COMPILER_OUTPUT}")
SET (CMAKE_COMPILER_IS_INTELCC 1)

SET (CMAKE_C_FLAGS_INIT "")
SET (CMAKE_C_FLAGS_DEBUG_INIT "-g")
SET (CMAKE_C_FLAGS_DEBUG "-g -C")
SET (CMAKE_C_FLAGS_MINSIZEREL_INIT "-Os -DNDEBUG")
SET (CMAKE_C_FLAGS_RELEASE_INIT "-O3 -DNDEBUG")
SET (CMAKE_C_FLAGS_RELWITHDEBINFO_INIT "-O2 -g")
SET (CMAKE_C_FLAGS_SSE3 "-axSSE3 -msse3")
SET (CMAKE_C_FLAGS_SSE41 "-axSSE4.1 -msse4.1")
SET (CMAKE_C_FLAGS_SSE42 "-axSSE4.2 -msse4.2")
SET (CMAKE_C_FLAGS_AVX   "-axAVX -mavx")

#restrict keyword
STRING(FIND "${CMAKE_C_FLAGS}" "-restrict" FOUND_RESTRICT)
IF(${FOUND_RESTRICT} STREQUAL "-1")
  SET (CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -restrict")
  MESSAGE( STATUS "Add -restrict to Intel C compiler options")
ENDIF(${FOUND_RESTRICT} STREQUAL "-1")
# C99
STRING(FIND "${CMAKE_C_FLAGS}" "-std=c99" FOUND_C99)
IF(${FOUND_C99} STREQUAL "-1")
  SET (CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -std=c99")
  MESSAGE( STATUS "Add -std=c99 to Intel C compiler options")
ENDIF(${FOUND_C99} STREQUAL "-1")

# Minimum optimization
SET(HAS_MINIMUM_OPTIMIZATION_SET 0)
STRING(FIND "${CMAKE_C_FLAGS}" "-msse3" FOUND_SSE3)
IF(${FOUND_SSE3} STREQUAL "-1")
  SET(HAS_MINIMUM_OPTIMIZATION_SET 1)
ENDIF(${FOUND_SSE3} STREQUAL "-1")
STRING(FIND "${CMAKE_C_FLAGS}" "-msse2" FOUND_SSE2)
IF(${FOUND_SSE2} STREQUAL "-1")
  SET(HAS_MINIMUM_OPTIMIZATION_SET 1)
ENDIF(${FOUND_SSE2} STREQUAL "-1")
STRING(FIND "${CMAKE_C_FLAGS}" "-msse"  FOUND_SSE)
IF(${FOUND_SSE} STREQUAL "-1")
  SET(HAS_MINIMUM_OPTIMIZATION_SET 1)
ENDIF(${FOUND_SSE} STREQUAL "-1")
STRING(FIND "${CMAKE_C_FLAGS}" "-mavx"  FOUND_AVX)
IF(${FOUND_AVX} STREQUAL "-1")
  SET(HAS_MINIMUM_OPTIMIZATION_SET 1)
ENDIF(${FOUND_AVX} STREQUAL "-1")

IF(NOT ${HAS_MINIMUM_OPTIMIZATION_SET})
  SET (CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -msse3")
  MESSAGE( STATUS "Add -msse3 as minimum optimization that handles AMD processors")
ENDIF(NOT ${HAS_MINIMUM_OPTIMIZATION_SET})

# Get library location for rpath
IF(EXISTS "$ENV{LIBRARY_PATH}")
  MESSAGE( STATUS "Using environment variable LIBRARY_PATH to retrieve Intel Compiler Libraries")
  SET (INTEL_LIBS $ENV{LIBRARY_PATH} )
ELSE(EXISTS "$ENV{LIBRARY_PATH}")
  MESSAGE(WARNING "Environment variable LIBRARY_PATH is not set, trying to guess Intel Library path.")
  GET_FILENAME_COMPONENT(INTEL_COMPILER_PATH ${CMAKE_C_COMPILER} PATH)
  IF (CMAKE_SYSTEM_ARCH STREQUAL "x86_64")
    SET (INTEL_LIBS ${INTEL_COMPILER_PATH}/../lib64 )
  ELSE (CMAKE_SYSTEM_ARCH STREQUAL "x86_64") 
    SET (INTEL_LIBS ${INTEL_COMPILER_PATH}/../lib )
  ENDIF(CMAKE_SYSTEM_ARCH STREQUAL "x86_64")
ENDIF(EXISTS "$ENV{LIBRARY_PATH}")

IF(${CMAKE_CXX_COMPILER})
    EXEC_PROGRAM(${CMAKE_CXX_COMPILER} ARGS -v OUTPUT_VARIABLE CMAKE_COMPILER_OUTPUT RETURN_VALUE CMAKE_COMPILER_RETURN)
    MESSAGE( STATUS "Intel C++ Compiler found, ${CMAKE_COMPILER_OUTPUT}")

    SET (CMAKE_CXX_FLAGS_INIT "")
    SET (CMAKE_CXX_FLAGS_INIT "")
    SET (CMAKE_CXX_FLAGS_DEBUG_INIT "-g")
    SET (CMAKE_CXX_FLAGS_MINSIZEREL_INIT "-Os -DNDEBUG")
    SET (CMAKE_CXX_FLAGS_RELEASE_INIT "-O3 -DNDEBUG")
    SET (CMAKE_CXX_FLAGS_RELWITHDEBINFO_INIT "-O2 -g")
    #restrict keyword
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -restrict")
    MESSAGE( STATUS "Add -restrict to Intel C++ compiler options")
ENDIF(${CMAKE_CXX_COMPILER})

#Platform dependant optimization
IF (CMAKE_SYSTEM_ARCH STREQUAL "x86_64")
    SET (CMAKE_C_FLAGS "${CMAKE_C_FLAGS}" CACHE STRING "C flags" FORCE)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" CACHE STRING "C++ flags" FORCE)
ELSE(CMAKE_SYSTEM_ARCH STREQUAL "x86_64")
    SET (CMAKE_C_FLAGS "${CMAKE_C_FLAGS}" CACHE STRING "C flags" FORCE)
    SET (CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}" CACHE STRING "C++ flags" FORCE)
ENDIF(CMAKE_SYSTEM_ARCH STREQUAL "x86_64")
