# Joining the team

Joining the PHP Documentation team is a simple process, but a process nonetheless.
You don't have to the join the team to [contribute](contributing.md),
but joining the team can be a way to get more involved in the process
and help out with larger projects.

## Write to a mailing list
Because official communication is done there, you should write to the proper list.
Say "Hi" and what you're interested in doing. You may feel more comfortable lurking
for a while, or reading the archives, but ultimately let the list know who you are.

### For authors
You should send your message to the `phpdoc@lists.php.net` mailing list. You
will need to subscribe to the list in order to send email to it. You can find
[archives of the list on news-web.php.net](https://news-web.php.net/php.doc),
and there is also a form to subscribe to the list there.

You can subscribe the regular version of the list (you get every
message as it is sent), the digest version (you'll get a daily-or-so
mail containing all of the new messages to the list), or the "no mail"
version which allows you to send a message but doesn't send you any emails
(useful if you just read through the web archive or an NNTP client).

### For translators
You should send your message to the appropriate `doc-{LANG}@lists.php.net` mailing list.

## Informal discussion
The mailing lists above are the primary communication forum. In particular,
decisions and plans should be made on the list so they are recorded in the
archives.

However for more realtime and/or informal chat, some doc authors hang out in
"Room 11" on Stackoverflow Chat: https://chat.stackoverflow.com/rooms/11/php

Some authors hang out in the `#php-doc` channel on IRC on the
https://Libera.Chat network, which is also bridged to the Discord server run
by the PHP Community Foundation, available at https://phpc.chat.

## Create a doc patch or three
This step is required to show us that you are a real human, you want to do
some work and in general know how to do this.

The simplest way to get started is by using GitHub, to create and send Pull Requests
to [php/doc-en][doc-en] or php/doc-{LANG} for translations.

Your Pull Requests will be then reviewed and accepted by someone with Git commit access.

## Obtaining Git commit access
If you plan to contribute to the manual regularly and want to help process
contributions from others, you might want to request to be added to the
documentation team (or a translation team) on GitHub, which you can do on the
email lists.

To be clear: you don't need Git commit access to start contributing to the
documentation! Anyone with a GitHub account (which is free) can submit Pull
Requests to the documentation repositories.

[doc-en]: https://github.com/php/doc-en
