--TEST--
Phar: PHP bug #48377 "error message unclear on converting phar with existing file" test #2
--EXTENSIONS--
phar
--INI--
phar.require_hash=0
phar.readonly=0
--FILE--
<?php
$fname = __DIR__ . '/' . basename(__FILE__, '.php') . '.zip';

$phar = new PharData($fname);
$phar['x'] = 'hi';
try {
    $phar->convertToData(Phar::ZIP, Phar::NONE, 'phar.zip');
} catch (BadMethodCallException $e) {
    echo $e->getMessage(),"\n";
}
?>
--CLEAN--
<?php unlink(__DIR__ . '/' . basename(__FILE__, '.clean.php') . '.zip');?>
--EXPECTF--
data phar "%sbug48377.2.phar.zip" has invalid extension phar.zip
