<?php
/**
*
* common [Galician]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste: 
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '&copy; 2007-2010 Traducido ao galego pola <a href="http://www.ciberirmandade.org/foros/">CiberIrmandade da Fala</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'gl',

	'1_DAY'			=> '1 día',
	'1_MONTH'		=> '1 mes',
	'1_YEAR'		=> '1 ano',
	'2_WEEKS'		=> '2 semanas',
	'3_MONTHS'		=> '3 meses',
	'6_MONTHS'		=> '6 meses',
	'7_DAYS'		=> '7 días',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'A túa conta xa está activada',
	'ACCOUNT_DEACTIVATED'			=> 'A túa conta foi desactivada de xeito manual e só pode ser reactivada por un administrador.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'A túa conta aínda non foi activada',
	'ACP'							=> 'Panel de Control da Administración',
	'ACTIVE'						=> 'activo',
	'ACTIVE_ERROR'					=> 'Especificaches un nome de usuario inactivo. Activa a túa conta e téntao de novo. Se segues a ter problemas contacta cun administrador dos foros.',
	'ADMINISTRATOR'					=> 'Administrador',
	'ADMINISTRATORS'				=> 'Administradores',
	'AGE'							=> 'Idade',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Permitido',
	'ALL_FILES'						=> 'Todos os arquivos',
	'ALL_FORUMS'					=> 'Todos os foros',
	'ALL_MESSAGES'					=> 'Todas as mensaxes',
	'ALL_POSTS'						=> 'Todas as mensaxes enviadas',
	'ALL_TIMES'						=> 'Todas as horas son %1$s %2$s',
	'ALL_TOPICS'					=> 'Todos os temas',
	'AND'							=> 'E',
	'ARE_WATCHING_FORUM'			=> 'Subscribícheste para recibir as actualizacións deste foro',
	'ARE_WATCHING_TOPIC'			=> 'Subscribícheste para recibir as actualizacións deste tema',
	'ASCENDING'						=> 'Ascendente',
	'ATTACHMENTS'					=> 'Adxuntos',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'O arquivo de imaxe que intentaches engadir como anexo non é válido.',
	'AUTHOR'						=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'		=> 'Fallou a creación dun perfil de usuario',
	'AVATAR_DISALLOWED_CONTENT'		=> 'A subida foi rexeitada por mor da identificación do arquivo subido como un posíbel vector de ataque.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Non se permite a extensión %s',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Non se puido subir o avatar, os datos remotos semellan ser inválidos ou corruptos.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'O arquivo de avatar subido está baleiro.',
	'AVATAR_INVALID_FILENAME'		=> 'O nome de arquivo %s non é válido',
	'AVATAR_NOT_UPLOADED'			=> 'Non se puido subir o avatar.',
	'AVATAR_NO_SIZE'				=> 'Non se puido obter o ancho ou o alto do avatar ligado, por favor, insíreo a man.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'O arquivo foi subido só parcialmente',
	'AVATAR_PHP_SIZE_NA'			=> 'O tamaño do avatar é grande de máis.<br />Non se pode determinar o tamaño máximo definido polo PHP no php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'O tamaño do arquivo do avatar é demasiado grande, sendo o máximo tamaño permitido %1$d %2$s. <br />Ten en conta que isto vén definido no php.ini e non se pode pasar por alto.',
	'AVATAR_URL_INVALID'			=> 'O URL que especificaches non é válido.',
	'AVATAR_URL_NOT_FOUND'			=> 'O arquivo que especificaches non foi atopado.',
	'AVATAR_WRONG_FILESIZE'			=> 'O tamaño do arquivo do avatar debe estar entre 0 e %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'O tamaño do avatar debe ser como mínimo de %1$d píxeles de ancho e %2$d píxeles de alto, e como máximo de %3$d píxeles de ancho e %4$d píxeles de alto. O avatar enviado é de %5$d píxeles de ancho e %6$d píxeles de alto.',

	'BACK_TO_TOP'			=> 'Enriba',
	'BACK_TO_PREV'			=> 'Volver á páxina anterior',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Emitiuse unha prohibición para o teu enderezo de correo-e.',
	'BAN_TRIGGERED_BY_IP'	=> 'Emitiuse unha prohibición para o teu enderezo IP.',
	'BAN_TRIGGERED_BY_USER'	=> 'Emitiuse unha prohibición para o teu nome de usuario.',
	'BBCODE_GUIDE'			=> 'Guía BBCode',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Aniversarios',
	'BOARD_BAN_PERM'		=> 'Fuches <strong>permanentemente</strong> expulsado deste foro. <br /><br />Contacta co %2$sAdministrador dos Foros%3$s para ter máis información.',
	'BOARD_BAN_REASON'		=> 'Motivo da expulsión: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Fuches expulsado deste foro até <strong>%1$s</strong>.<br /><br />Contacta co %2$sAdministrador dos Foros%3$s para ter máis información.',
	'BOARD_DISABLE'			=> 'Sentímolo, pero nestes intres este foro non está dispoñíbel.',
	'BOARD_DISABLED'		=> 'Este taboleiro está actualmente desactivado',
	'BOARD_UNAVAILABLE'		=> 'O foro non está dispoñíbel de xeito temporal. Téntao de novo nuns minutos.',
	'BROWSING_FORUM'		=> 'Usuarios navegando neste foro: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Usuarios navegando neste foro: %1$s e %2$d convidados',
	'BROWSING_FORUM_GUESTS'	=> 'Usuarios navegando neste foro: %1$s e %2$d convidados',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'Cancelar',
	'CHANGE'				=> 'Mudar',
	'CHANGE_FONT_SIZE'		=> 'Mudar tamaño de fonte',
	'CHANGING_PREFERENCES'	=> 'Mudando preferencias do foro',
	'CHANGING_PROFILE'		=> 'Mudando configuración do perfil do foro',
	'CLICK_VIEW_PRIVMSG'	=> '%sIr á túa caixa de entrada%s',
	'COLLAPSE_VIEW'			=> 'Colapsar vista',
	'CLOSE_WINDOW'			=> 'Pechar fiestra',
	'COLOUR_SWATCH'			=> 'Mostra de cor',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Confirmar',
	'CONFIRM_CODE'			=> 'Código de confirmación',
	'CONFIRM_CODE_EXPLAIN'	=> 'Insire o código exactamente como o ves na imaxe, sen necesidade de que coincidan maiúsculas e minúsculas. Ten en conta que o cero non existe.',
	'CONFIRM_CODE_WRONG'	=> 'O código de confirmación que introduciches está errado.',
	'CONFIRM_OPERATION'		=> 'Estás certo de que queres levar a cabo esta operación?',
	'CONGRATULATIONS'		=> 'Parabéns a',
	'CONNECTION_FAILED'		=> 'Fallo de conexión',
	'CONNECTION_SUCCESS'	=> 'Conexión correcta!',
	'COOKIES_DELETED'		=> 'Elimináronse correctamente todas as cookies dos Foros',
	'CURRENT_TIME'			=> 'Agora mesmo é %s',

	'DAY'					=> 'Día',
	'DAYS'					=> 'Días',
	'DELETE'				=> 'Eliminar',
	'DELETE_ALL'			=> 'Eliminar todo',
	'DELETE_COOKIES'		=> 'Eliminar todas as cookies dos Foros',
	'DELETE_MARKED'			=> 'Eliminar marcados',
	'DELETE_POST'			=> 'Eliminar mensaxe publicada',
	'DELIMITER'				=> 'Delimitador',
	'DESCENDING'			=> 'Descendente',
	'DISABLED'				=> 'Desactivado',
	'DISPLAY'				=> 'Amosar',
	'DISPLAY_GUESTS'		=> 'Amosar visitantes',
	'DISPLAY_MESSAGES'		=> 'Mostra mensaxes dende a anterior',
	'DISPLAY_POSTS'			=> 'Mostra envíos dende o anterior',
	'DISPLAY_TOPICS'		=> 'Mostra temas dende o anterior',
	'DOWNLOADED'			=> 'Descargado',
	'DOWNLOADING_FILE'		=> 'Descargando arquivo',
	'DOWNLOAD_COUNT'		=> '%d vez',
	'DOWNLOAD_COUNTS'		=> '%d veces',
	'DOWNLOAD_COUNT_NONE'			=> 'Non se descargou nunca aínda',
	'VIEWED_COUNT'			=> 'Visto %d vez',
	'VIEWED_COUNTS'			=> 'Visto %d veces',
	'VIEWED_COUNT_NONE'		=> 'Non foi visto nunca aínda',

	'EDIT_POST'							=> 'Editar mensaxe publicada',
	'EMAIL'								=> 'Correo-e', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Enderezo de correo-e',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Houbo problemas ao enviar correo-e na <strong>Liña %1$s</strong>. Resposta: %2$s',
	'EMPTY_SUBJECT'						=> 'Debes especificar un asunto ao enviar un novo tema.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Tes que especificar un asunto cando compoñas unha nova mensaxe.',
	'ENABLED'							=> 'Activado',
	'ENCLOSURE'							=> 'Anexo',
	'ENTER_USERNAME'					=> 'Insire o nome de usuario',
	'ERR_CHANGING_DIRECTORY'			=> 'Imposíbel cambiar directorio',
	'ERR_CONNECTING_SERVER'				=> 'Erro ao conectar co servidor',
	'ERR_JAB_AUTH'						=> 'Non se pode obter autorización no servidor Jabber.',
	'ERR_JAB_CONNECT'					=> 'Non se pode conectar co servidor Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Erro ao iniciar sesión. O nome ou o contrasinal proporcionado é incorrecto.',
	'ERR_UNWATCHING'					=> 'Houbo un erro ao tentar desubscribir.',
	'ERR_WATCHING'						=> 'Houbo un erro ao tentar subscribir.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'A ruta do phpBB inserida semella non ser válida.',
	'EXPAND_VIEW'						=> 'Expandir vista',
	'EXTENSION'							=> 'Extensión',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'A extensión <strong>%s</strong> foi desactivada e xa non pode ser amosada',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Preguntas mais frecuentes',
	'FILENAME'				=> 'Nome do arquivo',
	'FILESIZE'				=> 'Tamaño do arquivo',
	'FILEDATE'				=> 'Data de arquivo',
	'FILE_COMMENT'			=> 'Comentario do arquivo',
	'FILE_NOT_FOUND'		=> 'Non se puido atopar o arquivo solicitado',
	'FIND_USERNAME'			=> 'Atopar un membro',
	'FOLDER'				=> 'Cartafol',
	'FORGOT_PASS'			=> 'Esquecín o meu contrasinal',
	'FORM_INVALID'			=> 'O formulario enviado non é válido. Tenta envialo de novo.',
	'FORUM'					=> 'Foro',
	'FORUMS'				=> 'Foros',
	'FORUMS_MARKED'			=> 'Os foros foron marcados como lidos',
	'FORUM_CAT'				=> 'Categoría do foro',
	'FORUM_INDEX'			=> 'Índice do Foro',
	'FORUM_LINK'			=> 'Ligazón aos foros',
	'FORUM_LOCATION'		=> 'Ubicación do foro',
	'FORUM_LOCKED'			=> 'Foro bloqueado',
	'FORUM_RULES'			=> 'Regras do foro',
	'FORUM_RULES_LINK'		=> 'Preme para ver as regras do foro',
	'FROM'					=> 'dende',
	'FSOCK_DISABLED'		=> 'Non foi posíbel completar a operación xa que as funcións fsock foron desactivadas ou non se atopou o servidor consultado.',
	'FSOCK_TIMEOUT'			=> 'Esgotouse o tempo permitido ao tentar ler do fluxo de rede.',

	'FTP_FSOCK_HOST'				=> 'Host FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Servidor FTP usado para conectar o teu sitio',
	'FTP_FSOCK_PASSWORD'			=> 'Contrasinal FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Contrasinal para o teu nome de usuario FTP',
	'FTP_FSOCK_PORT'				=> 'Porto FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Porto usado para conectar co teu servidor',
	'FTP_FSOCK_ROOT_PATH'			=> 'Ruta ao phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Ruta dende a raíz ata o teu taboleiro phpBB',
	'FTP_FSOCK_TIMEOUT'				=> 'Exceso de tempo en conexión FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'A cantidade de segundos que o sistema agardará pola resposta dende o teu servidor',
	'FTP_FSOCK_USERNAME'			=> 'Nome de usuario do FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nome de usuario para conectar ao teu servidor',

	'FTP_HOST'					=> 'Host FTP',
	'FTP_HOST_EXPLAIN'			=> 'Servidor FTP usado para conectar o teu sitio',
	'FTP_PASSWORD'				=> 'Contrasinal FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Contrasinal para o teu nome de usuario FTP',
	'FTP_PORT'					=> 'Porto FTP',
	'FTP_PORT_EXPLAIN'			=> 'Porto usado para conectar co teu servidor',
	'FTP_ROOT_PATH'				=> 'Ruta ao phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Ruta dende a raíz ata o teu taboleiro phpBB',
	'FTP_TIMEOUT'				=> 'Exceso de tempo en conexión FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'A cantidade de segundos que o sistema agardará pola resposta dende o teu servidor',
	'FTP_USERNAME'				=> 'Nome de usuario do FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nome de usuario para conectar ao teu servidor',

	'GENERAL_ERROR'				=> 'Erro Xeral',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Ir',
	'GOTO_PAGE'					=> 'Ir á páxina',
	'GROUP'						=> 'Grupo',
	'GROUPS'					=> 'Grupos',
	'GROUP_ERR_TYPE'			=> 'Especificado tipo de grupo non axeitado.',
	'GROUP_ERR_USERNAME'		=> 'Non indicaches o nome do grupo.',
	'GROUP_ERR_USER_LONG'		=> 'O nome do grupo é demasiado longo.',
	'GUEST'						=> 'Convidado',
	'GUEST_USERS_ONLINE'		=> 'Hai %d usuarios convidados en liña',
	'GUEST_USERS_TOTAL'			=> '%d convidados',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Non hai ningún usuario convidado en liña',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 convidados',
	'GUEST_USER_ONLINE'			=> 'Hai %d usuario convidado en liña',
	'GUEST_USER_TOTAL'			=> '%d convidado',
	'G_ADMINISTRATORS'			=> 'Administradores',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Convidados',
	'G_REGISTERED'				=> 'Usuarios rexistrados',
	'G_REGISTERED_COPPA'		=> 'Usuarios menores rexistrados',
	'G_GLOBAL_MODERATORS'		=> 'Moderadores Globais',
	'G_NEWLY_REGISTERED'		=> 'Usuarios recentemente rexistrados',

	'HIDDEN_USERS_ONLINE'		=> '%d usuarios ocultos conectados',
	'HIDDEN_USERS_TOTAL'		=> '%d ocultos e',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d ocultos e ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 usuarios ocultos conectados',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 ocultos e ',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 ocultos e ',
	'HIDDEN_USER_ONLINE'		=> '%d usuario oculto conectado',
	'HIDDEN_USER_TOTAL'			=> '%d oculto e',
	'HIDDEN_USER_TOTAL_AND'			=> '%d oculto e ',
	'HIDE_GUESTS'				=> 'Visitantes ocultos',
	'HIDE_ME'					=> 'Ocultar o meu estado en liña nesta sesión.',
	'HOURS'						=> 'Horas',
	'HOME'						=> 'Inicio',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Estado ICQ',	
	'IF'						=> 'se',
	'IMAGE'						=> 'Imaxe',
	'IMAGE_FILETYPE_INVALID'	=> 'Tipo de arquivo de imaxe %d para o tipo mime %s non admitido.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Tipo de arquivo de imaxe non coincidente: a extensión agardada é %1$s no canto de %2$s.',
	'IN'						=> 'en',
	'INDEX'						=> 'Páxina índice',
	'INFORMATION'				=> 'Información',
	'INTERESTS'					=> 'Intereses',
	'INVALID_DIGEST_CHALLENGE'	=> 'Digest challenge inválido.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> pode ser unha dirección de correo-e non válida?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'O teu IP %1$s foi bloqueado por estar na nosa lista negra. Para obter máis detalles bótalle un ollo a <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Rexistrado',
	'JUMP_PAGE'				=> 'Insire o número de páxina ao que desexas ir',
	'JUMP_TO'				=> 'Ir a',
	'JUMP_TO_PAGE'			=> 'Preme para ir á páxina.',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Última mensaxe publicada',
	'LAST_UPDATED'						=> 'Última actualización',
	'LAST_VISIT'						=> 'Última visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extensión LDAP non dispoñíbel',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Non se puido conectar co servidor LDAP',
	'LDAP_SEARCH_FAILED'				=> 'Houbo un erro ao tentar a procura no directorio LDAP.',
	'LEGEND'							=> 'Lenda',
	'LOCATION'							=> 'Ubicación',
	'LOCK_POST'							=> 'Bloquear mensaxe',
	'LOCK_POST_EXPLAIN'					=> 'Previr a edición',
	'LOCK_TOPIC'						=> 'Pechar tema',
	'LOGIN'								=> 'Iniciar sesión',
	'LOGIN_CHECK_PM'					=> 'Inicia sesión para ver as túas mensaxes privadas',
	'LOGIN_CONFIRMATION'				=> 'Confirmación de inicio de sesión',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Para evitar ataques de forza bruta contra as contas, o administrador dos foros require que se insira un código de confirmación despois dun número máximo de intentos errados de inicio de sesión. O código amósase na imaxe que deberías ver debaixo. Se tes calquera problema para vela, contacta co %sAdministrador dos Foros%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Excediches o número máximo de tentativas de inicio de sesión permitido. A maiores do teu nome de usuario e contrasinal agora tamén terás que inserir o código de confirmación que aparece na imaxe que podes ver embaixo.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Non fuches autenticado por Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Especificaches un contrasinal incorrecto. Comproba o teu contrasinal e téntao de novo. Se segues a ter problemas contacta co %sAdministrador dos Foros%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Non foi posíbel converter o teu contrasinal ao actualizar o software deste taboleiro de mensaxes. %ssolicita un novo contrasinal%s. Se segues a ter problemas contacta co %sAdministrador do Taboleiro%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Especificaches un nome de usuario incorrecto. Comproba o teu nome de usuario e téntao de novo. Se segues a ter problemas contacta co %sAdministrador dos Foros%s.',
	'LOGIN_FORUM'						=> 'Para ver ou publicar mensaxes neste foro debes inserir o seu contrasinal.',
	'LOGIN_INFO'						=> 'Para poder iniciar unha sesión tes que estar rexistrado. O proceso de rexistro levarache só un intre e permitirache gozar de máis posibilidades. Do mesmo xeito, pode que o administrador do taboleiro conceda permisos adicionais aos usuarios rexistrados. Antes de iniciar sesión, asegúrate de familiarizarte cos termos de uso e as normas relacionadas. Asegúrate tamén de ler calquera norma dos foros así que vaias navegando polo taboleiro adiante.',
	'LOGIN_VIEWFORUM'					=> 'O administrador dos foros require que esteas rexistrado e identificado para ver este foro.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Para editar as mensaxes publicadas neste foro tes que estar rexistrado e identificado.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Para poder ver a lista de conectados debes estar rexistrado e iniciar unha sesión.',
	'LOGOUT'							=> 'Pechar sesión',
	'LOGOUT_USER'						=> 'Pechar sesión [ %s ]',
	'LOG_ME_IN'							=> 'Identificarme de xeito automático en cada visita',

	'MARK'					=> 'Marcar',
	'MARK_ALL'				=> 'Marcar todo',
	'MARK_FORUMS_READ'		=> 'Marcar foros coma lidos',
	'MARK_SUBFORUMS_READ'	=> 'Marcar subforos coma lidos',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Panel de Control do Moderador',
	'MEMBERLIST'			=> 'Membros',
	'MEMBERLIST_EXPLAIN'	=> 'Ver a lista completa dos membros',
	'MERGE'					=> 'Mesturar',
	'MERGE_POSTS'			=> 'Mesturar mensaxes publicadas',
	'MERGE_TOPIC'			=> 'Mesturar Tema',
	'MESSAGE'				=> 'Mensaxe',
	'MESSAGES'				=> 'Mensaxes',
	'MESSAGE_BODY'			=> 'Corpo da mensaxe',
	'MINUTES'				=> 'Minutos',
	'MODERATE'				=> 'Moderar',
	'MODERATOR'				=> 'Moderador',
	'MODERATORS'			=> 'Moderadores',
	'MONTH'					=> 'Mes',
	'MOVE'					=> 'Mover',
	'MSNM'					=> 'MSNM/WLM',	

	'NA'						=> 'N/D',
	'NEWEST_USER'				=> 'O último usuario rexistrado é <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nova Mensaxe',
	'NEW_MESSAGES'				=> 'Novas Mensaxes',
	'NEW_PM'					=> '<strong>%d</strong> nova mensaxe',
	'NEW_PMS'					=> '<strong>%d</strong> novas mensaxes',
	'NEW_POST'					=> 'Nova mensaxe publicada',	// Not used anymore
	'NEW_POSTS'					=> 'Novas mensaxes publicadas',	// Not used anymore
	'NEXT'						=> 'Seguinte',		// Used in pagination
	'NEXT_STEP'					=> 'Seguinte',
	'NEVER'						=> 'Nunca',
	'NO'						=> 'Non',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Non che está permitido xestionar este grupo dende o Panel de Control da Administración.',
	'NOT_AUTHORISED'			=> 'Non estás autorizado para entrar nesta area.',
	'NOT_WATCHING_FORUM'		=> 'Xa non estás subscrito ás actualizacións deste foro.',
	'NOT_WATCHING_TOPIC'		=> 'A partires de agora xa non estás subscrito a este tema.',
	'NOTIFY_ADMIN'				=> 'Por favor, notifícallo ao administrador ou xestor do web.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Por favor, notifícallo ao administrador ou xestor do web: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Non estás autorizado a acceder a este arquivo.',
	'NO_ACTION'					=> 'Non se especificou acción ningunha.',
	'NO_ADMINISTRATORS'			=> 'Non hai administradores.',
	'NO_AUTH_ADMIN'				=> 'Ao non teres permisos de administrador, non podes acceder ao panel de control de administración.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Non podes autenticarte de novo coma un usuario diferente.',
	'NO_AUTH_OPERATION'			=> 'Non tes os permisos requiridos para completar esta operación.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Non se puido conectar ao servidor SMTP : %s : %s',
	'NO_BIRTHDAYS'				=> 'Non hai aniversarios no día de hoxe',
	'NO_EMAIL_MESSAGE'			=> 'A mensaxe de correo-e está baleira',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Non se puideron obter os códigos de resposta do servidor de correo',
	'NO_EMAIL_SUBJECT'			=> 'Non especificaches o asunto do correo-e',
	'NO_FORUM'					=> 'O foro que seleccionaches non existe.',
	'NO_FORUMS'					=> 'Este Foro non ten foros',
	'NO_GROUP'					=> 'O grupo de usuarios solicitado non existe ',
	'NO_GROUP_MEMBERS'			=> 'Este grupo non ten actualmente asignado membro ningún',
	'NO_IPS_DEFINED'			=> 'Non hai IPs ou Nomes de Host definidos',
	'NO_MEMBERS'				=> 'Non se atoparon membros segundo estes criterios de procura',
	'NO_MESSAGES'				=> 'Non hai mensaxes',
	'NO_MODE'					=> 'Non se especificou modo ningún.',
	'NO_MODERATORS'				=> 'Non hai moderadores.',
	'NO_NEW_MESSAGES'			=> 'Non hai mensaxes novas',
	'NO_NEW_PM'					=> '<strong>0</strong> novas mensaxes',
	'NO_NEW_POSTS'				=> 'Non hai novas mensaxes publicadas',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Ningún usuario rexistrado',
	'NO_POSTS'					=> 'Non hai mensaxes publicadas',
	'NO_POSTS_TIME_FRAME'		=> 'Non hai mensaxes publicadas neste tema para o período de tempo seleccionado.',
	'NO_FEED_ENABLED'			=> 'Os fluxos non están dispoñíbeis neste taboleiro.',
	'NO_FEED'					=> 'O fluxo solicitado non está dispoñíbel.',
	'NO_SUBJECT'				=> 'Non se especificou asunto ningún',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'O backend de procura especificado non existe',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Non hai métodos de autenticación permitidos',
	'NO_TOPIC'					=> 'O tema solicitado non existe.',
	'NO_TOPIC_FORUM'			=> 'O tema ou foro xa non existen.',
	'NO_TOPICS'					=> 'Non hai temas ou mensaxes publicadas neste foro.',
	'NO_TOPICS_TIME_FRAME'		=> 'Non hai temas neste foro para o período de tempo seleccionado.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> mensaxes sen ler',
	'NO_UNREAD_POSTS'			=> 'Non hai mensaxes publicadas sen ler',
	'NO_UPLOAD_FORM_FOUND'		=> 'Subida iniciada pero non se atopou un formulario de subida de arquivo válido.',
	'NO_USER'					=> 'O usuario indicado non existe.',
	'NO_USERS'					=> 'Os usuarios indicados non existen.',
	'NO_USER_SPECIFIED'			=> 'Non se especificou nome de usuario ningún',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Non hai mensaxes na cola',		// 0
		1			=> '1 mensaxe na cola',		// 1
		2			=> '%d mensaxes na cola',		// 2+
	),

	'OCCUPATION'				=> 'Ocupación',
	'OFFLINE'					=> 'Fóra de liña',
	'ONLINE'					=> 'En liña',
	'ONLINE_BUDDIES'			=> 'Colegas en liña',
	'ONLINE_USERS_TOTAL'		=> 'En total hai <strong>%d</strong> usuarios en liña :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'En total hai <strong>0</strong> usuarios en liña :: ',
	'ONLINE_USER_TOTAL'			=> 'En total hai <strong>%d</strong> usuario en liña :: ',
	'OPTIONS'					=> 'Opcións',

	'PAGE_OF'				=> 'Páxina <strong>%1$d</strong> de <strong>%2$d</strong>',
	'PASSWORD'				=> 'Contrasinal',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Reproducir arquivo quicktime',
	'PM'					=> 'MP',
	'PM_REPORTED'			=> 'Preme para veres o relatorio',
	'POSTING_MESSAGE'		=> 'Publicando mensaxe en %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Compoñendo mensaxe privada',
	'POST'					=> 'Mensaxe',
	'POST_ANNOUNCEMENT'		=> 'Anuncio',
	'POST_STICKY'			=> 'Destacado',
	'POSTED'				=> 'Publicada',
	'POSTED_IN_FORUM'		=> 'en',
	'POSTED_ON_DATE'		=> 'o',
	'POSTS'					=> 'Mensaxes',
	'POSTS_UNAPPROVED'		=> 'Polo menos unha mensaxe deste tema non foi aprobada',
	'POST_BY_AUTHOR'		=> 'por',
	'POST_BY_FOE'			=> 'Esta mensaxe foi publicada por <strong>%1$s</strong> que está na túa lista de ignorados. %2$sAmosar esta mensaxe%3$s.',
	'POST_DAY'				=> '%.2f mensaxes publicadas por día',
	'POST_DETAILS'			=> 'Pormenores da mensaxe publicada',
	'POST_NEW_TOPIC'		=> 'Publicar novo tema',
	'POST_PCT'				=> '%.2f%% de todas as mensaxes',
	'POST_PCT_ACTIVE'		=> '%.2f%% das mensaxes dos usuarios',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% das túas mensaxes publicadas',
	'POST_REPLY'			=> 'Publicar unha resposta',
	'POST_REPORTED'			=> 'Preme para ver informe',
	'POST_SUBJECT'			=> 'Asunto da mensaxe',
	'POST_TIME'				=> 'Data de publicación',
	'POST_TOPIC'			=> 'Publicar un novo tema',
	'POST_UNAPPROVED'		=> 'Esta mensaxe está á espera de aprobación.',
	'POWERED_BY'			=> 'Coa tecnoloxía de %s',
	'PREVIEW'				=> 'Previsualizar',
	'PREVIOUS'				=> 'Anterior',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Anterior',
	'PRIVACY'				=> 'Política de privacidade',
	'PRIVATE_MESSAGE'		=> 'Mensaxe Privada',
	'PRIVATE_MESSAGES'		=> 'Mensaxes Privadas',
	'PRIVATE_MESSAGING'		=> 'Mensaxería Privada',
	'PROFILE'				=> 'Panel de Control de Usuario',

	'RANK'						=> 'Rango',
	'READING_FORUM'				=> 'Vendo temas en %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Lendo anuncio global',
	'READING_LINK'				=> 'Seguindo ligazón do foro %s',
	'READING_TOPIC'				=> 'Lendo temas en %s',
	'READ_PROFILE'				=> 'Perfil',
	'REASON'					=> 'Razón',
	'RECORD_ONLINE_USERS'		=> 'A maior cantidade de usuarios en liña foi <strong>%1$s</strong> o %2$s',
	'REDIRECT'					=> 'Redireccionar',
	'REDIRECTS'					=> 'Redireccións totais',
	'REGISTER'					=> 'Rexistrarse',
	'REGISTERED_USERS'			=> 'Usuarios rexistrados:',
	'REG_USERS_ONLINE'			=> 'Hai %d usuarios rexistrados e ',
	'REG_USERS_TOTAL'			=> '%d rexistrados, ',
	'REG_USERS_TOTAL_AND'		=> '%d rexistrados e ',
	'REG_USERS_ZERO_ONLINE'		=> 'Hai 0 usuarios rexistrados e ',
	'REG_USERS_ZERO_TOTAL'		=> '0 rexistrados, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 rexistrados e ',
	'REG_USER_ONLINE'			=> 'Hai %d usuario rexistrado e ',
	'REG_USER_TOTAL'			=> '%d rexistrado, ',
	'REG_USER_TOTAL_AND'		=> '%d rexistrado e ',
	'REMOVE'					=> 'Eliminar',
	'REMOVE_INSTALL'			=> 'Elimina, move ou muda de nome o directorio de instalación antes de utilizar o teu foro. Se tal directorio está aínda presente, só será accesíbel o Panel de Control da Administración (PCA).',
	'REPLIES'					=> 'Respostas',
	'REPLY_WITH_QUOTE'			=> 'Responder citando',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Respondendo a Anuncio Global',
	'REPLYING_MESSAGE'			=> 'Respondendo á mensaxe en %s',
	'REPORT_BY'					=> 'Informe de',
	'REPORT_POST'				=> 'Informar desta mensaxe',
	'REPORTING_POST'			=> 'Informando da mensaxe publicada',
	'RESEND_ACTIVATION'			=> 'Enviar correo-e de activación de novo',
	'RESET'						=> 'Restaurar',
	'RESTORE_PERMISSIONS'		=> 'Restaurar permisos',
	'RETURN_INDEX'				=> '%sVolver á páxina índice%s',
	'RETURN_FORUM'				=> '%sVoltar ao último foro visitado%s',
	'RETURN_PAGE'				=> '%sVoltar á páxina anterior%s',
	'RETURN_TOPIC'				=> '%sVoltar ao último tema visitado%s',
	'RETURN_TO'					=> 'Volver a',
	'FEED'						=> 'Fluxo',
	'FEED_NEWS'					=> 'Novas',
	'FEED_TOPICS_ACTIVE'		=> 'Temas Activos',
	'FEED_TOPICS_NEW'			=> 'Temas Novos',
	'RULES_ATTACH_CAN'			=> '<strong>Podes</strong> engadir arquivos anexos neste foro',
	'RULES_ATTACH_CANNOT'		=> '<strong>Non podes</strong> engadir arquivos anexos neste foro',
	'RULES_DELETE_CAN'			=> '<strong>Podes</strong> borrar as túas mensaxes publicadas neste foro',
	'RULES_DELETE_CANNOT'		=> '<strong>Non podes</strong> borrar as túas mensaxes publicadas neste foro',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Podes</strong> descargar arquivos adxuntos neste foro',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Non podes</strong> descargar arquivos adxuntos neste foro',
	'RULES_EDIT_CAN'			=> '<strong>Podes</strong> editar as túas mensaxes publicadas neste foro',
	'RULES_EDIT_CANNOT'			=> '<strong>Non podes</strong> editar as túas mensaxes publicadas neste foro',
	'RULES_LOCK_CAN'			=> '<strong>Podes</strong> bloquear os teus temas neste foro',
	'RULES_LOCK_CANNOT'			=> '<strong>Non podes</strong> bloquear os teus temas neste foro',
	'RULES_POST_CAN'			=> '<strong>Podes</strong> publicar novos temas neste foro',
	'RULES_POST_CANNOT'			=> '<strong>Non podes</strong> publicar novos temas neste foro',
	'RULES_REPLY_CAN'			=> '<strong>Podes</strong> responder en temas deste foro',
	'RULES_REPLY_CANNOT'		=> '<strong>Non podes</strong> responder en temas deste foro',
	'RULES_VOTE_CAN'			=> '<strong>Podes</strong> votar nas enquisas deste foro',
	'RULES_VOTE_CANNOT'			=> '<strong>Non podes</strong> votar nas enquisas deste foro',

	'SEARCH'					=> 'Procurar',
	'SEARCH_MINI'				=> 'Procurar...',
	'SEARCH_ADV'				=> 'Procura avanzada',
	'SEARCH_ADV_EXPLAIN'		=> 'Ver as opcións avanzadas de procura',
	'SEARCH_KEYWORDS'			=> 'Procurar por palabras clave',
	'SEARCHING_FORUMS'			=> 'Procurando foros',
	'SEARCH_ACTIVE_TOPICS'		=> 'Ver temas activos',
	'SEARCH_FOR'				=> 'Procurar',
	'SEARCH_FORUM'				=> 'Procurar neste foro',	
	'SEARCH_NEW'				=> 'Ver novas mensaxes publicadas',
	'SEARCH_POSTS_BY'			=> 'Procurar mensaxes por',
	'SEARCH_SELF'				=> 'Ver as túas mensaxes publicadas',
	'SEARCH_TOPIC'				=> 'Procurar neste tema',
	'SEARCH_UNANSWERED'			=> 'Ver mensaxes publicadas sen resposta',
	'SEARCH_UNREAD'				=> 'Ver mensaxes publicadas sen ler',
	'SEARCH_USER_POSTS'			=> 'Procurar mensaxes publicadas polo usuario',
	'SECONDS'					=> 'Segundos',
	'SELECT'					=> 'Seleccionar',
	'SELECT_ALL_CODE'			=> 'Seleccionalo todo',
	'SELECT_DESTINATION_FORUM'	=> 'Selecciona o foro de destino',
	'SELECT_FORUM'				=> 'Selecciona un foro',
	'SEND_EMAIL'				=> 'Correo-e', // Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Correo-e',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Enviar mensaxe privada',
	'SETTINGS'					=> 'Configuración',
	'SIGNATURE'					=> 'Sinatura',
	'SKIP'						=> 'Saltar ao contido',
	'SMTP_NO_AUTH_SUPPORT'		=> 'O servidor SMTP non soporta autenticación',
	'SORRY_AUTH_READ'			=> 'Non estás autorizado para ler este foro',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Non estás autorizado para descargar este adxunto',
	'SORT_BY'					=> 'Ordenar por',
	'SORT_JOINED'				=> 'Data de rexistro',
	'SORT_LOCATION'				=> 'Ubicación',
	'SORT_RANK'					=> 'Rango',
	'SORT_POSTS'				=> 'Mensaxes publicadas',
	'SORT_TOPIC_TITLE'			=> 'Título do tema',
	'SORT_USERNAME'				=> 'Nome de usuario',
	'SPLIT_TOPIC'				=> 'Dividir tema',
	'SQL_ERROR_OCCURRED'		=> 'Houbo un erro de SQL ao xerar esta páxina. Se o problema persiste contacta co %sAdministrador do Taboleiro%s.',
	'STATISTICS'				=> 'Estatísticas',
	'START_WATCHING_FORUM'		=> 'Subscribirse ao foro',
	'START_WATCHING_TOPIC'		=> 'Subscribirse ao tema',
	'STOP_WATCHING_FORUM'		=> 'Desubscribirse do foro',
	'STOP_WATCHING_TOPIC'		=> 'Desubscribirse do tema',
	'SUBFORUM'					=> 'Subforo',
	'SUBFORUMS'					=> 'Subforos',
	'SUBJECT'					=> 'Asunto',
	'SUBMIT'					=> 'Enviar',

	'TERMS_USE'			=> 'Termos de uso',
	'TEST_CONNECTION'	=> 'Probar conexión',
	'THE_TEAM'			=> 'O equipo',
	'TIME'				=> 'Data',

	'TOO_LARGE'						=> 'O valor que inseriches é grande de máis.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'O valor do <strong>Máximo número de destinatarios permitido por mensaxe privada</strong> que inseriches é grande de máis.',
	'TOO_LONG'						=> 'O valor que inseriches é longo de máis.',

	'TOO_LONG_AIM'					=> 'O nome de pantalla que introduciches é longo de máis.',
	'TOO_LONG_CONFIRM_CODE'			=> 'O código de confirmación que inseriches é longo de máis.',
	'TOO_LONG_DATEFORMAT'			=> 'A data que inseriches é longa de máis.',
	'TOO_LONG_ICQ'					=> 'O número do ICQ que inseriches é longo de máis.',
	'TOO_LONG_INTERESTS'			=> 'Os intereses que introduciches son longos de máis.',
	'TOO_LONG_JABBER'				=> 'O nome da conta de Jabber que inseriches é longo de máis.',
	'TOO_LONG_LOCATION'				=> 'A ubicación que inseriches é longa de máis.',
	'TOO_LONG_MSN'					=> 'O nome do MSN que inseriches é longo de máis.',
	'TOO_LONG_NEW_PASSWORD'			=> 'O contrasinal que inseriches é longo de máis.',
	'TOO_LONG_OCCUPATION'			=> 'A ocupación que inseriches é demasiado longa.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'A confirmación do contrasinal que inseriches é longa de mais.',
	'TOO_LONG_USER_PASSWORD'		=> 'O contrasinal que inseriches é longo de máis.',
	'TOO_LONG_USERNAME'				=> 'O nome de usuario que inseriches é demasiado longo.',
	'TOO_LONG_EMAIL'				=> 'O enderezo de correo electrónico que inseriches é demasiado longo.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'A confirmación do enderezo de correo-e que inseriches é longa de mais.',
	'TOO_LONG_WEBSITE'				=> 'O enderezo do sitio web que inseriches é demasiado longo.',
	'TOO_LONG_YIM'					=> 'O nome do Yahoo Messenger que inseriches é longo de máis.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Tentaches votar por demasiadas opcións ',

	'TOO_SHORT'						=> 'O valor que inseriches é curto de máis.',

	'TOO_SHORT_AIM'					=> 'O nome da pantalla que inseriches é demasiado curto.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'O código de confirmación que inseriches é curto de máis.',
	'TOO_SHORT_DATEFORMAT'			=> 'A data que inseriches é curta de máis.',
	'TOO_SHORT_ICQ'					=> 'O número ICQ que inseriches é demasiado curto.',
	'TOO_SHORT_INTERESTS'			=> 'Os intereses que inseriches son demasiado curtos.',
	'TOO_SHORT_JABBER'				=> 'A nome da conta de Jabber que inseriches é demasiado curto.',
	'TOO_SHORT_LOCATION'			=> 'A ubicación que inseriches é demasiado curta.',
	'TOO_SHORT_MSN'					=> 'O nome MSN que inseriches é demasiado curto.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'O contrasinal que introduciches é demasiado curto.',
	'TOO_SHORT_OCCUPATION'			=> 'A ocupación que introduciches é demasiado curta.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'A confirmación do contrasinal que introduciches é demasiado curto.',
	'TOO_SHORT_USER_PASSWORD'		=> 'O contrasinal que introduciches é demasiado curto.',
	'TOO_SHORT_USERNAME'			=> 'O nome de usuario que introduciches é demasiado curto.',
	'TOO_SHORT_EMAIL'				=> 'O enderezo de correo-e que introduciches é demasiado curto.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'A confirmación do enderezo de correo-e que introduciches é demasiado curto.',
	'TOO_SHORT_WEBSITE'				=> 'O enderezo do sitio web que inseriches é demasiado curto.',
	'TOO_SHORT_YIM'					=> 'O nome do Yahoo Messenger que inseriches é demasiado curto.',
	
	'TOO_SMALL'						=> 'O valor que inseriches é pequeno de máis.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'O valor do <strong>Máximo número permitido de destinatarios por mensaxe privada</strong> que inseriches é pequeno de máis.',

	'TOPIC'				=> 'Tema',
	'TOPICS'			=> 'Temas',
	'TOPICS_UNAPPROVED'	=> 'Polo menos un tema neste foro non foi aprobado.',
	'TOPIC_ICON'		=> 'Icona do tema',
	'TOPIC_LOCKED'		=> 'Este tema está bloqueado, non podes editar mensaxes ou publicar máis respostas',
	'TOPIC_LOCKED_SHORT'=> 'Tema bloqueado',
	'TOPIC_MOVED'		=> 'Tema movido',
	'TOPIC_REVIEW'		=> 'Revisión do tema',
	'TOPIC_TITLE'		=> 'Título do tema',
	'TOPIC_UNAPPROVED'	=> 'Este tema non foi aprobado',
	'TOTAL_ATTACHMENTS'	=> 'Adxunto(s)',
	'TOTAL_LOG'			=> '1 log',
	'TOTAL_LOGS'		=> '%d logs',
	'TOTAL_NO_PM'		=> '0 mensaxes privadas en total',
	'TOTAL_PM'			=> '1 mensaxe privada en total',
	'TOTAL_PMS'			=> '$d mensaxes privadas en total',
	'TOTAL_POSTS'		=> 'Total de mensaxes publicadas',
	'TOTAL_POSTS_OTHER'	=> 'Total de mensaxes publicadas <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Total de mensaxes publicadas <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Feito un informe deste tema',
	'TOTAL_TOPICS_OTHER'=> 'Total de temas <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Total de temas <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Total de membros <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Total de membros <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Errores do PHP rastrexados: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Non se puido acceder á imaxe ou o arquivo non é unha imaxe válida.',
	'UNABLE_TO_DELIVER_FILE'=> 'Non se puido entregar o arquivo.',
	'UNKNOWN_BROWSER'		=> 'Navegador descoñecido',
	'UNMARK_ALL'			=> 'Desmarcar todo',
	'UNREAD_MESSAGES'		=> 'Mensaxes sen ler',
	'UNREAD_PM'				=> '<strong>%d</strong> mensaxe sen ler',
	'UNREAD_PMS'			=> '<strong>%d</strong> mensaxes sen ler',
	'UNREAD_POST'			=> 'Mensaxe publicada sen ler',
	'UNREAD_POSTS'			=> 'Mensaxes publicadas sen ler',
	'UNWATCH_FORUM_CONFIRM'		=> 'Estás certo de quereres desubscribirte deste foro?',
	'UNWATCH_FORUM_DETAILED'	=> 'Estás certo de quereres desubscribirte do foro “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Estás certo de quereres desubscribirte deste tema?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Estás certo de quereres desubscribirte do tema “%s”?',
	'UNWATCHED_FORUMS'		=> 'A partires de agora xa non estarás subscrito aos foros seleccionados.',
	'UNWATCHED_TOPICS'		=> 'A partires de agora xa non estarás subscrito aos temas seleccionados.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'A partires de agora xa non estarás subscrito ás entradas seleccionadas.',
	'UPDATE'				=> 'Actualizar',
	'UPLOAD_IN_PROGRESS'	=> 'A subida está en progreso actualmente',
	'URL_REDIRECT'			=> 'Se o teu navegador non admite meta redirección preme %sAQUÍ%s para efectuar a redirección.',
	'USERGROUPS'			=> 'Grupos',
	'USERNAME'				=> 'Nome de usuario',
	'USERNAMES'				=> 'Nomes de usuario',
	'USER_AVATAR'			=> 'Avatar de Usuario',
	'USER_CANNOT_READ'		=> 'Non podes ler mensaxes publicadas neste foro',
	'USER_POST'				=> '%d mensaxe publicada',
	'USER_POSTS'			=> '%d mensaxes publicadas',
	'USERS'					=> 'Usuarios',
	'USE_PERMISSIONS'		=> 'Comprobar permisos de usuarios',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Sentímolo moito, mais non estás autorizado a empregares esta característica. Pode que veñas de te rexistrar e precises de participares máis para poderes empregala.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Visto',
	'VIEWING_FAQ'				=> 'Vendo FAQ',
	'VIEWING_MEMBERS'			=> 'Vendo pormenores do membro',
	'VIEWING_ONLINE'			=> 'Vendo quen está en liña',
	'VIEWING_MCP'				=> 'Vendo panel de control de moderador',
	'VIEWING_MEMBER_PROFILE'	=> 'Vendo perfil do membro',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Vendo mensaxes privadas',
	'VIEWING_REGISTER'			=> 'Rexistrando conta',
	'VIEWING_UCP'				=> 'Vendo panel de control de usuario',
	'VIEWS'						=> 'Vistas',
	'VIEW_BOOKMARKS'			=> 'Ver favoritos',
	'VIEW_FORUM_LOGS'			=> 'Ver Logs',
	'VIEW_LATEST_POST'			=> 'Ver última mensaxe publicada',
	'VIEW_NEWEST_POST'			=> 'Ver a primeira mensaxe sen ler',
	'VIEW_NOTES'				=> 'Ver as notas do usuario',
	'VIEW_ONLINE_TIME'			=> 'baseado nos usuarios activos no último %d minuto',
	'VIEW_ONLINE_TIMES'			=> 'baseado nos usuarios activos nos últimos %d minutos',
	'VIEW_TOPIC'				=> 'Ver tema',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Anuncio: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Anuncio Global: ',
	'VIEW_TOPIC_LOCKED'			=> 'Bloqueado:',
	'VIEW_TOPIC_LOGS'			=> 'Ver rexistros (logs)',
	'VIEW_TOPIC_MOVED'			=> 'Movido:',
	'VIEW_TOPIC_POLL'			=> 'Enquisa:',
	'VIEW_TOPIC_STICKY'			=> 'Destacado:',
	'VISIT_WEBSITE'				=> 'Visitar sitio web',

	'WARNINGS'			=> 'Advertencias',
	'WARN_USER'			=> 'Advertir a usuario',
	'WATCH_FORUM_CONFIRM'	=> 'Estás certo de quereres subscribirte a este forum?',
	'WATCH_FORUM_DETAILED'	=> 'Estás certo de quereres subscribirte ao foro “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Estás certo de quereres subscribirte a este tema?',
	'WATCH_TOPIC_DETAILED'	=> 'Estás certo de quereres subscribirte ao tema “%s”?',
	'WELCOME_SUBJECT'	=> 'Benvido aos foros %s',
	'WEBSITE'			=> 'Sitio web',
	'WHOIS'				=> 'Quen é',
	'WHO_IS_ONLINE'		=> 'Quen está en liña',
	'WRONG_PASSWORD'	=> 'O contrasinal inserido é incorrecto.',

	'WRONG_DATA_ICQ'			=> 'O número que inseriches non é un número ICQ válido.',
	'WRONG_DATA_JABBER'			=> 'O nome que inseriches non é un nome de conta Jabber válido.',
	'WRONG_DATA_LANG'			=> 'O idioma que especificaches non é válido.',
	'WRONG_DATA_WEBSITE'		=> 'O enderezo do sitio web ten que ser un url válido, incluíndo o protocolo. Por exemplo, http://www.exemplo.com/.',
	'WROTE'						=> 'escribiu',

	'YEAR'				=> 'Ano',
	'YEAR_MONTH_DAY'	=> '(AAAA-MM-DD)',
	'YES'				=> 'Si',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'A última visita foi: %s',
	'YOU_NEW_PM'		=> 'Tes unha nova mensaxe privada na túa caixa de entrada',
	'YOU_NEW_PMS'		=> 'Tes novas mensaxes privadas na túa caixa de entrada',
	'YOU_NO_NEW_PM'		=> 'Non tes mensaxes privadas novas',

	'datetime'			=> array(
		'TODAY'		=> 'Hoxe,',
		'TOMORROW'	=> 'Mañá, ',
		'YESTERDAY'	=> 'Onte,',
		'AGO'		=> array(
			0		=> 'fai menos dun minuto',
			1		=> 'fai %d minuto',
			2		=> 'fai %d minutos',
			60		=> 'fai 1 hora',
		),

		'Sunday'	=> 'Domingo',
		'Monday'	=> 'Luns',
		'Tuesday'	=> 'Martes',
		'Wednesday'	=> 'Mércores',
		'Thursday'	=> 'Xoves',
		'Friday'	=> 'Venres',
		'Saturday'	=> 'Sábado',

		'Sun'		=> 'Dom',
		'Mon'		=> 'Lun',
		'Tue'		=> 'Mar',
		'Wed'		=> 'Mér',
		'Thu'		=> 'Xov',
		'Fri'		=> 'Ven',
		'Sat'		=> 'Sáb',

		'January'	=> 'Xaneiro',
		'February'	=> 'Febreiro',
		'March'		=> 'Marzo',
		'April'		=> 'Abril',
		'May'		=> 'Maio',
		'June'		=> 'Xuño',
		'July'		=> 'Xullo',
		'August'	=> 'Agosto',
		'September' => 'Setembro',
		'October'	=> 'Outubro',
		'November'	=> 'Novembro',
		'December'	=> 'Decembro',

		'Jan'		=> 'Xan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Abr',
		'May_short'	=> 'Mai',	// Short representation of "May". May_short used because in english the short and long date are the same for May.
		'Jun'		=> 'Xuñ',
		'Jul'		=> 'Xul',
		'Aug'		=> 'Ago',
		'Sep'		=> 'Set',
		'Oct'		=> 'Out',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Dec',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 horas',
		'-11'	=> 'UTC - 11 horas',
		'-10'	=> 'UTC - 10 horas',
		'-9.5'	=> 'UTC - 9:30 horas',
		'-9'	=> 'UTC - 9 horas',
		'-8'	=> 'UTC - 8 horas',
		'-7'	=> 'UTC - 7 horas',
		'-6'	=> 'UTC - 6 horas',
		'-5'	=> 'UTC - 5 horas',
		'-4.5'	=> 'UTC - 4:30 horas',
		'-4'	=> 'UTC - 4 horas',
		'-3.5'	=> 'UTC - 3:30 horas',
		'-3'	=> 'UTC - 3 horas',
		'-2'	=> 'UTC - 2 horas',
		'-1'	=> 'UTC - 1 hora',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 hora',
		'2'		=> 'UTC + 2 horas',
		'3'		=> 'UTC + 3 horas',
		'3.5'	=> 'UTC + 3:30 horas',
		'4'		=> 'UTC + 4 horas',
		'4.5'	=> 'UTC + 4:30 horas',
		'5'		=> 'UTC + 5 horas',
		'5.5'	=> 'UTC + 5:30 horas',
		'5.75'	=> 'UTC + 5:45 horas',
		'6'		=> 'UTC + 6 horas',
		'6.5'	=> 'UTC + 6:30 horas',
		'7'		=> 'UTC + 7 horas',
		'8'		=> 'UTC + 8 horas',
		'8.75'	=> 'UTC + 8:45 horas',
		'9'		=> 'UTC + 9 horas',
		'9.5'	=> 'UTC + 9:30 horas',
		'10'	=> 'UTC + 10 horas',
		'10.5'	=> 'UTC + 10:30 horas',
		'11'	=> 'UTC + 11 horas',
		'11.5'	=> 'UTC + 11:30 horas',
		'12'	=> 'UTC + 12 horas',
		'12.75'	=> 'UTC + 12:45 horas',
		'13'	=> 'UTC + 13 horas',
		'14'	=> 'UTC + 14 horas',
		'dst'	=> '[ <abbr title="Horario de Verán">HV(DST)</abbr> ]',
	),

	'tz_zones'	=> array(
				'-12'	=> '[UTC - 12] Horario de Baker Island',
		'-11'	=> '[UTC - 11] Horario de Niue, Horario Estándar de Samoa',
		'-10'	=> '[UTC - 10] Horario estándar de Hawaii-Aleutian, Horario de Cook Island',
		'-9.5'	=> '[UTC - 9:30] Horario das Illas Marquesas',
		'-9'	=> '[UTC - 9] Horario Estándar de Alaska, Horario de Gambier Island',
		'-8'	=> '[UTC - 8] Horario Estándar do Pacífico',
		'-7'	=> '[UTC - 7] Horario Estándar das Montañas',
		'-6'	=> '[UTC - 6] Horario Estándar Central',
		'-5'	=> '[UTC - 5] Horario Estándar Oriental',
		'-4.5'	=> '[UTC - 4:30] Horario Estándar de Venezuela',
		'-4'	=> '[UTC - 4] Horario Estándar Atlántico',
		'-3.5'	=> '[UTC - 3:30] Horario Estándar de Newfoundland',
		'-3'	=> '[UTC - 3] Horario Estándar do Amazonas, Horario Central de Greenland',
		'-2'	=> '[UTC - 2] Horario de Fernando de Noronha, Sur de Xeorxia e Horario do Sur das Illas Sandwich',
		'-1'	=> '[UTC - 1] Horario Estándar das Azores, Horario de Cabo Verde, Horario do Este de Greenland',
		'0'		=> '[UTC] Horario da Europa Occidental, Horario de Greenwich',
		'1'		=> '[UTC + 1] Horario da Europa Central, Horario da África do Oeste, Horario da Galiza',
		'2'		=> '[UTC + 2] Horario da Europa do leste, Horario da África Central',
		'3'		=> '[UTC + 3] Horario Estándar de Moscú, Horario da África Oriental',
		'3.5'	=> '[UTC + 3:30] Horario Estándar do Irán',
		'4'		=> '[UTC + 4] Horario Estándar do Golfo, Horario Estándar de Samara',
		'4.5'	=> '[UTC + 4:30] Horario do Afganistán',
		'5'		=> '[UTC + 5] Horario Estándar do Pakistán, Horario Estándar de Yekaterinburg',
		'5.5'	=> '[UTC + 5:30] Horario Estándar da India, Horario de Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Horario do Nepal',
		'6'		=> '[UTC + 6] Horario de Bangladesh, Horario de Bhutan, Horario Estándar de Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Horario de Cocos Islands, Horario de Myanmar',
		'7'		=> '[UTC + 7] Horario de Indochina, Horario Estándar de Krasnoyarsk',
		'8'		=> '[UTC + 8] Horario Estándar da China, Horario Estándar do Oeste de Australia, Horario Estándar de Irkutsk',
		'8.75'	=> '[UTC + 8:45] Horario Estándar do sudeste occidental de Australia',
		'9'		=> '[UTC + 9] Horario Estándar do Xapón, Horario Estándar de Corea, Horario Estándar de Chita',
		'9.5'	=> '[UTC + 9:30] Horario Estándar de Australia Central',
		'10'	=> '[UTC + 10] Horario Estándar do leste de Australia, Horario Estándar de Vladivostok',
		'10.5'	=> '[UTC + 10:30] Horario Estándar de Lord Howe',
		'11'	=> '[UTC + 11] Horario das Illas Salomón, Horario Estándar de Magadan',
		'11.5'	=> '[UTC + 11:30] Horario da Illa Norfolk',
		'12'	=> '[UTC + 12] Horario de Nova Zelanda, Horario de Fiji, Horario Estándar de Kamchatka',
		'12.75'	=> '[UTC + 12:45] Horario das Illas Chatham',
		'13'	=> '[UTC + 13] Horario de Tonga, Horario das Illas Phoenix',
		'14'	=> '[UTC + 14] Horario de Line Island',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Xan 2007, 13:37',
		'd M Y H:i'				=> '01 Xan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Xan 1o, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Lun Xan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'			=> 'Xaneiro 1o, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Hoxe, 13:37 / 01 Xan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Hoxe, 1:37 pm / Xaneiro 1o, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D, d M Y, H:i', // Luns, 01 Xan 2007, 13:37

));

?>
