import sys
import os
import subprocess

class bcolors:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'

def test_program(name):
    x = None
    t = None
    print ("TESTING",name)
    if name == "pxlstr":
        cm = "./pxlstr -t TEST/test.tre"
        t = 'tree #: 0\nrooted: true\nbinary: true\nnterminal: 5\nninternal: 4\nbranch lengths: true\nrttipvar: 0.004634\ntreelength: 1.595\nultrametric: false\nrootheight: NA\n'
    elif name == "pxlssq":
        cm = "./pxlssq -s TEST/test.fa"
        t = 'File type: fasta\nNumber of sequences: 5\nIs aligned: true\nSequence length: 20\n--------Nucl TABLE---------\nNucl   Total      Proportion\nA      20         0.2\nC      37         0.37\nG      18         0.18\nT      25         0.25\n-      0          0\nN      0          0\nG+C    55         0.55\n--------Nucl TABLE---------\n'
    elif name == "pxbp":
        cm = "./pxbp -t TEST/test.tre"
        t = '1 trees \n3 unique clades found\nCLADE: TaxonA TaxonB 	FREQ:	1.	ICA:	1.	COUNT:	1	TREEFREQ:	1.\nCLADE: TaxonA TaxonB TaxonC 	FREQ:	1.	ICA:	1.	COUNT:	1	TREEFREQ:	1.\nCLADE: TaxonD TaxonE 	FREQ:	1.	ICA:	1.	COUNT:	1	TREEFREQ:	1.\nTSCA: 3\n'
    elif name == "pxbdfit":
        cm = "./pxbdfit -t TEST/ultra_100.tre"
        t = 'ntips: 10\nnspeciation: 8\ntreelength: 8.67581\nrootheight: 1.74148\nmodel: bd\nlikelihood: 4.18076\naic: -4.36152\naicc: -2.64723\nb: 1.05759\nd: 0.319273\nr (b-d): 0.738315\ne (d/b): 0.301888\n'
    elif name == "pxtscale":
        cm = "./pxtscale -t TEST/test.tre -s 10"
        t = '(((TaxonA:1,TaxonB:0.3):1.25,TaxonC:2.5):4,(TaxonD:2.3000000000000003,TaxonE:1.6000000000000001):3);\n'
    elif name == "pxupgma":
        cm = "./pxupgma -s TEST/test.fa"
        t = 'TaxonA\tTaxonB\tTaxonC\tTaxonD\tTaxonE\t\nTaxonA\t0\t18\t12\t14\t14\t\nTaxonB\t18\t0\t16\t16\t14\t\nTaxonC\t12\t16\t0\t15\t15\t\nTaxonD\t14\t16\t15\t0\t9\t\nTaxonE\t14\t14\t15\t9\t0\t\n(((TaxonA:6.000000,TaxonC:6.000000):1.250000,(TaxonD:4.500000,TaxonE:4.500000):2.750000):0.750000,TaxonB:8.000000);\n'
    elif name == "pxs2phy":
        cm = "./pxs2phy -s TEST/test.fa"
        t = '5 20\nTaxonA\tAAATTTCCCTGTCCCTTTAA\nTaxonB\tGCTCGAGGGGCCCCAAGACC\nTaxonC\tACGCTCCCCCTTAAAAATGA\nTaxonD\tTCCTTGTTCAACTCCGGTGG\nTaxonE\tTTACTATTCCCCCCCGCCGG\n'
    elif name == "pxfqfilt":
        cm = "./pxfqfilt -m 20 -s TEST/test.fastq | wc -l"
        t = "3872\n"
    elif name == "pxs2nex":
        cm = "./pxs2nex -s TEST/test.fa"
        t = '#NEXUS\nBEGIN DATA;\n\tDIMENSIONS NTAX=5 NCHAR=20;\n\tFORMAT DATATYPE=DNA INTERLEAVE=NO GAP=-;\n\tMATRIX\n\nTaxonA\tAAATTTCCCTGTCCCTTTAA\nTaxonB\tGCTCGAGGGGCCCCAAGACC\nTaxonC\tACGCTCCCCCTTAAAAATGA\nTaxonD\tTCCTTGTTCAACTCCGGTGG\nTaxonE\tTTACTATTCCCCCCCGCCGG\n;\nend;\n\n'
    elif name == "pxnw":
        cm = "./pxnw -s TEST/test.fa | grep TaxonA | grep TaxonB"
        t = 'TaxonA\tTaxonB\t40\n'
    elif name == "pxrecode":
        cm = "./pxrecode -s TEST/test.fa"
        t = '>TaxonA\nRRRYYYYYYYRYYYYYYYRR\n>TaxonB\nRYYYRRRRRRYYYYRRRRYY\n>TaxonC\nRYRYYYYYYYYYRRRRRYRR\n>TaxonD\nYYYYYRYYYRRYYYYRRYRR\n>TaxonE\nYYRYYRYYYYYYYYYRYYRR\n'
    elif name == "pxsw":
        cm = "./pxsw -s TEST/test.fa | grep TaxonA | grep TaxonB"
        t = 'TaxonA\tTaxonB\t40\n'
    elif name == "pxrms":
        cm = "./pxrms -s TEST/test.fa -n TaxonA"
        t = '>TaxonB\nGCTCGAGGGGCCCCAAGACC\n>TaxonC\nACGCTCCCCCTTAAAAATGA\n>TaxonD\nTCCTTGTTCAACTCCGGTGG\n>TaxonE\nTTACTATTCCCCCCCGCCGG\n'
    elif name == "pxboot":
        cm = "./pxboot -s TEST/test.fa -x 1 | grep -c \>"
        t = '5\n'
    elif name == "pxrevcomp":
        cm = "./pxrevcomp -s TEST/test.fa"
        t = '>TaxonA\nTTAAAGGGACAGGGAAATTT\n>TaxonB\nGGTCTTGGGGCCCCTCGAGC\n>TaxonC\nTCATTTTTAAGGGGGAGCGT\n>TaxonD\nCCACCGGAGTTGAACAAGGA\n>TaxonE\nCCGGCGGGGGGGAATAGTAA\n'
    elif name == "pxt2new":
        cm = "./pxt2new -t TEST/test_nexus.tre"
        t = '(((TaxonA:0.1,TaxonB:0.03):0.125,TaxonC:0.25):0.4,(TaxonD:0.23,TaxonE:0.16):0.3);\n'
    elif name == "pxt2nex":
        cm = "./pxt2nex -t TEST/collapse.tre"
        t = '#NEXUS\nBegin trees;\ntree tree0 = [&R] (((TaxonA:0.1,TaxonB:0.03)0.43:0.125,TaxonC:0.25)1.0:0.4,(TaxonD:0.23,TaxonE:0.16)0.94:0.3);\nend;\n'
    elif name == "pxbdsim":
        cm = "./pxbdsim -e 5 -x 1 | grep -o taxon | wc -l"
        t = '5\n'
    elif name == "pxs2fa":
        cm = "./pxs2fa -s TEST/Concat_Sequence2.NEX"
        t = '>Sequence1\nAAATTTCCCTTTCCCTTTAAA\n>Sequence2\nGGGGGGGGGGCCCCCCCCCCA\n>Sequence3\nCCCCCCCCCCCCAAAAAAAAA\n>Sequence9\nAAATTTCCCTTTCCCTTTAAA\n>Sequence10\nGGGGGGGGGGCCCCCCCCCCA\n>Sequence11\nCCCCCCCCCCCCAAAAAAAAA\n>Sequence8\nTTTTTTTTCCCCCCCGGGGGA\n'
    elif name == "pxrr":
        cm = "./pxrr -t TEST/test.tre -g TaxonA"
        t = '(TaxonA:0.05,(TaxonB:0.03,((TaxonD:0.23,TaxonE:0.16):0.7,TaxonC:0.25):0.125):0.05);\n'
    elif name == "pxnj":
        cm = "./pxnj -s TEST/test.fa"
        t = '((((TaxonA:0.300000,TaxonC:0.300000):0.112500,TaxonB:0.437500):0.087500,TaxonD:0.250000):0.100000,TaxonE:0.100000);\n'
    elif name == "pxconsq":
        cm = "./pxconsq -s TEST/test.fa"
        t = '>consensus\nDHNYKNBBSNNYHMMDNHVV\n'
    elif name == "pxseqgen":
        cm = "./pxseqgen -t TEST/test.tre -x 1 -l 10"
        t = '>TaxonE\nCTGTAACTAG\n>TaxonD\nCTGTAACTAG\n>TaxonC\nGTCTAACAGG\n>TaxonB\nGTTTGACTGG\n>TaxonA\nTTTTGACTGG\n'
    elif name == "pxrmt":
        cm = "./pxrmt -t TEST/test.tre -n TaxonA"
        t = '((TaxonC:0.25,TaxonB:0.155):0.4,(TaxonD:0.23,TaxonE:0.16):0.3);\n'
    elif name == "pxcat":
        cm = "./pxcat -s TEST/test.fa TEST/test.fa"
        t = '>TaxonA\nAAATTTCCCTGTCCCTTTAAAAATTTCCCTGTCCCTTTAA\n>TaxonB\nGCTCGAGGGGCCCCAAGACCGCTCGAGGGGCCCCAAGACC\n>TaxonC\nACGCTCCCCCTTAAAAATGAACGCTCCCCCTTAAAAATGA\n>TaxonD\nTCCTTGTTCAACTCCGGTGGTCCTTGTTCAACTCCGGTGG\n>TaxonE\nTTACTATTCCCCCCCGCCGGTTACTATTCCCCCCCGCCGG\n'
    elif name == "pxtlate":
        cm = "./pxtlate -s TEST/trlateTest.fa"
        t = '>Sequence1\nKFKPG*X\n>Sequence2\nKPGKI*\n>Sequence3\nIYIYIL\n'
    elif name == "pxcontrates":
        cm = "./pxcontrates -c TEST/contrates_file.txt -t TEST/contrates_tree.tre"
        t = '#nexus\nbegin trees;\ntree tree0 = ((((s1[&value=100.000000000]:0.360355,s2[&value=100.000000000]:0.360355)[&value=100.892125727]:0.896878,s3[&value=120.000000000]:1.25723)[&value=105.332899025]:0.420755,(((s4[&value=110.000000000]:0.119033,s5[&value=80.000000000]:0.119033)[&value=93.952153267]:0.0254417,s6[&value=90.000000000]:0.144475)[&value=93.504227541]:0.764764,s7[&value=100.000000000]:0.909239)[&value=98.589114242]:0.768749)[&value=102.507614350]:0.0634916,((s8[&value=100.000000000]:0.310689,s9[&value=100.000000000]:0.310689)[&value=100.154669043]:0.103151,s10[&value=100.000000000]:0.41384)[&value=100.257371380]:1.32764)[&value=102.404912715];\ntree tree1 = ((((s1[&value=19.000000000]:0.360355,s2[&value=18.000000000]:0.360355)[&value=18.086986419]:0.896878,s3[&value=17.000000000]:1.25723)[&value=16.031110631]:0.420755,(((s4[&value=16.000000000]:0.119033,s5[&value=15.000000000]:0.119033)[&value=15.080525602]:0.0254417,s6[&value=14.000000000]:0.144475)[&value=14.901211808]:0.764764,s7[&value=13.000000000]:0.909239)[&value=14.281614892]:0.768749)[&value=14.742377359]:0.0634916,((s8[&value=12.000000000]:0.310689,s9[&value=11.000000000]:0.310689)[&value=11.388982194]:0.103151,s10[&value=10.000000000]:0.41384)[&value=11.315264869]:1.32764)[&value=14.585963113];\ntree tree2 = ((((s1[&value=20.000000000]:0.360355,s2[&value=20.000000000]:0.360355)[&value=20.000000000]:0.896878,s3[&value=20.000000000]:1.25723)[&value=20.000000000]:0.420755,(((s4[&value=20.000000000]:0.119033,s5[&value=20.000000000]:0.119033)[&value=20.000000000]:0.0254417,s6[&value=20.000000000]:0.144475)[&value=20.000000000]:0.764764,s7[&value=20.000000000]:0.909239)[&value=20.000000000]:0.768749)[&value=20.000000000]:0.0634916,((s8[&value=20.000000000]:0.310689,s9[&value=20.000000000]:0.310689)[&value=20.000000000]:0.103151,s10[&value=20.000000000]:0.41384)[&value=20.000000000]:1.32764)[&value=20.000000000];\nend;\n\n'
    elif name == "pxmrca":
        cm = "./pxmrca -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = 'KIM 50 \nLEE 11 \nTHURSTON 2 \n'
    elif name == "pxmrcacut":
        cm = "./pxmrcacut -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = '((((s19:8.9192294969999999,s21:8.9192294939999996):19.9522496099999991,(((s28:1.9460922439999999,(s29:1.0875761909999999,(s30:0.892917128,s31:0.892917128):0.1946590628):0.8585160526):8.3971209000000009,s32:10.3432131500000004):11.0954325699999998,((s33:7.2263048049999998,((s34:2.6703496819999999,s35:2.6703496819999999):2.2229339779999999,s36:4.8932836599999998):2.333021145):7.1928712350000001,((s38:0.6421928454,s39:0.6421928454):0.0263742241,s40:0.6685670695):13.75060897):7.0194696820000004):7.4328333889999998):9.4218491340000003,(((s46:12.2010411199999993,s49:12.2010411199999993):6.6047551540000002,(s51:5.4152383840000002,s52:5.4152383840000002):13.3905578900000002):7.9737073949999999,s56:26.7795036700000004):11.5138245799999996):38.8094614199999981,(((((s87:3.6908438889999999,s88:3.6908438889999999):11.4507337099999997,(((s90:4.7201172930000004,(s91:3.9975684220000001,s92:3.9975684220000001):0.722548871):1.5459479199999999,(s93:2.1981845510000002,s94:2.1981845510000002):4.0678806630000004):0.4042469457,s95:6.6703121569999997):8.4712654399999998):12.3930690600000002,((s98:5.0744154459999997,s100:5.0744154459999997):14.9727031700000008,s104:20.0471186199999991):7.4875280369999997):20.7336537000000014,s126:48.268300349999997):16.5419383899999985,((((s133:19.1945240800000008,(s135:5.4586278740000003,(s136:0.5006869268,s137:0.5006869268):4.9579409449999998):13.7358962099999999):8.3350646560000001,s140:27.5295887400000012):2.2861742469999999,((s151:16.8626535299999993,((s153:3.9294314930000001,s154:3.9294314930000001):0.5895208589000001,(s155:4.4774633660000003,(s156:2.7123332000000002,s157:2.7123332000000002):1.7651301660000001):0.04148898642):12.3437011699999992):11.4377336100000004,s162:28.3003871400000016):1.515375849):2.6277221590000002,((s169:7.8409351410000001,s170:7.8409351410000001):7.5946375750000001,(s172:13.3298600599999997,(s173:6.7214149780000003,((s174:0.3080707103,s175:0.3080707103):4.1074336630000001,s177:4.4155043730000001):2.3059106030000001):6.6084450869999998):2.1057126570000002):17.0079124300000011):32.3667536000000027):12.29255092);\n((((((s283:0.4995078195,s284:0.4995078195):2.3766585789999999,s285:2.8761663990000002):13.2757500999999998,s286:16.1519164900000014):14.5552332300000007,(s288:9.1306009830000008,(s289:5.3395037639999998,s290:5.3395037639999998):3.791097218):21.5765487399999998):2.4713881350000002,((s292:0.1094902985,s293:0.1094902985):21.110084839999999,s296:21.2195751399999999):11.9589627200000006):12.9721000100000001,s307:46.1506378699999971);\n(s19:8.9192294969999999,s21:8.9192294939999996);\n'
    elif name == "pxmrcaname":
        cm = "./pxmrcaname -t TEST/mrca_test.tre -m TEST/mrca.txt"
        t = '(((((s19:8.9192294969999999,s21:8.9192294939999996)THURSTON:19.9522496099999991,(((s28:1.9460922439999999,(s29:1.0875761909999999,(s30:0.892917128,s31:0.892917128):0.1946590628):0.8585160526):8.3971209000000009,s32:10.3432131500000004):11.0954325699999998,((s33:7.2263048049999998,((s34:2.6703496819999999,s35:2.6703496819999999):2.2229339779999999,s36:4.8932836599999998):2.333021145):7.1928712350000001,((s38:0.6421928454,s39:0.6421928454):0.0263742241,s40:0.6685670695):13.75060897):7.0194696820000004):7.4328333889999998):9.4218491340000003,(((s46:12.2010411199999993,s49:12.2010411199999993):6.6047551540000002,(s51:5.4152383840000002,s52:5.4152383840000002):13.3905578900000002):7.9737073949999999,s56:26.7795036700000004):11.5138245799999996):38.8094614199999981,(((((s87:3.6908438889999999,s88:3.6908438889999999):11.4507337099999997,(((s90:4.7201172930000004,(s91:3.9975684220000001,s92:3.9975684220000001):0.722548871):1.5459479199999999,(s93:2.1981845510000002,s94:2.1981845510000002):4.0678806630000004):0.4042469457,s95:6.6703121569999997):8.4712654399999998):12.3930690600000002,((s98:5.0744154459999997,s100:5.0744154459999997):14.9727031700000008,s104:20.0471186199999991):7.4875280369999997):20.7336537000000014,s126:48.268300349999997):16.5419383899999985,((((s133:19.1945240800000008,(s135:5.4586278740000003,(s136:0.5006869268,s137:0.5006869268):4.9579409449999998):13.7358962099999999):8.3350646560000001,s140:27.5295887400000012):2.2861742469999999,((s151:16.8626535299999993,((s153:3.9294314930000001,s154:3.9294314930000001):0.5895208589000001,(s155:4.4774633660000003,(s156:2.7123332000000002,s157:2.7123332000000002):1.7651301660000001):0.04148898642):12.3437011699999992):11.4377336100000004,s162:28.3003871400000016):1.515375849):2.6277221590000002,((s169:7.8409351410000001,s170:7.8409351410000001):7.5946375750000001,(s172:13.3298600599999997,(s173:6.7214149780000003,((s174:0.3080707103,s175:0.3080707103):4.1074336630000001,s177:4.4155043730000001):2.3059106030000001):6.6084450869999998):2.1057126570000002):17.0079124300000011):32.3667536000000027):12.29255092)KIM:22.8972103300000001,((((((((s213:0.2029741842,s214:0.2029741842):12.7161028100000006,((s216:5.6164296230000001,(s218:3.7133940970000001,s219:3.7133940970000001):1.9030355269999999):3.1149687089999998,(s221:4.9410893590000002,s222:4.9410893610000004):3.7903089730000001):4.1876786619999997):2.7811719639999999,s224:15.7002489599999997):8.1136411430000006,(s228:16.4039877199999999,s229:16.4039877199999999):7.4099023769999999):20.1939318900000018,(((s235:1.164761961,s237:1.164761961):30.9289779899999999,(((s239:11.8092034100000003,(s240:1.1451934539999999,s241:1.1451934539999999):10.6640099599999996):6.4760607239999999,(s243:5.3663286640000001,s244:5.3663286640000001):12.91893548):0.5879546054,((s246:1.021385454,s247:1.021385454):2.2789929720000002,s248:3.3003784249999999):15.5728403199999992):13.2205212099999994):1.9422983140000001,((((s252:0.8909838051,s253:0.8909838051):1.4460778729999999,(s254:0.5364767172,s255:0.5364767172):1.800584961):0.5351456596,s256:2.8722073379999999):1.872321111,s257:4.7445284489999997):29.2915098100000009):9.9717837229999997):17.8392979599999997,(s266:27.9293939900000012,(s268:4.2347317469999997,s269:4.2347317469999997):23.6946622399999995):33.9177259599999985):17.5285275700000014,(((((((s283:0.4995078195,s284:0.4995078195):2.3766585789999999,s285:2.8761663990000002):13.2757500999999998,s286:16.1519164900000014):14.5552332300000007,(s288:9.1306009830000008,(s289:5.3395037639999998,s290:5.3395037639999998):3.791097218):21.5765487399999998):2.4713881350000002,((s292:0.1094902985,s293:0.1094902985):21.110084839999999,s296:21.2195751399999999):11.9589627200000006):12.9721000100000001,s307:46.1506378699999971)LEE:9.3515165059999994,(s325:1.575825061,s326:1.575825061):53.9263293200000007):23.8734931400000008):10.7713989100000003,(((s340:9.9405505230000006,s341:9.9405505230000006):21.0295773699999984,((s345:9.0691226749999991,s347:9.0691226769999993):1.9682665619999999,(s348:7.1978738189999998,s350:7.1978738189999998):3.839515418):19.9327386599999983):45.3301916799999987,(s381:4.5261479199999997,s382:4.5261479199999997):71.7741716599999933):13.8467268499999996):9.8529535619999997);\n'            
    elif name == "pxvcf2fa":
        cm = "./pxvcf2fa -s TEST/vcf_file"
        t = '>APC1\nCACCCCATTCTCGCATCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGTCGACCCCC\n>APC2\nCGCCCCATTCTCGCATCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GPC1\nCGCCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCTCGGGCGCCAACCCCC\n>GPC2\nCGCCCCCTTCTCGCACCACCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GPC3\nCACCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCGACCCCC\n>GPCREF\nCGCCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCGACCCCC\n>HH1\nCACCCCCTTCTCGCATCATCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH2\nCACCCCCTTCTCGCATCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH3\nCACCCCCTTCTCGCATCACCCAACGCCCACGAAGTATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH4\nCACCCCCTTCTCGCACCATCCAACGCCCACGAAGCATTATGACCGGTACGCGTCCTGGTCGCCGCGGGCGCCAACCCCC\n>HH5\nCACCTCCTTCTCGCATCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>LPC1\nCGCCCCATTCTCGCACCATCCAACGCCCACGAGGTATTATGACCGGTACGCGCCCTGGTCGCCTCGGGCGCCAGCCCCC\n>LPC2\nCGCCCCATTCTCGCACCACCCAACGCCCACGAAGCATTAGGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>QHH1\nCACTTCCTTCTCGCTCCGTCCGACATCTACGGAGCATCGTGACTGGCACACGTCCTGATCGCTTCAGACGCTAACCCCT\n>QHH2\nTGCCCCCTTCTCACACTATCTAATGTTCACAAAGCACTAGAACCGGTACGCGCCTTGGTCACCGTGAGCGCCGACTTCC\n>QHH3\nCACCCTCCTCTCGCATCATCCAACGCCCACGAAGTATTAGGACCGGTCCGCGCCCTAGTCGCCGCGGGTGCCAACCCTC\n>QHH4\nCGTCCCCTTTTCGCACCATTCAACGCCCACGAAACATTAGGATCGGTATGTGCCCTGGCTGCCGCGGGCACCAATCCCC\n>STG1\nCGCCCCCTCCTCGCACCATCCAACGCCCATGAAGTATCATGACCGGTACGCACCCTGGTCGCCTCGGGCGCCAACCCCC\n>STG2\nCGCCCCCTCCTCGCACCATCCAACGCCCGTGAAGCATCGTGACCGGTACGCGCCCTGGTCGCCGCGGGCGCCAACCCCC\n>GNNSN\nCGCCCCCTTCCAGTACCATCCAGCGCCCACGAAGCGTTATGGCCAATACGCGCTCCGGTCGTCGCGGGCGCCGACCCCC\n'
    elif name == "pxrlt":
        cm = "./pxrlt -t TEST/kingdoms.tre -c TEST/kingdoms.oldnames.txt -n TEST/kingdoms.newnames.txt"
        t = '(Eubacteria:4200,(Archaea:3806.0102499999998145,((((SAR:1626.0427319999998872,Plant:1626.0276670000000649):72.3801839999999999,Excavata:1698.4229159999999865):74.7312199999999933,Amoebozoa:1773.1541360000001077):7.9375349999999996,(Animal:1295.717544000000089,Fungi:1295.7033610000000863):485.3800600000000145):2024.9200000000000728):394);\n'
    elif name == "pxrls":
        cm = "./pxrls -s TEST/test.fa -c TEST/oldnames.txt -n TEST/newnames.txt"
        t = '>Cinclus_mexicanus\nAAATTTCCCTGTCCCTTTAA\n>Anodorhynchus_hyacinthinus\nGCTCGAGGGGCCCCAAGACC\n>Stellula_calliope\nACGCTCCCCCTTAAAAATGA\n>Anser_anser\nTCCTTGTTCAACTCCGGTGG\n>Gallus_gallus\nTTACTATTCCCCCCCGCCGG\n'
    elif name == "pxclsq":
        cm = "./pxclsq -s TEST/Alignment -p 0.6"
        t = '>Sequence1\nAAATTTCCCTTTCCCTTTAAAAAATTTCCCTTTCCCTTTAAA\n>Sequence10\nGGGGGGGGGGCCCCCCCCCCAGGGGGGGGGGCCCCCCCCCCA\n>Sequence11\nCCCCCCCCCCCCAAAAAAAAACCCCCCCCCCCCAAAAAAAAA\n>Sequence2\nGGGGGGGGGGCCCCCCCCCCAGGGGGGGGGGCCCCCCCCCCA\n>Sequence3\nCCCCCCCCCCCCAAAAAAAAACCCCCCCCCCCCAAAAAAAAA\n>Sequence8\nTTTTTTTTCCCCCCCGGGGGATTTTTTTTCCCCCCCGGGGGA\n>Sequence9\nAAATTTCCCTTTCCCTTTAAAAAATTTCCCTTTCCCTTTAAA\n'
    elif name == "pxlog":
        cm = "./pxlog -t TEST/run1.trees TEST/run2.trees -b 75 -n 2"
        t = '#NEXUS\n\nBegin taxa;\n	Dimensions ntax=33;\n	Taxlabels\n		113_V_gryphus\n		128_C_burrovianus\n		135_C_aura\n		31_C_melambrotus\n		6_C_atratus\n		97_S_papa\n		9_G_californianus\n		Anas_clypeata\n		Anas_platyrhunchos\n		Apterodytes_patagonicus\n		Ardea_herodias\n		Asio_otus\n		Balaeniceps_rex\n		Bonasa_umbellus\n		Bucephala_abeola\n		Caracara_cheriway\n		Charadrius_alexandrinus\n		Ciconia_maguari\n		Ephippiorhynchus_senegalensis\n		Falco_femoralis\n		Falco_peregrinus\n		Falco_rusticolus\n		Fulmarus_glacialis\n		Gallus_gallus\n		Gavia_immer\n		Gyps_bengalensis\n		Larus_marinus\n		Lunda_cirrhata\n		Nyctanassa_violacea\n		Pandion\n		Pygoscelis_antarcticus\n		Sagittarius\n		Scopus_umbretta\n		;\nEnd;\n\nBegin trees;\n	Translate\n		1 113_V_gryphus,\n		2 128_C_burrovianus,\n		3 135_C_aura,\n		4 31_C_melambrotus,\n		5 6_C_atratus,\n		6 97_S_papa,\n		7 9_G_californianus,\n		8 Anas_clypeata,\n		9 Anas_platyrhunchos,\n		10 Apterodytes_patagonicus,\n		11 Ardea_herodias,\n		12 Asio_otus,\n		13 Balaeniceps_rex,\n		14 Bonasa_umbellus,\n		15 Bucephala_abeola,\n		16 Caracara_cheriway,\n		17 Charadrius_alexandrinus,\n		18 Ciconia_maguari,\n		19 Ephippiorhynchus_senegalensis,\n		20 Falco_femoralis,\n		21 Falco_peregrinus,\n		22 Falco_rusticolus,\n		23 Fulmarus_glacialis,\n		24 Gallus_gallus,\n		25 Gavia_immer,\n		26 Gyps_bengalensis,\n		27 Larus_marinus,\n		28 Lunda_cirrhata,\n		29 Nyctanassa_violacea,\n		30 Pandion,\n		31 Pygoscelis_antarcticus,\n		32 Sagittarius,\n		33 Scopus_umbretta\n		;\ntree STATE_0 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55165.13148245269,EEF_ucld_branchRates=-266.168517335019,lnP=-55165.13148245269,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.491519171407602E-4]:1.13257396578E1,9[&rate=6.367032323998896E-4]:1.13257396578E1)[&rate=7.858985904720106E-4]:4.464111684496E0,15[&rate=4.1233866807259843E-4]:1.57898513423E1)[&rate=6.875024701695477E-4]:1.092846716327E2,(14[&rate=0.0012135271601642415]:4.944525647579E1,24[&rate=5.521552390624093E-4]:4.944525647579E1)[&rate=0.0010441679181449727]:7.562926649923E1)[&rate=9.262993402486683E-4]:1.723696214156E0,(((25[&rate=7.708275361737002E-4]:7.181708005364E1,((((30[&rate=6.121845853669823E-4]:4.985660910622E1,26[&rate=7.14127096657731E-4]:4.985660910622E1)[&rate=0.0010176993850459428]:9.995868247001E0,32[&rate=3.4625317941899754E-4]:5.985247735322E1)[&rate=4.6653751154651294E-4]:7.996827625354E0,((16[&rate=3.974271783369831E-4]:3.380740319842E1,((22[&rate=8.338699316080518E-4]:3.257441736696E0,21[&rate=7.56148400880097E-4]:3.257441736696E0)[&rate=6.367032323998896E-4]:3.227919911685E0,20[&rate=9.928761850134726E-4]:6.48536164838E0)[&rate=0.001311098279928485]:2.732204155004E1)[&rate=9.928761850134726E-4]:3.371522301258E1,((((3[&rate=3.2549049638558433E-4]:1.432620961347E0,4[&rate=0.0010441679181449727]:1.432620961347E0)[&rate=5.640993501024151E-4]:3.934199057588E-1,2[&rate=6.000746086707974E-4]:1.826040867106E0)[&rate=3.8165268046827126E-4]:9.803756223352E0,5[&rate=3.4625317941899754E-4]:1.162979709046E1)[&rate=6.617539259616744E-4]:2.042858207699E0,((7[&rate=5.521552390624093E-4]:7.913622803886E0,6[&rate=9.262993402486683E-4]:7.913622803886E0)[&rate=7.14127096657731E-4]:1.743947557529E0,1[&rate=8.68642972479051E-4]:9.657570361415E0)[&rate=7.278289091363475E-4]:4.015084936742E0)[&rate=4.535850203136672E-4]:5.384997091285E1)[&rate=4.1233866807259843E-4]:3.266787675755E-1)[&rate=0.001854090422241169]:1.851111882531E0,12[&rate=9.928761850134726E-4]:6.970041686111E1)[&rate=6.745302046339041E-4]:2.116663192535E0)[&rate=7.56148400880097E-4]:1.906772436903E0,((((33[&rate=9.473390789692693E-4]:4.850834425682E1,13[&rate=2.698812133915219E-4]:4.850834425682E1)[&rate=3.0109868906779026E-4]:2.007204490211E1,(19[&rate=8.509392570586737E-4]:1.274367209727E1,18[&rate=0.0012135271601642415]:1.274367209727E1)[&rate=2.698812133915219E-4]:5.583671706166E1)[&rate=7.858985904720106E-4]:1.489063433765E0,(11[&rate=4.7921810677827465E-4]:1.213878324424E1,29[&rate=6.000746086707974E-4]:1.213878324424E1)[&rate=8.870497241331672E-4]:5.793066934846E1)[&rate=2.698812133915219E-4]:2.53817815615E0,((10[&rate=6.745302046339041E-4]:1.574844011456E1,31[&rate=8.68642972479051E-4]:1.574844011456E1)[&rate=5.521552390624093E-4]:5.393796591546E1,23[&rate=5.521552390624093E-4]:6.968640603003E1)[&rate=4.6653751154651294E-4]:2.921224718818E0)[&rate=9.694820211563088E-4]:1.116221741701E0)[&rate=0.001854090422241169]:4.19015990179E0,(17[&rate=7.708275361737002E-4]:7.160357780666E1,(27[&rate=4.535850203136672E-4]:2.985614862999E1,28[&rate=7.278289091363475E-4]:2.985614862999E1)[&rate=0.0011364778888983934]:4.174742917667E1)[&rate=0.0011031761422500594]:6.310434585674E0)[&rate=0.0016618610145439333]:4.888420679684E1);\ntree STATE_1 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55114.92162296427,EEF_ucld_branchRates=-266.168517335019,lnP=-55114.92162296427,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.432835519837599E-4]:1.100973124427E1,9[&rate=4.8626015958343563E-4]:1.100973124427E1)[&rate=3.6454536364777235E-4]:5.649648486163E0,15[&rate=9.773747081365596E-4]:1.665937973043E1)[&rate=7.041365574460978E-4]:1.088979418912E2,(14[&rate=0.00100683793147973]:5.055464428328E1,24[&rate=5.570724333007862E-4]:5.055464428328E1)[&rate=8.238640701612584E-4]:7.500267733839E1)[&rate=0.0015473551116608954]:1.90590494296E0,(((25[&rate=6.66750193656917E-4]:7.568801303577E1,(12[&rate=6.432835519837599E-4]:7.28395630592E1,((16[&rate=2.5350035197253395E-4]:3.624643042751E1,((22[&rate=0.0018819295968046754]:3.169847917002E0,21[&rate=2.809302220991419E-4]:3.169847917002E0)[&rate=5.673801276555682E-4]:5.374182723095E0,20[&rate=4.963571768224952E-4]:8.544030640097E0)[&rate=0.0010394458163883933]:2.770239978741E1)[&rate=9.773747081365596E-4]:3.514029213497E1,(((30[&rate=7.594550785275435E-4]:4.843669821979E1,26[&rate=4.963571768224952E-4]:4.843669821979E1)[&rate=9.026669316639456E-4]:1.089160199797E1,32[&rate=3.773694205585881E-4]:5.932830021776E1)[&rate=5.570724333007862E-4]:1.015625933124E1,((((3[&rate=7.449171477244499E-4]:1.581049982656E0,4[&rate=9.773747081365596E-4]:1.581049982656E0)[&rate=8.419266792272108E-4]:5.692743077229E-1,2[&rate=4.963571768224952E-4]:2.150324290379E0)[&rate=4.2374920021226984E-4]:8.280531199389E0,5[&rate=3.509469086713054E-4]:1.043085548977E1)[&rate=6.319097002157012E-4]:3.133736605239E0,((7[&rate=3.89591068401691E-4]:8.514600229056E0,6[&rate=5.88308888642596E-4]:8.514600229056E0)[&rate=8.609824782466007E-4]:1.189340788068E0,1[&rate=7.449171477244499E-4]:9.703941017125E0)[&rate=4.2374920021226984E-4]:3.860651077882E0)[&rate=7.173032727879145E-4]:5.5919967454E1)[&rate=3.89591068401691E-4]:1.902163013473E0)[&rate=9.026669316639456E-4]:1.452840496727E0)[&rate=5.88308888642596E-4]:2.848449976572E0)[&rate=6.432835519837599E-4]:6.356517176802E-1,((((11[&rate=5.570724333007862E-4]:1.440547607658E1,29[&rate=7.745510698353868E-4]:1.440547607658E1)[&rate=5.777866535606864E-4]:5.443858763138E1,(33[&rate=7.902677421602243E-4]:5.598164503662E1,13[&rate=3.203025450350539E-4]:5.598164503662E1)[&rate=8.609824782466007E-4]:1.286241867135E1)[&rate=0.0011177048600246257]:1.20168189338E0,(19[&rate=7.902677421602243E-4]:1.397235759973E1,18[&rate=6.788925687625579E-4]:1.397235759973E1)[&rate=5.064289247136427E-4]:5.607338800162E1)[&rate=2.0843238030718346E-4]:3.542968383984E0,((10[&rate=6.097700838501141E-4]:1.417768651896E1,31[&rate=8.419266792272108E-4]:1.417768651896E1)[&rate=2.5350035197253395E-4]:5.807526881403E1,23[&rate=3.89591068401691E-4]:7.225295533299E1)[&rate=6.548891178634315E-4]:1.335758652342E0)[&rate=3.0224038688422003E-4]:2.734950768121E0)[&rate=4.2374920021226984E-4]:4.723307623727E0,(17[&rate=6.66750193656917E-4]:7.3448718883E1,(27[&rate=3.0224038688422003E-4]:3.512903799491E1,28[&rate=5.064289247136427E-4]:3.512903799491E1)[&rate=6.207454408416914E-4]:3.83196808881E1)[&rate=7.902677421602243E-4]:7.598253494177E0)[&rate=0.0015473551116608954]:4.641625418744E1);\ntree STATE_2 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55129.87052347309,EEF_ucld_branchRates=-266.168517335019,lnP=-55129.87052347309,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.066097019294435E-4]:1.07568141584E1,9[&rate=8.67989763853159E-4]:1.07568141584E1)[&rate=4.6356073087012426E-4]:9.37125547926E0,15[&rate=2.2676083374627897E-4]:2.012806963766E1)[&rate=8.67989763853159E-4]:9.872108264778E1,(14[&rate=0.0013676113136323678]:4.245714471267E1,24[&rate=9.80288710297613E-4]:4.245714471267E1)[&rate=8.020875789748006E-4]:7.639200757277E1)[&rate=5.633341908903434E-4]:6.884003169277E0,((((12[&rate=6.390353822594545E-4]:7.567921348753E1,((16[&rate=5.633341908903434E-4]:3.876191691889E1,((22[&rate=3.447167184332075E-4]:3.468309035193E0,21[&rate=3.07916205099355E-4]:3.468309035193E0)[&rate=7.638194289318662E-4]:4.390084770045E0,20[&rate=4.424107250105804E-4]:7.858393805238E0)[&rate=0.0016812837993772415]:3.090352311365E1)[&rate=9.80288710297613E-4]:3.528551690521E1,(((((3[&rate=4.424107250105804E-4]:2.171815157335E0,4[&rate=2.470891429183894E-4]:2.171815157335E0)[&rate=3.2067368401077776E-4]:4.723965727751E-1,2[&rate=2.0099040236757344E-4]:2.64421173011E0)[&rate=7.460135929861184E-4]:8.783333965784E0,5[&rate=3.447167184332075E-4]:1.142754569589E1)[&rate=5.066097019294435E-4]:2.771749475436E0,((7[&rate=3.6743046800013373E-4]:9.59617105114E0,6[&rate=6.125877263206706E-4]:9.59617105114E0)[&rate=2.470891429183894E-4]:1.27801552066E0,1[&rate=3.6743046800013373E-4]:1.08741865718E1)[&rate=6.390353822594545E-4]:3.32510859953E0)[&rate=6.125877263206706E-4]:5.906595491277E1,((30[&rate=8.446845102300667E-4]:4.880507558075E1,26[&rate=6.968735921907402E-4]:4.880507558075E1)[&rate=2.470891429183894E-4]:1.504868501029E1,32[&rate=4.957080547027265E-4]:6.385376059104E1)[&rate=6.968735921907402E-4]:9.411489493062E0)[&rate=6.670261269058315E-4]:7.821837400018E-1)[&rate=0.0012063415462943848]:1.631779663423E0)[&rate=5.516302283112064E-4]:1.482976541483E0,25[&rate=5.874260512070298E-4]:7.716219002901E1)[&rate=4.957080547027265E-4]:4.90155812249E-1,((((11[&rate=8.020875789748006E-4]:1.801527753452E1,29[&rate=7.460135929861184E-4]:1.801527753452E1)[&rate=8.446845102300667E-4]:5.128338566482E1,(33[&rate=0.001053787461148689]:5.221393998245E1,13[&rate=4.424107250105804E-4]:5.221393998245E1)[&rate=5.874260512070298E-4]:1.708472321689E1)[&rate=4.424107250105804E-4]:1.226723825238E0,(19[&rate=0.001053787461148689]:1.700916822088E1,18[&rate=6.125877263206706E-4]:1.700916822088E1)[&rate=4.424107250105804E-4]:5.35162188037E1)[&rate=2.2676083374627897E-4]:5.026086317692E0,((10[&rate=0.001053787461148689]:1.856373185197E1,31[&rate=5.401255454026521E-4]:1.856373185197E1)[&rate=3.2067368401077776E-4]:5.691282458383E1,23[&rate=2.6451651703730784E-4]:7.54765564358E1)[&rate=6.670261269058315E-4]:7.491690647019E-2)[&rate=5.287999956060568E-4]:2.100872498988E0)[&rate=3.447167184332075E-4]:1.890025224509E0,(17[&rate=7.638194289318662E-4]:7.079170717013E1,(27[&rate=3.2067368401077776E-4]:3.44566390445E1,28[&rate=8.227753045637104E-4]:3.44566390445E1)[&rate=8.929037701224505E-4]:3.633506812563E1)[&rate=5.633341908903434E-4]:8.750663895632E0)[&rate=0.0016812837993772415]:4.619078438895E1);\ntree STATE_3 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55130.41961333657,EEF_ucld_branchRates=-266.168517335019,lnP=-55130.41961333657,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.265597592001004E-4]:8.894066579974E0,9[&rate=4.942008716248169E-4]:8.894066579974E0)[&rate=4.942008716248169E-4]:7.413297552034E0,15[&rate=6.10615555232763E-4]:1.630736413201E1)[&rate=8.701281634825918E-4]:1.05429721927E2,(14[&rate=0.0014487090019437137]:5.06709934125E1,24[&rate=8.146421786052459E-4]:5.06709934125E1)[&rate=8.146421786052459E-4]:7.106609264646E1)[&rate=4.751169591625182E-4]:5.833296334621E0,((((((11[&rate=8.505166446613319E-4]:1.634423124338E1,29[&rate=5.705675442978731E-4]:1.634423124338E1)[&rate=8.146421786052459E-4]:5.602972737291E1,(33[&rate=8.146421786052459E-4]:5.777494628604E1,13[&rate=4.3578784528673376E-4]:5.777494628604E1)[&rate=3.0911402456563987E-4]:1.459901233025E1)[&rate=7.82343550272916E-4]:8.155563134595E-1,(19[&rate=5.903294744818761E-4]:1.638856103265E1,18[&rate=6.315659485059258E-4]:1.638856103265E1)[&rate=3.0911402456563987E-4]:5.680095389711E1)[&rate=9.380981198301507E-4]:2.853521681698E0,((10[&rate=8.505166446613319E-4]:1.703364988461E1,31[&rate=7.672816849567449E-4]:1.703364988461E1)[&rate=3.0911402456563987E-4]:5.806754549172E1,23[&rate=5.416248355097677E-4]:7.510119537633E1)[&rate=3.265597592001004E-4]:9.418412351273E-1)[&rate=3.93015342484971E-4]:2.437479239093E0,(25[&rate=6.423383786150817E-4]:7.682180135581E1,(12[&rate=6.315659485059258E-4]:7.577173523112E1,((((((3[&rate=5.705675442978731E-4]:2.936515268322E0,4[&rate=8.505166446613319E-4]:2.936515268322E0)[&rate=2.1750220322459818E-4]:2.172176350139E-1,2[&rate=0.0010274124997002878]:3.153732903336E0)[&rate=4.0421281044251186E-4]:8.987374165034E0,5[&rate=7.389536873156429E-4]:1.214110706837E1)[&rate=4.8468639813685797E-4]:2.457582565629E0,((7[&rate=6.423383786150817E-4]:9.212323691408E0,6[&rate=7.672816849567449E-4]:9.212323691408E0)[&rate=4.0421281044251186E-4]:7.637319843259E-1,1[&rate=4.942008716248169E-4]:9.976055675733E0)[&rate=6.003985464770884E-4]:4.622633958265E0)[&rate=6.423383786150817E-4]:5.726832544213E1,((30[&rate=9.943565750886703E-4]:5.150924347901E1,26[&rate=6.879378317525299E-4]:5.150924347901E1)[&rate=5.8039128041587E-4]:1.133732447301E1,32[&rate=3.93015342484971E-4]:6.284656795201E1)[&rate=4.3578784528673376E-4]:9.020447124121E0)[&rate=4.1502840590154513E-4]:2.823845134801E0,(16[&rate=5.22614015543845E-4]:4.151054091098E1,((22[&rate=0.001161169638341848]:3.754401843862E0,21[&rate=3.41991848716285E-4]:3.754401843862E0)[&rate=5.511999195063704E-4]:3.773258461487E0,20[&rate=4.255342167536232E-4]:7.527660305349E0)[&rate=0.0012267035700506072]:3.398288060563E1)[&rate=9.943565750886703E-4]:3.318031929996E1)[&rate=6.761103258563157E-4]:1.080875020185E0)[&rate=6.003985464770884E-4]:1.050066124693E0)[&rate=5.8039128041587E-4]:1.658714494734E0)[&rate=2.6174426815780483E-4]:2.166873964637E0,(17[&rate=7.126296315507377E-4]:7.250086945452E1,(27[&rate=6.315659485059258E-4]:2.824953325732E1,28[&rate=9.648256352788107E-4]:2.824953325732E1)[&rate=7.126296315507377E-4]:4.42513361972E1)[&rate=5.131462011710763E-4]:8.146520360661E0)[&rate=0.0017433905122138903]:4.69229925784E1);\ntree STATE_4 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55126.8531958235,EEF_ucld_branchRates=-266.168517335019,lnP=-55126.8531958235,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.958942865018653E-4]:7.980119830523E0,9[&rate=9.409357824418734E-4]:7.980119830523E0)[&rate=6.610092205557259E-4]:9.223074287036E0,15[&rate=5.640136042441317E-4]:1.720319411756E1)[&rate=7.215697147735745E-4]:1.03177976948E2,(14[&rate=0.001248797926431693]:5.101128745215E1,24[&rate=6.722214893654888E-4]:5.101128745215E1)[&rate=7.497794765887603E-4]:6.936988361345E1)[&rate=7.353173396272015E-4]:8.822578757667E0,((((((11[&rate=3.9537745351246215E-4]:1.765872030356E1,29[&rate=5.382771944612292E-4]:1.765872030356E1)[&rate=5.909167208060052E-4]:5.419026786031E1,(33[&rate=7.985752942302799E-4]:6.316680123389E1,13[&rate=4.1353642275682276E-4]:6.316680123389E1)[&rate=4.724598795905389E-4]:8.682186929977E0)[&rate=3.1712040905343885E-4]:1.253812802757E0,(19[&rate=5.298892934733114E-4]:1.589259478781E1,18[&rate=3.7604225355936045E-4]:1.589259478781E1)[&rate=5.640136042441317E-4]:5.721020617881E1)[&rate=4.0457609240361424E-4]:2.081218457384E0,((10[&rate=7.497794765887603E-4]:1.945417539857E1,31[&rate=8.591706622637619E-4]:1.945417539857E1)[&rate=3.3088217628321384E-4]:5.288462770702E1,23[&rate=6.097207020583551E-4]:7.233880310559E1)[&rate=3.1712040905343885E-4]:2.845216318423E0)[&rate=5.909167208060052E-4]:3.054949333202E0,(25[&rate=6.194411577770008E-4]:7.58509417795E1,(12[&rate=7.497794765887603E-4]:7.475059929462E1,((((((2[&rate=2.829135888180607E-4]:2.001651737464E0,4[&rate=6.097207020583551E-4]:2.001651737464E0)[&rate=5.817931495393205E-4]:9.191328349034E-1,3[&rate=6.722214893654888E-4]:2.920784572367E0)[&rate=8.372491380981624E-4]:1.021254595552E1,5[&rate=4.309059958531765E-4]:1.313333052788E1)[&rate=5.298892934733114E-4]:1.191963161146E0,((7[&rate=2.587163745161979E-4]:7.672308163403E0,6[&rate=4.5604259774885127E-4]:7.672308163403E0)[&rate=3.1712040905343885E-4]:8.614395739519E-1,1[&rate=2.829135888180607E-4]:8.533747737355E0)[&rate=7.650569687331224E-4]:5.791545951675E0)[&rate=5.215741123647838E-4]:5.790429613034E1,(16[&rate=3.7604225355936045E-4]:3.726786587316E1,((22[&rate=5.382771944612292E-4]:4.601106475017E0,21[&rate=8.833351477230477E-4]:4.601106475017E0)[&rate=5.553253287454143E-4]:4.338651081466E0,20[&rate=4.1353642275682276E-4]:8.939757556483E0)[&rate=0.001248797926431693]:2.832810831667E1)[&rate=6.958942865018653E-4]:3.496172394621E1)[&rate=9.409357824418734E-4]:4.426704831428E-1,((30[&rate=4.5604259774885127E-4]:5.307649583204E1,26[&rate=7.497794765887603E-4]:5.307649583204E1)[&rate=5.05108814335137E-4]:1.197683243844E1,32[&rate=4.642723446600494E-4]:6.505332827048E1)[&rate=5.728309913069172E-4]:7.618932032031E0)[&rate=7.084523981412808E-4]:2.078338992111E0)[&rate=3.1712040905343885E-4]:1.100342484881E0)[&rate=3.8588809152273316E-4]:2.388026977709E0)[&rate=5.382771944612292E-4]:3.035731214114E0,(17[&rate=6.00219506518633E-4]:7.432933597559E1,(27[&rate=3.9537745351246215E-4]:2.231170885024E1,28[&rate=0.001248797926431693]:2.231170885024E1)[&rate=4.887745314023434E-4]:5.201762712535E1)[&rate=4.724598795905389E-4]:6.94536399574E0)[&rate=0.0010188069351768198]:4.792904985194E1);\ntree STATE_5 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55145.76743416705,EEF_ucld_branchRates=-266.168517335019,lnP=-55145.76743416705,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.284586511296035E-4]:8.988874526607E0,9[&rate=0.0010471110139599945]:8.988874526607E0)[&rate=5.908358205426717E-4]:7.928595389068E0,15[&rate=3.460062796952484E-4]:1.691746991568E1)[&rate=8.125679624771528E-4]:9.921611174144E1,(14[&rate=9.421785681549233E-4]:5.130690722185E1,24[&rate=0.0012070475179313683]:5.130690722185E1)[&rate=7.410352212910093E-4]:6.482667443527E1)[&rate=9.000792418668197E-4]:1.200611009043E1,((((((33[&rate=7.153337011779748E-4]:5.842881509979E1,13[&rate=3.627281830402541E-4]:5.842881509979E1)[&rate=6.337412372369671E-4]:1.071371659715E1,(11[&rate=5.180614876118372E-4]:2.034846120923E1,29[&rate=6.560099401022837E-4]:2.034846120923E1)[&rate=6.228379023599891E-4]:4.879407048771E1)[&rate=8.625345666663701E-4]:2.665594421781E0,(19[&rate=0.0010471110139599945]:1.51406130555E1,18[&rate=7.029600340048602E-4]:1.51406130555E1)[&rate=3.460062796952484E-4]:5.666751306321E1)[&rate=5.284586511296035E-4]:5.095848167399E0,((10[&rate=6.674139007013036E-4]:2.856364207015E1,31[&rate=5.284586511296035E-4]:2.856364207015E1)[&rate=4.8643511888398524E-4]:4.521779247635E1,23[&rate=5.388228102025428E-4]:7.378143454651E1)[&rate=6.908658097291864E-4]:3.122539739603E0)[&rate=5.908358205426717E-4]:3.079034066281E0,((12[&rate=6.790250871653466E-4]:7.763060079507E1,((((((2[&rate=4.5352658208501766E-4]:1.910014604064E0,4[&rate=8.125679624771528E-4]:1.910014604064E0)[&rate=3.2712355195446647E-4]:6.65789620126E-1,3[&rate=8.808114590305644E-4]:2.57580422419E0)[&rate=3.047968895958437E-4]:1.095785793515E1,5[&rate=3.2712355195446647E-4]:1.353366215934E1)[&rate=0.0011583937692474851]:1.783660033855E0,((7[&rate=4.6469975843316035E-4]:6.501123400863E0,1[&rate=4.054427798861477E-4]:6.501123400863E0)[&rate=4.5352658208501766E-4]:1.690132196315E0,6[&rate=7.824908990682705E-4]:8.191255597178E0)[&rate=6.120642048620072E-4]:7.126066596018E0)[&rate=4.054427798861477E-4]:5.838444479636E1,((30[&rate=9.653902776980304E-4]:5.40607752468E1,26[&rate=8.285040884213225E-4]:5.40607752468E1)[&rate=3.2712355195446647E-4]:1.426443361425E1,32[&rate=4.4208479377401443E-4]:6.832520886104E1)[&rate=6.560099401022837E-4]:5.376558128517E0)[&rate=8.808114590305644E-4]:2.444804418705E0,(16[&rate=4.1813155165534464E-4]:3.97711590757E1,((22[&rate=6.560099401022837E-4]:3.541575892245E0,21[&rate=5.595338598108015E-4]:3.541575892245E0)[&rate=7.029600340048602E-4]:4.183779224866E0,20[&rate=6.120642048620072E-4]:7.72535511711E0)[&rate=0.0015864841418225762]:3.204580395859E1)[&rate=9.000792418668197E-4]:3.637541233256E1)[&rate=0.001079881489430989]:1.484029386803E0)[&rate=0.0012070475179313683]:1.401657878161E0,25[&rate=8.625345666663701E-4]:7.903225867323E1)[&rate=3.627281830402541E-4]:9.50749679163E-1)[&rate=8.285040884213225E-4]:5.02117290093E0,(17[&rate=7.029600340048602E-4]:7.96764124044E1,(27[&rate=8.125679624771528E-4]:2.269779704707E1,28[&rate=0.0015864841418225762]:2.269779704707E1)[&rate=4.1813155165534464E-4]:5.697861535733E1)[&rate=6.228379023599891E-4]:5.327768848926E0)[&rate=0.0015864841418225762]:4.313551049422E1);\ntree STATE_6 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55144.54150481558,EEF_ucld_branchRates=-266.168517335019,lnP=-55144.54150481558,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.108844231103969E-4]:7.955882687067E0,9[&rate=7.348718044447107E-4]:7.955882687067E0)[&rate=7.494268552672629E-4]:5.657522898089E0,15[&rate=7.803986358025438E-4]:1.361340558516E1)[&rate=7.969658964307591E-4]:1.003067745303E2,(14[&rate=0.001039896461485491]:4.792907794861E1,24[&rate=8.950853810921544E-4]:4.792907794861E1)[&rate=9.18970292372757E-4]:6.599110216682E1)[&rate=4.8101491702899206E-4]:8.2444271805E0,((((((33[&rate=8.327423379615736E-4]:5.557398785595E1,13[&rate=4.3155844893080406E-4]:5.557398785595E1)[&rate=5.904913645567397E-4]:9.642669307268E0,(11[&rate=2.4625055767745364E-4]:1.858762646732E1,29[&rate=4.3155844893080406E-4]:1.858762646732E1)[&rate=6.691886824036259E-4]:4.66290306959E1)[&rate=8.143761741214832E-4]:1.783851581137E0,(19[&rate=6.691886824036259E-4]:1.183730052356E1,18[&rate=7.803986358025438E-4]:1.183730052356E1)[&rate=2.934137251783608E-4]:5.51632082208E1)[&rate=2.934137251783608E-4]:7.649717365423E0,((10[&rate=5.697810568202703E-4]:2.803638106574E1,31[&rate=7.494268552672629E-4]:2.803638106574E1)[&rate=2.934137251783608E-4]:4.503702719086E1,23[&rate=6.454655406327056E-4]:7.30734082566E1)[&rate=5.904913645567397E-4]:1.576817853175E0)[&rate=3.6606049984949906E-4]:1.858445220136E0,(((12[&rate=8.143761741214832E-4]:6.964625469802E1,((30[&rate=7.969658964307591E-4]:4.907880463414E1,26[&rate=7.969658964307591E-4]:4.907880463414E1)[&rate=5.697810568202703E-4]:1.076849126568E1,32[&rate=4.002023144112605E-4]:5.984729589982E1)[&rate=5.004601287712626E-4]:9.798958798202E0)[&rate=4.8101491702899206E-4]:2.198775843852E0,(((((3[&rate=6.454655406327056E-4]:2.285714804425E0,4[&rate=5.495819752387034E-4]:2.285714804425E0)[&rate=4.416420555522912E-4]:3.375925370235E-1,2[&rate=3.108844231103969E-4]:2.623307341449E0)[&rate=0.0011268265720498088]:9.740736549966E0,5[&rate=3.6606049984949906E-4]:1.236404389141E1)[&rate=6.691886824036259E-4]:1.159316423671E0,((7[&rate=3.6606049984949906E-4]:7.820966364996E0,1[&rate=3.2638033838140073E-4]:7.820966364996E0)[&rate=6.340234452907275E-4]:1.263130797375E0,6[&rate=5.800637825216852E-4]:9.08409716237E0)[&rate=6.571782513638765E-4]:4.439263152715E0)[&rate=4.8101491702899206E-4]:5.826423059292E1,(16[&rate=5.297620622883042E-4]:3.779962479098E1,((22[&rate=0.0013481621073408816]:2.500003858253E0,21[&rate=6.118536497275481E-4]:2.500003858253E0)[&rate=2.934137251783608E-4]:4.849467472039E0,20[&rate=5.697810568202703E-4]:7.349471330292E0)[&rate=0.0011829928119369655]:3.045015346069E1)[&rate=0.0014934952487071801]:3.398796611703E1)[&rate=3.7787319673645604E-4]:5.743963386595E-2)[&rate=0.0010800447091355203]:2.76819223881E0,25[&rate=4.21317975242315E-4]:7.461322278069E1)[&rate=4.7126432698663015E-4]:1.895448549227E0)[&rate=5.396326928710295E-4]:3.70669900166E0,(17[&rate=6.010817097299917E-4]:7.110267934528E1,(27[&rate=5.101922380876828E-4]:2.324542241963E1,28[&rate=9.732736829684972E-4]:2.324542241963E1)[&rate=7.348718044447107E-4]:4.785725692565E1)[&rate=9.732736829684972E-4]:9.112690986297E0)[&rate=0.0018151640084546265]:4.194923696436E1);\ntree STATE_7 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55139.606098843455,EEF_ucld_branchRates=-266.168517335019,lnP=-55139.606098843455,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.918336287308795E-4]:8.478416193732E0,9[&rate=6.639279206747258E-4]:8.478416193732E0)[&rate=8.568924495181643E-4]:4.322871358967E0,15[&rate=6.028420142321957E-4]:1.28012875527E1)[&rate=8.171839914685901E-4]:1.027059985315E2,(14[&rate=0.0012518434347777]:5.161156317833E1,24[&rate=9.798010383990643E-4]:5.161156317833E1)[&rate=0.0010298204045832832]:6.389572290591E1)[&rate=3.764791629315091E-4]:9.909184582795E0,((((((33[&rate=7.931902660484254E-4]:5.99810205214E1,13[&rate=5.408553980551688E-4]:5.99810205214E1)[&rate=6.819382241949344E-4]:9.599088077016E0,(11[&rate=7.194677018811897E-4]:1.149131987741E1,29[&rate=8.568924495181643E-4]:1.149131987741E1)[&rate=6.462588680966214E-4]:5.808878872102E1)[&rate=4.44793041354612E-4]:1.160336512014E0,(19[&rate=5.767280971809501E-4]:1.376113875644E1,18[&rate=6.288185299355163E-4]:1.376113875644E1)[&rate=3.764791629315091E-4]:5.6979306354E1)[&rate=7.098556240374042E-4]:2.344605743065E0,((10[&rate=5.679144468930618E-4]:2.669893117301E1,31[&rate=4.153593321641355E-4]:2.669893117301E1)[&rate=5.941739184399428E-4]:4.557846763056E1,23[&rate=5.767280971809501E-4]:7.227739880357E1)[&rate=8.430797087493373E-4]:8.076520499289E-1)[&rate=9.384002540748842E-4]:4.579936885422E0,((12[&rate=8.298661374521401E-4]:7.530725677595E1,(((30[&rate=7.392633226221438E-4]:5.2879631128E1,26[&rate=3.764791629315091E-4]:5.2879631128E1)[&rate=6.375170443662108E-4]:1.304824673362E1,32[&rate=4.153593321641355E-4]:6.592787786163E1)[&rate=5.767280971809501E-4]:7.451037254396E0,((16[&rate=4.81008847690627E-4]:2.908838755594E1,((22[&rate=7.004082768833333E-4]:3.265696793873E0,21[&rate=5.408553980551688E-4]:3.265696793873E0)[&rate=6.639279206747258E-4]:3.797931351536E0,20[&rate=7.004082768833333E-4]:7.063628145408E0)[&rate=0.0010034835900562802]:2.202475941053E1)[&rate=8.171839914685901E-4]:4.244319416695E1,((((3[&rate=7.931902660484254E-4]:1.723851408008E0,4[&rate=0.0011346632468586867]:1.723851408008E0)[&rate=6.911080090910009E-4]:8.039436890888E-1,2[&rate=9.582365680495075E-4]:2.527795097097E0)[&rate=8.430797087493373E-4]:7.776369872838E0,5[&rate=4.81008847690627E-4]:1.030416496994E1)[&rate=7.292634449016973E-4]:2.278033156915E0,((7[&rate=4.153593321641355E-4]:7.372440745986E0,1[&rate=8.568924495181643E-4]:7.372440745986E0)[&rate=8.049753592624887E-4]:8.235312315438E-1,6[&rate=4.44793041354612E-4]:8.19597197753E0)[&rate=6.911080090910009E-4]:4.38622614932E0)[&rate=4.696568764218469E-4]:5.894938359604E1)[&rate=6.639279206747258E-4]:1.847333393132E0)[&rate=0.0010939088957497528]:1.928341659926E0)[&rate=8.298661374521401E-4]:8.357023619646E-1,25[&rate=6.114954201077676E-4]:7.614295913791E1)[&rate=5.315426239923827E-4]:1.522028601009E0)[&rate=5.315426239923827E-4]:1.8972803421E0,(17[&rate=9.199994915472741E-4]:6.969147751835E1,(27[&rate=6.550578534854667E-4]:2.489346528299E1,28[&rate=0.0011851024787387632]:2.489346528299E1)[&rate=7.292634449016973E-4]:4.479801223535E1)[&rate=3.976811937377634E-4]:9.870790562674E0)[&rate=0.001565624262773543]:4.585420258601E1);\ntree STATE_8 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55121.9401125964,EEF_ucld_branchRates=-266.168517335019,lnP=-55121.9401125964,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.390036884662745E-4]:8.569827855552E0,9[&rate=7.148944740861485E-4]:8.569827855552E0)[&rate=4.111919487725629E-4]:5.336238860854E0,15[&rate=8.415160265552725E-4]:1.390606671641E1)[&rate=6.885708657971076E-4]:1.076562283553E2,(14[&rate=0.0010935024897558156]:4.44758725026E1,24[&rate=7.938532807515849E-4]:4.44758725026E1)[&rate=9.98941207085299E-4]:7.70864225691E1)[&rate=6.467921533664746E-4]:7.891283140837E0,((((((33[&rate=8.288545851635866E-4]:5.638492094622E1,13[&rate=5.816301159805759E-4]:5.638492094622E1)[&rate=7.059804355164878E-4]:1.277382900037E1,(11[&rate=7.239706214440401E-4]:1.375568193973E1,29[&rate=8.050795589021622E-4]:1.375568193973E1)[&rate=8.415160265552725E-4]:5.540306800687E1)[&rate=8.050795589021622E-4]:2.078856011333E0,(19[&rate=3.907034858927431E-4]:1.629216678805E1,18[&rate=9.750878972317062E-4]:1.629216678805E1)[&rate=4.8022185338086E-4]:5.494543916988E1)[&rate=6.800440455403049E-4]:3.74144215303E0,((10[&rate=5.478082941919665E-4]:2.556548599373E1,31[&rate=5.980270197984777E-4]:2.556548599373E1)[&rate=4.282189767326637E-4]:4.678817562986E1,23[&rate=5.564463449789085E-4]:7.235366162359E1)[&rate=7.52366084311699E-4]:2.62538648737E0)[&rate=6.6327407058424E-4]:2.349951736231E0,((12[&rate=5.816301159805759E-4]:7.44228011961E1,((((((3[&rate=8.167293393070538E-4]:2.592413994882E0,4[&rate=4.111919487725629E-4]:2.592413994882E0)[&rate=7.938532807515849E-4]:2.100055829489E-1,2[&rate=5.64946524516647E-4]:2.802419577831E0)[&rate=0.0011387832826387782]:8.071258714626E0,5[&rate=4.910415268946466E-4]:1.087367829246E1)[&rate=7.059804355164878E-4]:8.787905250732E-1,((7[&rate=3.907034858927431E-4]:7.075170396849E0,1[&rate=6.142751389141861E-4]:7.075170396849E0)[&rate=8.288545851635866E-4]:4.974720350764E-1,6[&rate=0.0010568175604813673]:7.572642431925E0)[&rate=5.478082941919665E-4]:4.179826385605E0)[&rate=7.059804355164878E-4]:5.768785235264E1,((30[&rate=8.288545851635866E-4]:4.974078530311E1,26[&rate=6.972112682849033E-4]:4.974078530311E1)[&rate=6.142751389141861E-4]:1.004351171893E1,32[&rate=3.907034858927431E-4]:5.978429702204E1)[&rate=0.0010568175604813673]:9.65602414813E0)[&rate=4.111919487725629E-4]:3.335888055971E0,(16[&rate=5.816301159805759E-4]:3.231957233018E1,((22[&rate=6.550036882246595E-4]:2.864163877644E0,21[&rate=9.98941207085299E-4]:2.864163877644E0)[&rate=4.910415268946466E-4]:5.674572573211E0,20[&rate=6.467921533664746E-4]:8.538736450855E0)[&rate=0.001287743773141506]:2.378083587933E1)[&rate=7.938532807515849E-4]:4.045663689596E1)[&rate=6.885708657971076E-4]:1.646591969959E0)[&rate=4.5646187356434854E-4]:1.041112882466E0,25[&rate=6.304939004203264E-4]:7.546391407857E1)[&rate=4.282189767326637E-4]:1.865085768624E0)[&rate=8.991923453072178E-4]:6.919867862833E0,(17[&rate=7.72497460384424E-4]:7.647165777472E1,(27[&rate=5.112222246349429E-4]:2.470082187864E1,28[&rate=9.159588426583621E-4]:2.470082187864E1)[&rate=6.467921533664746E-4]:5.177083589608E1)[&rate=6.6327407058424E-4]:7.777209935308E0)[&rate=0.001287743773141506]:4.520471050251E1);\ntree STATE_9 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.36925630346,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.36925630346,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=9.900943521228376E-4]:8.566569890503E0,9[&rate=5.433135397518505E-4]:8.566569890503E0)[&rate=6.804273413900265E-4]:6.277086816739E0,15[&rate=8.059067146432804E-4]:1.484365670724E1)[&rate=6.609779198317763E-4]:1.065965781742E2,(14[&rate=0.001367613207454145]:4.447686965261E1,24[&rate=0.0010501998779511644]:4.447686965261E1)[&rate=7.797491117500977E-4]:7.696336522878E1)[&rate=9.011638420358655E-4]:7.722728001715E0,((((((11[&rate=6.804273413900265E-4]:1.60379217911E1,29[&rate=4.463243318232039E-4]:1.60379217911E1)[&rate=9.207092330446259E-4]:5.924781772252E1,(33[&rate=8.059067146432804E-4]:6.201301344728E1,13[&rate=5.160874072124125E-4]:6.201301344728E1)[&rate=6.804273413900265E-4]:1.327272606634E1)[&rate=3.961065471325046E-4]:1.332560350732E0,(19[&rate=5.522474308271677E-4]:1.521033395577E1,18[&rate=7.006069132855943E-4]:1.521033395577E1)[&rate=3.148656661888777E-4]:6.140796590858E1)[&rate=6.14630594543138E-4]:9.790055382911E-1,((10[&rate=6.32858818950554E-4]:2.54283375525E1,31[&rate=6.514808297429242E-4]:2.54283375525E1)[&rate=3.8071465665445E-4]:5.179574533359E1,23[&rate=4.97345945695808E-4]:7.722408288609E1)[&rate=3.422568930152044E-4]:3.73222516552E-1)[&rate=5.433135397518505E-4]:1.873574258086E0,((12[&rate=8.343827763201443E-4]:7.668684498019E1,((16[&rate=7.925707941135308E-4]:3.370850759852E1,((22[&rate=7.554393576225315E-4]:3.212377496058E0,21[&rate=3.422568930152044E-4]:3.212377496058E0)[&rate=7.797491117500977E-4]:5.168235457732E0,20[&rate=3.6318951828364396E-4]:8.38061295379E0)[&rate=0.0011310687312062126]:2.532789464473E1)[&rate=7.925707941135308E-4]:4.040566103098E1,(((((3[&rate=0.0011856466719875327]:1.974868242742E0,4[&rate=6.237029088792836E-4]:1.974868242742E0)[&rate=8.198195682898914E-4]:6.539422188376E-1,2[&rate=5.252551418746944E-4]:2.628810461579E0)[&rate=8.496832031819567E-4]:7.567091998284E0,5[&rate=4.349226341211698E-4]:1.019590245986E1)[&rate=3.422568930152044E-4]:2.141161238837E0,((7[&rate=6.904159617076632E-4]:7.887989837536E0,1[&rate=3.8071465665445E-4]:7.887989837536E0)[&rate=7.554393576225315E-4]:1.057910877061E0,6[&rate=6.609779198317763E-4]:8.945900714597E0)[&rate=6.32858818950554E-4]:3.391162984103E0)[&rate=5.522474308271677E-4]:5.901318766983E1,((30[&rate=4.97345945695808E-4]:5.275632021792E1,26[&rate=5.877712449039174E-4]:5.275632021792E1)[&rate=6.804273413900265E-4]:8.545341977115E0,32[&rate=4.463243318232039E-4]:6.130166219503E1)[&rate=6.32858818950554E-4]:1.00485891735E1)[&rate=5.160874072124125E-4]:2.763917260968E0)[&rate=0.001018280354246158]:2.572676350692E0)[&rate=3.8071465665445E-4]:1.740312684115E0,25[&rate=0.001018280354246158]:7.84271576643E1)[&rate=5.788893631092454E-4]:1.043721996425E0)[&rate=5.877712449039174E-4]:5.066679650943E0,(17[&rate=7.925707941135308E-4]:7.479240481834E1,(27[&rate=5.067941110771175E-4]:2.621071082587E1,28[&rate=0.0010871177130776118]:2.621071082587E1)[&rate=8.198195682898914E-4]:4.858169399248E1)[&rate=5.700185452462508E-4]:9.745154493328E0)[&rate=0.0012581614934330278]:4.462540357144E1);\ntree STATE_10 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.727454768545,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.727454768545,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.565387345008174E-4]:8.095261951754E0,9[&rate=0.0020761272207486634]:8.095261951754E0)[&rate=8.974064807418605E-4]:5.38957803014E0,15[&rate=4.087451471246129E-4]:1.348483998189E1)[&rate=6.80232642651083E-4]:1.0179428265E2,(14[&rate=0.0012394120327276351]:4.502012081775E1,24[&rate=9.794239443454064E-4]:4.502012081775E1)[&rate=0.0011176268948102466]:7.025900181416E1)[&rate=3.3951471514524165E-4]:7.313059721239E0,((((((33[&rate=6.106957905389321E-4]:5.681548913868E1,13[&rate=5.097035470267665E-4]:5.681548913868E1)[&rate=9.163351332549776E-4]:1.098355631626E1,(11[&rate=5.436660972299875E-4]:1.823147338128E1,29[&rate=5.548423344535778E-4]:1.823147338128E1)[&rate=7.172391449965775E-4]:4.956757207366E1)[&rate=3.936459112310721E-4]:9.609414166686E-1,(19[&rate=5.548423344535778E-4]:1.425110571161E1,18[&rate=8.79329944234177E-4]:1.425110571161E1)[&rate=4.981392193141693E-4]:5.450888116E1)[&rate=5.324356355089859E-4]:2.888490683775E0,((10[&rate=3.158047300469646E-4]:2.260064059613E1,31[&rate=7.431402510746801E-4]:2.260064059613E1)[&rate=3.3951471514524165E-4]:4.797669208578E1,23[&rate=7.300498368021334E-4]:7.057733268191E1)[&rate=7.172391449965775E-4]:1.071144873473E0)[&rate=6.682961277697795E-4]:1.455913871998E0,((12[&rate=8.79329944234177E-4]:6.875987826605E1,((16[&rate=3.158047300469646E-4]:2.87051588145E1,((22[&rate=0.001193627575632314]:2.453125231709E0,21[&rate=8.79329944234177E-4]:2.453125231709E0)[&rate=9.163351332549776E-4]:3.965975967039E0,20[&rate=8.293530212295146E-4]:6.419101198748E0)[&rate=0.0013567638882743948]:2.228605761576E1)[&rate=9.163351332549776E-4]:3.933680399551E1,(((30[&rate=5.211245841099812E-4]:5.041209427267E1,26[&rate=5.211245841099812E-4]:5.041209427267E1)[&rate=8.620132716269078E-4]:5.97089199802E0,32[&rate=3.158047300469646E-4]:5.638298627069E1)[&rate=4.229794115111491E-4]:7.774723505272E0,((((2[&rate=6.80232642651083E-4]:1.161920369672E0,4[&rate=0.0010556552688857452]:1.161920369672E0)[&rate=5.211245841099812E-4]:1.180375639585E0,3[&rate=9.794239443454064E-4]:2.342296009258E0)[&rate=8.974064807418605E-4]:7.316756904331E0,5[&rate=3.158047300469646E-4]:9.659052913589E0)[&rate=5.659883612847565E-4]:1.456063425613E0,((7[&rate=8.453771952631063E-4]:5.835932601117E0,6[&rate=6.448968926035843E-4]:5.835932601117E0)[&rate=0.001193627575632314]:1.847735793811E0,1[&rate=4.087451471246129E-4]:7.683668394928E0)[&rate=6.565240926033435E-4]:3.431447944273E0)[&rate=6.682961277697795E-4]:5.304259343676E1)[&rate=5.882772070818888E-4]:3.884253034054E0)[&rate=0.0015449087128659208]:7.179154560298E-1)[&rate=7.172391449965775E-4]:1.214675986695E0,25[&rate=7.565387345008174E-4]:6.997455425274E1)[&rate=6.106957905389321E-4]:3.129837174638E0)[&rate=4.863932278589192E-4]:5.170562193253E0,(17[&rate=0.0010283902386889695]:6.714130517087E1,(27[&rate=3.158047300469646E-4]:2.080957971762E1,28[&rate=0.0015449087128659208]:2.080957971762E1)[&rate=7.172391449965775E-4]:4.633172545325E1)[&rate=4.4956812243790716E-4]:1.113364844977E1)[&rate=0.001193627575632314]:4.431722873252E1);\ntree STATE_11 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55154.515035210075,EEF_ucld_branchRates=-266.168517335019,lnP=-55154.515035210075,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.6589707023059246E-4]:9.0872619867E0,9[&rate=5.364223393560873E-4]:9.0872619867E0)[&rate=6.581161829010711E-4]:4.870364343127E0,15[&rate=6.001912022882079E-4]:1.395762632983E1)[&rate=5.572074754252509E-4]:9.739215079023E1,(14[&rate=0.0010403629654011238]:4.664559059434E1,24[&rate=6.342408212006567E-4]:4.664559059434E1)[&rate=0.0014104897940793338]:6.470418652572E1)[&rate=5.892246828062797E-4]:1.843280254803E1,((((((19[&rate=4.955808312364502E-4]:1.455327889749E1,18[&rate=8.773955810916141E-4]:1.455327889749E1)[&rate=3.6589707023059246E-4]:5.673110566261E1,(11[&rate=5.05743561467904E-4]:1.875814735984E1,29[&rate=4.854191268531925E-4]:1.875814735984E1)[&rate=0.0010403629654011238]:5.252623720025E1)[&rate=2.698819676785777E-4]:4.029933831882E-1,(33[&rate=8.994773048365594E-4]:6.072623452952E1,13[&rate=2.698819676785777E-4]:6.072623452952E1)[&rate=4.2320774406403927E-4]:1.096114341376E1)[&rate=7.681204296520909E-4]:3.612995832506E0,((10[&rate=5.784172626460162E-4]:2.047728117534E1,31[&rate=4.854191268531925E-4]:2.047728117534E1)[&rate=4.752384124334228E-4]:5.334236257538E1,23[&rate=5.892246828062797E-4]:7.381964375072E1)[&rate=2.698819676785777E-4]:1.480730025066E0)[&rate=8.186059777909805E-4]:1.417635964988E0,((12[&rate=7.378299173180694E-4]:7.401520776112E1,(((((2[&rate=4.338587624786942E-4]:1.864262413142E0,4[&rate=8.186059777909805E-4]:1.864262413142E0)[&rate=4.5473147019727786E-4]:5.674842425133E-1,3[&rate=6.113358384298133E-4]:2.431746655655E0)[&rate=7.378299173180694E-4]:9.106502639456E0,5[&rate=4.5473147019727786E-4]:1.153824929511E1)[&rate=8.186059777909805E-4]:1.060087699058E0,((7[&rate=3.089733306653309E-4]:7.544064889519E0,6[&rate=6.226786278298425E-4]:7.544064889519E0)[&rate=3.249268411399915E-4]:1.167498116914E0,1[&rate=2.698819676785777E-4]:8.711563006433E0)[&rate=7.681204296520909E-4]:3.886773987735E0)[&rate=3.6589707023059246E-4]:6.033013274983E1,(((30[&rate=8.371220950499353E-4]:5.578085235416E1,26[&rate=7.842001683872851E-4]:5.578085235416E1)[&rate=0.0011715429838948775]:6.670980003961E0,32[&rate=3.089733306653309E-4]:6.245183235812E1)[&rate=2.427479518955201E-4]:8.967948199312E0,(16[&rate=6.342408212006567E-4]:3.045805756457E1,((22[&rate=0.0011212389528720515]:2.147339326037E0,21[&rate=6.581161829010711E-4]:2.147339326037E0)[&rate=6.7048044543632E-4]:3.776378938581E0,20[&rate=4.012743933811985E-4]:5.923718264618E0)[&rate=0.0019189601608913052]:2.453433929995E1)[&rate=9.231344571198702E-4]:4.096172299286E1)[&rate=6.7048044543632E-4]:1.508689186568E0)[&rate=5.05743561467904E-4]:1.086738017119E0)[&rate=6.342408212006567E-4]:1.530584162235E0,25[&rate=7.842001683872851E-4]:7.554579192336E1)[&rate=0.0014104897940793338]:1.17221781742E0)[&rate=4.6501707945489755E-4]:2.477948035318E0,(17[&rate=0.0011715429838948775]:6.889849475946E1,(27[&rate=4.5473147019727786E-4]:2.847091508902E1,28[&rate=8.009995637084802E-4]:2.847091508902E1)[&rate=8.566698346578898E-4]:4.042757967044E1)[&rate=6.113358384298133E-4]:1.029746301663E1)[&rate=0.0014104897940793338]:5.0586621892E1);\ntree STATE_12 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55157.155388174986,EEF_ucld_branchRates=-266.168517335019,lnP=-55157.155388174986,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.549407163711136E-4]:9.237212614191E0,9[&rate=8.700229035677426E-4]:9.237212614191E0)[&rate=4.013281110871622E-4]:5.683589600134E0,15[&rate=4.4122624600277785E-4]:1.492080221433E1)[&rate=7.722657880420839E-4]:9.224454835667E1,(14[&rate=0.0011627372997929477]:4.434782796756E1,24[&rate=0.0011169430181629581]:4.434782796756E1)[&rate=0.0011627372997929477]:6.281752260343E1)[&rate=7.846505453339222E-4]:2.199724150413E1,((((((33[&rate=7.846505453339222E-4]:6.191185706921E1,13[&rate=3.6753569056112797E-4]:6.191185706921E1)[&rate=6.453719498370311E-4]:6.37308549237E0,(11[&rate=4.4122624600277785E-4]:2.169544447631E1,29[&rate=5.342612431328813E-4]:2.169544447631E1)[&rate=6.844293238555242E-4]:4.658949808526E1)[&rate=4.8539992719435175E-4]:1.448898210479E0,(19[&rate=5.248084394996597E-4]:1.075797236654E1,18[&rate=8.390289159714373E-4]:1.075797236654E1)[&rate=4.955623692927919E-4]:5.897586840552E1)[&rate=9.234872247763082E-4]:4.149530542963E0,((10[&rate=5.436132470412716E-4]:1.822802463047E1,31[&rate=6.172263883867203E-4]:1.822802463047E1)[&rate=3.6753569056112797E-4]:5.523186189473E1,23[&rate=5.987802242470426E-4]:7.34598865252E1)[&rate=6.35906765427893E-4]:4.234847898205E-1)[&rate=4.955623692927919E-4]:2.018003166238E0,(25[&rate=5.621059657824798E-4]:7.48169873301E1,((12[&rate=7.722657880420839E-4]:6.995284747091E1,(16[&rate=7.974664190715935E-4]:2.978169456473E1,((22[&rate=8.245947539194194E-4]:2.394321083169E0,21[&rate=9.04549375512589E-4]:2.394321083169E0)[&rate=6.453719498370311E-4]:6.015602641113E0,20[&rate=4.955623692927919E-4]:8.409923724282E0)[&rate=0.0014096038047440738]:2.137177084045E1)[&rate=0.0011169430181629581]:4.017115290618E1)[&rate=0.0014096038047440738]:1.661612763508E0,(((30[&rate=8.54141431297666E-4]:5.00595672351E1,26[&rate=5.712869688767864E-4]:5.00595672351E1)[&rate=8.54141431297666E-4]:9.268747231891E0,32[&rate=3.4606819816348567E-4]:5.932831446699E1)[&rate=4.013281110871622E-4]:9.92141148946E0,((((2[&rate=7.262499467059052E-4]:1.584583650241E0,4[&rate=7.154656690545067E-4]:1.584583650241E0)[&rate=3.180046976055937E-4]:5.686045510407E-1,3[&rate=6.744526087378945E-4]:2.153188201282E0)[&rate=7.154656690545067E-4]:7.543109868545E0,5[&rate=5.712869688767864E-4]:9.696298069827E0)[&rate=5.436132470412716E-4]:2.725922345153E0,((7[&rate=3.6753569056112797E-4]:7.474689952912E0,6[&rate=6.744526087378945E-4]:7.474689952912E0)[&rate=4.4122624600277785E-4]:9.362681276306E-1,1[&rate=6.744526087378945E-4]:8.410958080542E0)[&rate=5.712869688767864E-4]:4.011262334438E0)[&rate=6.844293238555242E-4]:5.682750554147E1)[&rate=9.04549375512589E-4]:2.364734277973E0)[&rate=8.390289159714373E-4]:3.20252709568E0)[&rate=8.390289159714373E-4]:1.084387151157E0)[&rate=3.180046976055937E-4]:4.668894258915E0,(17[&rate=6.945771841873951E-4]:7.106228232809E1,(27[&rate=6.744526087378945E-4]:2.221994934111E1,28[&rate=0.0010159428087795843]:2.221994934111E1)[&rate=5.436132470412716E-4]:4.884233298698E1)[&rate=9.896353561781568E-4]:9.507986412085E0)[&rate=0.0014096038047440738]:4.859232333495E1);\ntree STATE_13 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.68507874516,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.68507874516,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.758058457353949E-4]:8.955668561954E0,9[&rate=6.631741946122945E-4]:8.955668561954E0)[&rate=4.573350758489119E-4]:5.898816585764E0,15[&rate=4.759871500750643E-4]:1.485448514772E1)[&rate=7.945340957059258E-4]:9.380501078005E1,(14[&rate=8.38589652933589E-4]:4.449291706563E1,24[&rate=9.354449400578019E-4]:4.449291706563E1)[&rate=9.608383499970157E-4]:6.416657886214E1)[&rate=0.0011757341926410616]:1.781724789846E1,(((25[&rate=6.820473462344158E-4]:7.31747700533E1,(((((((4[&rate=4.154266937654352E-4]:2.610328575045E0,2[&rate=4.759871500750643E-4]:2.610328575045E0)[&rate=0.0012731390146388081]:1.249421705328E0,3[&rate=6.103179253799095E-4]:3.859750280374E0)[&rate=8.727909142795875E-4]:8.991156234857E0,5[&rate=4.033704793154663E-4]:1.285090651523E1)[&rate=5.852348831588415E-4]:2.180385512041E0,((7[&rate=5.687594763393808E-4]:1.016825601032E1,6[&rate=4.759871500750643E-4]:1.016825601032E1)[&rate=7.945340957059258E-4]:1.934958949876E-1,1[&rate=5.935333782346822E-4]:1.036175190531E1)[&rate=4.2670378756619494E-4]:4.669540121965E0)[&rate=6.631741946122945E-4]:5.124103130833E1,((30[&rate=6.361667945953099E-4]:4.670481788035E1,26[&rate=8.084302908223347E-4]:4.670481788035E1)[&rate=5.769813236975734E-4]:8.034916971036E0,32[&rate=5.276382043475137E-4]:5.473973485139E1)[&rate=5.10891630405812E-4]:1.153258848421E1)[&rate=6.361667945953099E-4]:3.043867289032E0,(16[&rate=5.687594763393808E-4]:3.156305189163E1,((22[&rate=7.564992369646577E-4]:2.590103984927E0,21[&rate=7.226450443757622E-4]:2.590103984927E0)[&rate=9.608383499970157E-4]:3.187402419238E0,20[&rate=5.60555904900648E-4]:5.777506404165E0)[&rate=0.0011757341926410616]:2.578554548746E1)[&rate=7.335468998198809E-4]:3.7753138733E1)[&rate=5.35913626117201E-4]:3.769286160875E0,12[&rate=8.918716859079243E-4]:7.30854767855E1)[&rate=5.935333782346822E-4]:8.929326780076E-2)[&rate=4.759871500750643E-4]:9.850089175227E-1,((((11[&rate=3.3949671743888353E-4]:1.742154995075E1,29[&rate=6.018899743462611E-4]:1.742154995075E1)[&rate=9.354449400578019E-4]:5.117986570973E1,(33[&rate=7.686402084697027E-4]:5.297330864847E1,13[&rate=4.937443630127629E-4]:5.297330864847E1)[&rate=5.02379823772891E-4]:1.5628107012E1)[&rate=5.523567927143239E-4]:1.417688418508E0,(19[&rate=6.91803846308752E-4]:1.504360031851E1,18[&rate=7.945340957059258E-4]:1.504360031851E1)[&rate=4.759871500750643E-4]:5.497550376047E1)[&rate=5.10891630405812E-4]:2.601091598373E0,((10[&rate=6.820473462344158E-4]:2.499121319924E1,31[&rate=8.084302908223347E-4]:2.499121319924E1)[&rate=3.135226353074555E-4]:4.717627786596E1,23[&rate=5.523567927143239E-4]:7.21674910652E1)[&rate=7.120750945492981E-4]:4.527046121553E-1)[&rate=4.3737102392230347E-4]:1.539583293474E0)[&rate=7.226450443757622E-4]:2.307096506365E0,(17[&rate=9.126299575190982E-4]:5.866051275335E1,(27[&rate=4.3737102392230347E-4]:3.477236670925E1,28[&rate=8.727909142795875E-4]:3.477236670925E1)[&rate=0.0010621386109660028]:2.38881460441E1)[&rate=5.441477553518497E-4]:1.780636272384E1)[&rate=0.0010621386109660028]:5.000986834904E1);\ntree STATE_14 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.5324309916,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.5324309916,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.0238974300974706E-4]:7.253261647156E0,9[&rate=7.589619695539044E-4]:7.253261647156E0)[&rate=4.12125220914992E-4]:9.12847796961E0,15[&rate=6.49488662929709E-4]:1.638173961677E1)[&rate=5.937913081567761E-4]:9.409701631642E1,(14[&rate=0.0011912096431048278]:3.975017094763E1,24[&rate=8.113152095820876E-4]:3.975017094763E1)[&rate=0.0010714071853514511]:7.072858498555E1)[&rate=0.0011912096431048278]:1.896636375338E1,(((25[&rate=5.532001622028132E-4]:7.702040980136E1,(((((30[&rate=6.867922426092057E-4]:5.322669526753E1,26[&rate=6.867922426092057E-4]:5.322669526753E1)[&rate=6.152746115961397E-4]:9.830725724288E0,32[&rate=5.054360693218599E-4]:6.305742099182E1)[&rate=3.6107510832553337E-4]:9.16676698079E0,((((4[&rate=5.833764828162061E-4]:2.545133773583E0,3[&rate=7.928743206654859E-4]:2.545133773583E0)[&rate=6.263883367892908E-4]:6.734250398319E-1,2[&rate=4.498633554042796E-4]:3.218558813415E0)[&rate=5.242584596740147E-4]:1.057147494149E1,5[&rate=2.610554530980564E-4]:1.379003375491E1)[&rate=9.557666380719462E-4]:1.481840703734E0,((7[&rate=4.591284695900369E-4]:8.082341653522E0,6[&rate=0.0010271238247065225]:8.082341653522E0)[&rate=3.498379695018622E-4]:1.062214003147E0,1[&rate=5.054360693218599E-4]:9.144555656668E0)[&rate=3.9246683832268596E-4]:6.127318801974E0)[&rate=5.242584596740147E-4]:5.695231351397E1)[&rate=3.2553373988403726E-4]:2.272653668302E0,(16[&rate=3.8231195227624335E-4]:3.955834005638E1,((22[&rate=8.745828059780699E-4]:2.3311208713E0,21[&rate=4.12125220914992E-4]:2.3311208713E0)[&rate=7.000866172578479E-4]:5.642908590651E0,20[&rate=5.054360693218599E-4]:7.974029461951E0)[&rate=7.432556040938871E-4]:3.158431059443E1)[&rate=8.309442916705051E-4]:3.493850158453E1)[&rate=9.260219058890646E-4]:1.6252466032E0,12[&rate=8.991390376618166E-4]:7.612208824411E1)[&rate=3.6107510832553337E-4]:8.983215572436E-1)[&rate=8.745828059780699E-4]:1.355851143839E0,((((11[&rate=5.532001622028132E-4]:1.843918890631E1,29[&rate=4.8684804404665983E-4]:1.843918890631E1)[&rate=5.630992831785108E-4]:4.987818528387E1,(33[&rate=9.557666380719462E-4]:6.191248818911E1,13[&rate=2.8069237175515924E-4]:6.191248818911E1)[&rate=0.0012808139267449761]:6.404886001057E0)[&rate=4.591284695900369E-4]:5.230652870352E0,(19[&rate=7.589619695539044E-4]:1.675519880094E1,18[&rate=4.0238974300974706E-4]:1.675519880094E1)[&rate=5.337957946257013E-4]:5.679282825959E1)[&rate=4.6836888147953556E-4]:1.241624356231E0,((10[&rate=4.12125220914992E-4]:2.360672107627E1,31[&rate=7.754659491959088E-4]:2.360672107627E1)[&rate=2.9732753100044225E-4]:5.044888055845E1,23[&rate=6.044167786381218E-4]:7.405560163472E1)[&rate=4.311774879701899E-4]:7.34049782038E-1)[&rate=3.2553373988403726E-4]:3.586609528442E0)[&rate=5.054360693218599E-4]:4.405361639629E0,(17[&rate=6.739561946859455E-4]:7.009305980529E1,(27[&rate=4.405536422032317E-4]:3.366976166682E1,28[&rate=0.0012808139267449761]:3.366976166682E1)[&rate=7.000866172578479E-4]:3.642329813847E1)[&rate=7.589619695539044E-4]:1.268856277953E1)[&rate=0.0012808139267449761]:4.666349710174E1);\ntree STATE_15 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.32527386783,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.32527386783,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.118482569334975E-4]:6.321518292542E0,9[&rate=6.29726678209237E-4]:6.321518292542E0)[&rate=3.2680027085809873E-4]:8.71427131593E0,15[&rate=9.903668907412751E-4]:1.503578960847E1)[&rate=7.380959259644978E-4]:1.023627936744E2,(14[&rate=0.0014570815389533026]:4.511125849093E1,24[&rate=7.699321944751683E-4]:4.511125849093E1)[&rate=9.337868601339419E-4]:7.22873247919E1)[&rate=9.608868924009312E-4]:1.207580602174E1,(((25[&rate=6.176828843754559E-4]:7.138407651894E1,((((16[&rate=4.965370587508066E-4]:3.724325599135E1,((22[&rate=9.903668907412751E-4]:2.028826555418E0,21[&rate=4.441054909961613E-4]:2.028826555418E0)[&rate=7.230545092062196E-4]:5.008828354334E0,20[&rate=4.118482569334975E-4]:7.037654909752E0)[&rate=0.0013462024311208906]:3.02056010816E1)[&rate=8.633497447201288E-4]:2.896663049248E1,((((4[&rate=4.227342060687943E-4]:2.02696631264E0,2[&rate=3.6592529911581823E-4]:2.02696631264E0)[&rate=0.0010586265181049335]:2.904307151312E-1,3[&rate=4.546548402879399E-4]:2.317397027771E0)[&rate=5.070353433508079E-4]:9.570435488018E0,5[&rate=5.496998513929008E-4]:1.188783251579E1)[&rate=6.420339534374775E-4]:2.308240387501E0,((7[&rate=4.118482569334975E-4]:8.614176361928E0,6[&rate=8.045596740635029E-4]:8.614176361928E0)[&rate=5.070353433508079E-4]:4.767300970468E-1,1[&rate=3.5351534733626055E-4]:9.090906458975E0)[&rate=5.606220112799831E-4]:5.105166444316E0)[&rate=6.058784057544988E-4]:5.201381358054E1)[&rate=8.426842919861049E-4]:1.667961315908E0,((30[&rate=7.380959259644978E-4]:5.04377657877E1,26[&rate=5.388976984687352E-4]:5.04377657877E1)[&rate=4.546548402879399E-4]:9.016642100139E0,32[&rate=2.9602474210386353E-4]:5.945440788784E1)[&rate=6.944559650387033E-4]:8.423439911897E0)[&rate=0.0012642210870195954]:1.61318483846E0,12[&rate=0.001022724370661214]:6.94910326382E1)[&rate=0.0011991513786994866]:1.89304388074E0)[&rate=5.716821251482823E-4]:2.894091811389E0,((((33[&rate=0.0010586265181049335]:5.343781925382E1,13[&rate=5.716821251482823E-4]:5.343781925382E1)[&rate=2.568426757476306E-4]:1.415182400653E1,(11[&rate=8.426842919861049E-4]:1.81599302277E1,29[&rate=5.388976984687352E-4]:1.81599302277E1)[&rate=8.231315012729861E-4]:4.942971303264E1)[&rate=3.1208797145621144E-4]:1.854704279298E0,(19[&rate=3.778808891391027E-4]:1.496362657021E1,18[&rate=9.608868924009312E-4]:1.496362657021E1)[&rate=3.8947427028808847E-4]:5.448072096944E1)[&rate=0.0012642210870195954]:3.532769849838E0,((10[&rate=7.699321944751683E-4]:2.518060891621E1,31[&rate=5.388976984687352E-4]:2.518060891621E1)[&rate=3.405293272278505E-4]:4.713208943576E1,23[&rate=4.756140648089928E-4]:7.231269835197E1)[&rate=4.118482569334975E-4]:6.644190375151E-1)[&rate=4.8606971358347535E-4]:1.301050940842E0)[&rate=5.281979188612834E-4]:3.973045615446E0,(17[&rate=8.852861109288588E-4]:6.784665261012E1,(27[&rate=6.546307900569246E-4]:2.612596129496E1,28[&rate=0.0012642210870195954]:2.612596129496E1)[&rate=6.29726678209237E-4]:4.172069131517E1)[&rate=4.227342060687943E-4]:1.040456133565E1)[&rate=0.0014570815389533026]:5.12231753588E1);\ntree STATE_16 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55160.14298629151,EEF_ucld_branchRates=-266.168517335019,lnP=-55160.14298629151,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.36356383532107E-4]:7.59589354893E0,9[&rate=0.0011620402326078]:7.59589354893E0)[&rate=5.296066976212456E-4]:4.535024859767E0,15[&rate=5.942088904771761E-4]:1.21309184087E1)[&rate=7.36356383532107E-4]:1.112737502884E2,(14[&rate=9.938468527416538E-4]:4.625884361997E1,24[&rate=7.36356383532107E-4]:4.625884361997E1)[&rate=7.8514332711469E-4]:7.714582507715E1)[&rate=0.0011620402326078]:3.021929372181E0,(((25[&rate=6.055807748800204E-4]:7.600886195508E1,(((((((4[&rate=8.414718514233315E-4]:1.462174261868E0,2[&rate=4.988272486160912E-4]:1.462174261868E0)[&rate=4.379340646527872E-4]:6.486620532412E-1,3[&rate=4.0666323213377697E-4]:2.110836315109E0)[&rate=9.629465122293221E-4]:1.028669070209E1,5[&rate=3.239993441142344E-4]:1.23975270172E1)[&rate=9.347786471579876E-4]:2.223339018187E0,((7[&rate=4.684405913450021E-4]:7.114679108352E0,6[&rate=3.5000216052246763E-4]:7.114679108352E0)[&rate=4.886784285208488E-4]:1.289340975605E0,1[&rate=4.276334136752185E-4]:8.404020083957E0)[&rate=5.505742274465613E-4]:6.21684595143E0)[&rate=5.400343681870574E-4]:5.39350673863E1,((30[&rate=6.17179272099044E-4]:4.92164117078E1,26[&rate=7.213749476077792E-4]:4.92164117078E1)[&rate=5.942088904771761E-4]:1.165773257327E1,32[&rate=4.4815202371425273E-4]:6.087414428107E1)[&rate=2.93997772410455E-4]:7.681789140616E0)[&rate=3.736879211522297E-4]:1.114862637018E0,(16[&rate=3.8494833127585167E-4]:3.750682027101E1,((22[&rate=0.0013018931538154232]:3.12132718283E0,21[&rate=8.216795846220895E-4]:3.12132718283E0)[&rate=5.192742321792005E-4]:6.250751523375E0,20[&rate=4.1722094471814295E-4]:9.372078706205E0)[&rate=0.0011620402326078]:2.813474156481E1)[&rate=0.001223959887129298]:3.216397578769E1)[&rate=9.938468527416538E-4]:2.885021150128E0,12[&rate=5.400343681870574E-4]:7.255581720883E1)[&rate=3.8494833127585167E-4]:3.453044746254E0)[&rate=5.400343681870574E-4]:1.3673376839E0,((((11[&rate=5.612435381832351E-4]:1.620914494695E1,29[&rate=6.17179272099044E-4]:1.620914494695E1)[&rate=8.414718514233315E-4]:5.38250238073E1,(19[&rate=4.4815202371425273E-4]:1.721542613831E1,18[&rate=9.938468527416538E-4]:1.721542613831E1)[&rate=3.620693463415381E-4]:5.281874261594E1)[&rate=9.347786471579876E-4]:1.540847845411E0,(33[&rate=7.519321805323345E-4]:6.055285532981E1,13[&rate=6.7945039583527E-4]:6.055285532981E1)[&rate=9.088714358781018E-4]:1.102216126985E1)[&rate=3.5000216052246763E-4]:2.941065167121E0,((10[&rate=3.959212118797708E-4]:1.812565672046E1,31[&rate=7.069298325344E-4]:1.812565672046E1)[&rate=2.5572077704553574E-4]:5.436626475235E1,23[&rate=5.192742321792005E-4]:7.249192147281E1)[&rate=8.029451197239374E-4]:2.024160293975E0)[&rate=4.0666323213377697E-4]:2.860117872201E0)[&rate=5.090200806007932E-4]:5.155254799853E0,(17[&rate=9.347786471579876E-4]:6.846608139923E1,(27[&rate=5.612435381832351E-4]:2.284721914937E1,28[&rate=0.0013018931538154232]:2.284721914937E1)[&rate=6.411503311032941E-4]:4.561886224986E1)[&rate=3.096635299177424E-4]:1.406537303961E1)[&rate=0.0014071655987174226]:4.389514363046E1);\ntree STATE_17 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55143.38273308143,EEF_ucld_branchRates=-266.168517335019,lnP=-55143.38273308143,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.506555873556851E-4]:7.782559943303E0,9[&rate=4.4134343887960987E-4]:7.782559943303E0)[&rate=4.795290057618743E-4]:3.886493701882E0,15[&rate=5.295237023593705E-4]:1.166905364519E1)[&rate=9.874478348461955E-4]:9.434401092198E1,(14[&rate=0.0011380672227444576]:4.140097174971E1,24[&rate=8.371498644216759E-4]:4.140097174971E1)[&rate=8.617805661195788E-4]:6.461209281745E1)[&rate=0.0012129038251036403]:2.027672574672E1,(((25[&rate=6.595978307798603E-4]:7.578405838826E1,(((16[&rate=3.749228995664782E-4]:3.919324198424E1,((22[&rate=3.127711449059808E-4]:2.523869494099E0,21[&rate=7.366813638643875E-4]:2.523869494099E0)[&rate=0.0012129038251036403]:6.596889354711E0,20[&rate=7.198366130957052E-4]:9.120758848811E0)[&rate=0.001314217762520253]:3.007248313543E1)[&rate=0.0010295070770397566]:3.371750487466E1,(((30[&rate=8.371498644216759E-4]:5.091051873416E1,26[&rate=4.6030977385842076E-4]:5.091051873416E1)[&rate=5.399903353083351E-4]:8.338346113434E0,32[&rate=5.726652849829668E-4]:5.924886484759E1)[&rate=4.0363270993555665E-4]:1.071153093659E1,((((4[&rate=8.371498644216759E-4]:2.009648719856E0,2[&rate=4.319144420999477E-4]:2.009648719856E0)[&rate=6.884435116591824E-4]:1.02356672841E0,3[&rate=4.698798128342713E-4]:3.033215448265E0)[&rate=3.4503991728950775E-4]:9.273018170191E0,5[&rate=3.941413644910323E-4]:1.230623361846E1)[&rate=3.3463164790819617E-4]:3.007315054923E0,((7[&rate=3.127711449059808E-4]:7.405224186519E0,6[&rate=5.295237023593705E-4]:7.405224186519E0)[&rate=7.930929148350972E-4]:1.434749012153E0,1[&rate=3.749228995664782E-4]:8.839973198672E0)[&rate=7.037859961249325E-4]:6.473575474709E0)[&rate=6.077355501000912E-4]:5.46468471108E1)[&rate=3.6513857614309795E-4]:2.950351074716E0)[&rate=8.371498644216759E-4]:8.526486969747E-1,12[&rate=7.198366130957052E-4]:7.376339555587E1)[&rate=3.749228995664782E-4]:2.020662832387E0)[&rate=4.698798128342713E-4]:4.042041478786E-1,((((33[&rate=5.726652849829668E-4]:5.640319059084E1,13[&rate=2.8882627607631475E-4]:5.640319059084E1)[&rate=2.6127515959781857E-4]:1.386073688442E1,(19[&rate=4.795290057618743E-4]:1.772321736202E1,18[&rate=7.731771059123632E-4]:1.772321736202E1)[&rate=4.5080302175045246E-4]:5.254071011324E1)[&rate=9.180184465772864E-4]:2.102766722736E0,(11[&rate=4.89273163642694E-4]:1.658910594997E1,29[&rate=3.941413644910323E-4]:1.658910594997E1)[&rate=6.595978307798603E-4]:5.577758824802E1)[&rate=3.127711449059808E-4]:2.104229074197E0,((10[&rate=5.19236459853593E-4]:2.529787114429E1,31[&rate=5.091104187669138E-4]:2.529787114429E1)[&rate=2.2625527042442634E-4]:4.900331340396E1,23[&rate=4.795290057618743E-4]:7.430118454825E1)[&rate=3.749228995664782E-4]:1.697387239375E-1)[&rate=3.4503991728950775E-4]:1.717339263947E0)[&rate=6.737353930319007E-4]:3.253259998037E0,(17[&rate=7.544214387129368E-4]:6.906637409058E1,(27[&rate=5.615399158351626E-4]:2.999544425304E1,28[&rate=0.0011380672227444576]:2.999544425304E1)[&rate=6.595978307798603E-4]:3.907092983754E1)[&rate=2.8882627607631475E-4]:1.037514844359E1)[&rate=0.0011380672227444576]:4.684826777971E1);\ntree STATE_18 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55107.989193203604,EEF_ucld_branchRates=-266.168517335019,lnP=-55107.989193203604,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=8.901499101678172E-4]:6.432815542754E0,9[&rate=0.0012424526694587287]:6.432815542754E0)[&rate=6.710917671905881E-4]:6.34007728269E0,15[&rate=8.139553509342538E-4]:1.277289282544E1)[&rate=7.811239635211544E-4]:1.007816193011E2,(14[&rate=0.0013177025627507883]:4.431760162153E1,24[&rate=9.121510518604724E-4]:4.431760162153E1)[&rate=0.0011326087490347988]:6.923691050505E1)[&rate=3.193121109636076E-4]:1.298411519767E1,(((25[&rate=6.961757940263124E-4]:7.870872969651E1,((12[&rate=9.121510518604724E-4]:7.338507991885E1,(16[&rate=5.386507872486772E-4]:4.040338179798E1,((22[&rate=8.901499101678172E-4]:3.558574226266E0,21[&rate=4.0127612537553043E-4]:3.558574226266E0)[&rate=7.365257678052527E-4]:6.773835594906E0,20[&rate=6.130240660966053E-4]:1.033240982117E1)[&rate=0.0012424526694587287]:3.007097197681E1)[&rate=0.0014190139752666567]:3.298169812087E1)[&rate=3.355002141254822E-4]:2.513229787435E0,(((30[&rate=6.130240660966053E-4]:5.470721365309E1,26[&rate=5.593836233582823E-4]:5.470721365309E1)[&rate=9.121510518604724E-4]:8.565483861557E0,32[&rate=3.502799929766801E-4]:6.327269751465E1)[&rate=4.456891812553701E-4]:7.937948623335E0,((((4[&rate=0.0010898176834783474]:2.107766872221E0,3[&rate=2.519446732150179E-4]:2.107766872221E0)[&rate=3.8938227261411625E-4]:3.934031917792E-1,2[&rate=6.3557818399442E-4]:2.501170064001E0)[&rate=6.3557818399442E-4]:7.165919578443E0,5[&rate=5.181255781187556E-4]:9.667089642444E0)[&rate=3.6403353576627666E-4]:3.573475695282E0,((7[&rate=4.8741025438541667E-4]:8.850671530135E0,6[&rate=7.50855425062406E-4]:8.850671530135E0)[&rate=4.456891812553701E-4]:1.268487269741E0,1[&rate=4.239878242831944E-4]:1.011915879988E1)[&rate=4.3493912970669E-4]:3.121406537849E0)[&rate=5.593836233582823E-4]:5.797008080026E1)[&rate=5.489826400145201E-4]:4.687663568305E0)[&rate=5.698706965416856E-4]:2.810419990222E0)[&rate=5.07896573635833E-4]:1.287885151112E0,((((11[&rate=4.6674251776796395E-4]:1.672505616658E1,29[&rate=5.911712884186903E-4]:1.672505616658E1)[&rate=5.593836233582823E-4]:5.891976849923E1,(33[&rate=9.611023675350458E-4]:6.353051344182E1,13[&rate=4.6674251776796395E-4]:6.353051344182E1)[&rate=5.489826400145201E-4]:1.211431122399E1)[&rate=0.0010188706897049764]:1.11304233315E0,(19[&rate=7.811239635211544E-4]:1.9577877511E1,18[&rate=6.242035907587395E-4]:1.9577877511E1)[&rate=3.8938227261411625E-4]:5.717998948797E1)[&rate=8.139553509342538E-4]:2.310539503629E0,((10[&rate=6.130240660966053E-4]:3.325315432695E1,31[&rate=5.07896573635833E-4]:3.325315432695E1)[&rate=4.3493912970669E-4]:4.46507936094E1,23[&rate=4.7711079393141924E-4]:7.790394793635E1)[&rate=8.315263240811577E-4]:1.164458566244E0)[&rate=7.50855425062406E-4]:9.282083450276E-1)[&rate=6.710917671905881E-4]:4.151794711775E0,(17[&rate=8.499979529494374E-4]:7.483537119704E1,(27[&rate=4.1278660635779704E-4]:3.486722617287E1,28[&rate=0.0012424526694587287]:3.486722617287E1)[&rate=7.657027589676421E-4]:3.996814502417E1)[&rate=9.611023675350458E-4]:9.313038362351E0)[&rate=0.0013177025627507883]:4.239021776486E1);\ntree STATE_19 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55124.2057170475,EEF_ucld_branchRates=-266.168517335019,lnP=-55124.2057170475,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.493417010500502E-4]:7.791353937659E0,9[&rate=0.001557620367623235]:7.791353937659E0)[&rate=4.614410768772295E-4]:6.369841425831E0,15[&rate=4.614410768772295E-4]:1.416119536349E1)[&rate=8.69492073058587E-4]:8.978410078825E1,(14[&rate=0.0012449540722595464]:4.284743901432E1,24[&rate=0.0012449540722595464]:4.284743901432E1)[&rate=0.0011880782445117311]:6.109785713742E1)[&rate=7.877293121546733E-4]:1.804246022327E1,(((25[&rate=6.274991794316059E-4]:7.353898119445E1,((((16[&rate=5.343145826798609E-4]:3.404258146905E1,((22[&rate=5.853947012549252E-4]:4.493473487512E0,21[&rate=3.0383899693477026E-4]:4.493473487512E0)[&rate=3.7602845849495244E-4]:3.6116140851E0,20[&rate=9.521784746829063E-4]:8.105087572612E0)[&rate=0.0010998313561239293]:2.593749389644E1)[&rate=0.0011880782445117311]:3.162949772349E1,((30[&rate=8.183188072976597E-4]:4.732596507844E1,26[&rate=5.139131596308786E-4]:4.732596507844E1)[&rate=7.074973499036084E-4]:1.290945112786E1,32[&rate=4.3918672161076533E-4]:6.02354162063E1)[&rate=5.546593802832314E-4]:5.436662986241E0)[&rate=9.76592057479047E-4]:3.914196259611E0,12[&rate=9.76592057479047E-4]:6.958627545215E1)[&rate=4.1560395954885456E-4]:5.986178841108E-1,((((4[&rate=8.345889885042045E-4]:2.248700960113E0,3[&rate=5.75097339214739E-4]:2.248700960113E0)[&rate=4.275978487294785E-4]:1.535232386654E-1,2[&rate=6.719091981385685E-4]:2.402224198778E0)[&rate=6.383396227698032E-4]:6.409881579153E0,5[&rate=8.027223624033441E-4]:8.812105777932E0)[&rate=5.036388536750526E-4]:1.55689301517E0,((7[&rate=2.7535994841271927E-4]:6.901638922428E0,1[&rate=4.7221812779165584E-4]:6.901638922428E0)[&rate=5.036388536750526E-4]:1.222218415549E0,6[&rate=5.75097339214739E-4]:8.123857337977E0)[&rate=8.883349468360984E-4]:2.245141455124E0)[&rate=6.274991794316059E-4]:5.981589454316E1)[&rate=4.932836967294983E-4]:3.354087858187E0)[&rate=0.0010998313561239293]:6.278441597535E-1,((((11[&rate=7.877293121546733E-4]:1.602897494916E1,29[&rate=4.614410768772295E-4]:1.602897494916E1)[&rate=8.516147254041381E-4]:5.055666762737E1,(33[&rate=9.08279963924997E-4]:6.052400809282E1,13[&rate=4.7221812779165584E-4]:6.052400809282E1)[&rate=5.853947012549252E-4]:6.061634483709E0)[&rate=5.343145826798609E-4]:2.60459457382E0,(19[&rate=6.719091981385685E-4]:1.203616954534E1,18[&rate=8.345889885042045E-4]:1.203616954534E1)[&rate=3.8997457354453306E-4]:5.715406760501E1)[&rate=7.877293121546733E-4]:1.920803775918E0,((10[&rate=5.343145826798609E-4]:2.327032116691E1,31[&rate=7.199231328859089E-4]:2.327032116691E1)[&rate=6.493417010500502E-4]:4.723501333558E1,23[&rate=3.610084319417902E-4]:7.050533450249E1)[&rate=3.610084319417902E-4]:6.057064237805E-1)[&rate=5.957667485360641E-4]:3.055784427929E0)[&rate=6.605247489599863E-4]:4.127531265988E0,(17[&rate=9.08279963924997E-4]:7.0424888936E1,(27[&rate=7.593171038305255E-4]:2.589367306633E1,28[&rate=0.001032007165044626]:2.589367306633E1)[&rate=9.08279963924997E-4]:4.453121586967E1)[&rate=5.648578991723382E-4]:7.869467684191E0)[&rate=0.001878877617909416]:4.369339975483E1);\ntree STATE_20 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55155.251432595986,EEF_ucld_branchRates=-266.168517335019,lnP=-55155.251432595986,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.2889524125691884E-4]:9.966285226242E0,9[&rate=8.060698961176745E-4]:9.966285226242E0)[&rate=3.454268860857848E-4]:4.393361858234E0,15[&rate=4.73735411169531E-4]:1.435964708448E1)[&rate=0.001007646336840171]:9.984393819121E1,(14[&rate=0.0011938738313120821]:4.51937544206E1,24[&rate=8.381280558770989E-4]:4.51937544206E1)[&rate=9.336152406331877E-4]:6.900983085509E1)[&rate=7.624074498087509E-4]:1.382796919186E1,(((25[&rate=5.771496034135573E-4]:7.873049603687E1,(((((((4[&rate=4.6290452418879777E-4]:1.743144264124E0,3[&rate=6.744955273107764E-4]:1.743144264124E0)[&rate=9.122702431591241E-4]:8.668466776283E-1,2[&rate=5.463736276724504E-4]:2.609990941752E0)[&rate=0.001251132254463214]:6.847873308336E0,5[&rate=3.9109306588456654E-4]:9.457864250088E0)[&rate=7.356134729295236E-4]:2.522005867896E0,((7[&rate=8.552570328576166E-4]:7.692595680257E0,6[&rate=3.9109306588456654E-4]:7.692595680257E0)[&rate=5.979307182563579E-4]:6.338877782184E-1,1[&rate=0.0010689809086246761]:8.326483458476E0)[&rate=8.381280558770989E-4]:3.653386659508E0)[&rate=8.732434468405376E-4]:5.895308231556E1,((30[&rate=5.979307182563579E-4]:5.180116358097E1,26[&rate=5.875024515519181E-4]:5.180116358097E1)[&rate=6.980908275306392E-4]:9.905466208501E0,32[&rate=5.053155976943182E-4]:6.170662978947E1)[&rate=9.56442745242499E-4]:9.226322644068E0)[&rate=5.566025098128166E-4]:4.177885925914E0,(16[&rate=4.84391113585074E-4]:3.590865696183E1,((22[&rate=0.0015659806923635875]:4.195019440328E0,21[&rate=5.361504266841202E-4]:4.195019440328E0)[&rate=9.56442745242499E-4]:4.04617438565E0,20[&rate=4.0428665774465584E-4]:8.241193825978E0)[&rate=0.0011938738313120821]:2.766746313585E1)[&rate=0.0011938738313120821]:3.920218139763E1)[&rate=2.2871239947086185E-4]:8.947128614426E-1,12[&rate=8.060698961176745E-4]:7.60055512209E1)[&rate=8.060698961176745E-4]:2.724944815968E0)[&rate=0.0011938738313120821]:1.269036028869E0,((((11[&rate=6.630468917428986E-4]:2.071121670816E1,29[&rate=6.190809300122877E-4]:2.071121670816E1)[&rate=8.922019967338077E-4]:5.123700488417E1,(33[&rate=5.463736276724504E-4]:6.568529269011E1,13[&rate=4.73735411169531E-4]:6.568529269011E1)[&rate=7.909875163297657E-4]:6.262928902223E0)[&rate=6.298371507540307E-4]:1.797583625918E0,(19[&rate=5.463736276724504E-4]:1.184201483627E1,18[&rate=5.053155976943182E-4]:1.184201483627E1)[&rate=4.2889524125691884E-4]:6.190379038198E1)[&rate=4.949074857696984E-4]:3.146609559497E0,((10[&rate=4.518563404766492E-4]:2.964778732308E1,31[&rate=6.407377087640634E-4]:2.964778732308E1)[&rate=5.668553197494677E-4]:4.501853792215E1,23[&rate=3.9109306588456654E-4]:7.466632524523E1)[&rate=6.518011382342693E-4]:2.226089532517E0)[&rate=6.630468917428986E-4]:3.107117287984E0)[&rate=4.73735411169531E-4]:4.975424921658E0,(17[&rate=8.217598028144925E-4]:7.464515799391E1,(27[&rate=4.73735411169531E-4]:2.598745928262E1,28[&rate=9.336152406331877E-4]:2.598745928262E1)[&rate=6.630468917428986E-4]:4.86576987113E1)[&rate=0.0011938738313120821]:1.032979899348E1)[&rate=0.0015659806923635875]:4.305659748016E1);\ntree STATE_21 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.968391203874,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.968391203874,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.6620877109873176E-4]:1.065316195241E1,9[&rate=3.9248977365750285E-4]:1.065316195241E1)[&rate=7.122217956367653E-4]:4.41636372233E0,15[&rate=7.58603921192177E-4]:1.506952567474E1)[&rate=7.757105724939267E-4]:1.008788501231E2,(14[&rate=0.00116754096628117]:4.506741360646E1,24[&rate=7.757105724939267E-4]:4.506741360646E1)[&rate=0.0010060501255807345]:7.088096219141E1)[&rate=4.206989052048068E-4]:1.327005185815E1,(((25[&rate=5.599336829808822E-4]:7.701135214282E1,((((30[&rate=8.801685844439893E-4]:5.210644779827E1,26[&rate=5.40356476094704E-4]:5.210644779827E1)[&rate=5.69967210099984E-4]:7.980022569476E0,32[&rate=3.827683671838401E-4]:6.008647036775E1)[&rate=2.8962122600787517E-4]:1.052941888583E1,(12[&rate=6.714945456435572E-4]:6.652404833493E1,(16[&rate=4.7527391130743497E-4]:2.975402765597E1,((22[&rate=5.69967210099984E-4]:3.302727637011E0,21[&rate=3.6259399025384266E-4]:3.302727637011E0)[&rate=4.0202859886808047E-4]:5.340786517118E0,20[&rate=4.2988844752163104E-4]:8.643514154128E0)[&rate=0.0010060501255807345]:2.111051350184E1)[&rate=0.0011019352536023866]:3.677002067896E1)[&rate=4.8436665379179324E-4]:4.09184091865E0)[&rate=5.69967210099984E-4]:2.561737740664E0,((((4[&rate=4.11421283203048E-4]:2.239110944747E0,2[&rate=7.269563889940388E-4]:2.239110944747E0)[&rate=3.294707391416771E-4]:3.839203595214E-1,3[&rate=7.269563889940388E-4]:2.623031304268E0)[&rate=9.358563579790692E-4]:8.134540261231E0,5[&rate=4.935025083475585E-4]:1.07575715655E1)[&rate=4.11421283203048E-4]:1.237435040997E0,((7[&rate=3.5202144694948534E-4]:7.783759944073E0,6[&rate=7.938336725998552E-4]:7.783759944073E0)[&rate=4.2988844752163104E-4]:5.455708623035E-1,1[&rate=3.410179739749763E-4]:8.329330806377E0)[&rate=8.131265081268483E-4]:3.665675800119E0)[&rate=5.119639862389427E-4]:6.118262038775E1)[&rate=6.845513403308223E-4]:3.833725148578E0)[&rate=0.001690719015487785]:1.617981398433E0,((((11[&rate=3.172245905196809E-4]:1.598081606986E1,29[&rate=5.026966251445938E-4]:1.598081606986E1)[&rate=7.122217956367653E-4]:5.849457966789E1,(33[&rate=6.348636994287061E-4]:6.342549908624E1,13[&rate=3.9248977365750285E-4]:6.342549908624E1)[&rate=5.213195817914506E-4]:1.104989665151E1)[&rate=5.801884376963406E-4]:1.082697942566E0,(19[&rate=0.0010496225259700445]:1.597140251541E1,18[&rate=5.026966251445938E-4]:1.597140251541E1)[&rate=6.588889566018876E-4]:5.958669116491E1)[&rate=6.98108376337816E-4]:1.567827527474E0,((10[&rate=6.233716583741737E-4]:2.290182891667E1,31[&rate=7.122217956367653E-4]:2.290182891667E1)[&rate=3.410179739749763E-4]:5.334632312149E1,23[&rate=5.69967210099984E-4]:7.624815203816E1)[&rate=4.6620877109873176E-4]:8.777691696271E-1)[&rate=4.0202859886808047E-4]:1.503412333469E0)[&rate=2.2941334028975973E-4]:6.193343812733E0,(17[&rate=8.337779881803569E-4]:7.778692294697E1,(27[&rate=5.119639862389427E-4]:3.200009766253E1,28[&rate=0.00116754096628117]:3.200009766253E1)[&rate=4.0202859886808047E-4]:4.578682528445E1)[&rate=8.560247103508053E-4]:7.035754407015E0)[&rate=0.001255771056668636]:4.439575030204E1);\ntree STATE_22 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55131.59860775896,EEF_ucld_branchRates=-266.168517335019,lnP=-55131.59860775896,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=8.306012800252581E-4]:7.213687636348E0,9[&rate=5.861174742267083E-4]:7.213687636348E0)[&rate=7.606574067669981E-4]:8.874903099499E0,15[&rate=9.157114070895015E-4]:1.608859073585E1)[&rate=8.306012800252581E-4]:9.495614236845E1,(14[&rate=0.001190711584254777]:4.884553192923E1,24[&rate=6.342727343788983E-4]:4.884553192923E1)[&rate=0.001060968202744154]:6.219920117507E1)[&rate=3.841891764680352E-4]:3.998606964009E0,(((25[&rate=6.59794083153021E-4]:7.151634401412E1,((((30[&rate=9.669224981676951E-4]:5.089480182972E1,26[&rate=5.406686659087487E-4]:5.089480182972E1)[&rate=0.0015224380449208466]:7.426678184291E0,32[&rate=4.529977803298421E-4]:5.832148001401E1)[&rate=3.5893224441887523E-4]:9.856239952788E0,((((4[&rate=0.0014043336010761054]:1.947678100918E0,2[&rate=9.669224981676951E-4]:1.947678100918E0)[&rate=5.518450634211008E-4]:1.704710261733E0,3[&rate=3.454853862208925E-4]:3.652388362651E0)[&rate=8.119608544227841E-4]:6.001604931763E0,5[&rate=3.71791945750637E-4]:9.653993294414E0)[&rate=7.941454243253212E-4]:2.928684272001E0,((7[&rate=5.076246849850297E-4]:7.034129667086E0,6[&rate=7.606574067669981E-4]:7.034129667086E0)[&rate=5.518450634211008E-4]:8.883568549422E-1,1[&rate=5.185769953314012E-4]:7.922486522028E0)[&rate=4.1945386011925194E-4]:4.660191044387E0)[&rate=6.219082282704042E-4]:5.559504240038E1)[&rate=2.590971985978672E-4]:1.773093243095E0,((16[&rate=4.307682850992932E-4]:3.221173663642E1,((22[&rate=4.4193785483551004E-4]:3.239986683506E0,21[&rate=2.3130458582499395E-4]:3.239986683506E0)[&rate=0.0011417543207619218]:3.021653860288E0,20[&rate=4.307682850992932E-4]:6.261640543794E0)[&rate=0.0011417543207619218]:2.595009609262E1)[&rate=0.001248006779432821]:3.411408777783E1,12[&rate=7.148010530934151E-4]:6.632582441425E1)[&rate=5.518450634211008E-4]:3.624988795645E0)[&rate=0.0014043336010761054]:1.565530804222E0)[&rate=4.1945386011925194E-4]:3.561942729801E0,((((11[&rate=8.925676498670243E-4]:1.721635169221E1,29[&rate=4.529977803298421E-4]:1.721635169221E1)[&rate=8.119608544227841E-4]:5.155764303879E1,(33[&rate=7.004730070518115E-4]:6.089475784864E1,13[&rate=4.307682850992932E-4]:6.089475784864E1)[&rate=5.185769953314012E-4]:7.879236882358E0)[&rate=8.707756408664671E-4]:7.74640690559E-1,(19[&rate=6.219082282704042E-4]:1.64795486297E1,18[&rate=6.219082282704042E-4]:1.64795486297E1)[&rate=3.1607154622755664E-4]:5.306908679186E1)[&rate=5.295854361210119E-4]:3.850465859863E0,((10[&rate=5.861174742267083E-4]:2.504509479919E1,31[&rate=9.955605926304564E-4]:2.504509479919E1)[&rate=3.71791945750637E-4]:4.723820137262E1,23[&rate=4.529977803298421E-4]:7.228329617181E1)[&rate=8.925676498670243E-4]:1.115805109616E0)[&rate=4.4193785483551004E-4]:1.679185462494E0)[&rate=6.342727343788983E-4]:1.598540437058E0,(17[&rate=7.606574067669981E-4]:6.754671067246E1,(27[&rate=8.306012800252581E-4]:2.395586593991E1,28[&rate=8.306012800252581E-4]:2.395586593991E1)[&rate=5.861174742267083E-4]:4.359084473256E1)[&rate=4.1945386011925194E-4]:9.130116508509E0)[&rate=0.001705367972151901]:3.836651288734E1);\ntree STATE_23 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55151.10687253794,EEF_ucld_branchRates=-266.168517335019,lnP=-55151.10687253794,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.733400106445564E-4]:8.011739726933E0,9[&rate=0.0012031754742512144]:8.011739726933E0)[&rate=4.4341920271890185E-4]:5.401419109279E0,15[&rate=2.912720009263897E-4]:1.341315883621E1)[&rate=8.762102824569377E-4]:1.101571143742E2,(14[&rate=7.592943619057822E-4]:5.000563904019E1,24[&rate=6.145540394226147E-4]:5.000563904019E1)[&rate=0.0012031754742512144]:7.356463417023E1)[&rate=8.385815424580827E-4]:5.314572104775E0,(((25[&rate=8.212416702824886E-4]:7.520709755847E1,(12[&rate=8.212416702824886E-4]:7.101134182073E1,(((16[&rate=6.360373908496868E-4]:3.845924306731E1,((22[&rate=7.889523919556517E-4]:2.466796280363E0,21[&rate=7.059369822834136E-4]:2.466796280363E0)[&rate=0.0010273685195108986]:4.287915904644E0,20[&rate=7.452860288838153E-4]:6.754712185007E0)[&rate=0.0010273685195108986]:3.170453088231E1)[&rate=8.967933417228087E-4]:2.816679845315E1,((((4[&rate=4.327948505180505E-4]:1.540744983411E0,2[&rate=0.0013652372604493594]:1.540744983411E0)[&rate=7.592943619057822E-4]:1.290149201999E0,3[&rate=0.001062165923898783]:2.83089418541E0)[&rate=5.434282551894182E-4]:1.013652592077E1,5[&rate=3.464199625619159E-4]:1.296742010618E1)[&rate=9.188080406094449E-4]:1.836779751744E0,((7[&rate=4.538355649916614E-4]:8.360756423443E0,6[&rate=6.470633387487818E-4]:8.360756423443E0)[&rate=5.23717030628618E-4]:9.881404052304E-1,1[&rate=4.6408436405271465E-4]:9.348896828673E0)[&rate=4.327948505180505E-4]:5.455303029254E0)[&rate=4.4341920271890185E-4]:5.182184166253E1)[&rate=4.10717893345381E-4]:2.094216823152E0,((30[&rate=6.935769023747324E-4]:4.703366864549E1,26[&rate=6.360373908496868E-4]:4.703366864549E1)[&rate=9.96299927418965E-4]:8.468512931171E0,32[&rate=5.633015390468667E-4]:5.550218157666E1)[&rate=6.360373908496868E-4]:1.321807676695E1)[&rate=8.04729749892991E-4]:2.291083477118E0)[&rate=6.470633387487818E-4]:4.19575573774E0)[&rate=3.991322067246575E-4]:8.967626264101E-1,((((33[&rate=5.937017625625744E-4]:6.108672654358E1,13[&rate=2.912720009263897E-4]:6.108672654358E1)[&rate=5.23717030628618E-4]:9.957573483943E0,(11[&rate=4.6408436405271465E-4]:1.678689256976E1,29[&rate=7.738300549397457E-4]:1.678689256976E1)[&rate=9.188080406094449E-4]:5.425740745776E1)[&rate=8.385815424580827E-4]:1.797820226269E0,(19[&rate=5.434282551894182E-4]:2.093400052822E1,18[&rate=5.335607715414979E-4]:2.093400052822E1)[&rate=4.538355649916614E-4]:5.190811972557E1)[&rate=9.425031462154423E-4]:1.281267765847E0,((10[&rate=3.8706207270168265E-4]:2.569063231015E1,31[&rate=4.6408436405271465E-4]:2.569063231015E1)[&rate=4.941477417023862E-4]:4.608403965209E1,23[&rate=3.743816099190181E-4]:7.177467196224E1)[&rate=7.317532439525805E-4]:2.348716057394E0)[&rate=5.335607715414979E-4]:1.980472165244E0)[&rate=4.327948505180505E-4]:3.688437763967E0,(17[&rate=7.889523919556517E-4]:7.015960936284E1,(27[&rate=6.25207565327436E-4]:2.366037461202E1,28[&rate=0.0012031754742512144]:2.366037461202E1)[&rate=4.4341920271890185E-4]:4.649923475081E1)[&rate=6.040580598898777E-4]:9.632688586008E0)[&rate=0.0018201260923608933]:4.909254736634E1);\ntree STATE_24 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.099267745405,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.099267745405,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=2.7476312293384374E-4]:7.88093604643E0,9[&rate=8.234165193594261E-4]:7.88093604643E0)[&rate=5.352013119603402E-4]:8.419060470606E0,15[&rate=6.372977251980447E-4]:1.629999651704E1)[&rate=6.253467161905357E-4]:1.042091207751E2,(14[&rate=9.73885482454357E-4]:4.89855926709E1,24[&rate=9.482149789272512E-4]:4.89855926709E1)[&rate=0.001064734294280731]:7.152352462122E1)[&rate=4.132491924722523E-4]:5.70434490875E0,((((((16[&rate=3.325855168234456E-4]:3.745750177655E1,((22[&rate=0.0012445048495680379]:2.958836672565E0,21[&rate=3.622725836475443E-4]:2.958836672565E0)[&rate=9.242715992493518E-4]:6.372058155881E0,20[&rate=4.132491924722523E-4]:9.330894828446E0)[&rate=0.0013106719967786703]:2.81266069481E1)[&rate=0.0015064040769493222]:3.081073652827E1,(((((4[&rate=5.90595985930543E-4]:1.589560546844E0,2[&rate=4.699997112232875E-4]:1.589560546844E0)[&rate=5.681518494903769E-4]:4.812500207561E-1,3[&rate=7.144730001125443E-4]:2.0708105676E0)[&rate=4.36508911777722E-4]:1.029963180313E1,5[&rate=4.918226996298926E-4]:1.237044237073E1)[&rate=5.134975624546192E-4]:2.072299784407E0,((7[&rate=4.0118660237130766E-4]:7.694407531288E0,6[&rate=0.0010317001767666007]:7.694407531288E0)[&rate=7.893879944410368E-4]:1.723325791104E0,1[&rate=3.622725836475443E-4]:9.417733322392E0)[&rate=4.36508911777722E-4]:5.025008832746E0)[&rate=6.618796866868943E-4]:5.004888924425E1,((30[&rate=9.242715992493518E-4]:4.883298375917E1,26[&rate=0.0010015852326454616]:4.883298375917E1)[&rate=0.0011425217012434987]:6.548873195541E0,32[&rate=5.793141077656839E-4]:5.538185695471E1)[&rate=8.415721537341447E-4]:9.109774444683E0)[&rate=8.415721537341447E-4]:3.776606905431E0)[&rate=5.461135876863122E-4]:1.956473890156E0,12[&rate=7.893879944410368E-4]:7.022471219498E1)[&rate=0.0013106719967786703]:9.921957230517E-1,25[&rate=8.415721537341447E-4]:7.121690791803E1)[&rate=5.243356771291592E-4]:1.761640858288E0,((((11[&rate=5.352013119603402E-4]:1.499483092035E1,29[&rate=6.618796866868943E-4]:1.499483092035E1)[&rate=8.606117871277955E-4]:5.244872384198E1,(33[&rate=6.135929792866382E-4]:6.157180157286E1,13[&rate=4.4781673365169156E-4]:6.157180157286E1)[&rate=4.2500303787233875E-4]:5.871753189464E0)[&rate=4.36508911777722E-4]:1.600482693617E0,(19[&rate=8.060491788983889E-4]:1.859677580529E1,18[&rate=3.7581090577740894E-4]:1.859677580529E1)[&rate=7.579087902508236E-4]:5.044726165065E1)[&rate=6.618796866868943E-4]:1.192728606725E0,((10[&rate=7.893879944410368E-4]:2.149611147368E1,31[&rate=5.243356771291592E-4]:2.149611147368E1)[&rate=4.2500303787233875E-4]:4.829561904041E1,23[&rate=4.589683883943232E-4]:6.979173051409E1)[&rate=6.494677012290392E-4]:4.450355485773E-1)[&rate=4.589683883943232E-4]:2.741782713652E0)[&rate=6.494677012290392E-4]:2.653594109466E0,(17[&rate=0.001064734294280731]:6.690994039838E1,(27[&rate=7.144730001125443E-4]:2.796460412504E1,28[&rate=9.73885482454357E-4]:2.796460412504E1)[&rate=8.606117871277955E-4]:3.894533627334E1)[&rate=2.463815763482357E-4]:8.722202487405E0)[&rate=0.0016799319767232016]:5.058131931509E1);\ntree STATE_25 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.54873380309,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.54873380309,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.9147285856247195E-4]:8.173183096519E0,9[&rate=8.143781828224616E-4]:8.173183096519E0)[&rate=4.156474322614012E-4]:8.735495367781E0,15[&rate=5.115583619712337E-4]:1.69086784643E1)[&rate=8.8064112061869E-4]:1.010836425687E2,(14[&rate=0.0010555537481518865]:4.972838070335E1,24[&rate=0.0010207836918755067]:4.972838070335E1)[&rate=0.0011355154828000444]:6.826394032966E1)[&rate=4.993742632883034E-4]:1.178592184822E1,((((((16[&rate=2.470870355411002E-4]:4.284381472516E1,((22[&rate=6.435980992640667E-4]:3.658796743773E0,21[&rate=4.276063177870558E-4]:3.658796743773E0)[&rate=3.4086869728733045E-4]:4.460158187041E0,20[&rate=5.747037934758157E-4]:8.118954930815E0)[&rate=0.0014553993534517848]:3.472485979435E1)[&rate=0.0017185997004242387]:3.038537724325E1,(((30[&rate=9.589879795261333E-4]:4.924259479887E1,26[&rate=4.036147393243707E-4]:4.924259479887E1)[&rate=9.589879795261333E-4]:1.198862952761E1,32[&rate=3.6669064370178326E-4]:6.123122432648E1)[&rate=6.734977004948781E-4]:1.030645103532E1,((((4[&rate=2.470870355411002E-4]:2.119115937468E0,2[&rate=6.435980992640667E-4]:2.119115937468E0)[&rate=0.0019576056538517595]:7.767462627953E-1,3[&rate=0.0010207836918755067]:2.895862200263E0)[&rate=5.87927518630544E-4]:1.067372106625E1,5[&rate=3.2737359499432497E-4]:1.356958326651E1)[&rate=6.435980992640667E-4]:1.850617275052E0,((7[&rate=4.5142435226431436E-4]:9.149432083017E0,6[&rate=8.574231350838069E-4]:9.149432083017E0)[&rate=4.872901086235675E-4]:2.254788394284E0,1[&rate=3.539438902590613E-4]:1.14042204773E1)[&rate=8.143781828224616E-4]:4.015980064259E0)[&rate=6.292102681220622E-4]:5.611747482024E1)[&rate=0.0010935679185995952]:1.691516606609E0)[&rate=6.014027757605835E-4]:1.348945149704E0,12[&rate=9.589879795261333E-4]:7.457813711812E1)[&rate=7.051372855936251E-4]:1.43428163821E0,25[&rate=5.87927518630544E-4]:7.601241875633E1)[&rate=4.993742632883034E-4]:1.069927573256E0,((((11[&rate=8.143781828224616E-4]:1.337707797553E1,29[&rate=0.0012352829368172881]:1.337707797553E1)[&rate=9.051823307353437E-4]:5.605812824541E1,(33[&rate=8.8064112061869E-4]:6.181080479531E1,13[&rate=3.6669064370178326E-4]:6.181080479531E1)[&rate=3.7918090429176914E-4]:7.624401425628E0)[&rate=4.036147393243707E-4]:1.925606415298E0,(19[&rate=6.583493221634288E-4]:2.179601353008E1,18[&rate=5.115583619712337E-4]:2.179601353008E1)[&rate=5.115583619712337E-4]:4.956479910616E1)[&rate=7.38860436057362E-4]:2.021374505021E0,((10[&rate=8.353779839440136E-4]:2.08041030607E1,31[&rate=0.0011823240764984584]:2.08041030607E1)[&rate=4.276063177870558E-4]:5.074921830633E1,23[&rate=3.7918090429176914E-4]:7.155332136702E1)[&rate=3.1333848451668196E-4]:1.828865774237E0)[&rate=3.9147285856247195E-4]:3.700159188321E0)[&rate=5.238630524555457E-4]:4.223960165094E0,(17[&rate=8.353779839440136E-4]:7.12757882786E1,(27[&rate=4.5142435226431436E-4]:3.325810315451E1,28[&rate=9.589879795261333E-4]:3.325810315451E1)[&rate=8.353779839440136E-4]:3.801768512409E1)[&rate=1.9772198890520554E-4]:1.003051821608E1)[&rate=0.0014553993534517848]:4.847193638655E1);\ntree STATE_26 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55120.6002295403,EEF_ucld_branchRates=-266.168517335019,lnP=-55120.6002295403,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.903144721201903E-4]:1.042544895684E1,9[&rate=6.261244713629012E-4]:1.042544895684E1)[&rate=5.775147548618147E-4]:5.80576926096E0,15[&rate=6.136060948901627E-4]:1.62312182178E1)[&rate=8.940757175416415E-4]:9.922099316108E1,(14[&rate=0.0010053563641445483]:4.841910493554E1,24[&rate=8.285342728524506E-4]:4.841910493554E1)[&rate=8.089936993277209E-4]:6.703310644334E1)[&rate=8.285342728524506E-4]:1.322585863414E1,((((((16[&rate=3.903144721201903E-4]:3.828884718836E1,((22[&rate=0.001039734960929364]:3.476175402261E0,21[&rate=5.10015990005466E-4]:3.476175402261E0)[&rate=0.0010779379805749114]:4.914718509595E0,20[&rate=1.748070996359765E-4]:8.390893911855E0)[&rate=0.0012978002512941788]:2.989795327651E1)[&rate=9.740797446322901E-4]:3.45753241067E1,(((30[&rate=7.903878780782313E-4]:5.116716036018E1,26[&rate=5.209603668532543E-4]:5.116716036018E1)[&rate=0.0012978002512941788]:7.725055620049E0,32[&rate=4.56110324941187E-4]:5.889221598023E1)[&rate=3.291715914107245E-4]:1.285948580928E1,((((4[&rate=4.12705961962952E-4]:2.93582931845E0,2[&rate=4.56110324941187E-4]:2.93582931845E0)[&rate=2.450865415812791E-4]:3.305101534236E-1,3[&rate=8.285342728524506E-4]:3.266339471873E0)[&rate=7.903878780782313E-4]:8.26000835845E0,5[&rate=3.903144721201903E-4]:1.152634783032E1)[&rate=7.234878637271453E-4]:4.513850456929E0,((7[&rate=3.903144721201903E-4]:8.761176488842E0,6[&rate=4.015976310636382E-4]:8.761176488842E0)[&rate=4.12705961962952E-4]:1.048561646216E0,1[&rate=4.2367926175457905E-4]:9.809738135059E0)[&rate=0.001505551372568411]:6.230460152193E0)[&rate=6.389280550313043E-4]:5.571150350225E1)[&rate=3.5488888316876325E-4]:1.112469505549E0)[&rate=7.726155329826111E-4]:2.687351308304E0,12[&rate=8.940757175416415E-4]:7.555152260336E1)[&rate=4.2367926175457905E-4]:2.852398846775E0,25[&rate=7.726155329826111E-4]:7.840392145014E1)[&rate=5.658975116679521E-4]:8.455988946389E-1,((((11[&rate=6.793396491512761E-4]:1.400549607063E1,29[&rate=6.01347317356406E-4]:1.400549607063E1)[&rate=8.709191418707708E-4]:5.35667483986E1,(33[&rate=8.709191418707708E-4]:6.047980118067E1,13[&rate=5.320024467706047E-4]:6.047980118067E1)[&rate=3.903144721201903E-4]:7.092443288557E0)[&rate=3.291715914107245E-4]:5.59379701143E0,(19[&rate=4.345517048235722E-4]:2.408516097331E1,18[&rate=2.6623725938250496E-4]:2.408516097331E1)[&rate=4.56110324941187E-4]:4.908088050734E1)[&rate=8.089936993277209E-4]:3.332912007366E0,((10[&rate=6.136060948901627E-4]:2.04138871157E1,31[&rate=4.991511534489875E-4]:2.04138871157E1)[&rate=4.991511534489875E-4]:5.410939028226E1,23[&rate=4.668472142727088E-4]:7.452327739796E1)[&rate=8.709191418707708E-4]:1.975676090056E0)[&rate=6.261244713629012E-4]:2.750566856755E0)[&rate=9.453668911413456E-4]:4.51163651019E0,(17[&rate=5.775147548618147E-4]:7.695309843141E1,(27[&rate=5.10015990005466E-4]:3.115151110414E1,28[&rate=0.0012978002512941788]:3.115151110414E1)[&rate=6.520445336261696E-4]:4.580158732727E1)[&rate=8.285342728524506E-4]:6.808058423555E0)[&rate=0.0013859456784206473]:4.491691315806E1);\ntree STATE_27 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55142.6354293579,EEF_ucld_branchRates=-266.168517335019,lnP=-55142.6354293579,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.6941559425179495E-4]:8.186378922423E0,9[&rate=6.464031407847066E-4]:8.186378922423E0)[&rate=5.061929911599962E-4]:6.296730501664E0,15[&rate=6.134607302397474E-4]:1.448310942409E1)[&rate=8.362741118485404E-4]:9.646099097155E1,(14[&rate=0.0012742924071094705]:4.454063379608E1,24[&rate=6.820639382506874E-4]:4.454063379608E1)[&rate=0.0011227117085937555]:6.640346659956E1)[&rate=9.908584346661135E-4]:8.784792558563E0,((((((16[&rate=3.4844128382660665E-4]:3.818287300225E1,((22[&rate=9.030115307697507E-4]:2.942091360127E0,21[&rate=3.3588287238860734E-4]:2.942091360127E0)[&rate=3.8233840133932416E-4]:5.02621505051E0,20[&rate=8.789961195588283E-4]:7.968306410637E0)[&rate=7.989550575156367E-4]:3.021456659161E1)[&rate=0.0010279058965115394]:3.000942010434E1,(((30[&rate=7.355017372522286E-4]:4.602515252634E1,26[&rate=5.061929911599962E-4]:4.602515252634E1)[&rate=7.656715465047379E-4]:8.121814389845E0,32[&rate=6.029603923866958E-4]:5.414696691619E1)[&rate=8.568492438141847E-4]:9.131853526697E0,((((4[&rate=7.818743213080396E-4]:2.179438360063E0,2[&rate=7.077928711158399E-4]:2.179438360063E0)[&rate=4.029366747511004E-4]:5.156948343054E-1,3[&rate=6.029603923866958E-4]:2.695133194369E0)[&rate=0.0011227117085937555]:1.086532218654E1,5[&rate=3.715296819835555E-4]:1.356045538091E1)[&rate=6.029603923866958E-4]:1.791292544782E0,((7[&rate=4.029366747511004E-4]:8.690293823264E0,6[&rate=5.628004663485998E-4]:8.690293823264E0)[&rate=7.213729655281962E-4]:2.596135941345E0,1[&rate=3.4844128382660665E-4]:1.128642976461E1)[&rate=4.321344258575211E-4]:4.065318161078E0)[&rate=7.213729655281962E-4]:4.79270725172E1)[&rate=4.8779240248801066E-4]:4.9134726637E0)[&rate=7.989550575156367E-4]:9.143684909511E-1,12[&rate=7.656715465047379E-4]:6.910666159754E1)[&rate=4.321344258575211E-4]:2.802289698461E0,25[&rate=8.170380154705676E-4]:7.1908951296E1)[&rate=4.029366747511004E-4]:9.977815272249E-1,((((11[&rate=5.154428518793253E-4]:1.670109551317E1,29[&rate=4.321344258575211E-4]:1.670109551317E1)[&rate=8.568492438141847E-4]:4.949742727488E1,(33[&rate=9.292823744853958E-4]:5.332322811681E1,13[&rate=5.531303020741833E-4]:5.332322811681E1)[&rate=4.128502606666994E-4]:1.287529467125E1)[&rate=4.22570282567127E-4]:9.554924437596E-1,(19[&rate=6.134607302397474E-4]:1.556064663713E1,18[&rate=6.029603923866958E-4]:1.556064663713E1)[&rate=3.075197153665836E-4]:5.159336859469E1)[&rate=4.6019212910736244E-4]:2.07553039564E0,((10[&rate=7.656715465047379E-4]:2.058142152333E1,31[&rate=4.6019212910736244E-4]:2.058142152333E1)[&rate=5.926633724480712E-4]:4.792719002521E1,23[&rate=4.321344258575211E-4]:6.850861154855E1)[&rate=4.128502606666994E-4]:7.209340789098E-1)[&rate=5.341186688021905E-4]:3.677187195766E0)[&rate=4.509191789110659E-4]:3.372681619596E0,(17[&rate=8.170380154705676E-4]:7.01020751622E1,(27[&rate=2.709393724228811E-4]:3.395683359181E1,28[&rate=0.0011227117085937555]:3.395683359181E1)[&rate=4.786095425861748E-4]:3.614524157039E1)[&rate=5.628004663485998E-4]:6.177339280621E0)[&rate=7.355017372522286E-4]:4.344947851139E1);\ntree STATE_28 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55140.71766048652,EEF_ucld_branchRates=-266.168517335019,lnP=-55140.71766048652,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.960708476727161E-4]:9.808773305514E0,9[&rate=4.776393701358584E-4]:9.808773305514E0)[&rate=9.654024195225677E-4]:6.086234715942E0,15[&rate=7.436879433949868E-4]:1.589500802146E1)[&rate=5.712047296161358E-4]:1.041703013508E2,(14[&rate=9.104381003403188E-4]:4.043382268289E1,24[&rate=0.0011284928430587066]:4.043382268289E1)[&rate=8.440603404013136E-4]:7.963148668938E1)[&rate=0.0010344782037690352]:9.289068958016E0,((((((16[&rate=4.4021574201124464E-4]:3.88106141339E1,((22[&rate=5.145164181001073E-4]:2.942484065917E0,21[&rate=6.43550139190971E-4]:2.942484065917E0)[&rate=5.424925061917413E-4]:5.171321547008E0,20[&rate=8.86560314005066E-4]:8.113805612924E0)[&rate=0.0011284928430587066]:3.069680852098E1)[&rate=0.0016988018208742778]:3.123193594314E1,(((30[&rate=7.898989465411502E-4]:5.022193798197E1,26[&rate=7.436879433949868E-4]:5.022193798197E1)[&rate=4.2084034026752695E-4]:1.291142411684E1,32[&rate=4.868619105324113E-4]:6.313336209881E1)[&rate=7.436879433949868E-4]:6.574238087986E0,((((4[&rate=3.9015792586891455E-4]:2.179045799886E0,2[&rate=3.7928068216263136E-4]:2.179045799886E0)[&rate=8.440603404013136E-4]:5.836284436975E-1,3[&rate=6.113729960122972E-4]:2.762674243583E0)[&rate=4.4021574201124464E-4]:1.400363808925E1,5[&rate=2.778194730735305E-4]:1.676631233283E1)[&rate=4.2084034026752695E-4]:1.432015540846E0,((7[&rate=4.496963091497279E-4]:1.279937918287E1,6[&rate=4.590777032288949E-4]:1.279937918287E1)[&rate=6.113729960122972E-4]:1.55494728886E0,1[&rate=3.679446349808012E-4]:1.435432647173E1)[&rate=4.496963091497279E-4]:3.844001401944E0)[&rate=7.436879433949868E-4]:5.150927231312E1)[&rate=5.810113354330564E-4]:3.349498902416E-1)[&rate=7.898989465411502E-4]:2.27459540359E0,12[&rate=7.737571185932862E-4]:7.231714548063E1)[&rate=6.66311938289105E-4]:3.546979811635E0,25[&rate=6.43550139190971E-4]:7.586412529227E1)[&rate=4.0066607454615174E-4]:1.198707450069E0,((((33[&rate=8.24914361987709E-4]:5.815820464637E1,13[&rate=2.978471313525928E-4]:5.815820464637E1)[&rate=4.306078997156629E-4]:1.056067700376E1,(11[&rate=6.010775181693174E-4]:1.830947634312E1,29[&rate=4.590777032288949E-4]:1.830947634312E1)[&rate=6.010775181693174E-4]:5.040940530701E1)[&rate=6.547825763610909E-4]:2.672840064703E0,(19[&rate=8.069103554496241E-4]:1.152596652684E1,18[&rate=8.645322480940321E-4]:1.152596652684E1)[&rate=3.4337566472316045E-4]:5.986575518799E1)[&rate=8.440603404013136E-4]:3.601786805055E0,((10[&rate=6.113729960122972E-4]:1.750414687301E1,31[&rate=8.24914361987709E-4]:1.750414687301E1)[&rate=4.960708476727161E-4]:5.635867098973E1,23[&rate=4.4021574201124464E-4]:7.386281786274E1)[&rate=5.237853172032244E-4]:1.130690657146E0)[&rate=4.776393701358584E-4]:2.069324222451E0)[&rate=4.2084034026752695E-4]:4.265920667554E0,(17[&rate=7.160562700414259E-4]:7.460611317771E1,(27[&rate=3.4337566472316045E-4]:2.865049184355E1,28[&rate=9.977074320712477E-4]:2.865049184355E1)[&rate=8.86560314005066E-4]:4.595562133416E1)[&rate=5.810113354330564E-4]:6.722640232182E0)[&rate=7.737571185932862E-4]:4.80256249204E1);\ntree STATE_29 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55129.794636509185,EEF_ucld_branchRates=-266.168517335019,lnP=-55129.794636509185,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.8172473052696E-4]:9.206867550012E0,9[&rate=7.624734298737289E-4]:9.206867550012E0)[&rate=5.217689993200701E-4]:8.67103971363E0,15[&rate=3.4454831077793883E-4]:1.787790726364E1)[&rate=7.269941253380213E-4]:9.858606018488E1,(14[&rate=0.0011575165348884752]:4.668250537025E1,24[&rate=7.624734298737289E-4]:4.668250537025E1)[&rate=7.442713356634284E-4]:6.978146207827E1)[&rate=8.72764102335958E-4]:7.895442781628E0,((((((16[&rate=4.040319474341064E-4]:4.684549211126E1,((22[&rate=5.763266839527458E-4]:4.409766790505E0,21[&rate=3.5484400275438E-4]:4.409766790505E0)[&rate=9.642640201821443E-4]:5.861710206114E0,20[&rate=3.3399735288822303E-4]:1.027147699662E1)[&rate=8.72764102335958E-4]:3.657401511465E1)[&rate=0.0010021307164639853]:2.765211265248E1,(((((4[&rate=5.649595394928279E-4]:3.286029523823E0,2[&rate=6.948117796417444E-4]:3.286029523823E0)[&rate=2.4352053091756937E-4]:2.992787939667E-1,3[&rate=8.240052781732198E-4]:3.58530831779E0)[&rate=4.3279260078539375E-4]:1.019629575887E1,5[&rate=3.649362511780711E-4]:1.378160407666E1)[&rate=5.429515672235606E-4]:3.622703952688E0,((7[&rate=3.5484400275438E-4]:1.00649232558E1,6[&rate=6.121810483599872E-4]:1.00649232558E1)[&rate=2.0019216702859413E-4]:2.038092945586E0,1[&rate=3.649362511780711E-4]:1.210301620139E1)[&rate=3.9438672271803374E-4]:5.301291827958E0)[&rate=4.136338750023068E-4]:5.503125318235E1,((30[&rate=5.322671379926243E-4]:5.120567093934E1,26[&rate=6.948117796417444E-4]:5.120567093934E1)[&rate=3.9438672271803374E-4]:1.224995558155E1,32[&rate=3.8467427909664634E-4]:6.345562652089E1)[&rate=4.040319474341064E-4]:8.979934690808E0)[&rate=4.7144618680923685E-4]:2.06204355205E0)[&rate=8.240052781732198E-4]:2.26786997734E0,12[&rate=5.012578317491164E-4]:7.676547474109E1)[&rate=8.474411144990577E-4]:9.411577515126E-1,25[&rate=5.649595394928279E-4]:7.77066324926E1)[&rate=3.231266552414985E-4]:2.318106061005E0,((((33[&rate=7.624734298737289E-4]:6.398261324415E1,13[&rate=4.6169797533613424E-4]:6.398261324415E1)[&rate=3.649362511780711E-4]:8.405866178292E0,(11[&rate=5.999096235926464E-4]:1.695515390953E1,29[&rate=4.423878106821967E-4]:1.695515390953E1)[&rate=6.948117796417444E-4]:5.543332551291E1)[&rate=5.763266839527458E-4]:8.143193337766E-1,(19[&rate=5.999096235926464E-4]:1.248234748449E1,18[&rate=8.474411144990577E-4]:1.248234748449E1)[&rate=3.9438672271803374E-4]:6.072045127173E1)[&rate=5.429515672235606E-4]:4.027216842862E0,((10[&rate=4.3279260078539375E-4]:1.784895896752E1,31[&rate=0.0010962459524725052]:1.784895896752E1)[&rate=2.7430833061618104E-4]:5.874088640241E1,23[&rate=4.3279260078539375E-4]:7.658984536994E1)[&rate=3.8467427909664634E-4]:6.401702291491E-1)[&rate=3.118537982063007E-4]:2.794722954523E0)[&rate=8.021746985097921E-4]:6.184754844097E0,(17[&rate=6.948117796417444E-4]:7.858839984041E1,(27[&rate=8.021746985097921E-4]:3.182969122478E1,28[&rate=0.0011575165348884752]:3.182969122478E1)[&rate=5.999096235926464E-4]:4.675870861563E1)[&rate=0.0010021307164639853]:7.621093557297E0)[&rate=0.0018681582614768037]:3.814991683245E1);\ntree STATE_30 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55146.84853873062,EEF_ucld_branchRates=-266.168517335019,lnP=-55146.84853873062,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.208453414419401E-4]:8.805020679128E0,9[&rate=6.608063379082266E-4]:8.805020679128E0)[&rate=4.6022622597981005E-4]:7.896216628115E0,15[&rate=5.302993935119918E-4]:1.670123730724E1)[&rate=9.014763754775282E-4]:9.001330626193E1,(14[&rate=0.0014096049586761821]:4.222758282096E1,24[&rate=0.0011149513324931566]:4.222758282096E1)[&rate=9.629377406187616E-4]:6.448696074821E1)[&rate=9.4089720753323E-4]:1.960163810223E1,((((((16[&rate=3.6376465277983305E-4]:4.187101873818E1,((22[&rate=0.0012944564794138318]:2.998705012015E0,21[&rate=6.806462754774087E-4]:2.998705012015E0)[&rate=4.814459783138822E-4]:5.204576512968E0,20[&rate=8.508652510774143E-4]:8.203281524983E0)[&rate=0.0010762842076049097]:3.36677372132E1)[&rate=9.014763754775282E-4]:2.670515886383E1,(((30[&rate=8.073296510742574E-4]:4.631897029614E1,26[&rate=7.225644832190805E-4]:4.631897029614E1)[&rate=9.4089720753323E-4]:9.66890708888E0,32[&rate=4.7100703314909817E-4]:5.598787738502E1)[&rate=3.4235929076516973E-4]:1.097685221517E1,((((4[&rate=8.668083263733282E-4]:2.391506755923E0,2[&rate=6.040717223535721E-4]:2.391506755923E0)[&rate=4.814459783138822E-4]:2.365280517723E-1,3[&rate=8.356962267739732E-4]:2.628034807695E0)[&rate=5.673421657735794E-4]:1.118510391894E1,5[&rate=4.4902728092780056E-4]:1.381313872664E1)[&rate=8.212100490524422E-4]:2.01947995506E0,((7[&rate=7.939892450285796E-4]:9.117680739874E0,6[&rate=9.4089720753323E-4]:9.117680739874E0)[&rate=5.856782742316435E-4]:3.877072528605E-1,1[&rate=5.948600720656455E-4]:9.505387992735E0)[&rate=5.015299295060334E-4]:6.327230688962E0)[&rate=6.415154945250626E-4]:5.113211091849E1)[&rate=5.015299295060334E-4]:1.611448001827E0)[&rate=5.396538957722829E-4]:2.778252409991E0,12[&rate=8.356962267739732E-4]:7.1354430012E1)[&rate=7.225644832190805E-4]:1.628992809647E0,25[&rate=7.225644832190805E-4]:7.298342282165E1)[&rate=5.948600720656455E-4]:2.523159598324E0,((((33[&rate=7.117532249660856E-4]:5.734930938824E1,13[&rate=4.916037893768911E-4]:5.734930938824E1)[&rate=4.2494913693788333E-4]:1.305991730652E1,(11[&rate=6.806462754774087E-4]:1.782092440049E1,29[&rate=8.668083263733282E-4]:1.782092440049E1)[&rate=6.90816053549248E-4]:5.258830229427E1)[&rate=5.208453414419401E-4]:2.176340139432E0,(19[&rate=0.0010428758731266183]:1.442121030615E1,18[&rate=5.112655113416944E-4]:1.442121030615E1)[&rate=5.015299295060334E-4]:5.816435652804E1)[&rate=5.673421657735794E-4]:1.941325014484E0,((10[&rate=6.806462754774087E-4]:1.605169914962E1,31[&rate=8.668083263733282E-4]:1.605169914962E1)[&rate=2.6727468137656527E-4]:5.789858055704E1,23[&rate=5.208453414419401E-4]:7.395027970666E1)[&rate=7.939892450285796E-4]:5.766121420252E-1)[&rate=5.489321513570119E-4]:9.796905712945E-1)[&rate=0.0010133939952830955]:4.213178245369E0,(17[&rate=8.836346071210225E-4]:6.731364253985E1,(27[&rate=6.226444597277582E-4]:2.806117540153E1,28[&rate=6.608063379082266E-4]:2.806117540153E1)[&rate=5.015299295060334E-4]:3.925246713833E1)[&rate=8.073296510742574E-4]:1.240611812549E1)[&rate=0.0016581039398719311]:4.659642100606E1);\ntree STATE_31 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.3752470363,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.3752470363,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.52778970427855E-4]:6.71772245889E0,9[&rate=4.424190874599782E-4]:6.71772245889E0)[&rate=4.1171759254246624E-4]:1.272859167766E1,15[&rate=5.063180499680869E-4]:1.944631413655E1)[&rate=7.075886621723801E-4]:9.993919086305E1,(14[&rate=8.524722169145591E-4]:5.133557109333E1,24[&rate=9.390866118587179E-4]:5.133557109333E1)[&rate=6.908415774465502E-4]:6.804993390627E1)[&rate=5.896220814679888E-4]:9.639957866343E0,((((((16[&rate=3.502006242356142E-4]:3.619328248984E1,((22[&rate=9.077196632478096E-4]:2.773002026316E0,21[&rate=4.7379388491762065E-4]:2.773002026316E0)[&rate=6.300974157969632E-4]:5.196302479321E0,20[&rate=5.523432500741697E-4]:7.969304505637E0)[&rate=0.0011644003633728929]:2.82239779842E1)[&rate=0.0010121564737436764]:3.335862838427E1,(((((4[&rate=6.161945302018636E-4]:2.318290461709E0,3[&rate=3.606237703106146E-4]:2.318290461709E0)[&rate=7.434635860072854E-4]:4.252425436179E-1,2[&rate=2.9495074156152593E-4]:2.743533005327E0)[&rate=5.644652801811244E-4]:1.014875784024E1,5[&rate=3.606237703106146E-4]:1.289229084557E1)[&rate=0.0013261063540181697]:3.208657860953E0,((7[&rate=3.0661597709936934E-4]:1.109632751992E1,6[&rate=7.627841595976633E-4]:1.109632751992E1)[&rate=0.0011056359822729724]:6.615082531269E-1,1[&rate=3.0661597709936934E-4]:1.175783577305E1)[&rate=3.606237703106146E-4]:4.343112933474E0)[&rate=5.644652801811244E-4]:5.2284391939E1,((30[&rate=7.627841595976633E-4]:5.10040949884E1,26[&rate=4.6323142845214365E-4]:5.10040949884E1)[&rate=3.606237703106146E-4]:9.601396471386E0,32[&rate=3.811829285174663E-4]:6.060549145979E1)[&rate=4.0154798180535374E-4]:7.779849185739E0)[&rate=6.300974157969632E-4]:1.166570228586E0)[&rate=8.048083138496528E-4]:2.1801238989E0,12[&rate=8.278331243940449E-4]:7.173203477301E1)[&rate=2.059566932950806E-4]:3.501394306281E0,25[&rate=5.523432500741697E-4]:7.523342907929E1)[&rate=2.059566932950806E-4]:8.907691094599E-1,((((11[&rate=8.278331243940449E-4]:1.92169390943E1,29[&rate=4.6323142845214365E-4]:1.92169390943E1)[&rate=5.644652801811244E-4]:5.075546709951E1,(33[&rate=9.736488793936712E-4]:6.024303474642E1,13[&rate=3.811829285174663E-4]:6.024303474642E1)[&rate=7.250996991978289E-4]:9.729371447386E0)[&rate=3.811829285174663E-4]:1.608166805086E0,(19[&rate=8.048083138496528E-4]:1.341683573405E1,18[&rate=0.0010121564737436764]:1.341683573405E1)[&rate=4.321342435850917E-4]:5.816373726484E1)[&rate=7.831838211330526E-4]:3.415798885978E0,((10[&rate=5.174995152183044E-4]:2.161758393507E1,31[&rate=3.2888601469625254E-4]:2.161758393507E1)[&rate=4.1171759254246624E-4]:5.250951673418E1,23[&rate=4.1171759254246624E-4]:7.412710066925E1)[&rate=3.0661597709936934E-4]:8.692712156194E-1)[&rate=7.627841595976633E-4]:1.127826303879E0)[&rate=0.0016425596747470692]:3.412988799031E0,(17[&rate=9.390866118587179E-4]:6.534577303202E1,(27[&rate=3.502006242356142E-4]:2.728351608548E1,28[&rate=7.250996991978289E-4]:2.728351608548E1)[&rate=5.644652801811244E-4]:3.806225694655E1)[&rate=2.415991429580193E-4]:1.419141395576E1)[&rate=0.001449510077729178]:4.948827587816E1);\ntree STATE_32 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.928835337036,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.928835337036,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.031560140059146E-4]:6.505818671482E0,9[&rate=0.001239038262532476]:6.505818671482E0)[&rate=5.71057443915998E-4]:9.567627223999E0,15[&rate=5.471336653016367E-4]:1.607344589548E1)[&rate=9.703622500924103E-4]:9.315091060872E1,(14[&rate=0.001125356121527823]:4.40210258119E1,24[&rate=4.6833967209726425E-4]:4.40210258119E1)[&rate=0.001039492760536983]:6.520333069231E1)[&rate=0.0014077206095905095]:1.999951241596E1,((((((16[&rate=4.4661195828691783E-4]:3.088097334835E1,((22[&rate=0.0015361896116283494]:2.895448087877E0,21[&rate=4.902908115261922E-4]:2.895448087877E0)[&rate=8.395196772162355E-4]:6.45853800669E0,20[&rate=3.582450154653724E-4]:9.353986094567E0)[&rate=9.703622500924103E-4]:2.152698725379E1)[&rate=9.703622500924103E-4]:3.953625749916E1,(((((4[&rate=3.8101967377796335E-4]:1.932742055134E0,2[&rate=6.218841462865998E-4]:1.932742055134E0)[&rate=5.239662616048965E-4]:8.908584124578E-1,3[&rate=2.262920128218332E-4]:2.823600467591E0)[&rate=7.599117400220138E-4]:9.143526619177E0,5[&rate=3.2192801373764733E-4]:1.196712708677E1)[&rate=2.646713600169429E-4]:3.714100868994E0,((7[&rate=4.357819261570697E-4]:1.026638321297E1,6[&rate=3.4649666471765333E-4]:1.026638321297E1)[&rate=7.977096304954903E-4]:1.303278430244E0,1[&rate=3.921473751746849E-4]:1.156966164322E1)[&rate=3.3442026004278417E-4]:4.111566312545E0)[&rate=6.933169212198266E-4]:5.315201464014E1,((30[&rate=5.959096270843827E-4]:5.22336379023E1,26[&rate=6.218841462865998E-4]:5.22336379023E1)[&rate=7.253152566876658E-4]:1.096041247467E1,32[&rate=3.921473751746849E-4]:6.319405037698E1)[&rate=6.781432051434982E-4]:5.639192218922E0)[&rate=6.634538609921072E-4]:1.583988251614E0)[&rate=0.002194240689533166]:2.5879719786E0,12[&rate=8.622652948599426E-4]:7.300520282612E1)[&rate=8.395196772162355E-4]:6.575384329942E-1,25[&rate=8.864714168659573E-4]:7.366274125911E1)[&rate=6.492060141041475E-4]:1.482345498202E0,(((19[&rate=8.180517493351567E-4]:1.873565426806E1,18[&rate=4.031560140059146E-4]:1.873565426806E1)[&rate=3.8101967377796335E-4]:5.363480540426E1,((11[&rate=4.5745765064940136E-4]:2.109748011497E1,29[&rate=4.140789653008104E-4]:2.109748011497E1)[&rate=6.087433812394271E-4]:4.874910233569E1,(33[&rate=7.599117400220138E-4]:6.091854468882E1,13[&rate=3.582450154653724E-4]:6.091854468882E1)[&rate=4.140789653008104E-4]:8.92803776184E0)[&rate=9.703622500924103E-4]:2.523877221657E0)[&rate=4.792777155672929E-4]:1.405194436919E0,((10[&rate=5.013975984889435E-4]:2.719239025302E1,31[&rate=8.180517493351567E-4]:2.719239025302E1)[&rate=2.262920128218332E-4]:4.562186448071E1,23[&rate=5.589906759436227E-4]:7.281425473373E1)[&rate=7.977096304954903E-4]:9.613993755061E-1)[&rate=6.087433812394271E-4]:1.369432648075E0)[&rate=3.8101967377796335E-4]:6.108445943956E0,(17[&rate=0.0011776341883834752]:6.851241453326E1,(27[&rate=4.4661195828691783E-4]:3.341560483397E1,28[&rate=9.123608653708172E-4]:3.341560483397E1)[&rate=7.783657218332745E-4]:3.509680969929E1)[&rate=5.126165633670391E-4]:1.274111816801E1)[&rate=8.180517493351567E-4]:4.797033621889E1);\ntree STATE_33 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.15583397838,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.15583397838,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.8313811765572885E-4]:8.277732993737E0,9[&rate=7.022186034213433E-4]:8.277732993737E0)[&rate=4.632190846050816E-4]:6.165380664359E0,15[&rate=2.7993266891059666E-4]:1.44431136581E1)[&rate=8.007630689825537E-4]:9.721787666827E1,(14[&rate=0.0015874933155215184]:4.800161853749E1,24[&rate=8.961528153641692E-4]:4.800161853749E1)[&rate=0.0012148068938390194]:6.365937178888E1)[&rate=7.736384740666215E-4]:1.46465652461E1,((((((16[&rate=3.619052861810251E-4]:3.512091812871E1,((22[&rate=0.0011403325167684728]:4.214354375103E0,21[&rate=3.104784903190988E-4]:4.214354375103E0)[&rate=7.245764595646921E-4]:4.846982992789E0,20[&rate=2.901446886738343E-4]:9.061337367891E0)[&rate=8.961528153641692E-4]:2.605958076082E1)[&rate=9.762991838851309E-4]:3.985325563233E1,(((((4[&rate=3.2065235943633816E-4]:1.942604578454E0,2[&rate=2.7993266891059666E-4]:1.942604578454E0)[&rate=3.8313811765572885E-4]:7.687820043067E-1,3[&rate=5.015707665618452E-4]:2.71138658276E0)[&rate=5.582830547028909E-4]:1.194757461403E1,5[&rate=9.39029441073894E-5]:1.465896119679E1)[&rate=8.961528153641692E-4]:2.421228665418E0,((7[&rate=1.9125438991971609E-4]:1.051565087058E1,6[&rate=3.5146861296180107E-4]:1.051565087058E1)[&rate=2.2696360365283112E-4]:9.240164393847E-1,1[&rate=2.7993266891059666E-4]:1.143966730997E1)[&rate=8.299751231452357E-4]:5.640522552243E0)[&rate=7.245764595646921E-4]:5.521064003382E1,((30[&rate=7.022186034213433E-4]:5.013459796504E1,26[&rate=5.89731479018194E-4]:5.013459796504E1)[&rate=3.8313811765572885E-4]:1.204047681947E1,32[&rate=3.003174727468885E-4]:6.217507478451E1)[&rate=5.582830547028909E-4]:1.011575511153E1)[&rate=2.5926063877513173E-4]:2.683343864997E0)[&rate=0.002474226485228632]:7.004106093832E-1,12[&rate=5.737098845902199E-4]:7.567458437042E1)[&rate=4.884431399494666E-4]:2.034503309412E0,25[&rate=8.007630689825537E-4]:7.770908767983E1)[&rate=4.161637173012407E-4]:1.989250333003E0,(((19[&rate=8.961528153641692E-4]:1.61033702242E1,18[&rate=7.736384740666215E-4]:1.61033702242E1)[&rate=2.6965012724017393E-4]:5.909518430665E1,((11[&rate=3.104784903190988E-4]:2.348853455633E1,29[&rate=2.4872077802977116E-4]:2.348853455633E1)[&rate=6.237981510512977E-4]:4.983854383572E1,(33[&rate=7.483196375783033E-4]:6.310234342154E1,13[&rate=3.4112705576945984E-4]:6.310234342154E1)[&rate=5.290132196505338E-4]:1.02247349705E1)[&rate=7.245764595646921E-4]:1.871476138806E0)[&rate=3.003174727468885E-4]:1.094568854001E0,((10[&rate=4.5106759416288164E-4]:2.398080343172E1,31[&rate=5.015707665618452E-4]:2.398080343172E1)[&rate=4.161637173012407E-4]:5.034813652561E1,23[&rate=5.290132196505338E-4]:7.432893995733E1)[&rate=2.5926063877513173E-4]:1.964183427519E0)[&rate=4.5106759416288164E-4]:3.405214627984E0)[&rate=3.104784903190988E-4]:1.684941139151E0,(17[&rate=6.610466561823494E-4]:6.939391899879E1,(27[&rate=1.463547273426599E-4]:3.01977060807E1,28[&rate=6.419833039831087E-4]:3.01977060807E1)[&rate=0.0011403325167684728]:3.919621291809E1)[&rate=2.2696360365283112E-4]:1.19893601532E1)[&rate=0.0015874933155215184]:4.492427642049E1);\ntree STATE_34 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55131.00331870173,EEF_ucld_branchRates=-266.168517335019,lnP=-55131.00331870173,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.542552018188383E-4]:7.278409787561E0,9[&rate=6.564510141123168E-4]:7.278409787561E0)[&rate=5.277660281470275E-4]:6.319540216539E0,15[&rate=7.940309510950135E-4]:1.35979500041E1)[&rate=9.242081858901678E-4]:8.764980100548E1,(14[&rate=7.940309510950135E-4]:4.55657507427E1,24[&rate=0.001014004263361372]:4.55657507427E1)[&rate=0.001629098116962156]:5.568200026689E1)[&rate=0.001137871874497968]:2.464489842708E1,((((((((30[&rate=6.435093226010557E-4]:5.026911800518E1,26[&rate=5.170879886926286E-4]:5.026911800518E1)[&rate=3.6756005998326386E-4]:1.373586706862E1,32[&rate=4.43811476278961E-4]:6.400498507379E1)[&rate=4.6467301534505685E-4]:9.145052445648E0,((((4[&rate=4.227493404543816E-4]:1.906355937245E0,2[&rate=9.515531126474297E-4]:1.906355937245E0)[&rate=9.515531126474297E-4]:5.953817341287E-1,3[&rate=5.064987423281247E-4]:2.501737671374E0)[&rate=6.975460614585562E-4]:1.057478317321E1,5[&rate=3.790568126423792E-4]:1.307652084458E1)[&rate=6.975460614585562E-4]:2.536162627894E0,((7[&rate=6.697473678898233E-4]:9.452777994389E0,6[&rate=9.813163322383094E-4]:9.452777994389E0)[&rate=4.542552018188383E-4]:1.786118343869E0,1[&rate=7.762290428511893E-4]:1.123889633826E1)[&rate=3.4341993728585334E-4]:4.373787134219E0)[&rate=3.790568126423792E-4]:5.753735404696E1)[&rate=7.592146328146416E-4]:1.944266221239E0,(16[&rate=4.120754016238206E-4]:3.840261506186E1,((22[&rate=0.0013417903287754416]:2.595260197706E0,21[&rate=3.902721220681051E-4]:2.595260197706E0)[&rate=4.120754016238206E-4]:9.045093356644E0,20[&rate=1.784003484515904E-4]:1.164035355435E1)[&rate=8.323967550210683E-4]:2.676226150751E1)[&rate=0.0014545161971881073]:3.669168867882E1)[&rate=0.0010911334569830924]:2.681450063639E0,12[&rate=8.753075008086558E-4]:7.777575380432E1)[&rate=6.185671840875535E-4]:1.039461350979E0,25[&rate=6.185671840875535E-4]:7.88152151553E1)[&rate=4.43811476278961E-4]:1.773191416267E0,(((19[&rate=7.940309510950135E-4]:1.536683910295E1,18[&rate=6.834329432048742E-4]:1.536683910295E1)[&rate=4.43811476278961E-4]:6.055722619273E1,((11[&rate=3.0245045082288494E-4]:2.318822072449E1,29[&rate=4.012627500593491E-4]:2.318822072449E1)[&rate=7.272312575634321E-4]:5.160152751478E1,(33[&rate=8.988940286301705E-4]:6.189808015986E1,13[&rate=4.8551612340910413E-4]:6.189808015986E1)[&rate=5.831099664171907E-4]:1.289166807941E1)[&rate=3.0245045082288494E-4]:1.13431705641E0)[&rate=6.065117524093762E-4]:1.22548121081E0,((10[&rate=6.564510141123168E-4]:2.302496817176E1,31[&rate=8.753075008086558E-4]:2.302496817176E1)[&rate=5.494586529473409E-4]:5.141372536616E1,23[&rate=5.717195692932298E-4]:7.443869353792E1)[&rate=5.064987423281247E-4]:2.710852968573E0)[&rate=3.557112163852169E-4]:3.438860065072E0)[&rate=8.532069844328745E-4]:1.598328086157E0,(17[&rate=8.323967550210683E-4]:7.399556651321E1,(27[&rate=4.012627500593491E-4]:2.863542246202E1,28[&rate=8.753075008086558E-4]:2.863542246202E1)[&rate=5.831099664171907E-4]:4.53601440512E1)[&rate=2.479812123353225E-4]:8.191168144505E0)[&rate=0.001137871874497968]:4.370591477895E1);\ntree STATE_35 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55114.1134672862,EEF_ucld_branchRates=-266.168517335019,lnP=-55114.1134672862,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=6.955528338933501E-4]:7.927185116134E0,9[&rate=7.519733328436986E-4]:7.927185116134E0)[&rate=6.461522760207562E-4]:5.324892056458E0,15[&rate=4.534125669968609E-4]:1.325207717259E1)[&rate=7.226997959955858E-4]:9.951922298852E1,(14[&rate=9.296971672565506E-4]:5.276327594094E1,24[&rate=7.519733328436986E-4]:5.276327594094E1)[&rate=0.0011090867489392182]:6.000802422017E1)[&rate=3.2046664357955466E-4]:1.454468352348E1,((((((((30[&rate=6.461522760207562E-4]:4.899683065672E1,26[&rate=4.036179538448876E-4]:4.899683065672E1)[&rate=6.826504227016899E-4]:1.009070883512E1,32[&rate=3.9310734751397334E-4]:5.908753949184E1)[&rate=4.7265679824977033E-4]:7.957897172604E0,((((4[&rate=4.036179538448876E-4]:2.390393682452E0,3[&rate=6.015042745334696E-4]:2.390393682452E0)[&rate=0.0013274019851362178]:4.075436473525E-1,2[&rate=6.461522760207562E-4]:2.797937329804E0)[&rate=5.206549297434891E-4]:1.00177100356E1,5[&rate=2.8803752704152603E-4]:1.281564736541E1)[&rate=7.519733328436986E-4]:2.940241705532E0,((7[&rate=3.2046664357955466E-4]:1.261651929139E1,6[&rate=6.123133630041144E-4]:1.261651929139E1)[&rate=9.296971672565506E-4]:1.190256172828E0,1[&rate=4.918021422456336E-4]:1.380677546421E1)[&rate=7.838894061213176E-4]:1.949113606726E0)[&rate=4.138901660049568E-4]:5.128954759351E1)[&rate=1.9875597128735014E-4]:5.079992062908E0,(16[&rate=4.534125669968609E-4]:3.627673341688E1,((22[&rate=5.804630918510973E-4]:3.27427073656E0,21[&rate=0.0010233649336536229]:3.27427073656E0)[&rate=4.138901660049568E-4]:5.223968849567E0,20[&rate=7.838894061213176E-4]:8.498239586126E0)[&rate=8.805983591297407E-4]:2.777849383075E1)[&rate=0.001233954865262643]:3.584869531047E1)[&rate=8.383266320813607E-4]:1.063858719654E0,12[&rate=7.838894061213176E-4]:7.318928744701E1)[&rate=5.908940682870152E-4]:3.195858048509E0,25[&rate=8.805983591297407E-4]:7.638514549552E1)[&rate=6.701396696330817E-4]:1.413544239252E0,(((19[&rate=4.437005080379725E-4]:1.579228560064E1,18[&rate=6.701396696330817E-4]:1.579228560064E1)[&rate=4.036179538448876E-4]:5.460139143919E1,((11[&rate=4.036179538448876E-4]:2.321872483446E1,29[&rate=5.109968510682673E-4]:2.321872483446E1)[&rate=8.010477820789281E-4]:4.650537560823E1,(33[&rate=8.587430605124715E-4]:5.661503412559E1,13[&rate=4.534125669968609E-4]:5.661503412559E1)[&rate=7.370419587114917E-4]:1.310906631711E1)[&rate=3.823022381792754E-4]:6.695765971339E-1)[&rate=4.036179538448876E-4]:4.233423618679E0,((10[&rate=3.595082820994329E-4]:2.700133680796E1,31[&rate=4.7265679824977033E-4]:2.700133680796E1)[&rate=5.401728151149252E-4]:4.676908081088E1,23[&rate=5.109968510682673E-4]:7.377041761884E1)[&rate=8.383266320813607E-4]:8.566830396693E-1)[&rate=9.041431306711395E-4]:3.171589076258E0)[&rate=4.3389580233781934E-4]:2.586570867305E0,(17[&rate=8.805983591297407E-4]:6.852046175974E1,(27[&rate=6.015042745334696E-4]:2.615098140078E1,28[&rate=0.0013274019851362178]:2.615098140078E1)[&rate=5.908940682870152E-4]:4.236948035895E1)[&rate=4.63057138167151E-4]:1.186479884233E1)[&rate=0.0013274019851362178]:4.693072308252E1);\ntree STATE_36 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55127.820752460815,EEF_ucld_branchRates=-266.168517335019,lnP=-55127.820752460815,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.133019805118262E-4]:8.330568263499E0,9[&rate=8.644694995669905E-4]:8.330568263499E0)[&rate=5.85631982298124E-4]:9.141135615336E0,15[&rate=4.4443856419774686E-4]:1.747170387883E1)[&rate=6.427903054447473E-4]:1.064734688976E2,(14[&rate=0.0015142017808350632]:5.088671067334E1,24[&rate=7.861207884588626E-4]:5.088671067334E1)[&rate=0.0011284587572499578]:7.305846210308E1)[&rate=4.3452614430466275E-4]:2.967235392064E0,((((((((30[&rate=8.040537930525356E-4]:4.839003607981E1,26[&rate=8.229895614847981E-4]:4.839003607981E1)[&rate=5.85631982298124E-4]:7.213727132008E0,32[&rate=4.739041428161422E-4]:5.560376321182E1)[&rate=3.8304010323080386E-4]:1.329241269785E1,((((4[&rate=6.940631534735494E-4]:2.307807245067E0,3[&rate=3.8304010323080386E-4]:2.307807245067E0)[&rate=9.121300656556434E-4]:3.833919919439E-1,2[&rate=3.8304010323080386E-4]:2.691199237011E0)[&rate=4.935270204716802E-4]:9.503723374764E0,5[&rate=2.9428377418232415E-4]:1.219492261177E1)[&rate=4.3452614430466275E-4]:2.106487155056E0,((7[&rate=1.8823485292091878E-4]:8.949334208196E0,6[&rate=6.427903054447473E-4]:8.949334208196E0)[&rate=6.806566266513908E-4]:1.376920905395E0,1[&rate=3.8304010323080386E-4]:1.032625511359E1)[&rate=7.528076368979361E-4]:3.97515465324E0)[&rate=4.935270204716802E-4]:5.459476614284E1)[&rate=3.8304010323080386E-4]:2.316237304932E0,(16[&rate=2.3073701202225346E-4]:3.751558098296E1,((22[&rate=0.0012611068666530745]:2.289352420862E0,21[&rate=4.04158150962714E-4]:2.289352420862E0)[&rate=6.940631534735494E-4]:5.998618876754E0,20[&rate=0.001037752225658682]:8.287971297616E0)[&rate=0.0013607468032528155]:2.922760968534E1)[&rate=7.690720105326406E-4]:3.369683223164E1)[&rate=0.001037752225658682]:2.445053427119E0,12[&rate=7.690720105326406E-4]:7.365746664172E1)[&rate=3.2362058312438845E-4]:2.373653847257E0,25[&rate=6.550564783787897E-4]:7.603112048898E1)[&rate=3.937145768377775E-4]:1.176364104165E0,(((19[&rate=9.121300656556434E-4]:1.442201540411E1,18[&rate=8.430704368143749E-4]:1.442201540411E1)[&rate=4.542908722769456E-4]:5.601778247193E1,((11[&rate=3.937145768377775E-4]:1.697187672363E1,29[&rate=7.223044532959644E-4]:1.697187672363E1)[&rate=8.040537930525356E-4]:5.13606029285E1,(33[&rate=8.229895614847981E-4]:6.146774683055E1,13[&rate=3.937145768377775E-4]:6.146774683055E1)[&rate=6.077624366440952E-4]:6.864732821583E0)[&rate=5.965903589104183E-4]:2.10731822391E0)[&rate=4.542908722769456E-4]:2.629333116707E0,((10[&rate=5.965903589104183E-4]:1.965184086013E1,31[&rate=5.333622459140468E-4]:1.965184086013E1)[&rate=5.85631982298124E-4]:5.140939749139E1,23[&rate=4.04158150962714E-4]:7.106123835152E1)[&rate=3.366722671077844E-4]:2.007892641221E0)[&rate=4.8370516464959145E-4]:4.138353600397E0)[&rate=9.684581094866725E-4]:2.085047884287E0,(17[&rate=6.940631534735494E-4]:6.902731765721E1,(27[&rate=6.550564783787897E-4]:2.974849191564E1,28[&rate=9.121300656556434E-4]:2.974849191564E1)[&rate=4.542908722769456E-4]:3.927882574157E1)[&rate=8.229895614847981E-4]:1.026521482022E1)[&rate=0.0015142017808350632]:4.761987569105E1);\ntree STATE_37 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55100.41569701832,EEF_ucld_branchRates=-266.168517335019,lnP=-55100.41569701832,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.008944245009175E-4]:9.011731128748E0,9[&rate=4.7760444139708475E-4]:9.011731128748E0)[&rate=6.318912100450975E-4]:6.852797305253E0,15[&rate=7.883889047153635E-4]:1.5864528434E1)[&rate=6.772497006034407E-4]:9.544607650725E1,(14[&rate=0.0014042872210225286]:4.396093360909E1,24[&rate=0.0014042872210225286]:4.396093360909E1)[&rate=0.0010739687739907719]:6.734967133216E1)[&rate=8.625945688028441E-4]:1.66136261398E1,(((25[&rate=7.57045259065675E-4]:7.447597201015E1,(((16[&rate=2.0971469470177067E-4]:4.162210325784E1,((22[&rate=0.0012738900649748306]:3.291519265502E0,21[&rate=4.210045171071777E-4]:3.291519265502E0)[&rate=4.210045171071777E-4]:4.604277439306E0,20[&rate=5.516287929507339E-4]:7.895796704808E0)[&rate=8.625945688028441E-4]:3.372630655303E1)[&rate=0.0010739687739907719]:2.865880217384E1,(((30[&rate=7.883889047153635E-4]:4.792330372812E1,26[&rate=4.959658652683034E-4]:4.792330372812E1)[&rate=7.019559486150385E-4]:9.591020277174E0,32[&rate=4.591107021816338E-4]:5.751432400529E1)[&rate=6.772497006034407E-4]:6.117551594769E0,((((4[&rate=5.805525893150549E-4]:2.684446854834E0,3[&rate=7.57045259065675E-4]:2.684446854834E0)[&rate=2.525037919262159E-4]:1.689639671668E-1,2[&rate=3.5638774068260217E-4]:2.853410822001E0)[&rate=4.497626059181228E-4]:8.264242173314E0,5[&rate=3.1522660642978805E-4]:1.111765299531E1)[&rate=5.143388293491342E-4]:1.936719305147E0,((7[&rate=4.210045171071777E-4]:8.678776171308E0,6[&rate=9.628498444156778E-4]:8.678776171308E0)[&rate=3.904182455614432E-4]:1.170353338113E0,1[&rate=5.707892721320559E-4]:9.849129509421E0)[&rate=3.5638774068260217E-4]:3.205242791041E0)[&rate=5.904598204204804E-4]:5.05775032996E1)[&rate=7.019559486150385E-4]:6.649029831615E0)[&rate=5.707892721320559E-4]:2.589164298629E0,12[&rate=8.053050146780069E-4]:7.28700697303E1)[&rate=4.867922470162448E-4]:1.605902279844E0)[&rate=4.110712739054605E-4]:1.935402527626E0,(((19[&rate=8.232067410795184E-4]:2.11488487283E1,18[&rate=6.894051703435004E-4]:2.11488487283E1)[&rate=4.008944245009175E-4]:5.102939776355E1,((11[&rate=4.008944245009175E-4]:1.692208855192E1,29[&rate=6.539795303115497E-4]:1.692208855192E1)[&rate=8.053050146780069E-4]:5.363350944705E1,(33[&rate=5.904598204204804E-4]:5.67704460411E1,13[&rate=4.6838394932865616E-4]:5.67704460411E1)[&rate=6.428015592967512E-4]:1.378515195787E1)[&rate=9.082256075194421E-4]:1.622648492882E0)[&rate=4.497626059181228E-4]:8.371776944209E-1,((10[&rate=7.57045259065675E-4]:2.837571125358E1,31[&rate=4.3073972863332606E-4]:2.837571125358E1)[&rate=4.7760444139708475E-4]:4.341812300126E1,23[&rate=8.232067410795184E-4]:7.179383425484E1)[&rate=5.707892721320559E-4]:1.221589931438E0)[&rate=7.149440578332835E-4]:3.3959503515E0)[&rate=5.235703285594263E-4]:3.71679141492E0,(17[&rate=8.625945688028441E-4]:7.287253464141E1,(27[&rate=4.008944245009175E-4]:2.942346574355E1,28[&rate=0.0012738900649748306]:2.942346574355E1)[&rate=7.883889047153635E-4]:4.344906889786E1)[&rate=4.867922470162448E-4]:7.255631311283E0)[&rate=0.0010739687739907719]:4.779606512836E1);\ntree STATE_38 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55142.34858739371,EEF_ucld_branchRates=-266.168517335019,lnP=-55142.34858739371,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.7593390412241615E-4]:1.128453767221E1,9[&rate=5.120167544203494E-4]:1.128453767221E1)[&rate=2.4612679596302926E-4]:7.045435707993E0,15[&rate=4.7593390412241615E-4]:1.83299733802E1)[&rate=0.0010131341646191455]:9.631206797761E1,(14[&rate=0.0015436403272377297]:4.331503428449E1,24[&rate=9.679326360199737E-4]:4.331503428449E1)[&rate=6.81885692316831E-4]:7.132700707332E1)[&rate=0.0010648792922968117]:1.070241036158E1,(((25[&rate=9.679326360199737E-4]:7.144568539248E1,(12[&rate=9.472439748438469E-4]:7.144446814974E1,((16[&rate=7.058084871821155E-4]:3.534647745666E1,((22[&rate=5.463583225712241E-4]:3.439102314845E0,21[&rate=4.36544626390831E-4]:3.439102314845E0)[&rate=6.701720005658637E-4]:4.208504858606E0,20[&rate=4.501853467915935E-4]:7.647607173451E0)[&rate=0.0015436403272377297]:2.769887028321E1)[&rate=8.910756944762019E-4]:3.282809417544E1,(((30[&rate=9.276186306027548E-4]:4.774944856688E1,26[&rate=4.88232496343585E-4]:4.774944856688E1)[&rate=0.0014384415830891151]:9.175275932769E0,32[&rate=3.726398863819391E-4]:5.692472449965E1)[&rate=5.236027179390186E-4]:7.912332098384E0,((((4[&rate=8.263487552781389E-4]:2.004785910254E0,3[&rate=4.7593390412241615E-4]:2.004785910254E0)[&rate=7.69532735662572E-4]:6.185013296545E-1,2[&rate=6.585972701545557E-4]:2.623287239909E0)[&rate=7.305318540798441E-4]:8.404952747051E0,5[&rate=3.2832269930965953E-4]:1.102823998696E1)[&rate=7.83153712212516E-4]:3.396271188542E0,((7[&rate=6.81885692316831E-4]:7.51175898561E0,6[&rate=8.263487552781389E-4]:7.51175898561E0)[&rate=6.93757782321898E-4]:2.098851533011E0,1[&rate=5.799016798643577E-4]:9.610610518621E0)[&rate=4.88232496343585E-4]:4.813900656881E0)[&rate=5.236027179390186E-4]:5.041254542253E1)[&rate=5.120167544203494E-4]:3.337515034073E0)[&rate=6.245198790139762E-4]:3.26989651764E0)[&rate=9.472439748438469E-4]:1.217242741248E-3)[&rate=0.0010131341646191455]:3.24372793639E0,(((19[&rate=0.0012003649119132476]:1.526468694514E1,18[&rate=0.0010380549488153631]:1.526468694514E1)[&rate=4.36544626390831E-4]:5.402445735164E1,((11[&rate=5.910254498651832E-4]:1.558965627505E1,29[&rate=0.0012974541230855654]:1.558965627505E1)[&rate=4.501853467915935E-4]:5.172020186376E1,(33[&rate=8.263487552781389E-4]:6.126005235008E1,13[&rate=6.133150873221203E-4]:6.126005235008E1)[&rate=6.93757782321898E-4]:6.049805788738E0)[&rate=8.575132578767027E-4]:1.979286157971E0)[&rate=0.002059150678896681]:2.051719868671E0,((10[&rate=5.002418995439331E-4]:2.530851066076E1,31[&rate=5.687644294908693E-4]:2.530851066076E1)[&rate=5.350386726772109E-4]:4.599013925146E1,23[&rate=6.357896128556575E-4]:7.129864991222E1)[&rate=0.0010939666376536962]:4.221425323881E-2)[&rate=8.739622191135632E-4]:3.348549163419E0)[&rate=8.115228610530668E-4]:5.183310901283E0,(17[&rate=9.679326360199737E-4]:7.294992952097E1,(27[&rate=8.739622191135632E-4]:2.715851181257E1,28[&rate=0.0011609629998015295]:2.715851181257E1)[&rate=5.687644294908693E-4]:4.57914177084E1)[&rate=9.089311325336518E-4]:6.922794709184E0)[&rate=0.001360058806164613]:4.547172748924E1);\ntree STATE_39 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55132.34321308806,EEF_ucld_branchRates=-266.168517335019,lnP=-55132.34321308806,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.792016848731595E-4]:9.842673647933E0,9[&rate=0.0011257919442460489]:9.842673647933E0)[&rate=7.227575423510512E-4]:6.991694760296E0,15[&rate=7.542176237838972E-4]:1.683436840823E1)[&rate=8.261531106116021E-4]:1.026377856543E2,(14[&rate=0.0010399834146125]:4.910876519242E1,24[&rate=8.914622767746791E-4]:4.910876519242E1)[&rate=5.808115754240077E-4]:7.036338887014E1)[&rate=3.5607473277891844E-4]:1.031908915267E1,(((25[&rate=5.808115754240077E-4]:7.292554220203E1,((12[&rate=9.163111749771631E-4]:6.85830449535E1,((16[&rate=4.1188677271363785E-4]:3.28079798237E1,((22[&rate=7.542176237838972E-4]:2.568414592238E0,21[&rate=6.935455940794962E-4]:2.568414592238E0)[&rate=2.698482976811609E-4]:7.551684453772E0,20[&rate=7.542176237838972E-4]:1.012009904601E1)[&rate=0.0013253464711003042]:2.268788077769E1)[&rate=0.0013253464711003042]:3.394036950344E1,((30[&rate=7.884491624313214E-4]:4.927026460483E1,26[&rate=6.935455940794962E-4]:4.927026460483E1)[&rate=8.465969755576206E-4]:8.487558449255E0,32[&rate=3.9030680715321887E-4]:5.775782305409E1)[&rate=3.9030680715321887E-4]:8.99052627305E0)[&rate=4.3290097739798845E-4]:1.834695626364E0)[&rate=2.4913693642455694E-4]:1.856365554425E0,((((4[&rate=5.476201828961527E-4]:1.55550251138E0,2[&rate=4.948305179919384E-4]:1.55550251138E0)[&rate=0.001988820846835081]:8.775165247689E-1,3[&rate=3.9030680715321887E-4]:2.433019036149E0)[&rate=8.465969755576206E-4]:8.784164979891E0,5[&rate=6.038820978058286E-4]:1.121718401604E1)[&rate=6.279066583106705E-4]:2.54074296033E0,((7[&rate=4.224471612700787E-4]:9.655401407029E0,6[&rate=8.914622767746791E-4]:9.655401407029E0)[&rate=4.741900451355997E-4]:1.142001750097E0,1[&rate=3.4389249293692765E-4]:1.079740315713E1)[&rate=0.0011257919442460489]:2.960523819243E0)[&rate=5.585215794302609E-4]:5.668148353156E1)[&rate=8.068141122266289E-4]:2.486131694108E0)[&rate=4.3290097739798845E-4]:1.774379835314E0,(((19[&rate=4.741900451355997E-4]:1.328936133427E1,18[&rate=6.935455940794962E-4]:1.328936133427E1)[&rate=4.011863411182195E-4]:5.686197575716E1,((33[&rate=8.465969755576206E-4]:6.26502613837E1,13[&rate=4.011863411182195E-4]:6.26502613837E1)[&rate=2.226919614766592E-4]:5.943014079757E0,(11[&rate=5.262132704505441E-4]:1.818633926603E1,29[&rate=5.808115754240077E-4]:1.818633926603E1)[&rate=7.542176237838972E-4]:5.040693619742E1)[&rate=5.156726423139198E-4]:1.558061627975E0)[&rate=4.3290097739798845E-4]:1.514833264136E0,((10[&rate=7.078980583701457E-4]:3.040856492385E1,31[&rate=3.67814452645611E-4]:3.040856492385E1)[&rate=3.5607473277891844E-4]:4.004894035785E1,23[&rate=4.5360247192260006E-4]:7.04575052817E1)[&rate=8.914622767746791E-4]:1.208665073862E0)[&rate=3.4389249293692765E-4]:3.033751681784E0)[&rate=4.844940753298634E-4]:2.396330550121E0,(17[&rate=0.0010800051900569539]:7.112218455816E1,(27[&rate=5.695790677333439E-4]:2.852649273496E1,28[&rate=0.0010044028855206808]:2.852649273496E1)[&rate=6.661787418863078E-4]:4.259569182319E1)[&rate=8.683029239028272E-4]:5.974068029314E0)[&rate=0.0014355257562238314]:5.269499062775E1);\ntree STATE_40 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55144.55479300203,EEF_ucld_branchRates=-266.168517335019,lnP=-55144.55479300203,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.039432217924652E-4]:9.396491810929E0,9[&rate=6.087474740306766E-4]:9.396491810929E0)[&rate=2.952048641482632E-4]:1.017067187296E1,15[&rate=4.8024592124351026E-4]:1.956716368389E1)[&rate=8.810150087191867E-4]:9.287141939955E1,(14[&rate=0.0010140022869874429]:4.81949816113E1,24[&rate=0.0011381071411997016]:4.81949816113E1)[&rate=6.955218332899894E-4]:6.424360147214E1)[&rate=0.0012709979502969477]:1.360932213935E1,((((12[&rate=8.447408867687516E-4]:6.858684258418E1,((((((4[&rate=4.558702147762144E-4]:1.752816977588E0,2[&rate=9.645652670283671E-4]:1.752816977588E0)[&rate=0.0010413486866019549]:4.048374619927E-1,3[&rate=4.1711349681696055E-4]:2.15765443958E0)[&rate=6.697862050415918E-4]:1.226347080273E1,5[&rate=4.8024592124351026E-4]:1.442112524232E1)[&rate=0.0016081030737343806]:1.238258794156E0,((7[&rate=4.3041782997860445E-4]:8.611959542189E0,6[&rate=5.735720407549848E-4]:8.611959542189E0)[&rate=6.327026470944442E-4]:7.879668214448E-1,1[&rate=6.697862050415918E-4]:9.399926363634E0)[&rate=7.952546310964095E-4]:6.259457672837E0)[&rate=5.039432217924652E-4]:5.004670354465E1,((30[&rate=6.572443298341171E-4]:4.675128054603E1,26[&rate=8.111790612640112E-4]:4.675128054603E1)[&rate=9.206583783890526E-4]:9.876370676556E0,32[&rate=4.032927826023763E-4]:5.662765122258E1)[&rate=4.681644760669467E-4]:9.078436358535E0)[&rate=0.0010140022869874429]:2.115217798816E0,(16[&rate=5.15630836107543E-4]:3.287667069061E1,((22[&rate=0.0012209296385452346]:1.779964283452E0,21[&rate=4.1711349681696055E-4]:1.779964283452E0)[&rate=4.1711349681696055E-4]:6.943626078218E0,20[&rate=0.0010140022869874429]:8.72359036167E0)[&rate=0.002204751392490196]:2.415308032894E1)[&rate=8.625022924798325E-4]:3.494463468932E1)[&rate=0.0016081030737343806]:7.655372042489E-1)[&rate=3.88818351550382E-4]:2.183389596041E0,25[&rate=7.648609189438319E-4]:7.077023218022E1)[&rate=4.558702147762144E-4]:2.37656867325E0,(((19[&rate=6.448901290833521E-4]:1.438844569382E1,18[&rate=8.625022924798325E-4]:1.438844569382E1)[&rate=4.032927826023763E-4]:5.599522601485E1,((11[&rate=2.952048641482632E-4]:2.083834196275E1,29[&rate=6.327026470944442E-4]:2.083834196275E1)[&rate=9.645652670283671E-4]:4.788044665436E1,(33[&rate=0.0011381071411997016]:5.941007681432E1,13[&rate=5.61970962757621E-4]:5.941007681432E1)[&rate=8.111790612640112E-4]:9.308711802779E0)[&rate=9.645652670283671E-4]:1.664883091574E0)[&rate=9.206583783890526E-4]:1.376996615387E0,((10[&rate=4.921593858346972E-4]:2.500014685199E1,31[&rate=8.447408867687516E-4]:2.500014685199E1)[&rate=5.503983624823375E-4]:4.53196110857E1,23[&rate=6.572443298341171E-4]:7.031975793769E1)[&rate=3.1892843975205303E-4]:1.440910386371E0)[&rate=7.222882387406479E-4]:1.38613252941E0)[&rate=4.4330969163319534E-4]:4.891556480619E0,(17[&rate=7.952546310964095E-4]:6.836064350579E1,(27[&rate=5.503983624823375E-4]:3.296519522956E1,28[&rate=0.0011029279373527803]:3.296519522956E1)[&rate=8.625022924798325E-4]:3.539544827623E1)[&rate=0.0010140022869874429]:9.677713828305E0)[&rate=0.00148848390500147]:4.800954788869E1);\ntree STATE_41 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55140.96694267298,EEF_ucld_branchRates=-266.168517335019,lnP=-55140.96694267298,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.988674925122007E-4]:1.043689047176E1,9[&rate=5.058889965524765E-4]:1.043689047176E1)[&rate=2.4941543506937745E-4]:4.83045015668E0,15[&rate=9.132082699401146E-4]:1.526734062844E1)[&rate=8.318168442553656E-4]:1.035526475369E2,(14[&rate=0.00142615782472543]:4.553408589455E1,24[&rate=8.504582666961033E-4]:4.553408589455E1)[&rate=7.971679162523477E-4]:7.328590227078E1)[&rate=0.0010210387738082613]:6.397996069538E0,((((12[&rate=9.905145293690654E-4]:7.533219818484E1,(((((4[&rate=5.264642961069288E-4]:1.912853849069E0,2[&rate=0.0013234790459352378]:1.912853849069E0)[&rate=9.132082699401146E-4]:7.435696501323E-1,3[&rate=7.654182332212986E-4]:2.656423499202E0)[&rate=7.654182332212986E-4]:1.248357860229E1,5[&rate=3.869432354197096E-4]:1.51400021015E1)[&rate=4.853089407304815E-4]:1.415151625279E0,((7[&rate=4.5404954817196766E-4]:9.559288008933E0,6[&rate=8.909914235419271E-4]:9.559288008933E0)[&rate=2.985193062479921E-4]:1.256668673813E0,1[&rate=5.896166536640857E-4]:1.081595668275E1)[&rate=3.1676210513098107E-4]:5.739197044028E0)[&rate=6.343082915030767E-4]:5.518334425888E1,(((30[&rate=6.825422987726087E-4]:5.842448684577E1,26[&rate=6.1160601754234E-4]:5.842448684577E1)[&rate=7.654182332212986E-4]:6.164940330566E0,32[&rate=3.869432354197096E-4]:6.458942717634E1)[&rate=5.16167540148099E-4]:6.660923322771E0,(16[&rate=3.988674925122007E-4]:3.242386911328E1,((22[&rate=8.701342138032625E-4]:3.284312348937E0,21[&rate=4.1041034163159513E-4]:3.284312348937E0)[&rate=5.896166536640857E-4]:7.975588048879E0,20[&rate=7.504479402456898E-4]:1.125990039782E1)[&rate=0.0019348362196393116]:2.116396871546E1)[&rate=8.701342138032625E-4]:3.882648138583E1)[&rate=7.360020646330965E-4]:4.881474865434E-1)[&rate=6.700693478909562E-4]:3.593700199181E0)[&rate=7.360020646330965E-4]:1.614503148307E-1,25[&rate=5.896166536640857E-4]:7.549364849967E1)[&rate=3.7454271853246715E-4]:1.642580146972E0,(((19[&rate=8.701342138032625E-4]:1.545733146932E1,18[&rate=6.005319252345768E-4]:1.545733146932E1)[&rate=3.7454271853246715E-4]:5.642752373783E1,((11[&rate=6.005319252345768E-4]:2.22382604358E1,29[&rate=4.1041034163159513E-4]:2.22382604358E1)[&rate=7.504479402456898E-4]:4.82625558205E1,(33[&rate=0.001054843752334472]:5.952525684885E1,13[&rate=4.1041034163159513E-4]:5.952525684885E1)[&rate=4.5404954817196766E-4]:1.097555940745E1)[&rate=4.7496519138178443E-4]:1.384038950855E0)[&rate=9.905145293690654E-4]:1.421697975266E0,((10[&rate=7.220305670650937E-4]:2.063529370569E1,31[&rate=4.434207066278796E-4]:2.063529370569E1)[&rate=2.985193062479921E-4]:5.246589938567E1,23[&rate=4.6455430218954904E-4]:7.310119309136E1)[&rate=5.058889965524765E-4]:2.0536009106E-1)[&rate=7.654182332212986E-4]:3.829675464218E0)[&rate=6.228580832360526E-4]:1.185608470405E0,(17[&rate=0.0011360694639734488]:7.058571658017E1,(27[&rate=4.3263301442972047E-4]:2.712045854725E1,28[&rate=9.370046689971604E-4]:2.712045854725E1)[&rate=8.504582666961033E-4]:4.346525803292E1)[&rate=5.681897643302158E-4]:7.736120536869E0)[&rate=0.0015840400836317327]:4.689614711783E1);\ntree STATE_42 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55145.30263896374,EEF_ucld_branchRates=-266.168517335019,lnP=-55145.30263896374,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=2.920800003552209E-4]:7.703462259216E0,9[&rate=8.644366508332302E-4]:7.703462259216E0)[&rate=3.7985457365216814E-4]:8.429615571707E0,15[&rate=4.864814306679694E-4]:1.613307783092E1)[&rate=7.963041900247137E-4]:9.077159797243E1,(14[&rate=0.0011757946616699243]:4.802761296986E1,24[&rate=0.0010269986196701079]:4.802761296986E1)[&rate=9.984883635338491E-4]:5.887706283349E1)[&rate=0.0010927933973366329]:2.168697434658E1,((((12[&rate=9.478564534657445E-4]:6.721066318336E1,((16[&rate=4.864814306679694E-4]:3.362958819224E1,((22[&rate=4.972388885615076E-4]:3.10837600682E0,21[&rate=5.50408045094477E-4]:3.10837600682E0)[&rate=7.963041900247137E-4]:5.114945419446E0,20[&rate=7.809324796812648E-4]:8.223321426266E0)[&rate=0.0014716225656306364]:2.540626676597E1)[&rate=8.835517501705293E-4]:3.168671327312E1,(((30[&rate=7.963041900247137E-4]:4.688796133238E1,26[&rate=6.267592754034485E-4]:4.688796133238E1)[&rate=9.250960133045228E-4]:7.761299029876E0,32[&rate=4.1853174021812967E-4]:5.464926036226E1)[&rate=4.1853174021812967E-4]:8.3706184527E0,((((4[&rate=9.250960133045228E-4]:1.932020677131E0,2[&rate=2.1615533129271222E-4]:1.932020677131E0)[&rate=7.809324796812648E-4]:5.629215565846E-1,3[&rate=6.381637697375828E-4]:2.494942233716E0)[&rate=8.288922392354498E-4]:1.16518003219E1,5[&rate=4.061815748098438E-4]:1.414674255561E1)[&rate=8.644366508332302E-4]:2.32607714826E0,((7[&rate=4.3048225216254707E-4]:1.015774448793E1,6[&rate=9.478564534657445E-4]:1.015774448793E1)[&rate=6.381637697375828E-4]:8.519460318665E-1,1[&rate=5.50408045094477E-4]:1.10096905198E1)[&rate=3.1443142076645054E-4]:5.463129184076E0)[&rate=5.93436149303632E-4]:4.654705911108E1)[&rate=6.15515635831176E-4]:2.296422650394E0)[&rate=6.15515635831176E-4]:1.89436171801E0)[&rate=7.809324796812648E-4]:2.372639640471E0,25[&rate=7.963041900247137E-4]:6.958330282383E1)[&rate=4.061815748098438E-4]:4.06220826455E0,((((11[&rate=4.534774415688267E-4]:1.876467808031E1,29[&rate=5.185613993546539E-4]:1.876467808031E1)[&rate=6.267592754034485E-4]:4.869020828309E1,(33[&rate=9.478564534657445E-4]:5.500339939219E1,13[&rate=6.615349504165037E-4]:5.500339939219E1)[&rate=3.1443142076645054E-4]:1.245148697121E1)[&rate=0.0016322844698275763]:1.336654750797E0,(19[&rate=9.037216918371041E-4]:1.715194295217E1,18[&rate=6.381637697375828E-4]:1.715194295217E1)[&rate=4.3048225216254707E-4]:5.163959816202E1)[&rate=5.397830689284798E-4]:2.39971468124E0,((10[&rate=7.111541339738366E-4]:2.184027018874E1,31[&rate=4.534774415688267E-4]:2.184027018874E1)[&rate=4.1853174021812967E-4]:4.842136607569E1,23[&rate=4.1853174021812967E-4]:7.026163626443E1)[&rate=0.001058225055366865]:9.296195309961E-1)[&rate=7.111541339738366E-4]:2.454255292954E0)[&rate=7.809324796812648E-4]:4.008358278038E0,(17[&rate=7.517419611962864E-4]:6.740256680429E1,(27[&rate=5.291741074700119E-4]:2.661667141988E1,28[&rate=0.0014716225656306364]:2.661667141988E1)[&rate=4.864814306679694E-4]:4.078589538441E1)[&rate=0.0014716225656306364]:1.025130256213E1)[&rate=9.478564534657445E-4]:5.093778078351E1);\ntree STATE_43 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55138.548908553275,EEF_ucld_branchRates=-266.168517335019,lnP=-55138.548908553275,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.1419014849046835E-4]:1.039759783966E1,9[&rate=6.759619958816485E-4]:1.039759783966E1)[&rate=4.1581162496061406E-4]:8.179943095316E0,15[&rate=7.860691520011469E-4]:1.857754093497E1)[&rate=8.367428394828276E-4]:9.312108690729E1,(14[&rate=0.0011073784503783308]:4.283943082598E1,24[&rate=0.0011073784503783308]:4.283943082598E1)[&rate=8.56496658847231E-4]:6.885919701629E1)[&rate=0.0014000459437884432]:1.710994810625E1,((((12[&rate=7.713252958882316E-4]:7.380014879164E1,((16[&rate=5.939985148704459E-4]:4.05076197524E1,((22[&rate=6.970000490024071E-4]:4.096207031646E0,21[&rate=6.863049142318677E-4]:4.096207031646E0)[&rate=4.913621150256415E-4]:6.751091746551E0,20[&rate=7.080875572618298E-4]:1.08472987782E1)[&rate=6.759619958816485E-4]:2.966032097421E1)[&rate=0.0012004708896018903]:3.097245531099E1,(((((4[&rate=6.759619958816485E-4]:2.665395458276E0,3[&rate=4.339493665390688E-4]:2.665395458276E0)[&rate=4.42616783617283E-4]:4.322731695401E-1,2[&rate=6.467140853789835E-4]:3.097668627816E0)[&rate=5.302187050194217E-4]:1.11257888257E1,5[&rate=2.4851141585971177E-4]:1.422345745351E1)[&rate=7.196136009553508E-4]:1.404664474952E0,((7[&rate=7.080875572618298E-4]:1.088536563893E1,6[&rate=6.284275279269907E-4]:1.088536563893E1)[&rate=5.775858132059484E-4]:8.084332546282E-1,1[&rate=4.675158235592779E-4]:1.169379889356E1)[&rate=5.695288101655564E-4]:3.934323034905E0)[&rate=5.695288101655564E-4]:5.243492412393E1,((30[&rate=7.860691520011469E-4]:5.233483004036E1,26[&rate=4.991784437569117E-4]:5.233483004036E1)[&rate=6.467140853789835E-4]:8.373472929551E0,32[&rate=4.339493665390688E-4]:6.070830296991E1)[&rate=4.062215493377317E-4]:7.35474308248E0)[&rate=4.675158235592779E-4]:3.417029011006E0)[&rate=7.713252958882316E-4]:2.320073728243E0)[&rate=5.147144393905096E-4]:1.733687291754E0,25[&rate=8.782149957264873E-4]:7.553383608339E1)[&rate=3.1419014849046835E-4]:1.233248395423E0,((((33[&rate=7.860691520011469E-4]:5.69995734868E1,13[&rate=4.675158235592779E-4]:5.69995734868E1)[&rate=4.062215493377317E-4]:1.312753858307E1,(11[&rate=4.1581162496061406E-4]:1.32272923462E1,29[&rate=6.659360729879755E-4]:1.32272923462E1)[&rate=6.023821773396867E-4]:5.689981972367E1)[&rate=5.775858132059484E-4]:2.197517846045E0,(19[&rate=4.339493665390688E-4]:1.978938956257E1,18[&rate=5.857378277038243E-4]:1.978938956257E1)[&rate=3.4829290701487536E-4]:5.253524035335E1)[&rate=7.442045428766068E-4]:2.718969063263E0,((10[&rate=4.834919730499928E-4]:2.351242001546E1,31[&rate=2.898257698484427E-4]:2.351242001546E1)[&rate=4.1581162496061406E-4]:5.060892926078E1,23[&rate=4.062215493377317E-4]:7.412134927624E1)[&rate=5.147144393905096E-4]:9.222497029401E-1)[&rate=4.991784437569117E-4]:1.723485499639E0)[&rate=5.615536705447738E-4]:3.547262302409E0,(17[&rate=7.316317098152575E-4]:7.021975670511E1,(27[&rate=6.659360729879755E-4]:3.037929369254E1,28[&rate=9.023966270115289E-4]:3.037929369254E1)[&rate=7.080875572618298E-4]:3.984046301257E1)[&rate=7.860691520011469E-4]:1.009459007612E1)[&rate=8.367428394828276E-4]:4.849422916729E1);\ntree STATE_44 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55161.72593721111,EEF_ucld_branchRates=-266.168517335019,lnP=-55161.72593721111,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=3.075498942296498E-4]:9.499997955933E0,9[&rate=4.777560469269576E-4]:9.499997955933E0)[&rate=5.314940929565066E-4]:1.034031043582E1,15[&rate=5.492657550090859E-4]:1.984030839175E1)[&rate=7.070917474507502E-4]:9.06702569276E1,(14[&rate=0.0012423700575887862]:4.646972515889E1,24[&rate=7.997612636474515E-4]:4.646972515889E1)[&rate=0.0012423700575887862]:6.404084016046E1)[&rate=7.437375394134466E-4]:1.74070402285E1,((((((11[&rate=8.88821328046344E-4]:1.57574856806E1,29[&rate=9.608465576299054E-4]:1.57574856806E1)[&rate=7.070917474507502E-4]:5.783233421912E1,(33[&rate=9.106902406142049E-4]:5.756480516057E1,13[&rate=4.08851024340255E-4]:5.756480516057E1)[&rate=3.075498942296498E-4]:1.602501473914E1)[&rate=7.705263813180125E-4]:6.114017274561E-1,(19[&rate=5.048363747619781E-4]:1.332777837342E1,18[&rate=7.568606362520217E-4]:1.332777837342E1)[&rate=4.1956173764178906E-4]:6.087344325376E1)[&rate=4.1956173764178906E-4]:1.860083352401E0,((10[&rate=6.327021259429665E-4]:2.828940835231E1,31[&rate=7.568606362520217E-4]:2.828940835231E1)[&rate=4.685359164666626E-4]:4.602310366972E1,23[&rate=4.958828004719774E-4]:7.431251202203E1)[&rate=4.496395224965875E-4]:1.748792957545E0)[&rate=6.7366725652099E-4]:1.129565972212E0,((12[&rate=7.848007931243338E-4]:7.324052145657E1,((16[&rate=5.403694516066005E-4]:4.225543650921E1,((22[&rate=6.845077969393678E-4]:4.55103022196E0,21[&rate=3.4475669517703447E-4]:4.55103022196E0)[&rate=7.188993911109792E-4]:4.452458936007E0,20[&rate=8.88821328046344E-4]:9.003489157967E0)[&rate=7.070917474507502E-4]:3.325194735125E1)[&rate=9.902111403179484E-4]:2.899689458244E1,(((((4[&rate=6.03903107226097E-4]:2.658467615532E0,3[&rate=4.591746835097254E-4]:2.658467615532E0)[&rate=7.568606362520217E-4]:4.312814910474E-1,2[&rate=4.2988480108298234E-4]:3.08974910658E0)[&rate=4.958828004719774E-4]:1.021984137943E1,5[&rate=3.277660969959996E-4]:1.330959048601E1)[&rate=8.321251008112734E-4]:2.200936733566E0,(1[&rate=4.3989172715697524E-4]:1.112175108672E1,(6[&rate=5.945740391571921E-4]:1.050311365094E1,7[&rate=4.2988480108298234E-4]:1.050311365094E1)[&rate=3.9766055960902637E-4]:6.186374357867E-1)[&rate=4.777560469269576E-4]:4.38877613285E0)[&rate=5.314940929565066E-4]:5.483256969557E1,((30[&rate=6.133565372713593E-4]:5.143904726406E1,26[&rate=5.492657550090859E-4]:5.143904726406E1)[&rate=8.497713405707449E-4]:8.101793263892E0,32[&rate=2.8123200507937206E-4]:5.954084052795E1)[&rate=7.070917474507502E-4]:1.080225638719E1)[&rate=5.945740391571921E-4]:9.092341765113E-1)[&rate=8.497713405707449E-4]:1.988190364919E0)[&rate=8.321251008112734E-4]:1.652694864405E0,25[&rate=6.7366725652099E-4]:7.489321632097E1)[&rate=7.705263813180125E-4]:2.297654630813E0)[&rate=0.0012423700575887862]:5.556737538729E0,(17[&rate=9.106902406142049E-4]:7.03260697609E1,(27[&rate=3.9766055960902637E-4]:3.13943760786E1,28[&rate=6.327021259429665E-4]:3.13943760786E1)[&rate=7.997612636474515E-4]:3.893169368229E1)[&rate=6.03903107226097E-4]:1.242153872962E1)[&rate=0.0012423700575887862]:4.516999705734E1);\ntree STATE_45 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55126.76398413293,EEF_ucld_branchRates=-266.168517335019,lnP=-55126.76398413293,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.753680568889684E-4]:7.858405734945E0,9[&rate=8.516375335182313E-4]:7.858405734945E0)[&rate=5.478517198306347E-4]:8.554521422425E0,15[&rate=6.112264434133929E-4]:1.641292715737E1)[&rate=8.119131396873995E-4]:9.065112668216E1,(14[&rate=0.0012810625076170876]:4.170777599229E1,24[&rate=7.762560221783427E-4]:4.170777599229E1)[&rate=0.0012810625076170876]:6.535627784724E1)[&rate=8.971337723704443E-4]:1.942577600451E1,((((((11[&rate=4.770249485044845E-4]:1.989826043279E1,29[&rate=6.02295069833516E-4]:1.989826043279E1)[&rate=7.877670453876485E-4]:5.061548952531E1,(33[&rate=8.119131396873995E-4]:6.075643073145E1,13[&rate=3.9193294264194394E-4]:6.075643073145E1)[&rate=6.291184222040986E-4]:9.757319226653E0)[&rate=7.03226211741024E-4]:1.377076449703E0,(19[&rate=7.650707262133881E-4]:1.273699869083E1,18[&rate=0.0012105851690240635]:1.273699869083E1)[&rate=4.770249485044845E-4]:5.915382771698E1)[&rate=3.4206191354322257E-4]:3.398579637754E0,((10[&rate=8.246342526899382E-4]:1.977345183244E1,31[&rate=8.971337723704443E-4]:1.977345183244E1)[&rate=5.571245852143261E-4]:5.370015632853E1,23[&rate=3.4206191354322257E-4]:7.347360816097E1)[&rate=6.840816288693066E-4]:1.81579788459E0)[&rate=4.987767399429767E-4]:1.603451294238E0,((12[&rate=7.331681994384833E-4]:7.499847439311E1,((16[&rate=4.531144001203039E-4]:3.020043852391E1,((22[&rate=8.971337723704443E-4]:2.076149905965E0,21[&rate=8.246342526899382E-4]:2.076149905965E0)[&rate=9.512637010068684E-4]:5.645616854511E0,20[&rate=4.987767399429767E-4]:7.721766760476E0)[&rate=0.0012810625076170876]:2.247867176344E1)[&rate=4.770249485044845E-4]:4.348388622681E1,(((((4[&rate=7.877670453876485E-4]:1.656853159756E0,2[&rate=8.811839713007434E-4]:1.656853159756E0)[&rate=5.384439833987434E-4]:8.466007322695E-1,3[&rate=8.119131396873995E-4]:2.503453892026E0)[&rate=0.0010194802074486018]:1.220289372667E1,5[&rate=4.0994026115434E-4]:1.47063476187E1)[&rate=4.6540207857661333E-4]:2.661259554805E0,(1[&rate=4.987767399429767E-4]:1.204639149737E1,(6[&rate=9.720389841955517E-4]:9.640213110594E0,7[&rate=5.190982088454859E-4]:9.640213110594E0)[&rate=6.02295069833516E-4]:2.406178386774E0)[&rate=9.320047976716845E-4]:5.321215676133E0)[&rate=7.650707262133881E-4]:5.528566329665E1,((30[&rate=7.130250124483001E-4]:5.563579333722E1,26[&rate=5.753680568889684E-4]:5.563579333722E1)[&rate=8.660522372020216E-4]:9.973289110392E0,32[&rate=3.4206191354322257E-4]:6.560908244761E1)[&rate=6.74702108215824E-4]:7.044188022539E0)[&rate=8.516375335182313E-4]:1.031054280572E0)[&rate=5.478517198306347E-4]:1.314149642383E0)[&rate=6.65429962947757E-4]:1.151827941771E0,25[&rate=6.291184222040986E-4]:7.615030233488E1)[&rate=5.662889199190407E-4]:7.425550049205E-1)[&rate=9.320047976716845E-4]:3.036139094536E0,(17[&rate=6.65429962947757E-4]:6.633629727939E1,(27[&rate=7.650707262133881E-4]:2.739042686163E1,28[&rate=9.512637010068684E-4]:2.739042686163E1)[&rate=6.74702108215824E-4]:3.894587041776E1)[&rate=7.541794849243332E-4]:1.359269915494E1)[&rate=0.0010194802074486018]:4.65608334097E1);\ntree STATE_46 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55163.3935945383,EEF_ucld_branchRates=-266.168517335019,lnP=-55163.3935945383,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.5292014258110024E-4]:7.130621327583E0,9[&rate=5.398310647903867E-4]:7.130621327583E0)[&rate=3.851810934633781E-4]:6.893552370316E0,15[&rate=8.983637816324361E-4]:1.40241736979E1)[&rate=9.808262641340737E-4]:8.762432034037E1,(14[&rate=0.0010235593430365133]:4.207662040389E1,24[&rate=0.0013483044502161205]:4.207662040389E1)[&rate=9.282688252355821E-4]:5.957187363438E1)[&rate=8.587271569987223E-4]:1.816797971758E1,((((((11[&rate=7.916515747379436E-4]:2.172928251256E1,29[&rate=5.073876624633162E-4]:2.172928251256E1)[&rate=8.46590163237665E-4]:4.423816299637E1,(33[&rate=6.134507640268771E-4]:5.925791647362E1,13[&rate=7.251158238847533E-4]:5.925791647362E1)[&rate=6.220455464741775E-4]:6.709529035314E0)[&rate=6.987168982446417E-4]:1.749255299989E0,(19[&rate=9.445946506250665E-4]:1.141088412532E1,18[&rate=7.525768337650957E-4]:1.141088412532E1)[&rate=6.644947301137631E-4]:5.630581668361E1)[&rate=6.81511936042071E-4]:3.220727555077E0,((10[&rate=0.001193687248974803]:2.079693916843E1,31[&rate=9.282688252355821E-4]:2.079693916843E1)[&rate=6.390818124182727E-4]:4.924978873534E1,23[&rate=5.498034337926013E-4]:7.004672790377E1)[&rate=8.126367741410239E-4]:8.907004602334E-1)[&rate=5.871281474405948E-4]:2.50776107453E0,((12[&rate=7.620429738500196E-4]:6.959242779252E1,((((((4[&rate=8.126367741410239E-4]:2.085455664494E0,2[&rate=7.916515747379436E-4]:2.085455664494E0)[&rate=3.3634406799986076E-4]:8.399325698624E-1,3[&rate=5.871281474405948E-4]:2.925388234356E0)[&rate=6.475565056749473E-4]:9.03523675492E0,5[&rate=6.047804337187823E-4]:1.196062498928E1)[&rate=5.688903147893429E-4]:2.276765125325E0,(1[&rate=8.983637816324361E-4]:9.628405858725E0,(6[&rate=7.916515747379436E-4]:7.843382518316E0,7[&rate=5.073876624633162E-4]:7.843382518316E0)[&rate=7.251158238847533E-4]:1.785023340409E0)[&rate=8.845451963420485E-4]:4.608984255875E0)[&rate=4.8250870056834334E-4]:5.232035074262E1,((30[&rate=8.845451963420485E-4]:4.785737870199E1,26[&rate=6.390818124182727E-4]:4.785737870199E1)[&rate=9.282688252355821E-4]:7.742328068296E0,32[&rate=5.871281474405948E-4]:5.559970677028E1)[&rate=4.1358919677052914E-4]:1.095803408694E1)[&rate=8.46590163237665E-4]:1.076926893791E0,(16[&rate=5.187131058016917E-4]:2.736880309325E1,((22[&rate=0.001048365368438611]:2.726489911129E0,21[&rate=7.71696458904038E-4]:2.726489911129E0)[&rate=5.29493755873561E-4]:5.306784973402E0,20[&rate=5.871281474405948E-4]:8.033274884532E0)[&rate=0.0015440777223875378]:1.933552820872E1)[&rate=9.282688252355821E-4]:4.026586465776E1)[&rate=8.348928553535478E-4]:1.95776004151E0)[&rate=8.46590163237665E-4]:5.051758831679E-1,25[&rate=7.074236852227159E-4]:7.009760367569E1)[&rate=7.162185203371399E-4]:3.347585762839E0)[&rate=4.1358919677052914E-4]:4.497399052369E0,(17[&rate=6.900842002504263E-4]:6.848160962452E1,(27[&rate=5.29493755873561E-4]:2.734115266298E1,28[&rate=0.001048365368438611]:2.734115266298E1)[&rate=8.126367741410239E-4]:4.114045696153E1)[&rate=8.020016444966069E-4]:9.460978866385E0)[&rate=0.0015440777223875378]:4.187388526495E1);\ntree STATE_47 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55133.600694501525,EEF_ucld_branchRates=-266.168517335019,lnP=-55133.600694501525,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=4.297317294209122E-4]:6.696908609474E0,9[&rate=6.13229223596863E-4]:6.696908609474E0)[&rate=3.4865904347525613E-4]:9.524894421299E0,15[&rate=3.110242343898536E-4]:1.622180303077E1)[&rate=6.473323724414366E-4]:9.510850828169E1,(14[&rate=0.0012766318523924382]:4.71097709767E1,24[&rate=8.282020964548449E-4]:4.71097709767E1)[&rate=9.858626085533263E-4]:6.422054033576E1)[&rate=6.13229223596863E-4]:6.217004436443E0,(((((((4[&rate=9.526233140142844E-4]:1.903070674221E0,2[&rate=5.612233167458301E-4]:1.903070674221E0)[&rate=5.612233167458301E-4]:1.052656958193E0,3[&rate=4.760055041376315E-4]:2.955727632414E0)[&rate=7.258457943464438E-4]:8.948028195741E0,5[&rate=3.244348253300856E-4]:1.190375582815E1)[&rate=3.810263305912398E-4]:2.527225365696E0,(1[&rate=2.797414720436004E-4]:9.404203999474E0,(6[&rate=3.4865904347525613E-4]:8.770327448283E0,7[&rate=5.712434676241928E-4]:8.770327448283E0)[&rate=6.024066172647704E-4]:6.338765511914E-1)[&rate=5.037478006676626E-4]:5.026777194377E0)[&rate=6.845152007474311E-4]:5.798416628372E1,((12[&rate=8.282020964548449E-4]:6.721164831747E1,(16[&rate=7.258457943464438E-4]:3.102261719076E1,((22[&rate=7.902547585901267E-4]:2.807853150029E0,21[&rate=2.3495948405539735E-4]:2.807853150029E0)[&rate=7.258457943464438E-4]:5.276954592525E0,20[&rate=7.902547585901267E-4]:8.084807742554E0)[&rate=0.0017165777367884637]:2.293780944821E1)[&rate=6.977665816242626E-4]:3.618903112671E1)[&rate=7.407960993152723E-4]:3.858806262331E0,((30[&rate=6.845152007474311E-4]:5.052149642274E1,26[&rate=4.1074184225312624E-4]:5.052149642274E1)[&rate=6.356652571668981E-4]:1.313560180522E1,32[&rate=2.3495948405539735E-4]:6.365709822796E1)[&rate=6.473323724414366E-4]:7.41335635184E0)[&rate=4.575913176648086E-4]:1.34469289777E0)[&rate=2.6016954914136686E-4]:2.985562719683E0,(25[&rate=7.407960993152723E-4]:7.454948757866E1,((((33[&rate=7.902547585901267E-4]:5.739504782319E1,13[&rate=3.4865904347525613E-4]:5.739504782319E1)[&rate=4.202957715167862E-4]:1.296283071257E1,(11[&rate=4.944625665496633E-4]:1.71442280954E1,29[&rate=4.575913176648086E-4]:1.71442280954E1)[&rate=5.416257423419832E-4]:5.321365044036E1)[&rate=4.1074184225312624E-4]:7.597966803079E-1,(19[&rate=8.491435965940325E-4]:1.153068591923E1,18[&rate=7.902547585901267E-4]:1.153068591923E1)[&rate=4.202957715167862E-4]:5.958698929684E1)[&rate=5.814346286318608E-4]:1.915907746852E0,((10[&rate=4.010382669618826E-4]:2.220676028084E1,31[&rate=6.593393222089163E-4]:2.220676028084E1)[&rate=3.810263305912398E-4]:5.033960885297E1,23[&rate=4.390772099068804E-4]:7.254636913381E1)[&rate=6.593393222089163E-4]:4.872138291033E-1)[&rate=0.0011873131682265602]:1.515904615739E0)[&rate=8.086362266734E-4]:8.512226185964E-1)[&rate=8.282020964548449E-4]:4.496828142512E0,(17[&rate=8.491435965940325E-4]:6.823938679106E1,(27[&rate=4.852203911524246E-4]:2.548502793971E1,28[&rate=0.0010678934202925385]:2.548502793971E1)[&rate=5.320151502616179E-4]:4.275435885134E1)[&rate=4.1074184225312624E-4]:1.165815154871E1)[&rate=0.0017165777367884637]:3.764977740914E1);\ntree STATE_48 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55149.05309882678,EEF_ucld_branchRates=-266.168517335019,lnP=-55149.05309882678,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.036856012933165E-4]:8.047622462807E0,9[&rate=7.274724279311377E-4]:8.047622462807E0)[&rate=3.7510030485838757E-4]:7.206445773086E0,15[&rate=3.461185576535476E-4]:1.525406823589E1)[&rate=8.263454258946099E-4]:9.681637875805E1,(14[&rate=0.001384288181343608]:5.325579813316E1,24[&rate=6.393674170843887E-4]:5.325579813316E1)[&rate=8.43375440023308E-4]:5.881464886078E1)[&rate=6.294078235284257E-4]:1.138556029405E1,(((((((11[&rate=6.704141562730126E-4]:1.747858804207E1,29[&rate=4.527084599049553E-4]:1.747858804207E1)[&rate=7.949100218371862E-4]:5.051371236513E1,(33[&rate=8.43375440023308E-4]:6.022354781552E1,13[&rate=6.196108332609429E-4]:6.022354781552E1)[&rate=3.083853664798067E-4]:7.76875259168E0)[&rate=0.0010793651134835384]:2.755089773435E0,(19[&rate=9.753464580252881E-4]:1.13574166349E1,18[&rate=5.270442686019902E-4]:1.13574166349E1)[&rate=4.4278963098648444E-4]:5.938997354573E1)[&rate=4.719429596590307E-4]:1.506133633603E0,((10[&rate=4.624131643987955E-4]:2.176016501524E1,31[&rate=7.66310810286895E-4]:2.176016501524E1)[&rate=5.089160961351947E-4]:4.96231479406E1,23[&rate=6.923052126733147E-4]:7.138331295584E1)[&rate=9.238997945944608E-4]:8.702108584006E-1)[&rate=5.179933556066841E-4]:2.596309983257E0,25[&rate=6.704141562730126E-4]:7.484983379749E1)[&rate=6.704141562730126E-4]:1.354016901687E0,((((((4[&rate=8.807521195303425E-4]:1.713959457185E0,2[&rate=7.153964039272457E-4]:1.713959457185E0)[&rate=4.997938623898211E-4]:6.11888131647E-1,3[&rate=5.451354016549759E-4]:2.325847588832E0)[&rate=7.802975093224094E-4]:1.033076655791E1,5[&rate=4.221106101323324E-4]:1.265661414674E1)[&rate=8.807521195303425E-4]:1.489706598586E0,(1[&rate=2.8172450740630985E-4]:8.93520912582E0,(6[&rate=8.614548667353845E-4]:8.241306195753E0,7[&rate=3.461185576535476E-4]:8.241306195753E0)[&rate=0.0010054800123234953]:6.939029300674E-1)[&rate=5.54207596802661E-4]:5.211111619505E0)[&rate=7.66310810286895E-4]:5.827324940911E1,(((30[&rate=6.923052126733147E-4]:4.839495889385E1,26[&rate=7.036856012933165E-4]:4.839495889385E1)[&rate=8.263454258946099E-4]:1.224710042492E1,32[&rate=3.878624151823843E-4]:6.064205931878E1)[&rate=4.997938623898211E-4]:1.035854103192E1,(16[&rate=3.998455141642531E-4]:3.071393986184E1,((22[&rate=7.802975093224094E-4]:2.805347582305E0,21[&rate=4.527084599049553E-4]:2.805347582305E0)[&rate=5.817119199353388E-4]:3.533728830489E0,20[&rate=4.8133111610875547E-4]:6.339076412794E0)[&rate=0.0016445428389015987]:2.437486344905E1)[&rate=6.099589931808033E-4]:4.028666048886E1)[&rate=9.238997945944608E-4]:1.418969803731E0)[&rate=2.8172450740630985E-4]:1.235834245285E0,12[&rate=6.004357197927499E-4]:7.365540439972E1)[&rate=3.998455141642531E-4]:2.548446299465E0)[&rate=6.704141562730126E-4]:2.709154082965E0,(17[&rate=5.910251415819451E-4]:6.951835005877E1,(27[&rate=4.624131643987955E-4]:2.054067739991E1,28[&rate=0.001126746594118679]:2.054067739991E1)[&rate=7.802975093224094E-4]:4.897767265886E1)[&rate=4.719429596590307E-4]:9.394654723377E0)[&rate=0.0016445428389015987]:4.454300250585E1);\ntree STATE_49 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55171.10859955921,EEF_ucld_branchRates=-266.168517335019,lnP=-55171.10859955921,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=7.029834648675939E-4]:7.905655787429E0,9[&rate=6.830034347410179E-4]:7.905655787429E0)[&rate=4.894024652467166E-4]:5.333153541292E0,15[&rate=7.700617141881774E-4]:1.323880932872E1)[&rate=4.98443806859593E-4]:1.148333612364E2,(14[&rate=0.001047178509430801]:5.240629374215E1,24[&rate=9.107716371658064E-4]:5.240629374215E1)[&rate=5.160967473291032E-4]:7.566587682296E1)[&rate=6.830034347410179E-4]:1.466708868384E0,((((12[&rate=8.392093211686843E-4]:7.208315250956E1,((16[&rate=3.7737471027482066E-4]:3.179710908811E1,((22[&rate=8.095502272361342E-4]:2.682901470203E0,21[&rate=3.9220735236556917E-4]:2.682901470203E0)[&rate=5.160967473291032E-4]:4.179640512749E0,20[&rate=7.133446570940516E-4]:6.862541982952E0)[&rate=0.0015280166764625157]:2.493456710515E1)[&rate=5.842400727239504E-4]:3.867717998625E1,(((((4[&rate=8.239867864456607E-4]:1.558016477962E0,3[&rate=7.579412723624248E-4]:1.558016477962E0)[&rate=7.029834648675939E-4]:3.879476835955E-1,2[&rate=6.453943547296622E-4]:1.945964161558E0)[&rate=6.638598917456294E-4]:7.706287495968E0,5[&rate=5.247613874691316E-4]:9.652251657526E0)[&rate=6.638598917456294E-4]:2.522055880065E0,(1[&rate=4.98443806859593E-4]:7.856398140655E0,(6[&rate=8.239867864456607E-4]:7.047980200952E0,7[&rate=6.274696496580309E-4]:7.047980200952E0)[&rate=4.801755006822578E-4]:8.084179397025E-1)[&rate=4.894024652467166E-4]:4.317909396936E0)[&rate=4.801755006822578E-4]:5.614864538838E1,((30[&rate=8.909118224003037E-4]:4.561295276316E1,26[&rate=5.418772213813261E-4]:4.561295276316E1)[&rate=6.099631318655953E-4]:1.583218037892E1,32[&rate=7.958025559422418E-4]:6.144513314209E1)[&rate=6.099631318655953E-4]:6.877819783885E0)[&rate=6.013309593292333E-4]:2.151336148378E0)[&rate=7.700617141881774E-4]:1.608863435207E0)[&rate=4.98443806859593E-4]:1.973775145427E0,25[&rate=7.349460570053993E-4]:7.405692765499E1)[&rate=3.1372423703276444E-4]:1.412619337305E0,(((19[&rate=5.073324629160769E-4]:1.281026057876E1,18[&rate=8.392093211686843E-4]:1.281026057876E1)[&rate=3.4024115481442064E-4]:5.756192304526E1,((33[&rate=7.133446570940516E-4]:6.353617458716E1,13[&rate=4.404943325623336E-4]:6.353617458716E1)[&rate=7.133446570940516E-4]:5.175737992168E0,(11[&rate=6.830034347410179E-4]:1.56527749122E1,29[&rate=4.6100085363266996E-4]:1.56527749122E1)[&rate=5.503661216561566E-4]:5.305913766712E1)[&rate=3.1372423703276444E-4]:1.66027104469E0)[&rate=0.0010883376640127263]:1.735517316768E0,((10[&rate=8.392093211686843E-4]:2.231393602638E1,31[&rate=8.553354139359847E-4]:2.231393602638E1)[&rate=3.4024115481442064E-4]:4.926372679982E1,23[&rate=4.295446499087731E-4]:7.15776628262E1)[&rate=4.056122600478204E-4]:5.300381145819E-1)[&rate=5.672893661131775E-4]:3.361846051509E0)[&rate=9.826218193015558E-4]:3.978638611129E0,(17[&rate=9.107716371658064E-4]:7.202688853209E1,(27[&rate=6.733375989165151E-4]:1.970942630571E1,28[&rate=0.0011393881823691721]:1.970942630571E1)[&rate=7.029834648675939E-4]:5.231746222638E1)[&rate=9.826218193015558E-4]:7.421297071327E0)[&rate=0.0015280166764625157]:5.009069383007E1);\ntree STATE_50 [&HMG_ucld_branchRates=-266.168517335019,TGFb2_ucld_branchRates=-266.168517335019,mtDNA_linked_ucld_branchRates=-266.168517335019,GAPDH_ucld_branchRates=-266.168517335019,posterior=-55134.90850656344,EEF_ucld_branchRates=-266.168517335019,lnP=-55134.90850656344,RHOD_ucld_branchRates=-266.168517335019] = [&R] ((((8[&rate=5.803197525194792E-4]:7.670870139057E0,9[&rate=7.225436496226685E-4]:7.670870139057E0)[&rate=0.0010434913940446146]:5.478477828768E0,15[&rate=4.829879279472217E-4]:1.314934796783E1)[&rate=7.692137150934966E-4]:9.803945529613E1,(14[&rate=9.51540214662105E-4]:4.898917536697E1,24[&rate=8.587800724997733E-4]:4.898917536697E1)[&rate=0.0010165694538464165]:6.219962789698E1)[&rate=7.692137150934966E-4]:1.457589729998E1,(((((((16[&rate=4.705269031732208E-4]:2.774064334456E1,((22[&rate=7.050145087358959E-4]:1.817443728987E0,21[&rate=7.79196700607247E-4]:1.817443728987E0)[&rate=7.40649943286784E-4]:3.579559795952E0,20[&rate=9.711709714378167E-4]:5.397003524939E0)[&rate=0.001216010265835883]:2.234363981963E1)[&rate=0.0013050175282145714]:4.061507782896E1,12[&rate=8.861076594136634E-4]:6.835572117352E1)[&rate=8.338939846309957E-4]:2.722238846159E0,((30[&rate=8.861076594136634E-4]:5.256812213146E1,26[&rate=8.221932251845324E-4]:5.256812213146E1)[&rate=7.499636492089143E-4]:1.17880019859E1,32[&rate=4.946068869755539E-4]:6.435612411736E1)[&rate=5.540983298266575E-4]:6.721835902317E0)[&rate=4.0377189890762437E-4]:2.151275468481E0,((((4[&rate=5.449921830210305E-4]:1.839615974367E0,3[&rate=5.449921830210305E-4]:1.839615974367E0)[&rate=6.219374233425796E-4]:3.828148072719E-1,2[&rate=5.803197525194792E-4]:2.222430781639E0)[&rate=5.449921830210305E-4]:7.83989340964E0,5[&rate=5.62999757278043E-4]:1.006232419128E1)[&rate=8.221932251845324E-4]:3.156253650843E0,(1[&rate=3.762330876884519E-4]:1.021712266504E1,(6[&rate=6.879365981673345E-4]:9.238221259391E0,7[&rate=5.717305161710644E-4]:9.238221259391E0)[&rate=7.40649943286784E-4]:9.789014056505E-1)[&rate=7.692137150934966E-4]:3.00145517708E0)[&rate=7.692137150934966E-4]:6.001065764604E1)[&rate=3.762330876884519E-4]:1.783492006334E0,25[&rate=8.587800724997733E-4]:7.50127274945E1)[&rate=6.219374233425796E-4]:9.319574946797E-1,(((19[&rate=8.861076594136634E-4]:1.291473496051E1,18[&rate=0.0011111486997196938]:1.291473496051E1)[&rate=4.569594466623367E-4]:5.624169919146E1,((11[&rate=6.54686096646994E-4]:1.762161214085E1,29[&rate=8.460693815712207E-4]:1.762161214085E1)[&rate=7.225436496226685E-4]:5.021712536242E1,(33[&rate=7.315161536544858E-4]:6.3476950061E1,13[&rate=3.762330876884519E-4]:6.3476950061E1)[&rate=6.629188033807829E-4]:4.361787442272E0)[&rate=7.692137150934966E-4]:1.317696648697E0)[&rate=5.540983298266575E-4]:3.617847096466E0,((10[&rate=5.803197525194792E-4]:2.111026288911E1,31[&rate=8.338939846309957E-4]:2.111026288911E1)[&rate=4.705269031732208E-4]:5.051481645551E1,23[&rate=6.54686096646994E-4]:7.162507934462E1)[&rate=5.356408773676935E-4]:1.149201903813E0)[&rate=7.692137150934966E-4]:3.170403740744E0)[&rate=6.054773409114629E-4]:6.905940729011E0,(17[&rate=9.009134248605781E-4]:7.744448815072E1,(27[&rate=0.0010165694538464165]:2.181584424899E1,28[&rate=9.334504852317562E-4]:2.181584424899E1)[&rate=5.62999757278043E-4]:5.562864390173E1)[&rate=6.795309520526933E-4]:5.40613756747E0)[&rate=0.0014930302801874373]:4.291407484575E1);\nEnd;\n'
    elif name == "pxstrec":
        cm = "./pxstrec -t TEST/test.strec.tre -d TEST/test.data.narrow -c TEST/test.conf | tail -1"
        t = '0.316161 \n'
    elif name == "pxssort":
        cm = "./pxssort -s TEST/Codon.fa"
        t = '>Sequence1\nATGAAAAAAATATAT\n>Sequence2\nATGAAATTTAATATA\n>Sequence3\nAAATTTAAATTTAAA\n>Sequence4\nAAATTTAAATTTATA\n'
    elif name == "pxrmk":
        cm = "./pxrmk -t TEST/knuckle_tree.tre"
        t = '(((((s4:0.1190332191,s5:0.1190332191)C:0.02544171746,s6:0.1444749366)D:0.7647640019,s7:0.9092389385)E:0.76874935,(s3:1.2572336289999999,(s1:0.3603553431,s2:0.3603553431)A:1.1968782862)B:0.5207546592)F:0.06349158892,((s8:0.3106889265,s9:0.3106889265)G:0.1031508249,s10:0.4138397514)H:1.3276401259999999);\n'
    elif name == "pxsstat":
        cm = "./pxsstat -s TEST/Bollback_2002_MBE.fa"
        t = '-18.867\n'
    elif name == "pxaa2cdn":
        cm = "./pxaa2cdn -a TEST/AA.fa -n TEST/un_aln_nuc.fa"
        t = '>Sequence1\nATG---AAA---AAG\n>Sequence2\nATG------------\n>Sequence3\nATGATGATGATGATG\n>Sequence5\nATGATGATGATGATG\n'
    elif name == "pxcolt":
        cm = "./pxcolt -t TEST/collapse.tre -l 0.7"
        t = '((TaxonC:0.25,TaxonA:0.225,TaxonB:0.155)1.0:0.4,(TaxonD:0.23,TaxonE:0.16)0.94:0.3);\n'
    else:
        return
    p = subprocess.Popen(cm,shell=True,stdout=subprocess.PIPE)
    x = p.communicate()
    #print(x)
    x = x[0].lstrip().decode("utf-8")
    if x == t:
        print (bcolors.OKBLUE+"PASSED"+bcolors.ENDC)
        return True
    else:
        for i,j in zip(x,t):
            print (i,j,i==j)
        print (bcolors.FAIL+"FAILED"+bcolors.ENDC)
        print ("intended output:\n",t)
        print ("your output:\n",x)
        return False

# this are skipped in the testing because they are preliminary, tests will
# be added as they become more permanent.
notest = ["pxbpsq","pxnni"]

if __name__ == "__main__":
    if len(sys.argv) != 1:
        print ("python run_tests.py")
        sys.exit(0)
    
    passed = 0
    failed = 0
    failedl = []
    print ("=================")
    for i in os.listdir("."):
        if i[:2] == "px":
            if i in notest:
                continue
            t = test_program(i)
            if t == True:
                passed += 1
            elif t == False:
                failed += 1
                failedl.append(i)
            else:
                print (bcolors.WARNING+"no test for "+i+bcolors.ENDC)
            print ("=================")
    print ("PASSED TESTS:",passed)
    print ("FAILED TESTS:",failed)
    if failed > 0:
        print ("These failed:")
        print ("\t",",".join(failedl))
