/*	String_Buffer_test

CVS ID: String_Buffer_test.java,v 1.7 2012/04/16 06:15:36 castalia Exp

Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Strings.String_Buffer;
import	PIRL.Utilities.Checker;

public class String_Buffer_test
{
public static void main (String[] arguments) 
{
System.out.println ("*** String_Buffer_test:\n"
	+ String_Buffer.ID);
Checker
	checker = new Checker ();
if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

String
	string =
		"+ZERO.X---=--==-===+SECOND.Y+-THIRTY!",
	indexing =
		"          111111111122222222223333333\n" +
		"0123456789012345678901234567890123456\n",
	delimiters = "+=-";

if (checker.Verbose)
	System.out.println
		("Test String -\n"
		+ string + '\n'
		+ indexing);

if (checker.Verbose)
	System.out.println ("--- Constructor");
String_Buffer
	SB = new String_Buffer (string);

if (! checker.Check ("length",
	37, SB.length ()) ||
	! checker.Check ("toString ()",
	string, SB.toString ()))
	System.exit (1);
	
int
	index = 0,
	end;

checker.Check ("index_of (0, \"negative one\")",
	-1, SB.index_of (0, "negative one"));
checker.Check ("index_of (0, \"THIRTY\")",
	30, (index = SB.index_of (0, "THIRTY")));
checker.Check ("equals_ignore_case (" + index + ", \"Thirty\")",
	true, SB.equals_ignore_case (index, "Thirty"));
checker.Check ("substring (6, 7)",
	"X", SB.substring (6, 7));
checker.Check ("skip_until (6, \"+\")",
	19, (index = SB.skip_until (6, "+")));
checker.Check ("skip_back_over (" + index + ", \"" + delimiters + "\")",
	6, SB.skip_back_over (index, delimiters));

index = 0;
checker.Check ("skip_over (" + index + ", \"" + delimiters + "\")",
	1, (index = SB.skip_over (index, delimiters)));
checker.Check ("skip_until (" + index + "\".\")",
	5, (end = SB.skip_until (index, ".")));
if (end < 0)
	end = SB.length ();
checker.Check ("substring (" + index + ", " + end + ")",
	"ZERO", SB.substring (index, end));
checker.Check ("skip_until (" + end + ", \"" + delimiters + "\")",
	7, (index = SB.skip_until (end, delimiters)));

checker.Check ("skip_over (" + index + ", \"" + delimiters + "\")",
	20, (index = SB.skip_over (index, delimiters)));
checker.Check ("skip_until (" + index + "\".\")",
	26, (end = SB.skip_until (index, ".")));
if (end < 0)
	end = SB.length ();
checker.Check ("substring (" + index + ", " + end + ")",
	"SECOND", SB.substring (index, end));
checker.Check ("skip_until (" + end + ", \"" + delimiters + "\")",
	28, (index = SB.skip_until (end, delimiters)));

checker.Check ("skip_over (" + index + ", \"" + delimiters + "\")",
	30, (index = SB.skip_over (index, delimiters)));
checker.Check ("skip_until (" + index + "\".\")",
	-1, (end = SB.skip_until (index, ".")));
if (end < 0)
	end = SB.length ();
checker.Check ("substring (" + index + ", " + end + ")",
	"THIRTY!", SB.substring (index, end));


checker.Check ("replace (0, \".\", \"_._\")",
	"+ZERO_._X---=--==-===+SECOND_._Y+-THIRTY!",
	SB.replace (0, ".", "_._").toString ());
checker.Check ("replace_span (0, \"" + delimiters + "\", \"<->\")",
	"<->ZERO_._X<->SECOND_._Y<->THIRTY!",
	SB.replace_span (0, delimiters, "<->").toString ());

string = "... HT>|\t|<NL>|\n|<BEL>|\07|<CR>|\r|<";
String
	expected = "... HT>|\\t|<NL>|\\n|<BEL>|\\07|<CR>|\\r|<";
if (checker.Verbose)
	System.out.println ("\nTest String -\n"
		+ string);
SB = new String_Buffer (string);
checker.Check ("special_to_escape ()",
	expected, SB.special_to_escape ().toString ());
checker.Check ("special_to_escape (String)",
	expected, String_Buffer.special_to_escape (string));
checker.Check ("escape_to_special ()",
	string, SB.escape_to_special ().toString ());
checker.Check ("escape_to_special (String)",
	string, String_Buffer.escape_to_special (expected));

expected = "... HT>|&#X9;|<NL>|&#XA;|<BEL>|&#X7;|<CR>|&#XD;|<";
SB = new String_Buffer (string);
checker.Check ("to_character_references ()",
	expected, SB.to_character_references ().toString ());
checker.Check ("to_character_references (String)",
	expected, String_Buffer.to_character_references (string));
string = "&#X46;&#x6f;o&#66;ar";
expected = "FooBar";
if (checker.Verbose)
	System.out.println ("\nTest String: " + string);
SB = new String_Buffer (string);
checker.Check ("from_character_references ()",
	expected, SB.from_character_references ().toString ());
checker.Check ("from_character_references (String)",
	expected, String_Buffer.from_character_references (string));

string = "... HT>|\t|<NL>|\n|<BEL>|\07|<CR>|\r|<";
if (checker.Verbose)
	System.out.println ("\nTest String -\n"
		+ string);
expected = "... HT>|?|<NL>|?|<BEL>|?|<CR>|?|<";
SB = new String_Buffer (string);
checker.Check ("to_printable_ASCII ()",
	expected, SB.to_printable_ASCII ().toString ());
checker.Check ("to_printable_ASCII (String)",
	expected, String_Buffer.to_printable_ASCII (string));


System.out.println (String_Buffer.NL
	+"Checks: " + checker.Checks_Total + String_Buffer.NL
	+"Passed: " + checker.Checks_Passed);

System.exit (checker.Checks_Total - checker.Checks_Passed);
}

}
