#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;
use CGI;
use Date::Calc;

use Classes::Filter;
use Classes::User;
use Classes::Process;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';

require 'Functions/_Filters.pl';
require 'Functions/Filtered_Links.pl';

require 'Functions/FilterList.pl';
require 'Functions/Delete.pl';
require 'Functions/DateTime.pl';

our $User = User->new();
our $CurUser = $User->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

$conf{'refresh'} = int( $conf{'refresh'} );
if ( $conf{'refresh'} < 15 ) {$conf{'refresh'}=15;};

  # Import CGI parameters :
$cgi = CGI->new();

  # By default, show all 3 severity level :
if ( ! defined( $cgi->param( 'show_high') ) ) {$cgi->param( 'show_high', '' );};
if ( ! defined( $cgi->param( 'show_medium' ) ) ) {$cgi->param( 'show_medium', '' );};
if ( ! defined( $cgi->param( 'show_low' ) ) ) {$cgi->param( 'show_low', '' );};

if ( ( ! $cgi->param( 'show_high' ) ) and ! $cgi->param( 'show_medium' ) and ( ! $cgi->param( 'show_low' ) ) )
{
	$cgi->param( 'desc', 1 );
	$cgi->param( 'show_high', 1 );
	$cgi->param( 'show_medium', 1);
	$cgi->param( 'show_low', 1);
}

if ( ! $cgi->param( 'page_num' ) ) {$cgi->param( 'page_num', 0 );};
if ( ! $cgi->param( 'by_page' ) ) {$cgi->param( 'by_page', $conf{'nb_resbypage'} );};
if ( ! defined( $cgi->param( 'sortby' ) ) ) {$cgi->param( 'sortby', 'time' );};
if ( ! defined( $cgi->param( 'submit' ) ) ) {$cgi->param( 'submit', '' );};

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";

if ( ! defined( $cgi->param( 'mode' ) ) ) {$cgi->param( 'mode' ,'' );};
if ( $cgi->param( 'mode' ) ne 'edit' ) {print "refresh: $conf{'refresh'};\n";};
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

our $PageTitle = ' - Filter builder';
ParseComponent( 'CommonHeader' );

our $Filter = Filter->new();

if ( $cgi->param( 'load' ) )
{
	if ( ! defined( $cgi->param( 'trigger' ) ) ) {$cgi->param( 'trigger', '');};
	if ( $cgi->param( 'trigger' ) eq 'add' )
	{
		$Filter->get_data_from_cgi();
		$Filter->concat( 'generated/Filters/'.$cgi->param( 'load' ).'.flt' );
	}
	else
	{
		my $desc = $cgi->param( 'desc' );
		my $by_page = $cgi->param( 'by_page' );

		$Filter->load( 'generated/Filters/'.$cgi->param( 'load' ).'.flt' );
		if ( $cgi->param( 'load' ) !~ m/^defaults\// )
		{
			$Filter->desc( $desc );
			$Filter->by_page( $by_page );
			$Filter->save( 'generated/Filters/'.$cgi->param( 'load' ).'.flt' );
		}
		if (($cgi->param ( 'load' ) =~ m/^defaults\//) and ( ! $cgi->param( 'mode' ) ) )
		{
			$Filter->desc( $desc );
			$Filter->by_page( $by_page );
			$Filter->get_Criteria_by_num( 0 )->Value( $cgi->param( 'valA' ) );
			$cgi->param('load', $Filter->save_temp() );
		}
	}

	$Filter->load_data_for_cgi();
}
else
{
	$Filter->get_data_from_cgi();

	if ( ! defined( $cgi->param( 'desc' ) ) ) {$cgi->param( 'desc', 1 );};
	$Filter->desc( $cgi->param( 'desc' ) );

	if ( $cgi->param( 'mode' ) ne 'edit' )
	{
		$cgi->param( 'load', $Filter->save_temp() );
	}
}

if ( $cgi->param( 'mode' ) eq 'edit' )
{
	$cgi->param( 'load', '' );
}

####################### Add a criteria (edit mode) #########################

if ( ! defined( $cgi->param( 'addline' ) ) ) {$cgi->param( 'addline', '' );};
if ( $cgi->param( 'addline' ) )
{
	$cgi->param( 'Table_'.chr( 65 + ( $Filter->CriteriaNb() ) ), 'Address' );
	$cgi->param( 'LineNb', $cgi->param( 'LineNb' ) + 1 );
}

############################################################################

if ( ! $cgi->param( 'timelimit' ) ) { $cgi->param( 'timelimit', '1D' );};
if ( ! defined( $cgi->param( 'desc' ) ) ) { $cgi->param( 'desc', 1 );};

my $Period = $cgi->param( 'timelimit' ) || '1D';
my ( $Nb, $Unit ) = ( $Period =~ m/^(\d+)([DWMY])$/ );
my %Val = ( 'D', 1, 'W', 7, 'M', 31, 'Y', 365 );
my $Date = sprintf( "%04d-%02d-%02d", Date::Calc::Add_Delta_Days( Date::Calc::Today, -$Nb*$Val{$Unit} ) );
$Date .= ' 00:00:00';

my $DateCrit = Criteria->new();
$DateCrit->Table( 'CreateTime' );
$DateCrit->Field( 'time' );
$DateCrit->Operator( '>=' );
$DateCrit->Value( $Date );
$DateCrit->IsTemporary( 1 );
$Filter->add_Criteria( $DateCrit );

my $CurCritNum = $Filter->CriteriaNb();
my $Letter = chr( 64 + $CurCritNum );
$CurCritNum ++;

my $BaseFormula = $Filter->Formula();
my $GUIFormula = '';
if ( $BaseFormula) { $GUIFormula = '('.$BaseFormula.') AND '; };
$GUIFormula .= $Letter;

if ( ( ! $cgi->param( 'show_high' ) ) and ( ! $cgi->param( 'show_medium') ) and ( ! $cgi->param( 'show_low' ) ) )
{
	$cgi->param( 'show_high', 'on' );
	$cgi->param( 'show_medium', 'on' );
	$cgi->param( 'show_low', 'on' );
}

if ( ! ( $cgi->param( 'show_high' ) and $cgi->param( 'show_medium')  and $cgi->param( 'show_low' ) ) )
{
	my $Severity_Formula = '';
	foreach my $Severity ( 'high', 'medium', 'low' )
	{
		if ( $cgi->param( 'show_'.$Severity ) )
		{
			my $Crit = Criteria->new();

			$Crit->Table( 'Impact' );
			$Crit->Field( 'severity' );
			$Crit->Operator( '=' );
			$Crit->Value( $Severity );
			$Crit->IsTemporary( 1 );
			$Filter->add_Criteria( $Crit );
			$Severity_Formula .= ' OR '.chr( 64 + $CurCritNum );
			$CurCritNum ++;
		}
	}

	$Severity_Formula =~ s/^ OR //;
	$GUIFormula .= ' AND ('.$Severity_Formula.')';
}

############################### Display form ###############################

ParseComponent( 'Links' );
ParseComponent( 'FilterBuilder' );

########################## Alert deletion ##################################

if ( ! defined( $cgi->param( 'priv_name' ) ) ) {$cgi->param( 'priv_name', '' );};
if ( ! defined( $cgi->param( 'priv_value' ) ) ) {$cgi->param( 'priv_value', '' );};

if ( ( $cgi->param( 'priv_name' ) eq 'delete' )
  and $cgi->param( 'priv_value' )
  and $cgi->param( 'load' )
  and ( $User->priv_delete() eq 'all' ) )
{
	my $result = 0;
	print '<br>';
	print '<font color=red>Deletion in progress ... may take a while</font>';
	print "<br>\n";

	if ( $cgi->param( 'priv_value' ) eq 'filter' )
	{
		$Filter->Formula( $GUIFormula );
		$result = $Filter->DeleteAlerts();
	}

	if ( $cgi->param( 'priv_value' ) eq 'checked' )
	{
		foreach my $Key ( $cgi->param() )
		{
			if ( my ( $id ) = ( $Key =~ m/^chk(\d+)$/ ) )
			{
				if ( $cgi->param( 'chk'.$id ) )
				{
					$result += DeleteAlert_by_Id( $id );
				}
			}
		}
	}

	print $result.' alert(s) matching this filter deleted';
	print "<br><br>\n";
}

####################### Alert external processing ##########################

if ( ( $cgi->param( 'priv_name' ) eq 'process' )
  and $cgi->param( 'priv_value' )
  and $cgi->param( 'process' ) # process to do on each alert
  and $cgi->param( 'load' )
  and ( $User->priv_process() eq 'all' ) )
{
	my $result = 0;
	print '<br>';
	print '<font color=red>Processing in progress ... may take a while</font>';
	print "<br>\n";

	my $Process = Process->new();

	if ( $cgi->param( 'priv_value' ) eq 'filter' )
	{
		$Filter->Formula( $GUIFormula );
		$Process->load( $cgi->param( 'process' ) );
		$result = $Filter->ProcessAlerts( $Process );
	}

	if ( $cgi->param( 'priv_value' ) eq 'checked' )
	{
		my $cnt = 0;
		my @ExportList = ();
		foreach my $Key ( $cgi->param() )
		{
			if ( my ( $id ) = ( $Key =~ m/^chk(\d+)$/) )
			{
				if ( $cgi->param( 'chk'.$id ) )
				{
					$cnt ++;
					push @ExportList, $id;
				}
			}
		}

		$Process->load( $cgi->param( 'process' ) );

		$result = $Process->ExecCommand( \@ExportList );
	}

	print $result.' alert(s) matching this filter processed (';
	print $Process->Command();
	print ")<br><br>\n";
}

############################# Saving Filter ################################

if ( $cgi->param( 'submit' ) eq 'save' )
{
	$Filter->Formula( $BaseFormula );

	if ( $cgi->param( 'name' ) )
	{
		my $name = $cgi->param( 'name' );
		$name =~ s/\///g;

		$Filter->save( 'generated/Filters/'.$name.'.flt' );
	}
	else
	{
		print "Impossible to save this filter without a filter name<br>\n";
	}
}

############################# Generating SQL ###############################

if ( ! $cgi->param( 'mode' ) or ( $cgi->param( 'Table_A' ) and $cgi->param( 'Field_A' ) ) )
{
	ParseComponent( 'AlertList_OpenSensorTree' );

	$Filter->Formula( $GUIFormula );

	our $Grouping = $cgi->param( 'groupby' );

	our $TotalResultNb = 0;

	if ( $Grouping )
	{
		$Filter->get_GroupSQL( $Grouping );

		debug( $Filter->SQL_GroupNb() );
		debug( $Filter->SQL_GroupList() );

		my $order = 'desc';
		if ( ! $Filter->desc() ) { $order = 'asc'; };

		my $sth = $dbh->prepare( $Filter->SQL_GroupNb );
		$sth->execute() || debug( $dbh->errstr );
		$TotalResultNb = $sth->fetchrow_array();
		$sth->finish();

		if ( $TotalResultNb > 0 )
		{
			Page_Navigation( $cgi->param( 'page_num' ), $cgi->param( 'by_page' ), $TotalResultNb, 1 );
			ParseComponent( 'AlertList_Head' );

			my $sql = $Filter->SQL_GroupList();

			  # Sort by TimeStamp :
			if ( $cgi->param( 'sortby' ) eq 'time' )
			{
				$sql =~ s/ FROM/,MAX(Prelude_CreateTime.time) AS max_timestamp FROM/;
				$sql =~ s/ ORDER BY .* LIMIT/ ORDER BY max_timestamp $order LIMIT/;
			}
			else
			{
				$sql =~ s/ ORDER BY (.*) LIMIT/ ORDER BY $1 $order LIMIT/;
			}
			debug( $sql );

			  # Set element number per group :
			my $PageNum = $cgi->param( 'page_num' );
			my $ByPage = $cgi->param( 'by_page' );
			$cgi->param( 'page_num', 0 );

			$sth = $dbh->prepare( $sql );
			LIMIT_values( $sth, $ByPage, $PageNum * $ByPage );
			$sth->execute() || debug( 'SQL Error : '.$dbh->errstr );

			while( my $HashRef = $sth->fetchrow_hashref() )
			{
				# Assign values to criteria and build group labels :

				my @Labels = ();
				foreach my $Key ( keys %{$HashRef} )
				{
					foreach my $Line ( 0..($Filter->GroupCriteriaNb() - 1 ) )
					{
						my $Crit = $Filter->get_GroupCriteria_by_num( $Line );
						if ( $Crit->Field() eq $Key )
						{
							$Crit->Value( $HashRef->{$Key} );
							push @Labels, ( $Crit->Table )." $Key = ".( $HashRef->{$Key} );
						}
					}
				}

				#

				$Filter->load_data_for_cgi();
				my $URL = 'Formula='.url_encode( $cgi->param( 'Formula' ) );
				foreach my $Key ( $cgi->param() )
				{
					if ( $Key =~ m/^(Table|Field|Operator|Value)_([A-Z])$/ )
					{
						my $K = $1.'_'.$2;
						$URL .= "&amp;$K=".url_encode( $cgi->param( $K ) );
					}
					else
					{
						if ( $Key =~ m/^(desc|by_page|show_(high|medium|low)|timelimit)/ )
						{
							$URL .= "&amp;$1=".$cgi->param( $1 );
						}
					}
				}

				# Set number of alert per group key :

				$cgi->param( 'by_page', $conf{'nb_resbygroup'} );

				# For each group key, display Alert List :

				$TotalResultNb = $Filter->count();

				if ( defined( $TotalResultNb ) )
				{
					if ( $TotalResultNb > 0 )
					{
						my $Label = join( ' / ', @Labels );
						print "<tr><td colspan=10><a href=\"Filters".$conf{'extension'}.'?'.$URL."\"><i>$Label</i></a>&nbsp;&nbsp;(";
						if ( $conf{'nb_resbygroup'} > 1 )
						{
							print ( ( ( $conf{'nb_resbygroup'} < $TotalResultNb )?$conf{'nb_resbygroup'}:$TotalResultNb ).'/' );
						}
						print "$TotalResultNb) :</td></tr>\n";
						AlertList( $Filter );
					}
				}
			}
			$sth->finish();

			  # Restore original values :
			$cgi->param( 'page_num', $PageNum );
			$cgi->param( 'by_page', $ByPage );

			ParseComponent( 'AlertList_Foot' );
#			Page_Navigation( $cgi->param( 'page_num' ), $cgi->param( 'by_page' ), $TotalResultNb, 0 );

			if ( $User->priv_list()->[0] )
			{
				ParseComponent( 'AlertList_CheckAll' );
			}
		}
		else
		{
			ParseComponent( 'AlertList_NoResult' );
		}
	}
	else
	{
		############################ Display Alerts ################################

		$TotalResultNb = $Filter->count();

		if ( defined( $TotalResultNb ) )
		{
			if ( $TotalResultNb > 0 )
			{
				Page_Navigation( $cgi->param( 'page_num' ), $cgi->param( 'by_page' ), $TotalResultNb, 1 );
				ParseComponent( 'AlertList_Head' );
				AlertList( $Filter );
				ParseComponent( 'AlertList_Foot' );
				Page_Navigation( $cgi->param( 'page_num' ), $cgi->param( 'by_page' ), $TotalResultNb, 0 );

				if ( $User->priv_list()->[0] )
				{
					ParseComponent( 'AlertList_CheckAll' );
				}
			}
			else
			{
				ParseComponent( 'AlertList_NoResult' );
			}
		}
		else
		{
			error( "This filter generates bad SQL, so it might be invalid.  Please check carrefully field names" );
		}
	}
}

print "</form>\n";

ParseComponent( 'CommonFooter' );
