# SPDX-License-Identifier: BSD-3-Clause
# Copyright 2014-2018, Intel Corporation
#
#
# pmempool_create/TEST3 -- test for inheriting pools
#

. ..\unittest\unittest.ps1

require_test_type medium

require_fs_type any

setup

$POOL="$DIR\file.pool"
$INHERIT="$DIR\inherit.pool"

# PMEMBLK
expect_normal_exit $PMEMPOOL create blk 512 $POOL
check_file $POOL
check_signature PMEMBLK $POOL
sv -Name SIZE -Scope "Local" (get_size $POOL)
expect_normal_exit $PMEMPOOL create --inherit $POOL $INHERIT
check_file $INHERIT
check_signature PMEMBLK $INHERIT
check_size $SIZE $INHERIT

# PMEMLOG
rm $POOL
rm $INHERIT
expect_normal_exit $PMEMPOOL create log $POOL
check_file $POOL
check_signature PMEMLOG $POOL
sv -Name SIZE -Scope "Local" (get_size $POOL)
expect_normal_exit $PMEMPOOL create --inherit $POOL $INHERIT
check_file $INHERIT
check_signature PMEMLOG $INHERIT
check_size $SIZE $INHERIT

# PMEMOBJ
rm $POOL
rm $INHERIT
expect_normal_exit $PMEMPOOL create --layout=pmempool$Env:SUFFIX obj $POOL
check_file $POOL
check_signature PMEMOBJ $POOL
check_layout pmempool$Env:SUFFIX $POOL
sv -Name SIZE -Scope "Local" (get_size $POOL)
expect_normal_exit $PMEMPOOL create --inherit $POOL $INHERIT
check_file $INHERIT
check_signature PMEMOBJ $INHERIT
check_layout pmempool$Env:SUFFIX $POOL
check_size $SIZE $INHERIT

pass
