include( ../global.pri )

TARGET   = xtuple
CONFIG   += qt warn_on

QT += xml sql script scripttools network
QT += webkit xmlpatterns printsupport webkitwidgets

isEqual(QT_MAJOR_VERSION, 5) {
  QT     += designer uitools quick websockets webchannel serialport
} else {
  CONFIG += designer uitools
}

TEMPLATE = app

INCLUDEPATH += ../scriptapi \
               ../common \
               ../widgets ../widgets/tmp/lib \
               ../../xtuple-build-desktop/scriptapi \
               ../../xtuple-build-desktop/common \
               ../../xtuple-build-desktop/widgets \
               ../../xtuple-build-desktop/widgets/tmp/lib \
               ../../xtuple-build-desktop/guiclient . \
               $(CSVIMP_HEADERS)/csvimpcommon $(CSVIMP_HEADERS)/plugin

DEPENDPATH  += $${INCLUDEPATH}

win32-msvc* {
  PRE_TARGETDEPS += ../lib/xtuplecommon.$${XTLIBEXT}    \
                    ../lib/xtuplescriptapi.lib          \
                    ../lib/xtuplewidgets.lib            \
                    $${OPENRPT_LIBDIR}/qzint.$${OPENRPTLIBEXT}    \
                    $${OPENRPT_LIBDIR}/MetaSQL.$${OPENRPTLIBEXT}  \
                    $${OPENRPT_LIBDIR}/renderer.$${OPENRPTLIBEXT} \
                    $${OPENRPT_LIBDIR}/wrtembed.$${OPENRPTLIBEXT} \
                    $${OPENRPT_LIBDIR}/openrptcommon.$${OPENRPTLIBEXT}
} else {
  PRE_TARGETDEPS += ../lib/libxtuplecommon.$${XTLIBEXT} \
                    ../lib/libxtuplescriptapi.a         \
                    ../lib/libxtuplewidgets.a           \
                    $${OPENRPT_LIBDIR}/libqzint.$${OPENRPTLIBEXT}    \
                    $${OPENRPT_LIBDIR}/libMetaSQL.$${OPENRPTLIBEXT}  \
                    $${OPENRPT_LIBDIR}/librenderer.$${OPENRPTLIBEXT} \
                    $${OPENRPT_LIBDIR}/libwrtembed.$${OPENRPTLIBEXT} \
                    $${OPENRPT_LIBDIR}/libopenrptcommon.$${OPENRPTLIBEXT}
}

QMAKE_LIBDIR = ../lib $${OPENRPT_LIBDIR} $$QMAKE_LIBDIR
LIBS        += -lxtuplecommon -lxtuplewidgets -lwrtembed -lopenrptcommon
LIBS        += -lrenderer -lxtuplescriptapi -lqzint $${DMTXLIB} -lMetaSQL

lessThan(QT_MAJOR_VERSION, 5) {
#not the best way to handle this, but it should do
mac:!static:contains(QT_CONFIG, qt_framework) {
  LIBS += -lz -framework QtDesignerComponents
}
 else {
  LIBS += -lz -lQtDesignerComponents
}
}

OBJECTS_DIR = tmp/obj
win32 {
  win32-msvc*:LIBS += -lshell32
  RC_FILE = rcguiclient.rc
  LIBS += -lz
}
win32-g++-4.6 {
  LIBS += -lz
}

unix: !macx {
 LIBS += -lz
}

macx {
  RC_FILE = images/icons.icns
  QMAKE_INFO_PLIST = Info.plist
  LIBS += -lz -framework QtDesignerComponents
}

equals(QT_MAJOR_VERSION, 5) {
  win32 {
    LIBS += -lQt5DesignerComponents
  }
  unix: !macx {
    LIBS += -lQt5DesignerComponents
  }
}

DESTDIR     = ../bin
MOC_DIR     = moc
UI_DIR      = ui

FORMS =   absoluteCalendarItem.ui               \
          account1099.ui                        \
          accountNumber.ui                      \
          accountNumbers.ui                     \
          accountingPeriod.ui                   \
          accountingPeriods.ui                  \
          accountingYearPeriod.ui               \
          accountingYearPeriods.ui              \
          addPoComment.ui                       \
          address.ui                            \
          addresses.ui                          \
          adjustmentTrans.ui                    \
          adjustInvValue.ui                     \
          allocateARCreditMemo.ui               \
          allocateReservations.ui               \
          apAccountAssignment.ui                \
          apAccountAssignments.ui               \
          apCreditMemoApplication.ui            \
          apOpenItem.ui                         \
          apWorkBench.ui                        \
          applyAPCreditMemo.ui                  \
          applyARCreditMemo.ui                  \
          applyARDiscount.ui                    \
          applyDiscount.ui                      \
          arAccountAssignment.ui                \
          arAccountAssignments.ui               \
          arCreditMemoApplication.ui            \
          arOpenItem.ui                         \
          arWorkBench.ui                        \
          archRestoreSalesHistory.ui            \
          assessFinanceCharges.ui               \
          assignClassCodeToPlannerCode.ui       \
          assignItemToPlannerCode.ui            \
          assignLotSerial.ui                    \
          atlasMap.ui                           \
          bankAccount.ui                        \
          bankAccounts.ui                       \
          bankAdjustment.ui                     \
          bankAdjustmentEditList.ui             \
          bankAdjustmentType.ui                 \
          bankAdjustmentTypes.ui                \
          bom.ui                                \
          bomItem.ui                            \
          bomList.ui                            \
          budgets.ui                            \
          buyCard.ui                            \
          calendar.ui                           \
          calendars.ui                          \
          cashReceipt.ui                        \
          cashReceiptItem.ui                    \
          cashReceiptMiscDistrib.ui             \
          cashReceiptsEditList.ui               \
          changePoitemQty.ui                    \
          changeWoQty.ui                        \
          characteristic.ui                     \
          characteristicPrice.ui                \
          characteristics.ui                    \
          check.ui                              \
          checkFormat.ui                        \
          checkFormats.ui                       \
          classCode.ui                          \
          classCodeTax.ui                       \
          classCodes.ui                         \
          closePurchaseOrder.ui                 \
          closeWo.ui                            \
          commentType.ui                        \
          commentTypes.ui                       \
          companies.ui                          \
          company.ui                            \
          configauthorizedotnetprocessor.ui     \
          configcybersourceprocessor.ui         \
          configureCC.ui                        \
          configureCRM.ui                       \
          configureEncryption.ui                \
          configureGL.ui                        \
          configureIE.ui                        \
          configureIM.ui                        \
          configureMS.ui                        \
          configurePD.ui                        \
          configurePO.ui                        \
          configureSearchPath.ui                \
          configureSO.ui                        \
          configureWO.ui                        \
          confirmAchOK.ui                       \
          contact.ui                            \
          contacts.ui                           \
          contactMerge.ui                       \
          contract.ui                           \
          copyBOM.ui                            \
          copyBudget.ui                         \
          copyContract.ui                       \
          copyItem.ui                           \
          copyPurchaseOrder.ui                  \
          copyQuote.ui                          \
          copySalesOrder.ui                     \
          copyTransferOrder.ui                  \
          correctProductionPosting.ui           \
          costCategories.ui                     \
          costCategory.ui                       \
          costingElements.ui                    \
          countSlip.ui                          \
          countTag.ui                           \
          countTagList.ui                       \
          countries.ui                          \
          country.ui                            \
          createCountTagsByItem.ui              \
          createCountTagsByParameterList.ui     \
          createCycleCountTags.ui               \
          createInvoices.ui                     \
          createItemSitesByClassCode.ui         \
          createLotSerial.ui                    \
          createPlannedOrdersByItem.ui          \
          createPlannedOrdersByPlannerCode.ui   \
          createRecurringInvoices.ui            \
          createRecurringItems.ui               \
          createfiscalyear.ui                   \
          creditCard.ui                         \
          creditMemo.ui                         \
          creditMemoEditList.ui                 \
          creditMemoItem.ui                     \
          crmaccount.ui                         \
          crmaccountMerge.ui                    \
          crmaccountMergePickAccountsPage.ui    \
          crmaccountMergePickDataPage.ui        \
          crmaccountMergePickTaskPage.ui        \
          crmaccountMergePurgePage.ui           \
          crmaccountMergeResultPage.ui          \
          currencies.ui                         \
          currency.ui                           \
          currencyConversion.ui                 \
          currencyConversions.ui                \
          currencySelect.ui                     \
          customCommand.ui                      \
          customCommandArgument.ui              \
          customCommands.ui                     \
          customer.ui                           \
          customerFormAssignment.ui             \
          customerFormAssignments.ui            \
          customerGroup.ui                      \
          customerGroups.ui                     \
          customerType.ui                       \
          customerTypeList.ui                   \
          customerTypes.ui                      \
          databaseInformation.ui                \
          deletePlannedOrder.ui                 \
          deletePlannedOrdersByPlannerCode.ui   \
          department.ui                         \
          departments.ui                        \
          incidentHistory.ui                    \
          dictionaries.ui                       \
          display.ui                            \
          displayTimePhased.ui                  \
          distributeInventory.ui                \
          distributeToLocation.ui               \
          dspAROpenItems.ui                     \
          dspBankrecHistory.ui                  \
          dspBillingSelections.ui               \
          dspCashReceipts.ui                    \
          dspCheckRegister.ui                   \
          dspCountSlipEditList.ui               \
          dspCountTagEditList.ui                \
          dspCreditCardTransactions.ui          \
          dspFinancialReport.ui                 \
          dspInvoiceInformation.ui              \
          dspMRPDetail.ui                       \
          dspTax1099.ui                 \
          dspTaxHistory.ui              \
          dspTaxReturn.ui               \
          duplicateAccountNumbers.ui    \
          editOwners.ui                 \
          empGroup.ui                   \
          empGroups.ui                  \
          employee.ui                   \
          enterMiscCount.ui             \
          enterPoReceipt.ui             \
          enterPoReturn.ui              \
          enterPoitemReceipt.ui         \
          enterPoitemReturn.ui          \
          errorLog.ui                   \
          eventManager.ui               \
          expenseCategories.ui          \
          expenseCategory.ui            \
          expenseTrans.ui               \
          explodeWo.ui                  \
          exportData.ui                 \
          externalCCTransaction.ui      \
          externalShipping.ui           \
          externalShippingList.ui       \
          failedPostList.ui             \
          financialLayout.ui            \
          financialLayoutColumns.ui     \
          financialLayoutGroup.ui       \
          financialLayoutItem.ui        \
          financialLayoutSpecial.ui     \
          financialLayouts.ui           \
          financialReportNotes.ui       \
          firmPlannedOrder.ui           \
          firmPlannedOrdersByPlannerCode.ui     \
          fixACL.ui                     \
          fixSerial.ui                  \
          form.ui                       \
          forms.ui                      \
          forwardUpdateAccounts.ui      \
          freightBreakdown.ui           \
          freightClass.ui               \
          freightClasses.ui             \
          getGLDistDate.ui              \
          getLotInfo.ui                 \
          glSeries.ui                   \
          glSeriesItem.ui               \
          glTransaction.ui              \
          glTransactionDetail.ui        \
          group.ui                      \
          groups.ui                     \
          honorific.ui                  \
          honorifics.ui                 \
          hotkey.ui                     \
          hotkeys.ui                    \
          idleShutdown.ui               \
          image.ui                      \
          imageList.ui                  \
          images.ui                     \
          implodeWo.ui                  \
          importData.ui                 \
          incident.ui                   \
          incidentCategories.ui         \
          incidentCategory.ui           \
          incidentPriorities.ui         \
          incidentPriority.ui           \
          incidentResolution.ui         \
          incidentResolutions.ui        \
          incidentSeverities.ui         \
          incidentSeverity.ui           \
          invoice.ui                    \
          invoiceItem.ui                \
          invoiceList.ui                \
          issueLineToShipping.ui        \
          issueToShipping.ui            \
          issueWoMaterialBatch.ui       \
          issueWoMaterialItem.ui        \
          item.ui                       \
          itemAlias.ui                  \
          itemAvailabilityWorkbench.ui  \
          itemCost.ui                   \
          itemGroup.ui                  \
          itemGroups.ui                 \
          itemImages.ui                 \
          itemListPrice.ui              \
          itemPricingSchedule.ui        \
          itemPricingScheduleItem.ui    \
          itemPricingSchedules.ui       \
          itemSite.ui                   \
          itemSites.ui                  \
          itemSource.ui                 \
          itemSourceList.ui             \
          itemSourcePrice.ui            \
          itemSourceSearch.ui           \
          itemSubstitute.ui             \
          itemUOM.ui                    \
          items.ui                      \
          itemtax.ui                    \
          labelForm.ui                  \
          labelForms.ui                 \
          listRecurringInvoices.ui      \
          locales.ui                    \
          location.ui                   \
          locations.ui                  \
          lotSerial.ui                  \
          lotSerialSequence.ui          \
          lotSerialSequences.ui         \
          lotSerialRegistration.ui      \
          maintainBudget.ui             \
          maintainItemCosts.ui          \
          maintainShipping.ui           \
          massExpireComponent.ui        \
          massReplaceComponent.ui       \
          materialReceiptTrans.ui       \
          metasqls.ui                   \
          miscCheck.ui                  \
          miscVoucher.ui                \
          openPurchaseOrder.ui          \
          openReturnAuthorizations.ui   \
          openSalesOrders.ui            \
          openVouchers.ui               \
          opportunity.ui                \
          opportunityList.ui            \
          opportunitySource.ui          \
          opportunitySources.ui         \
          opportunityStage.ui           \
          opportunityStages.ui          \
          opportunityType.ui            \
          opportunityTypes.ui           \
          package.ui                    \
          packages.ui                   \
          packingListBatch.ui           \
          plannedOrder.ui               \
          plannerCode.ui                \
          plannerCodes.ui               \
          poLiabilityDistrib.ui         \
          postCashReceipts.ui           \
          postCheck.ui                  \
          postChecks.ui                 \
          postCostsByClassCode.ui       \
          postCostsByItem.ui            \
          postCountSlips.ui             \
          postCountTags.ui              \
          postCreditMemos.ui            \
          postInvoices.ui                       \
          postJournals.ui                       \
          postMiscProduction.ui                 \
          postPoReturnCreditMemo.ui             \
          postProduction.ui                     \
          postPurchaseOrder.ui                  \
          postPurchaseOrdersByAgent.ui          \
          postStandardJournal.ui                \
          postStandardJournalGroup.ui           \
          postVouchers.ui                       \
          poType.ui                             \
          poTypes.ui                            \
          prepareCheckRun.ui                    \
          priceList.ui                          \
          pricingScheduleAssignment.ui          \
          pricingScheduleAssignments.ui         \
          printApOpenItem.ui                    \
          printArOpenItem.ui                    \
          printCheck.ui                         \
          printChecks.ui                        \
          printChecksReview.ui                  \
          printChecksReviewEdit.ui              \
          printCreditMemo.ui                    \
          printCreditMemos.ui                   \
          printInvoice.ui                       \
          printInvoices.ui                      \
          printItemLabelsByClassCode.ui         \
          printLabelsByInvoice.ui               \
          printLabelsByOrder.ui                 \
          printLabelsBySo.ui                    \
          printLabelsByTo.ui                    \
          printMulticopyDocument.ui             \
          printOptions.ui                       \
          printPackingList.ui                   \
          printPackingListBatchByShipvia.ui     \
          printPoForm.ui                        \
          printToForm.ui                        \
          printPurchaseOrder.ui                 \
          printPurchaseOrdersByAgent.ui         \
          printQuote.ui                         \
          printRaForm.ui                        \
          printShippingForm.ui                  \
          printShippingForms.ui                 \
          printSinglecopyDocument.ui            \
          printSoForm.ui                        \
          printStatementByCustomer.ui           \
          printStatementsByCustomerType.ui      \
          printVendorForm.ui                    \
          printWoForm.ui                        \
          printWoPickList.ui                    \
          printWoTraveler.ui                    \
          productCategories.ui                  \
          productCategory.ui                    \
          profitCenter.ui                       \
          profitCenters.ui                      \
          project.ui                            \
          projects.ui                           \
          projectType.ui                        \
          projectTypes.ui                       \
          prospect.ui                           \
          purchaseOrder.ui                      \
          purchaseOrderItem.ui                  \
          purchaseRequest.ui                    \
          purgeClosedWorkOrders.ui              \
          purgeCreditMemos.ui                   \
          purgeInvoices.ui                      \
          purgePostedCountSlips.ui              \
          purgePostedCounts.ui                  \
          quickRelocateLot.ui                   \
          quotes.ui                             \
          reasonCode.ui                         \
          reasonCodes.ui                        \
          reassignClassCodeByClassCode.ui       \
          reassignCustomerTypeByCustomerType.ui \
          reassignLotSerial.ui                  \
          reassignProductCategoryByProductCategory.ui   \
          recallOrders.ui                       \
          reconcileBankaccount.ui               \
          registrationKey.ui                    \
          registrationKeyDialog.ui              \
          rejectCode.ui                         \
          rejectCodes.ui                        \
          relativeCalendarItem.ui               \
          releasePlannedOrdersByPlannerCode.ui  \
          releaseTransferOrdersByAgent.ui       \
          releaseWorkOrdersByPlannerCode.ui     \
          relocateInventory.ui                  \
          reports.ui                            \
          reprintCreditMemos.ui                 \
          reprintInvoices.ui                    \
          reprintMulticopyDocument.ui           \
          reprioritizeWo.ui                     \
          reschedulePoitem.ui                   \
          rescheduleWo.ui                       \
          reserveSalesOrderItem.ui              \
          resetQOHBalances.ui                   \
          returnAuthCheck.ui                    \
          returnAuthItemLotSerial.ui            \
          returnAuthorization.ui                \
          returnAuthorizationItem.ui            \
          returnAuthorizationWorkbench.ui       \
          returnWoMaterialBatch.ui              \
          returnWoMaterialItem.ui               \
          reverseGLSeries.ui                    \
          sale.ui                               \
          sales.ui                              \
          salesAccount.ui                       \
          salesAccounts.ui                      \
          salesCategories.ui                    \
          salesCategory.ui                      \
          salesHistoryInformation.ui            \
          salesOrder.ui                         \
          salesOrderInformation.ui              \
          salesOrderItem.ui                     \
          salesOrderSimple.ui                   \
          salesRep.ui                           \
          salesReps.ui                          \
          saleType.ui                           \
          saleTypes.ui                          \
          scrapTrans.ui                         \
          scrapWoMaterialFromWIP.ui             \
          scriptEditor.ui                       \
          scripts.ui                            \
          searchForEmp.ui                       \
          selectBankAccount.ui                  \
          selectBillingQty.ui                   \
          selectOrderForBilling.ui              \
          selectPayment.ui                      \
          selectPayments.ui                     \
          selectShippedOrders.ui                \
          selectedPayments.ui                   \
          setup.ui                              \
          shipOrder.ui                          \
          shipTo.ui                             \
          shipVia.ui                            \
          shipVias.ui                           \
          shippingChargeType.ui                 \
          shippingChargeTypes.ui                \
          shippingForm.ui                       \
          shippingForms.ui                      \
          shippingInformation.ui                \
          shippingZone.ui                       \
          shippingZones.ui                      \
          siteType.ui                           \
          siteTypes.ui                          \
          splitReceipt.ui                       \
          standardJournal.ui                    \
          standardJournalGroup.ui               \
          standardJournalGroupItem.ui           \
          standardJournalGroups.ui              \
          standardJournalItem.ui                \
          standardJournals.ui                   \
          state.ui                              \
          states.ui                             \
          subAccntType.ui                       \
          subAccntTypes.ui                      \
          subaccount.ui                         \
          subaccounts.ui                        \
          submitAction.ui                       \
          submitReport.ui                       \
          substituteList.ui                     \
          summarizeInvTransByClassCode.ui       \
          syncCompanies.ui                      \
          sysLocale.ui                          \
          systemMessage.ui                      \
          task.ui                               \
          taxAdjustment.ui                      \
          taxAssignment.ui                      \
          taxAssignments.ui                     \
          taxAuthority.ui                       \
          taxBreakdown.ui                       \
          taxClass.ui                           \
          taxClasses.ui                         \
          taxCode.ui                            \
          taxCodeRate.ui                        \
          taxCodes.ui                           \
          taxDetail.ui                          \
          taxRegistration.ui                    \
          taxRegistrations.ui                   \
          taxType.ui                            \
          taxTypes.ui                           \
          taxZone.ui                            \
          taxZones.ui                           \
          terms.ui                              \
          termses.ui                            \
          thawItemSitesByClassCode.ui           \
          todoItem.ui                           \
          todoList.ui                           \
          todoListCalendar.ui                   \
          toggleBankrecCleared.ui               \
          transactionInformation.ui             \
          transferOrder.ui                      \
          transferOrderItem.ui                  \
          transferOrders.ui                     \
          transferTrans.ui                      \
          transformTrans.ui                     \
          translations.ui                       \
          uiform.ui                             \
          uiformchooser.ui                      \
          uiforms.ui                            \
          unappliedAPCreditMemos.ui             \
          unappliedARCreditMemos.ui             \
          uninvoicedShipments.ui                \
          unpostedCreditMemos.ui                \
          unpostedGLTransactions.ui             \
          unpostedGlSeries.ui                   \
          unpostedInvoices.ui                   \
          unpostedPoReceipts.ui                 \
          unpostedPurchaseOrders.ui             \
          uom.ui                                \
          uomConv.ui                            \
          uoms.ui                               \
          updateABCClass.ui                     \
          updateActualCostsByClassCode.ui       \
          updateActualCostsByItem.ui            \
          updateCreditStatusByCustomer.ui       \
          updateCycleCountFrequency.ui          \
          updateItemSiteLeadTimes.ui            \
          updateLateCustCreditStatus.ui         \
          updateListPricesByProductCategory.ui  \
          updateOUTLevelByItem.ui               \
          updateOUTLevels.ui                    \
          updateOUTLevelsByClassCode.ui         \
          updatePrices.ui                       \
          updateReorderLevels.ui                \
          user.ui                               \
          userCostingElement.ui                 \
          userList.ui                           \
          userPreferences.ui                    \
          users.ui                              \
          vendor.ui                             \
          vendorAddress.ui                      \
          vendorAddressList.ui                  \
          vendorPriceList.ui                    \
          vendorType.ui                         \
          vendorTypes.ui                        \
          viewCheckRun.ui                       \
          voidChecks.ui                         \
          voucher.ui                            \
          voucherItem.ui                        \
          voucherItemDistrib.ui                 \
          voucherMiscDistrib.ui                 \
          warehouse.ui                          \
          warehouseZone.ui                      \
          warehouses.ui                         \
          woMaterialItem.ui                     \
          workOrder.ui                          \
          workOrderMaterials.ui                 \
          xdateinputdialog.ui                   \
          xdocumentwindow.ui                    \
          xsltMap.ui                            \
          zeroUncountedCountTagsByWarehouse.ui  \
          printStatementsByCustomerGroup.ui


HEADERS = ../common/format.h                    \
          SaveSizePositionEventFilter.h         \
          absoluteCalendarItem.h                \
          account1099.h                         \
          accountNumber.h                       \
          accountNumbers.h                      \
          accountingPeriod.h                    \
          accountingPeriods.h                   \
          accountingYearPeriod.h                \
          accountingYearPeriods.h               \
          addPoComment.h                        \
          address.h                             \
          addresses.h                           \
          adjustmentTrans.h                     \
          adjustInvValue.h                      \
          allocateARCreditMemo.h                \
          allocateReservations.h                \
          apAccountAssignment.h                 \
          apAccountAssignments.h                \
          apCreditMemoApplication.h             \
          apOpenItem.h                          \
          apWorkBench.h                         \
          applyAPCreditMemo.h                   \
          applyARCreditMemo.h                   \
          applyARDiscount.h                     \
          applyDiscount.h                       \
          arAccountAssignment.h                 \
          arAccountAssignments.h                \
          arCreditMemoApplication.h             \
          arOpenItem.h                          \
          arWorkBench.h                         \
          archRestoreSalesHistory.h             \
          assessFinanceCharges.h                \
          assignClassCodeToPlannerCode.h        \
          assignItemToPlannerCode.h             \
          assignLotSerial.h                     \
          atlasMap.h                            \
          authorizedotnetprocessor.h            \
          bankAccount.h                         \
          bankAccounts.h                        \
          bankAdjustment.h                      \
          bankAdjustmentEditList.h              \
          bankAdjustmentType.h                  \
          bankAdjustmentTypes.h                 \
          bom.h                         \
          bomItem.h                     \
          bomList.h                     \
          budgets.h                     \
          buyCard.h                     \
          calendar.h                    \
          calendars.h                   \
          cashReceipt.h                 \
          cashReceiptItem.h             \
          cashReceiptMiscDistrib.h      \
          cashReceiptsEditList.h        \
          changePoitemQty.h             \
          changeWoQty.h                 \
          characteristic.h              \
          characteristicPrice.h         \
          characteristics.h             \
          check.h                       \
          checkFormat.h                 \
          checkFormats.h                \
          classCode.h                   \
          classCodeTax.h                \
          classCodes.h                  \
          closePurchaseOrder.h          \
          closeWo.h                     \
          commentType.h                 \
          commentTypes.h                \
          companies.h                   \
          company.h                     \
          configauthorizedotnetprocessor.h \
          configcreditcardprocessor.h   \
          configcybersourceprocessor.h  \
          configureCC.h                 \
          configureCRM.h                \
          configureEncryption.h         \
          configureGL.h                 \
          configureIE.h                 \
          configureIM.h                 \
          configureMS.h                 \
          configurePD.h                 \
          configurePO.h                 \
          configureSearchPath.h         \
          configureSO.h                 \
          configureWO.h                 \
          confirmAchOK.h                \
          contact.h                     \
          contacts.h                    \
          contactMerge.h                \
          contract.h                    \
          contracts.h                   \
          copyBOM.h                     \
          copyBudget.h                  \
          copyContract.h                \
          copyItem.h                    \
          copyPurchaseOrder.h           \
          copyQuote.h                   \
          copySalesOrder.h              \
          copyTransferOrder.h           \
          correctProductionPosting.h    \
          costCategories.h              \
          costCategory.h                \
          costingElements.h             \
          countSlip.h                   \
          countTag.h                    \
          countTagList.h                \
          countries.h                   \
          country.h                     \
          createCountTagsByItem.h       \
          createCountTagsByParameterList.h      \
          createCycleCountTags.h                \
          createInvoices.h                      \
          createItemSitesByClassCode.h          \
          createLotSerial.h                     \
          createPlannedOrdersByItem.h           \
          createPlannedOrdersByPlannerCode.h    \
          createRecurringInvoices.h             \
          createRecurringItems.h                \
          createfiscalyear.h                    \
          creditCard.h                          \
          creditMemo.h                          \
          creditMemoEditList.h                  \
          creditMemoItem.h                      \
          creditcardprocessor.h                 \
          crmaccount.h                          \
          crmaccountMerge.h                     \
          crmaccountMergePickAccountsPage.h     \
          crmaccountMergePickDataPage.h         \
          crmaccountMergePickTaskPage.h         \
          crmaccountMergePurgePage.h            \
          crmaccountMergeResultPage.h           \
          crmaccounts.h                         \
          currencies.h                          \
          currenciesDialog.h                    \
          currency.h                            \
          currencyConversion.h                  \
          currencyConversions.h                 \
          currencySelect.h                      \
          custCharacteristicDelegate.h          \
          customCommand.h                       \
          customCommandArgument.h               \
          customCommands.h                      \
          customer.h                            \
          customerFormAssignment.h              \
          customerFormAssignments.h             \
          customerGroup.h                       \
          customerGroups.h                      \
          customerType.h                        \
          customerTypeList.h                    \
          customerTypes.h                       \
          customers.h                           \
          cybersourceprocessor.h                \
          databaseInformation.h                 \
          deletePlannedOrder.h                  \
          deletePlannedOrdersByPlannerCode.h    \
          department.h                          \
          departments.h                         \
          incidentHistory.h                     \
          dictionaries.h                        \
          display.h                             \
          displayprivate.h                      \
          displayTimePhased.h                   \
          distributeInventory.h                 \
          distributeToLocation.h                \
          dspAROpenItems.h                      \
          dspBankrecHistory.h                   \
          dspBillingSelections.h                \
          dspCashReceipts.h                     \
          dspCheckRegister.h                    \
          dspCountSlipEditList.h                \
          dspCountTagEditList.h                 \
          dspCreditCardTransactions.h           \
          dspFinancialReport.h                  \
          dspInvoiceInformation.h               \
          dspMRPDetail.h                        \
          dspProcesses.h                        \
          dspTax1099.h                          \
          dspTaxHistory.h                       \
          dspTaxReturn.h                        \
          duplicateAccountNumbers.h             \
          editOwners.h                          \
          empGroup.h                            \
          empGroups.h                           \
          employee.h                            \
          employees.h                           \
          enterMiscCount.h                      \
          enterPoReceipt.h                      \
          enterPoReturn.h                       \
          enterPoitemReceipt.h                  \
          enterPoitemReturn.h                   \
          errorLog.h                            \
          eventManager.h                        \
          expenseCategories.h                   \
          expenseCategory.h                     \
          expenseTrans.h                        \
          explodeWo.h                           \
          exportData.h                          \
          externalCCTransaction.h               \
          externalShipping.h                    \
          externalShippingList.h                \
          externalccprocessor.h                 \
          failedPostList.h                      \
          financialLayout.h                     \
          financialLayoutColumns.h              \
          financialLayoutGroup.h                \
          financialLayoutItem.h                 \
          financialLayoutSpecial.h              \
          financialLayouts.h                    \
          financialReportNotes.h                \
          firmPlannedOrder.h                    \
          firmPlannedOrdersByPlannerCode.h      \
          fixACL.h                      \
          fixSerial.h                   \
          form.h                        \
          forms.h                       \
          forwardUpdateAccounts.h       \
          freightBreakdown.h            \
          freightClass.h                \
          freightClasses.h              \
          getGLDistDate.h               \
          getLotInfo.h                  \
          getscreen.h                   \
          getscreen_classlist.h         \
          getscreen_headerlist.h        \
          glSeries.h                    \
          glSeriesItem.h                \
          glTransaction.h               \
          glTransactionDetail.h         \
          group.h                       \
          groups.h                      \
          guiErrorCheck.h               \
          guiclient.h                   \
          honorific.h                   \
          honorifics.h                  \
          hotkey.h                      \
          hotkeys.h                     \
          idleShutdown.h                \
          image.h                       \
          imageList.h                   \
          images.h                      \
          implodeWo.h                   \
          importData.h                  \
          incident.h                    \
          incidentCategories.h          \
          incidentCategory.h            \
          incidentPriorities.h          \
          incidentPriority.h            \
          incidentResolution.h          \
          incidentResolutions.h         \
          incidentSeverities.h          \
          incidentSeverity.h            \
          incidentWorkbench.h           \
          inputManager.h                \
          inputManagerPrivate.h         \
          invoice.h                     \
          invoiceItem.h                 \
          invoiceList.h                 \
          issueLineToShipping.h         \
          issueToShipping.h             \
          issueWoMaterialBatch.h        \
          issueWoMaterialItem.h         \
          item.h                        \
          itemAlias.h                   \
          itemAvailabilityWorkbench.h   \
          itemCharacteristicDelegate.h  \
          itemCost.h                    \
          itemGroup.h                   \
          itemGroups.h                  \
          itemImages.h                  \
          itemListPrice.h               \
          itemPricingSchedule.h         \
          itemPricingScheduleItem.h     \
          itemPricingSchedules.h        \
          itemSite.h                    \
          itemSites.h                   \
          itemSource.h                  \
          itemSourceList.h              \
          itemSourcePrice.h             \
          itemSourceSearch.h            \
          itemSubstitute.h              \
          itemUOM.h                     \
          items.h                       \
          itemtax.h                     \
          jsHighlighter.h               \
          labelForm.h                   \
          labelForms.h                  \
          ledgerControl.h               \
          listRecurringInvoices.h       \
          locales.h                     \
          location.h                    \
          locations.h                   \
          lotSerial.h                   \
          lotSerialSequence.h           \
          lotSerialSequences.h          \
          lotSerialRegistration.h       \
          lotSerialUtils.h              \
          maintainBudget.h              \
          maintainItemCosts.h           \
          maintainShipping.h            \
          massExpireComponent.h         \
          massReplaceComponent.h        \
          materialReceiptTrans.h        \
          metasqls.h                    \
          menuAccounting.h              \
          menuCRM.h                     \
          menuInventory.h               \
          menuManufacture.h             \
          menuProducts.h                \
          menuPurchase.h                \
          menuSales.h                   \
          menuSchedule.h                \
          menuSystem.h                  \
          menuWindow.h                  \
          miscCheck.h                   \
          miscVoucher.h                 \
          openPurchaseOrder.h           \
          openReturnAuthorizations.h    \
          openSalesOrders.h             \
          openVouchers.h                \
          opportunity.h                 \
          opportunityList.h             \
          opportunitySource.h           \
          opportunitySources.h          \
          opportunityStage.h            \
          opportunityStages.h           \
          opportunityType.h             \
          opportunityTypes.h            \
          package.h                     \
          packages.h                    \
          packingListBatch.h            \
          paymentechprocessor.h         \
          plannedOrder.h                \
          plannerCode.h                 \
          plannerCodes.h                \
          poLiabilityDistrib.h          \
          poitemTableModel.h            \
          poitemTableView.h             \
          postCashReceipts.h            \
          postCheck.h                   \
          postChecks.h                  \
          postCostsByClassCode.h        \
          postCostsByItem.h             \
          postCountSlips.h              \
          postCountTags.h               \
          postCreditMemos.h             \
          postInvoices.h                \
          postJournals.h                \
          postMiscProduction.h          \
          postPoReturnCreditMemo.h      \
          postProduction.h              \
          postPurchaseOrder.h           \
          postPurchaseOrdersByAgent.h   \
          postStandardJournal.h         \
          postStandardJournalGroup.h    \
          postVouchers.h                \
          poType.h                      \
          poTypes.h                     \
          prepareCheckRun.h             \
          priceList.h                   \
          pricingScheduleAssignment.h   \
          pricingScheduleAssignments.h  \
          printApOpenItem.h             \
          printArOpenItem.h             \
          printCheck.h                  \
          printChecks.h                 \
          printChecksReview.h           \
          printChecksReviewEdit.h       \
          printCreditMemo.h             \
          printCreditMemos.h            \
          printInvoice.h                \
          printInvoices.h               \
          printItemLabelsByClassCode.h  \
          printLabelsByInvoice.h        \
          printLabelsByOrder.h          \
          printLabelsBySo.h             \
          printLabelsByTo.h             \
          printOptions.h                \
          printMulticopyDocument.h      \
          printPackingList.h            \
          printPackingListBatchByShipvia.h      \
          printPoForm.h                 \
          printToForm.h                 \
          printPurchaseOrder.h          \
          printPurchaseOrdersByAgent.h  \
          printQuote.h                  \
          printRaForm.h                 \
          printShippingForm.h           \
          printShippingForms.h          \
          printSinglecopyDocument.h     \
          printSoForm.h                 \
          printStatementByCustomer.h    \
          printStatementsByCustomerType.h       \
          printVendorForm.h             \
          printWoForm.h                 \
          printWoPickList.h             \
          printWoTraveler.h             \
          productCategories.h           \
          productCategory.h             \
          profitCenter.h                \
          profitCenters.h               \
          project.h                     \
          projects.h                    \
	  projectType.h			\
	  projectTypes.h		\
          prospect.h                    \
          prospects.h                   \
          purchaseOrder.h               \
          purchaseOrderItem.h           \
          purchaseRequest.h             \
          purgeClosedWorkOrders.h       \
          purgeCreditMemos.h            \
          purgeInvoices.h               \
          purgePostedCountSlips.h       \
          purgePostedCounts.h           \
          quickRelocateLot.h            \
          quotes.h                      \
          reasonCode.h                  \
          reasonCodes.h                 \
          reassignClassCodeByClassCode.h        \
          reassignCustomerTypeByCustomerType.h  \
          reassignLotSerial.h                   \
          reassignProductCategoryByProductCategory.h    \
          recallOrders.h                        \
          reconcileBankaccount.h                \
          registrationKey.h                     \
          registrationKeyDialog.h               \
          rejectCode.h                          \
          rejectCodes.h                         \
          relativeCalendarItem.h                \
          releasePlannedOrdersByPlannerCode.h   \
          releaseTransferOrdersByAgent.h        \
          releaseWorkOrdersByPlannerCode.h      \
          relocateInventory.h                   \
          reports.h                             \
          reprintCreditMemos.h                  \
          reprintInvoices.h                     \
          reprintMulticopyDocument.h            \
          reprioritizeWo.h                      \
          reschedulePoitem.h                    \
          rescheduleWo.h                        \
          reserveSalesOrderItem.h               \
          resetQOHBalances.h                    \
          returnAuthCheck.h                     \
          returnAuthItemLotSerial.h             \
          returnAuthorization.h                 \
          returnAuthorizationItem.h             \
          returnAuthorizationWorkbench.h        \
          returnWoMaterialBatch.h               \
          returnWoMaterialItem.h                \
          reverseGLSeries.h                     \
          sale.h                                \
          sales.h                               \
          salesAccount.h                        \
          salesAccounts.h                       \
          salesCategories.h                     \
          salesCategory.h                       \
          salesHistoryInformation.h             \
          salesOrder.h                          \
          salesOrderInformation.h               \
          salesOrderItem.h                      \
          salesOrderSimple.h                    \
          salesRep.h                            \
          salesReps.h                           \
          saleType.h                            \
          saleTypes.h                           \
          scrapTrans.h                          \
          scrapWoMaterialFromWIP.h              \
          scriptablePrivate.h                   \
          scriptEditor.h                        \
          scripts.h                             \
          scripttoolbox.h                       \
          searchForEmp.h                        \
          selectBankAccount.h                   \
          selectBillingQty.h                    \
          selectOrderForBilling.h               \
          selectPayment.h                       \
          selectPayments.h                      \
          selectShippedOrders.h                 \
          selectedPayments.h                    \
          setup.h                               \
          shipOrder.h                           \
          shipTo.h                              \
          shipVia.h                             \
          shipVias.h                            \
          shippingChargeType.h                  \
          shippingChargeTypes.h                 \
          shippingForm.h                        \
          shippingForms.h                       \
          shippingInformation.h                 \
          shippingZone.h                        \
          shippingZones.h                       \
          siteType.h                    \
          siteTypes.h                   \
          splitReceipt.h                \
          standardJournal.h             \
          standardJournalGroup.h        \
          standardJournalGroupItem.h    \
          standardJournalGroups.h       \
          standardJournalItem.h         \
          standardJournals.h            \
          state.h                       \
          states.h                      \
          subAccntType.h                \
          subAccntTypes.h               \
          subaccount.h                  \
          subaccounts.h                 \
          submitAction.h                \
          submitReport.h                \
          substituteList.h              \
          summarizeInvTransByClassCode.h\
          syncCompanies.h               \
          sysLocale.h                   \
          systemMessage.h               \
          task.h                        \
          taxAdjustment.h               \
          taxAssignment.h               \
          taxAssignments.h              \
          taxAuthorities.h              \
          taxAuthority.h                \
          taxBreakdown.h                \
          taxCache.h                    \
          taxClass.h                    \
          taxClasses.h                  \
          taxCode.h                     \
          taxCodeRate.h                 \
          taxCodes.h                    \
          taxDetail.h                   \
          taxRegistration.h             \
          taxRegistrations.h            \
          taxType.h                     \
          taxTypes.h                    \
          taxZone.h                     \
          taxZones.h                    \
          terms.h                       \
          termses.h                     \
          thawItemSitesByClassCode.h    \
          timeoutHandler.h              \
          todoCalendarControl.h         \
          todoItem.h                    \
          todoList.h                    \
          todoListCalendar.h            \
          toggleBankrecCleared.h        \
          toitemTableModel.h            \
          toitemTableView.h             \
          transactionInformation.h      \
          transferOrder.h               \
          transferOrderItem.h           \
          transferOrders.h              \
          transferTrans.h               \
          transformTrans.h              \
          translations.h                \
          uiform.h                      \
          uiformchooser.h               \
          uiforms.h                     \
          unappliedAPCreditMemos.h      \
          unappliedARCreditMemos.h      \
          uninvoicedShipments.h         \
          unpostedCreditMemos.h         \
          unpostedGLTransactions.h      \
          unpostedGlSeries.h            \
          unpostedInvoices.h            \
          unpostedPoReceipts.h          \
          unpostedPurchaseOrders.h      \
          uom.h                         \
          uomConv.h                     \
          uoms.h                        \
          updateABCClass.h              \
          updateActualCostsByClassCode.h        \
          updateActualCostsByItem.h             \
          updateCreditStatusByCustomer.h        \
          updateCycleCountFrequency.h           \
          updateItemSiteLeadTimes.h             \
          updateLateCustCreditStatus.h          \
          updateListPricesByProductCategory.h   \
          updateOUTLevelByItem.h                \
          updateOUTLevels.h                     \
          updateOUTLevelsByClassCode.h          \
          updatePrices.h                        \
          updateReorderLevels.h                 \
          user.h                        \
          userCostingElement.h          \
          userList.h                    \
          userPreferences.h             \
          users.h                       \
          vendor.h                      \
          vendorAddress.h               \
          vendorAddressList.h           \
          vendorPriceList.h             \
          vendorType.h                  \
          vendorTypes.h                 \
          vendors.h                     \
          verisignprocessor.h           \
          version.h                     \
          viewCheckRun.h                \
          voidChecks.h                  \
          voucher.h                     \
          voucherItem.h                 \
          voucherItemDistrib.h          \
          voucherMiscDistrib.h          \
          warehouse.h                   \
          warehouseZone.h               \
          warehouses.h                  \
          woMaterialItem.h              \
          workOrder.h                   \
          workOrderMaterials.h          \
          xTupleDesigner.h              \
          xTupleDesignerActions.h       \
          xabstractconfigure.h          \
          xdateinputdialog.h            \
          xdialog.h                     \
          xdocumentwindow.h             \
          xerrormessage.h               \
          xmainwindow.h                 \
          xmessagebox.h                 \
          xmessageboxmessagehandler.h   \
          xsltMap.h                     \
          xtupleguiclientinterface.h    \
          xuiloader.h                   \
          xwidget.h                     \
          zeroUncountedCountTagsByWarehouse.h \
          printStatementsByCustomerGroup.h

SOURCES = absoluteCalendarItem.cpp              \
          account1099.cpp                       \
          accountNumber.cpp                     \
          accountNumbers.cpp                    \
          accountingPeriod.cpp                  \
          accountingPeriods.cpp                 \
          accountingYearPeriod.cpp              \
          accountingYearPeriods.cpp             \
          addPoComment.cpp                      \
          address.cpp                           \
          addresses.cpp                         \
          adjustmentTrans.cpp                   \
          adjustInvValue.cpp                    \
          allocateARCreditMemo.cpp              \
          allocateReservations.cpp              \
          apAccountAssignment.cpp               \
          apAccountAssignments.cpp              \
          apCreditMemoApplication.cpp           \
          apOpenItem.cpp                        \
          apWorkBench.cpp                       \
          applyAPCreditMemo.cpp                 \
          applyARCreditMemo.cpp                 \
          applyARDiscount.cpp                   \
          applyDiscount.cpp                     \
          arAccountAssignment.cpp               \
          arAccountAssignments.cpp              \
          arCreditMemoApplication.cpp           \
          arOpenItem.cpp                        \
          arWorkBench.cpp                       \
          archRestoreSalesHistory.cpp           \
          assessFinanceCharges.cpp              \
          assignClassCodeToPlannerCode.cpp      \
          assignItemToPlannerCode.cpp           \
          assignLotSerial.cpp                   \
          atlasMap.cpp                          \
          authorizedotnetprocessor.cpp          \
          bankAccount.cpp                       \
          bankAccounts.cpp                      \
          bankAdjustment.cpp                    \
          bankAdjustmentEditList.cpp            \
          bankAdjustmentType.cpp                \
          bankAdjustmentTypes.cpp               \
          bom.cpp                               \
          bomItem.cpp                           \
          bomList.cpp                           \
          budgets.cpp                           \
          buyCard.cpp                           \
          calendar.cpp                          \
          calendars.cpp                         \
          cashReceipt.cpp                       \
          cashReceiptItem.cpp                   \
          cashReceiptMiscDistrib.cpp            \
          cashReceiptsEditList.cpp              \
          changePoitemQty.cpp                   \
          changeWoQty.cpp                       \
          characteristic.cpp                    \
          characteristicPrice.cpp               \
          characteristics.cpp                   \
          check.cpp                             \
          checkFormat.cpp                       \
          checkFormats.cpp                      \
          classCode.cpp                         \
          classCodeTax.cpp                      \
          classCodes.cpp                        \
          closePurchaseOrder.cpp                \
          closeWo.cpp                           \
          commentType.cpp                       \
          commentTypes.cpp                      \
          companies.cpp                         \
          company.cpp                           \
          configauthorizedotnetprocessor.cpp    \
          configcreditcardprocessor.cpp         \
          configcybersourceprocessor.cpp        \
          configureCC.cpp                       \
          configureCRM.cpp                      \
          configureEncryption.cpp               \
          configureGL.cpp                       \
          configureIE.cpp                       \
          configureIM.cpp                       \
          configureMS.cpp                       \
          configurePD.cpp                       \
          configurePO.cpp                       \
          configureSearchPath.cpp               \
          configureSO.cpp                       \
          configureWO.cpp                       \
          confirmAchOK.cpp                      \
          contact.cpp                           \
          contacts.cpp                          \
          contactMerge.cpp                      \
          contract.cpp                          \
          contracts.cpp                         \
          copyBOM.cpp                           \
          copyBudget.cpp                        \
          copyContract.cpp                      \
          copyItem.cpp                          \
          copyPurchaseOrder.cpp                 \
          copyQuote.cpp                         \
          copySalesOrder.cpp                    \
          copyTransferOrder.cpp                 \
          correctProductionPosting.cpp          \
          costCategories.cpp                    \
          costCategory.cpp                      \
          costingElements.cpp                   \
          countSlip.cpp                         \
          countTag.cpp                          \
          countTagList.cpp                      \
          countries.cpp                         \
          country.cpp                           \
          createCountTagsByItem.cpp             \
          createCountTagsByParameterList.cpp    \
          createCycleCountTags.cpp              \
          createInvoices.cpp                    \
          createItemSitesByClassCode.cpp        \
          createLotSerial.cpp                   \
          createPlannedOrdersByItem.cpp         \
          createPlannedOrdersByPlannerCode.cpp  \
          createRecurringInvoices.cpp           \
          createRecurringItems.cpp              \
          createfiscalyear.cpp                  \
          creditCard.cpp                        \
          creditMemo.cpp                        \
          creditMemoEditList.cpp                \
          creditMemoItem.cpp                    \
          creditcardprocessor.cpp               \
          crmaccount.cpp                        \
          crmaccountMerge.cpp                   \
          crmaccountMergePickAccountsPage.cpp   \
          crmaccountMergePickDataPage.cpp       \
          crmaccountMergePickTaskPage.cpp       \
          crmaccountMergePurgePage.cpp          \
          crmaccountMergeResultPage.cpp         \
          crmaccounts.cpp                       \
          currencies.cpp                        \
          currenciesDialog.cpp                  \
          currency.cpp                          \
          currencyConversion.cpp                \
          currencyConversions.cpp               \
          currencySelect.cpp                    \
          custCharacteristicDelegate.cpp        \
          customCommand.cpp                     \
          customCommandArgument.cpp             \
          customCommands.cpp                    \
          customer.cpp                          \
          customerFormAssignment.cpp            \
          customerFormAssignments.cpp           \
          customerGroup.cpp                     \
          customerGroups.cpp                    \
          customerType.cpp                      \
          customerTypeList.cpp                  \
          customerTypes.cpp                     \
          customers.cpp                         \
          cybersourceprocessor.cpp              \
          databaseInformation.cpp               \
          deletePlannedOrder.cpp                \
          deletePlannedOrdersByPlannerCode.cpp  \
          department.cpp                        \
          departments.cpp                       \
          incidentHistory.cpp                   \
          dictionaries.cpp                      \
          display.cpp                           \
          displayTimePhased.cpp                 \
          distributeInventory.cpp               \
          distributeToLocation.cpp              \
          dspAROpenItems.cpp                    \
          dspBankrecHistory.cpp                 \
          dspBillingSelections.cpp              \
          dspCashReceipts.cpp                   \
          dspCheckRegister.cpp                  \
          dspCountSlipEditList.cpp              \
          dspCountTagEditList.cpp               \
          dspCreditCardTransactions.cpp         \
          dspFinancialReport.cpp                \
          dspInvoiceInformation.cpp             \
          dspMRPDetail.cpp                      \
          dspProcesses.cpp                      \
          dspTax1099.cpp                        \
          dspTaxHistory.cpp                     \
          dspTaxReturn.cpp                      \
          duplicateAccountNumbers.cpp           \
          editOwners.cpp                        \
          empGroup.cpp                          \
          empGroups.cpp                         \
          employee.cpp                          \
          employees.cpp                         \
          enterMiscCount.cpp                    \
          enterPoReceipt.cpp                    \
          enterPoReturn.cpp                     \
          enterPoitemReceipt.cpp                \
          enterPoitemReturn.cpp                 \
          errorLog.cpp                          \
          eventManager.cpp                      \
          expenseCategories.cpp                 \
          expenseCategory.cpp                   \
          expenseTrans.cpp                      \
          explodeWo.cpp                         \
          exportData.cpp                        \
          externalCCTransaction.cpp             \
          externalShipping.cpp                  \
          externalShippingList.cpp              \
          externalccprocessor.cpp               \
          failedPostList.cpp                    \
          financialLayout.cpp                   \
          financialLayoutColumns.cpp            \
          financialLayoutGroup.cpp              \
          financialLayoutItem.cpp               \
          financialLayoutSpecial.cpp            \
          financialLayouts.cpp                  \
          firmPlannedOrder.cpp                  \
          firmPlannedOrdersByPlannerCode.cpp    \
          financialReportNotes.cpp              \
          fixACL.cpp                    \
          fixSerial.cpp                 \
          form.cpp                      \
          forms.cpp                     \
          forwardUpdateAccounts.cpp     \
          freightBreakdown.cpp          \
          freightClass.cpp              \
          freightClasses.cpp            \
          getGLDistDate.cpp             \
          getLotInfo.cpp                \
          getscreen.cpp                 \
          glSeries.cpp                  \
          glSeriesItem.cpp              \
          glTransaction.cpp             \
          glTransactionDetail.cpp       \
          group.cpp                     \
          groups.cpp                    \
          guiErrorCheck.cpp             \
          guiclient.cpp                 \
          honorific.cpp                 \
          honorifics.cpp                \
          hotkey.cpp                    \
          hotkeys.cpp                   \
          idleShutdown.cpp              \
          image.cpp                     \
          imageList.cpp                 \
          images.cpp                    \
          implodeWo.cpp                 \
          importData.cpp                \
          incident.cpp                  \
          incidentCategories.cpp        \
          incidentCategory.cpp          \
          incidentPriorities.cpp        \
          incidentPriority.cpp          \
          incidentResolution.cpp        \
          incidentResolutions.cpp       \
          incidentSeverities.cpp        \
          incidentSeverity.cpp          \
          incidentWorkbench.cpp         \
          inputManager.cpp              \
          invoice.cpp                   \
          invoiceItem.cpp               \
          invoiceList.cpp               \
          issueLineToShipping.cpp       \
          issueToShipping.cpp           \
          issueWoMaterialBatch.cpp      \
          issueWoMaterialItem.cpp       \
          item.cpp                      \
          itemAlias.cpp                 \
          itemAvailabilityWorkbench.cpp \
          itemCharacteristicDelegate.cpp\
          itemCost.cpp                  \
          itemGroup.cpp                 \
          itemGroups.cpp                \
          itemImages.cpp                \
          itemListPrice.cpp             \
          itemPricingSchedule.cpp       \
          itemPricingScheduleItem.cpp   \
          itemPricingSchedules.cpp      \
          itemSite.cpp                  \
          itemSites.cpp                 \
          itemSource.cpp                \
          itemSourceList.cpp            \
          itemSourcePrice.cpp           \
          itemSourceSearch.cpp          \
          itemSubstitute.cpp            \
          itemUOM.cpp                   \
          items.cpp                     \
          itemtax.cpp                   \
          jsHighlighter.cpp             \
          labelForm.cpp                 \
          labelForms.cpp                \
          ledgerControl.cpp             \
          listRecurringInvoices.cpp     \
          locales.cpp                   \
          location.cpp                  \
          locations.cpp                 \
          lotSerial.cpp                 \
          lotSerialSequence.cpp         \
          lotSerialSequences.cpp        \
          lotSerialRegistration.cpp     \
          lotSerialUtils.cpp            \
          main.cpp                      \
          maintainBudget.cpp            \
          maintainItemCosts.cpp         \
          maintainShipping.cpp          \
          massExpireComponent.cpp       \
          massReplaceComponent.cpp      \
          materialReceiptTrans.cpp      \
          metasqls.cpp                  \
          menuAccounting.cpp            \
          menuCRM.cpp                   \
          menuInventory.cpp             \
          menuManufacture.cpp           \
          menuProducts.cpp              \
          menuPurchase.cpp              \
          menuSales.cpp                 \
          menuSchedule.cpp              \
          menuSystem.cpp                \
          menuWindow.cpp                \
          miscCheck.cpp                 \
          miscVoucher.cpp               \
          openPurchaseOrder.cpp         \
          openReturnAuthorizations.cpp  \
          openSalesOrders.cpp           \
          openVouchers.cpp              \
          opportunity.cpp               \
          opportunityList.cpp           \
          opportunitySource.cpp         \
          opportunitySources.cpp        \
          opportunityStage.cpp          \
          opportunityStages.cpp         \
          opportunityType.cpp           \
          opportunityTypes.cpp          \
          package.cpp                   \
          packages.cpp                  \
          packingListBatch.cpp          \
          paymentechprocessor.cpp       \
          plannedOrder.cpp              \
          plannerCode.cpp               \
          plannerCodes.cpp              \
          poLiabilityDistrib.cpp        \
          poitemTableModel.cpp          \
          poitemTableView.cpp           \
          postCashReceipts.cpp          \
          postCheck.cpp                 \
          postChecks.cpp                \
          postCostsByClassCode.cpp      \
          postCostsByItem.cpp           \
          postCountSlips.cpp            \
          postCountTags.cpp             \
          postCreditMemos.cpp           \
          postInvoices.cpp                      \
          postJournals.cpp                      \
          postMiscProduction.cpp                \
          postPoReturnCreditMemo.cpp            \
          postProduction.cpp                    \
          postPurchaseOrder.cpp                 \
          postPurchaseOrdersByAgent.cpp         \
          postStandardJournal.cpp               \
          postStandardJournalGroup.cpp          \
          postVouchers.cpp                      \
          poType.cpp                            \
          poTypes.cpp                           \
          prepareCheckRun.cpp                   \
          priceList.cpp                         \
          pricingScheduleAssignment.cpp         \
          pricingScheduleAssignments.cpp        \
          printApOpenItem.cpp                   \
          printArOpenItem.cpp                   \
          printCheck.cpp                        \
          printChecks.cpp                       \
          printChecksReview.cpp                 \
          printChecksReviewEdit.cpp             \
          printCreditMemo.cpp                   \
          printCreditMemos.cpp                  \
          printInvoice.cpp                      \
          printInvoices.cpp                     \
          printItemLabelsByClassCode.cpp        \
          printLabelsByInvoice.cpp              \
          printLabelsByOrder.cpp                \
          printLabelsBySo.cpp                   \
          printLabelsByTo.cpp                   \
          printOptions.cpp                      \
          printMulticopyDocument.cpp            \
          printPackingList.cpp                  \
          printPackingListBatchByShipvia.cpp    \
          printPoForm.cpp                       \
          printToForm.cpp                       \
          printPurchaseOrder.cpp                \
          printPurchaseOrdersByAgent.cpp        \
          printQuote.cpp                        \
          printRaForm.cpp                       \
          printShippingForm.cpp                 \
          printShippingForms.cpp                \
          printSinglecopyDocument.cpp           \
          printSoForm.cpp                       \
          printStatementByCustomer.cpp          \
          printStatementsByCustomerType.cpp     \
          printVendorForm.cpp                   \
          printWoForm.cpp                       \
          printWoPickList.cpp                   \
          printWoTraveler.cpp                   \
          productCategories.cpp                 \
          productCategory.cpp                   \
          profitCenter.cpp                      \
          profitCenters.cpp                     \
          project.cpp                           \
          projects.cpp                          \
          projectType.cpp                       \
          projectTypes.cpp                      \
          prospect.cpp                          \
          prospects.cpp                         \
          purchaseOrder.cpp                     \
          purchaseOrderItem.cpp                 \
          purchaseRequest.cpp                   \
          purgeClosedWorkOrders.cpp             \
          purgeCreditMemos.cpp                  \
          purgeInvoices.cpp                     \
          purgePostedCountSlips.cpp             \
          purgePostedCounts.cpp                 \
          quickRelocateLot.cpp                  \
          quotes.cpp                            \
          reasonCode.cpp                        \
          reasonCodes.cpp                       \
          reassignClassCodeByClassCode.cpp      \
          reassignCustomerTypeByCustomerType.cpp\
          reassignLotSerial.cpp                 \
          reassignProductCategoryByProductCategory.cpp  \
          recallOrders.cpp                      \
          reconcileBankaccount.cpp              \
          registrationKey.cpp                   \
          registrationKeyDialog.cpp             \
          rejectCode.cpp                        \
          rejectCodes.cpp                       \
          relativeCalendarItem.cpp              \
          releasePlannedOrdersByPlannerCode.cpp \
          releaseTransferOrdersByAgent.cpp      \
          releaseWorkOrdersByPlannerCode.cpp    \
          relocateInventory.cpp                 \
          reports.cpp                           \
          reprintCreditMemos.cpp                \
          reprintInvoices.cpp                   \
          reprintMulticopyDocument.cpp          \
          reprioritizeWo.cpp                    \
          reschedulePoitem.cpp                  \
          rescheduleWo.cpp                      \
          reserveSalesOrderItem.cpp             \
          resetQOHBalances.cpp                  \
          returnAuthCheck.cpp                   \
          returnAuthItemLotSerial.cpp           \
          returnAuthorization.cpp               \
          returnAuthorizationItem.cpp           \
          returnAuthorizationWorkbench.cpp      \
          returnWoMaterialBatch.cpp             \
          returnWoMaterialItem.cpp              \
          reverseGLSeries.cpp                   \
          sale.cpp                              \
          sales.cpp                             \
          salesAccount.cpp                      \
          salesAccounts.cpp                     \
          salesCategories.cpp                   \
          salesCategory.cpp                     \
          salesHistoryInformation.cpp           \
          salesOrder.cpp                        \
          salesOrderInformation.cpp             \
          salesOrderItem.cpp                    \
          salesOrderSimple.cpp                  \
          salesRep.cpp                          \
          salesReps.cpp                         \
          saleType.cpp                          \
          saleTypes.cpp                         \
          scrapTrans.cpp                        \
          scrapWoMaterialFromWIP.cpp            \
          scriptablePrivate.cpp                 \
          scriptEditor.cpp                      \
          scripts.cpp                           \
          scripttoolbox.cpp                     \
          searchForEmp.cpp                      \
          selectBankAccount.cpp                 \
          selectBillingQty.cpp                  \
          selectOrderForBilling.cpp             \
          selectPayment.cpp                     \
          selectPayments.cpp                    \
          selectShippedOrders.cpp               \
          selectedPayments.cpp                  \
          setup.cpp                             \
          shipOrder.cpp                         \
          shipTo.cpp                            \
          shipVia.cpp                           \
          shipVias.cpp                          \
          shippingChargeType.cpp                \
          shippingChargeTypes.cpp               \
          shippingForm.cpp                      \
          shippingForms.cpp                     \
          shippingInformation.cpp               \
          shippingZone.cpp                      \
          shippingZones.cpp                     \
          siteType.cpp                          \
          siteTypes.cpp                         \
          splitReceipt.cpp                      \
          standardJournal.cpp                   \
          standardJournalGroup.cpp              \
          standardJournalGroupItem.cpp          \
          standardJournalGroups.cpp             \
          standardJournalItem.cpp               \
          standardJournals.cpp                  \
          state.cpp                             \
          states.cpp                            \
          subAccntType.cpp                      \
          subAccntTypes.cpp                     \
          subaccount.cpp                        \
          subaccounts.cpp                       \
          submitAction.cpp                      \
          submitReport.cpp                      \
          substituteList.cpp                    \
          summarizeInvTransByClassCode.cpp      \
          syncCompanies.cpp                     \
          sysLocale.cpp                         \
          systemMessage.cpp                     \
          task.cpp                              \
          taxAdjustment.cpp                     \
          taxAssignment.cpp                     \
          taxAssignments.cpp                    \
          taxAuthorities.cpp                    \
          taxAuthority.cpp                      \
          taxBreakdown.cpp                      \
          taxCache.cpp                          \
          taxClass.cpp                          \
          taxClasses.cpp                        \
          taxCode.cpp                           \
          taxCodeRate.cpp                       \
          taxCodes.cpp                          \
          taxDetail.cpp                         \
          taxRegistration.cpp                   \
          taxRegistrations.cpp                  \
          taxType.cpp                           \
          taxTypes.cpp                          \
          taxZone.cpp                           \
          taxZones.cpp                          \
          terms.cpp                             \
          termses.cpp                           \
          thawItemSitesByClassCode.cpp          \
          timeoutHandler.cpp                    \
          todoCalendarControl.cpp               \
          todoItem.cpp                          \
          todoList.cpp                          \
          todoListCalendar.cpp                  \
          toggleBankrecCleared.cpp              \
          toitemTableModel.cpp                  \
          toitemTableView.cpp                   \
          transactionInformation.cpp            \
          transferOrder.cpp                     \
          transferOrderItem.cpp                 \
          transferOrders.cpp                    \
          transferTrans.cpp                     \
          transformTrans.cpp                    \
          translations.cpp                      \
          uiform.cpp                            \
          uiformchooser.cpp                     \
          uiforms.cpp                           \
          unappliedAPCreditMemos.cpp            \
          unappliedARCreditMemos.cpp            \
          uninvoicedShipments.cpp               \
          unpostedCreditMemos.cpp               \
          unpostedGLTransactions.cpp            \
          unpostedGlSeries.cpp                  \
          unpostedInvoices.cpp                  \
          unpostedPoReceipts.cpp                \
          unpostedPurchaseOrders.cpp            \
          uom.cpp                               \
          uomConv.cpp                           \
          uoms.cpp                              \
          updateABCClass.cpp                    \
          updateActualCostsByClassCode.cpp      \
          updateActualCostsByItem.cpp           \
          updateCreditStatusByCustomer.cpp      \
          updateCycleCountFrequency.cpp         \
          updateItemSiteLeadTimes.cpp           \
          updateLateCustCreditStatus.cpp        \
          updateListPricesByProductCategory.cpp \
          updateOUTLevelByItem.cpp              \
          updateOUTLevels.cpp                   \
          updateOUTLevelsByClassCode.cpp        \
          updatePrices.cpp                      \
          updateReorderLevels.cpp               \
          user.cpp                              \
          userCostingElement.cpp                \
          userList.cpp                          \
          userPreferences.cpp                   \
          users.cpp                             \
          vendor.cpp                            \
          vendorAddress.cpp                     \
          vendorAddressList.cpp                 \
          vendorPriceList.cpp                   \
          vendorType.cpp                        \
          vendorTypes.cpp                       \
          vendors.cpp                           \
          verisignprocessor.cpp                 \
          version.cpp                           \
          viewCheckRun.cpp                      \
          voidChecks.cpp                        \
          voucher.cpp                           \
          voucherItem.cpp                       \
          voucherItemDistrib.cpp                \
          voucherMiscDistrib.cpp                \
          warehouse.cpp                         \
          warehouseZone.cpp                     \
          warehouses.cpp                        \
          woMaterialItem.cpp                    \
          workOrder.cpp                         \
          workOrderMaterials.cpp                \
          xTupleDesigner.cpp                    \
          xTupleDesignerActions.cpp             \
          xabstractconfigure.cpp                \
          xdateinputdialog.cpp                  \
          xdialog.cpp                           \
          xdocumentwindow.cpp                   \
          xerrormessage.cpp                     \
          xmainwindow.cpp                       \
          xmessagebox.cpp                       \
          xmessageboxmessagehandler.cpp         \
          xsltMap.cpp                           \
          xtupleguiclientinterface.cpp          \
          xuiloader.cpp                         \
          xwidget.cpp                           \
          zeroUncountedCountTagsByWarehouse.cpp \
          printStatementsByCustomerGroup.cpp

include( displays/displays.pri )
include( hunspell.pri )

RESOURCES += guiclient.qrc $${OPENRPT_IMAGE_DIR}/OpenRPTMetaSQL.qrc
