require 'spec_helper'

describe 'collectd::plugin::hugepages', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context 'default' do
        it 'defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin hugepages>
  Globals false
</LoadPlugin>

<Plugin "hugepages">
  ReportPerNodeHP true
  ReportRootHP true
  ValuesPages true
  ValuesBytes false
  ValuesPercentage false
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_file('hugepages.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-hugepages.conf"
          )
        end
      end

      options = os_specific_options(facts)
      context 'all set' do
        let :params do
          {
            'report_per_node_hp' => false,
            'report_root_hp'     => false,
            'values_pages'       => false,
            'values_bytes'       => true,
            'values_percentage'  => true
          }
        end

        it 'overrides defaults' do
          content = <<EOS
# Generated by Puppet
<LoadPlugin hugepages>
  Globals false
</LoadPlugin>

<Plugin "hugepages">
  ReportPerNodeHP false
  ReportRootHP false
  ValuesPages false
  ValuesBytes true
  ValuesPercentage true
</Plugin>

EOS

          is_expected.to compile.with_all_deps
          is_expected.to contain_class('collectd')
          is_expected.to contain_file('hugepages.load').with(
            content: content,
            path: "#{options[:plugin_conf_dir]}/10-hugepages.conf"
          )
        end
      end
    end
  end
end
