---
layout: default
title: Development Team
nav_order: 8
---

# Development Team

Pymatgen has a large community of active developers. It would not be the package it is today without the diligent work
of everyone on this page! This goes from the smallest bug fix to years of contributions.

If you've contributed but your name is missing from this list, please let us know by filling out [this form](https://forms.gle/JnisFb38QDR8QTFTA) so you can be credited appropriately. An always-up-to-date list of `pymatgen` developers can also be found [on GitHub](https://github.com/materialsproject/pymatgen/graphs/contributors).

## Lead Maintainers

| Name             | Position                                                       | 💻 GitHub                                                                           | 🔬 ORCID                                                      | 🌐 Web                                                        |
| ---------------- | -------------------------------------------------------------- | ---------------------------------------------------------------------------------- | ------------------------------------------------------------ | ------------------------------------------------------------ |
| Shyue Ping Ong   | Lead developer, Professor, Department of NanoEngineering, UCSD | [shyuep](https://github.com/shyuep)                                                | [0000-0001-7777-8871](https://orcid.org/0000-0001-5726-2587) | [materialsvirtuallab.org](https://materialsvirtuallab.org)   |
| Matthew Horton   | Senior Software Engineer @ Microsoft Research                  | [mkhorton](https://github.com/mkhorton)                                            | [0000-0001-7777-8871](https://orcid.org/0000-0001-7777-8871) | [linkedin.com/in/mkhorton](https://linkedin.com/in/mkhorton) |
| Janosh Riebesell | University of Cambridge, Materials Project Staff               | [janosh](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:janosh) | [0000-0001-5233-3462](https://orcid.org/0000-0001-5233-3462) | [janosh.dev](https://janosh.dev)                             |

<iframe src="/assets/team-map.html" width="100%" height="500" frameborder="0"></iframe>

## List of Developers (A–Z)

### 4+ years active

| Name                               | Position                                                                                                                   | Github                                                                                                              | Orcid                                                                      |
| ---------------------------------- | -------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------- |
| **Alex Ganose**                    | Lawrence Berkeley National Laboratory                                                                                      | utf [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:utf)                         | [0000-0002-4486-3321 ![orcid logo]](https://orcid.org/0000-0002-4486-3321) |
| **Anubhav Jain**                   | Lawrence Berkeley National Laboratory                                                                                      | computron [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:computron)             | [0000-0001-5893-9967 ![orcid logo]](https://orcid.org/0000-0001-5893-9967) |
| **Bharat Medasani**                | University of Delaware                                                                                                     | mbkumar [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mbkumar)                 | [0000-0002-2073-4162 ![orcid logo]](https://orcid.org/0000-0002-2073-4162) |
| **Chi Chen**                       | University of California, San Diego                                                                                        | chc273 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:chc273)                   |                                                                            |
| **Danny Broberg**                  | Lawrence Berkeley National Laboratory                                                                                      | dbroberg [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dbroberg)               |                                                                            |
| **David Waroquiers**               | Université catholique de Louvain                                                                                           | davidwaroquiers [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:davidwaroquiers) |                                                                            |
| **Donny Winston**                  | Consulting at donnywinston.com                                                                                             | dwinston [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dwinston)               | [0000-0002-8424-0604 ![orcid logo]](https://orcid.org/0000-0002-8424-0604) |
| **Evan Walter Clark Spotte-Smith** | Lawrence Berkeley National Laboratory; University of California, Berkeley                                                  | espottesmith [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:espottesmith)       | [0000-0003-1554-197X ![orcid logo]](https://orcid.org/0000-0003-1554-197X) |
| **Francesco Ricci**                | IMCN/MODL - Université catholique de Louvain                                                                               | fraricci [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:fraricci)               | [0000-0002-2677-7227 ![orcid logo]](https://orcid.org/0000-0002-2677-7227) |
| **Guido Petretto**                 | Université catholique de Louvain                                                                                           | gpetretto [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:gpetretto)             |                                                                            |
| **Janine George**                  | Federal Institute for Materials Research and Testing (BAM), Berlin, Germany. Friedrich-Schiller-Universität Jena, Germany. | JaGeo [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:JaGeo)                     | [0000-0001-8907-0336 ![orcid logo]](https://orcid.org/0000-0001-8907-0336) |
| **Joseph Montoya**                 | Toyota Research Institute                                                                                                  | montoyjh [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:montoyjh)               | [0000-0001-5760-2860 ![orcid logo]](https://orcid.org/0000-0001-5760-2860) |
| **Koki Muraoka**                   | Lawrence Berkeley National Laboratory                                                                                      | kmu [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:kmu)                         | [0000-0003-1830-7978 ![orcid logo]](https://orcid.org/0000-0003-1830-7978) |
| **Matteo Giantomassi**             | Université catholique de Louvain                                                                                           | gmatteo [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:gmatteo)                 |                                                                            |
| **Matthew McDermott**              | Lawrence Berkeley National Laboratory; University of California, Berkeley                                                  | mattmcdermott [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mattmcdermott)     |                                                                            |
| **Nils Zimmermann**                | Parent                                                                                                                     | nisse3000 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:nisse3000)             | [0000-0003-1063-5926 ![orcid logo]](https://orcid.org/0000-0003-1063-5926) |
| **Patrick Huck**                   | Lawrence Berkeley National Laboratory                                                                                      | tschaume [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:tschaume)               |                                                                            |
| **Richard Tran**                   | Carnegie Mellon University                                                                                                 | CifLord [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:CifLord)                 | [0000-0002-0308-2182 ![orcid logo]](https://orcid.org/0000-0002-0308-2182) |
| **Ryan Kingsbury**                 | Lawrence Berkeley National Laboratory                                                                                      | rkingsbury [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:rkingsbury)           | [0000-0002-7168-3967 ![orcid logo]](https://orcid.org/0000-0002-7168-3967) |
| **Salvato-Vallverdu Germain**      | University of Pau and Pays de l'Adour                                                                                      | gVallverdu [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:gVallverdu)           | [0000-0003-1116-8776 ![orcid logo]](https://orcid.org/0000-0003-1116-8776) |
| **Samuel M. Blau**                 | Lawrence Berkeley National Laboratory                                                                                      | samblau [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:samblau)                 | [0000-0003-3132-3032 ![orcid logo]](https://orcid.org/0000-0003-3132-3032) |
| **Shyam Dwaraknath**               | LBL                                                                                                                        | shyamd [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:shyamd)                   | [0000-0003-0289-2607 ![orcid logo]](https://orcid.org/0000-0003-0289-2607) |
| **Tess Smidt**                     | Lawrence Berkeley National Laboratory                                                                                      | blondegeek [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:blondegeek)           | [0000-0001-5581-5344 ![orcid logo]](https://orcid.org/0000-0001-5581-5344) |

### 1–4 years active

| Name                      | Position                                                                                                        | Github                                                                                                                      | Orcid                                                                      |
| ------------------------- | --------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------- |
| **Alex Dunn**             | Lawrence Berkeley National Laboratory; University of California, Berkeley                                       | ardunn [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ardunn)                           | [0000-0002-8567-1879 ![orcid logo]](https://orcid.org/0000-0002-8567-1879) |
| **Alex Epstein**          | University of California, Berkeley; Lawrence Berkeley National Laboratory                                       | arepstein [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:arepstein)                     | [0000-0002-9914-2388 ![orcid logo]](https://orcid.org/0000-0002-9914-2388) |
| **Alexander Bonkowski**   | RWTH Aachen University; Université catholique de Louvain                                                        | ab5424 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ab5424)                           | [0000-0002-0525-4742 ![orcid logo]](https://orcid.org/0000-0002-0525-4742) |
| **Andrew Rosen**          | Department of Chemical & Biological Engineering, Princeton University                                           | Andrew-S-Rosen [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:Andrew-S-Rosen)           | [0000-0002-0141-7006 ![orcid logo]](https://orcid.org/0000-0002-0141-7006) |
| **Ann Rutt**              | University of California Berkeley                                                                               | acrutt [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:acrutt)                           | [0000-0001-6534-454X ![orcid logo]](https://orcid.org/0000-0001-6534-454X) |
| **Benjamin J. Morgan**    | University of Bath                                                                                              | bjmorgan [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:bjmorgan)                       | [0000-0002-3056-8233 ![orcid logo]](https://orcid.org/0000-0002-3056-8233) |
| **Brandon M. Wood**       | Lawrence Berkeley National Laboratory                                                                           | wood-b [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:wood-b)                           | [0000-0002-7251-337X ![orcid logo]](https://orcid.org/0000-0002-7251-337X) |
| **Christian Vorwerk**     | Humboldt-Universität zu Berlin                                                                                  | vorwerkc [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:vorwerkc)                       | [0000-0002-2516-9553 ![orcid logo]](https://orcid.org/0000-0002-2516-9553) |
| **Christopher Stihl**     | Karlsruhe Institute of Technology                                                                               | stichri [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:stichri)                         |                                                                            |
| **Drew Parsons**          | University of Cagliari                                                                                          | drew-parsons [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:drew-parsons)               | [0000-0002-3956-6031 ![orcid logo]](https://orcid.org/0000-0002-3956-6031) |
| **Eric Sivonxay**         | University of California, Berkeley; Lawrence Berkeley National Laboratory                                       | sivonxay [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:sivonxay)                       |                                                                            |
| **Hanmei Tang**           | UC San Diego                                                                                                    | HanmeiTang [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:HanmeiTang)                   | [0000-0003-2659-7768 ![orcid logo]](https://orcid.org/0000-0003-2659-7768) |
| **Henrique Miranda**      | Université catholique de Louvain                                                                                | henriquemiranda [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:henriquemiranda)         | [0000-0002-2843-0876 ![orcid logo]](https://orcid.org/0000-0002-2843-0876) |
| **Jack Sundberg**         | University of North Carolina (Chapel Hill)                                                                      | jacksund [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:jacksund)                       | [0000-0001-5739-8919 ![orcid logo]](https://orcid.org/0000-0001-5739-8919) |
| **Jan Janssen**           | Los Alamos National Laboratory                                                                                  | jan-janssen [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:jan-janssen)                 | [0000-0001-9948-7119 ![orcid logo]](https://orcid.org/0000-0001-9948-7119) |
| **Jason Munro**           | Lawrence Berkeley National Laboratory                                                                           | munrojm [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:munrojm)                         |                                                                            |
| **Jimmy-Xuan Shen**       | Lawrence Livermore National Laboratory                                                                          | munrojm [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:munrojm)                         |                                                                            |
| **Kamal Choudhary**       | National Institute of Standards and Technology                                                                  | knc6 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:knc6)                               | [0000-0001-9737-8074 ![orcid logo]](https://orcid.org/0000-0001-9737-8074) |
| **Ke Liu**                | University of Michigan – Shanghai Jiao Tong University Joint Institute                                          | specter119 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:specter119)                   | [0000-0003-3604-1026 ![orcid logo]](https://orcid.org/0000-0003-3604-1026) |
| **Kiran Mathew**          | nan                                                                                                             | matk86 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:matk86)                           |                                                                            |
| **Kohei Shinohara**       | Kyoto University                                                                                                | lan496 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:lan496)                           |                                                                            |
| **Kristjan Eimre**        | Swiss Federal Laboratories for Materials Science and Technology                                                 | eimrek [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:eimrek)                           | [0000-0002-3444-3286 ![orcid logo]](https://orcid.org/0000-0002-3444-3286) |
| **Mark E. Turiansky**     | University of California, Santa Barbara                                                                         | mturiansky [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mturiansky)                   | [0000-0002-9154-3582 ![orcid logo]](https://orcid.org/0000-0002-9154-3582) |
| **Martin Siron**          | Lawrence Berkeley National Laboratory; University of California, Berkeley                                       | mhsiron [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mhsiron)                         | [0000-0002-4562-7814 ![orcid logo]](https://orcid.org/0000-0002-4562-7814) |
| **Maxwell Dylla**         | Northwestern University                                                                                         | dyllamt [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dyllamt)                         |                                                                            |
| **Michael F. Herbst**     | CERMICS, Inria Paris and École des Ponts ParisTech                                                              | mfherbst [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mfherbst)                       | [0000-0003-0378-7921 ![orcid logo]](https://orcid.org/0000-0003-0378-7921) |
| **Nathan C. Frey**        | University of Pennsylvania                                                                                      | ncfrey [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ncfrey)                           | [0000-0001-5291-6131 ![orcid logo]](https://orcid.org/0000-0001-5291-6131) |
| **Nicholas Winner**       | University of California Berkeley, Lawrence Berkeley National Lab                                               | nwinner [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:nwinner)                         | [0000-0003-3648-3959 ![orcid logo]](https://orcid.org/0000-0003-3648-3959) |
| **Rachel Woods-Robinson** | Lawrence Berkeley National Laboratory; University of California, Berkeley; National Renewable Energy Laboratory | rwoodsrobinson [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:rwoodsrobinson)           | [0000-0001-5009-9510 ![orcid logo]](https://orcid.org/0000-0001-5009-9510) |
| **Rhys Goodall**          | University of Cambridge                                                                                         | CompRhys [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:CompRhys)                       | [0000-0002-6589-1700 ![orcid logo]](https://orcid.org/0000-0002-6589-1700) |
| **Seán R. Kavanagh**      | Materials, Imperial College London; Chemistry, University College London; Thomas Young Centre                   | kavanase [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:kavanase)                       | [0000-0003-4577-9647 ![orcid logo]](https://orcid.org/0000-0003-4577-9647) |
| **Steven Hartman**        | Los Alamos National Laboratory                                                                                  | sthartman [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:sthartman)                     |                                                                            |
| **Steven Torrisi**        | Harvard University                                                                                              | stevetorr [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:stevetorr)                     | [0000-0002-4283-8077 ![orcid logo]](https://orcid.org/0000-0002-4283-8077) |
| **Tingzheng Hou**         | University of California, Berkeley                                                                              | htz1992213 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:htz1992213)                   | [0000-0002-7163-2561 ![orcid logo]](https://orcid.org/0000-0002-7163-2561) |
| **Xiangguo Li**           | University of California, San Diego                                                                             | ucsdlxg [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ucsdlxg)                         | [0000-0002-2062-3809 ![orcid logo]](https://orcid.org/0000-0002-2062-3809) |
| **Xiaohui Qu**            | Brookhaven National Laboratory                                                                                  | xhqu1981 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:xhqu1981)                       | [0000-0001-5651-8405 ![orcid logo]](https://orcid.org/0000-0001-5651-8405) |
| **Yihan Xiao**            | University of California, Berkeley                                                                              | yihanxiao92 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:yihanxiao92)                 | [0000-0002-4409-6898 ![orcid logo]](https://orcid.org/0000-0002-4409-6898) |
| **Yiming Chen**           | University of California, San Diego                                                                             | yimingchen-eng [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:yimingchen-eng)           | [0000-0002-1501-5550 ![orcid logo]](https://orcid.org/0000-0002-1501-5550) |
| **Yu Hsuan Liang**        | University of California, Berkeley                                                                              | welltemperedpaprika [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:welltemperedpaprika) |                                                                            |
| **Yu Kumagai**            | Tokyo Institute of Technology                                                                                   | yuuukuma [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:yuuukuma)                       | [0000-0003-0489-8148 ![orcid logo]](https://orcid.org/0000-0003-0489-8148) |
| **Yuh-Chieh Lin**         | TSMC                                                                                                            | random-var-x [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:random-var-x)               |                                                                            |
| **Zachary M Gibbs**       | California Institute of Technology                                                                              | zacharygibbs [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:zacharygibbs)               |                                                                            |
| **Aakash Naik**           | Federal Institute for Materials Research and Testing (BAM), Berlin, Germany.                                    | naik-aakash [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:naik-aakash)                 | [0000-0002-6071-6786 ![orcid logo]](https://orcid.org/0000-0002-6071-6786) |

### < 1 year active

| Name                         | Position                                                                                                                        | Github                                                                                                              | Orcid                                                                      |
| ---------------------------- | ------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------- |
| **Adam Fekete**              | Université catholique de Louvain                                                                                                | fekad [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:fekad)                     |
| **Adam J. Jackson**          | Scientific Computing Department, Science and Technology Facilities Council, UK                                                  | ajjackson [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ajjackson)             | [0000-0001-5272-6530 ![orcid logo]](https://orcid.org/0000-0001-5272-6530) |
| **Alan Kent Dozier**         | NIOSH                                                                                                                           | adozier [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:adozier)                 |
| **Amanda Wang**              | University of California, Berkeley                                                                                              | awvio [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:awvio)                     |
| **Andrius Merkys**           | Vilnius University Institute of Biotechnology                                                                                   | merkys [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:merkys)                   | [0000-0002-7731-6236 ![orcid logo]](https://orcid.org/0000-0002-7731-6236) |
| **Anjli Patel**              | Stanford University                                                                                                             | anjlip [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:anjlip)                   | [0000-0002-0590-7619 ![orcid logo]](https://orcid.org/0000-0002-0590-7619) |
| **Ayush Gupta**              | University of California, Berkeley                                                                                              | ayushsgupta [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ayushsgupta)         |
| **Benjamin Justus**          | Lawrence Berkeley National Laboratory                                                                                           | bwjustus [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:bwjustus)               |
| **Brandon Bocklund**         | The Pennsylvania State University                                                                                               | bocklund [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:bocklund)               | [0000-0002-3264-8413 ![orcid logo]](https://orcid.org/0000-0002-3264-8413) |
| **Bruno Camino**             | University College London                                                                                                       | bcamino [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:bcamino)                 | [0000-0002-9569-2219 ![orcid logo]](https://orcid.org/0000-0002-9569-2219) |
| **Conrad Cole**              | University of Florida                                                                                                           | darnoceloc [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:darnoceloc)           |
| **Dale Gaines II**           | Northwestern University                                                                                                         | dgaines2 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dgaines2)               | [0000-0001-9280-1240 ![orcid logo]](https://orcid.org/0000-0001-9280-1240) |
| **Daniel Schwalbe-Koda**     | Department of Materials Science and Engineering, Massachusetts Institute of Technology                                          | dskoda [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dskoda)                   | [0000-0001-9176-0854 ![orcid logo]](https://orcid.org/0000-0001-9176-0854) |
| **Dmitry Korotin**           | Institute of Metal Physics, UB RAS                                                                                              | dkorotin [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:dkorotin)               | [0000-0002-4070-2045 ![orcid logo]](https://orcid.org/0000-0002-4070-2045) |
| **Eisuke Kawashima**         | RIKEN                                                                                                                           | e-kwsm [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:e-kwsm)                   |
| **Elizabeth Decolvenaere**   | D. E. Shaw Research                                                                                                             | tallakahath [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:tallakahath)         | [0000-0002-6350-3559 ![orcid logo]](https://orcid.org/0000-0002-6350-3559) |
| **Evgeny Blokhin**           | Tilde Materials Informatics                                                                                                     | blokhin [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:blokhin)                 | [0000-0002-5333-3947 ![orcid logo]](https://orcid.org/0000-0002-5333-3947) |
| **Fanchen Meng**             | Brookhaven National Laboratory                                                                                                  | FCMeng [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:FCMeng)                   |
| **Fanchen Meng**             | Brookhaven National Laboratory                                                                                                  | FCMeng [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:FCMeng)                   |
| **Geoffroy Hautier**         | Université catholique de Louvain                                                                                                | hautierg [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:hautierg)               | [0000-0003-1754-2220 ![orcid logo]](https://orcid.org/0000-0003-1754-2220) |
| **Guy Moore**                | Lawrence Berkeley National Laboratory; University of California, Berkeley                                                       | guymoore13 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:guymoore13)           |
| **Henning Janßen**           | RWTH Aachen; Forschungszentrum Jülich                                                                                           | janssenhenning [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:janssenhenning)   | [0000-0003-3558-9487 ![orcid logo]](https://orcid.org/0000-0003-3558-9487) |
| **Hillary Pan**              | Cornell University                                                                                                              | hillarypan [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:hillarypan)           | [0000-0002-4073-2180 ![orcid logo]](https://orcid.org/0000-0002-4073-2180) |
| **Hongsheng Zhao**           | Hebei Vocational University of Technology and Engineering No. 473, Quannan West Street, Xindu District, Xingtai, Hebei province | hongyi-zhao [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:hongyi-zhao)         |
| **Ioannis Petousis**         | nan                                                                                                                             | petousis [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:petousis)               |
| **Iulia-Oxana Andriuc**      | University of California, Berkeley; Lawrence Berkeley National Laboratory                                                       | oxana-a [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:oxana-a)                 |
| **Janakiraman Balachandran** | Hitachi                                                                                                                         | rambalachandran [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:rambalachandran) |
| **Jens Renè Suckert**        | Friedrich-Schiller-Universität Jena                                                                                             | JRSuckert [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:JRSuckert)             |
| **Jonathan James Denney**    | SUNY Stony Brook                                                                                                                | jonathanjdenney [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:jonathanjdenney) | [0000-0002-7615-997X ![orcid logo]](https://orcid.org/0000-0002-7615-997X) |
| **Josua Vieten**             | ExoMatter GmbH                                                                                                                  | josuav1 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:josuav1)                 | [0000-0002-2060-2039 ![orcid logo]](https://orcid.org/0000-0002-2060-2039) |
| **Kai Pei**                  | Frontier Institute of Science and Technology, Xi'an Jiaotong University; Massachusetts Institute of Technology                  | peikai [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:peikai)                   | [0000-0001-7378-9987 ![orcid logo]](https://orcid.org/0000-0001-7378-9987) |
| **Kevin Maik Jablonka**      | École Polytechnique Fédérale de Lausanne                                                                                        | kjappelbaum [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:kjappelbaum)         | [0000-0003-4894-4660 ![orcid logo]](https://orcid.org/0000-0003-4894-4660) |
| **Kevin Waters**             | Michigan Technological University                                                                                               | kwaters4 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:kwaters4)               |
| **Leopold Talirz**           | Microsoft                                                                                                                       | ltalirz [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ltalirz)                 | [0000-0002-1524-5903 ![orcid logo]](https://orcid.org/0000-0002-1524-5903) |
| **Linda Hung**               | Toyota Research Institute                                                                                                       | LindaHung-TRI [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:LindaHung-TRI)     | [0000-0002-1578-6152 ![orcid logo]](https://orcid.org/0000-0002-1578-6152) |
| **Luis Barroso-Luque**       | University of California, Berkeley                                                                                              | lbluque [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:lbluque)                 |
| **Matthew Evans**            | UCLouvain                                                                                                                       | ml-evs [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ml-evs)                   | [0000-0002-1182-9098 ![orcid logo]](https://orcid.org/0000-0002-1182-9098) |
| **Michael Humbert**          | University of Notre Dame                                                                                                        | mike5603 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mike5603)               | [0000-0003-1966-6382 ![orcid logo]](https://orcid.org/0000-0003-1966-6382) |
| **Michael Wolloch**          | Computational Materials Physics, Faculty of Physics, University of Vienna                                                       | MichaelWolloch [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:MichaelWolloch)   | [0000-0002-3419-5526 ![orcid logo]](https://orcid.org/0000-0002-3419-5526) |
| **Michael Wu**               | University of California, Berkeley                                                                                              | wuxiaohua1011 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:wuxiaohua1011)     |
| **Miguel Dias Costa**        | Centre for Advanced 2D Materials, National University of Singapore                                                              | migueldiascosta [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:migueldiascosta) | [0000-0001-8859-5763 ![orcid logo]](https://orcid.org/0000-0001-8859-5763) |
| **Niclas Heinsdorf**         | Max Planck Institute for Solid State Research                                                                                   | nheinsdorf [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:nheinsdorf)           |
| **Oskar Weser**              | Max Planck Institute for Solid State Research                                                                                   | mcocdawc [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:mcocdawc)               | [0000-0001-5503-1195 ![orcid logo]](https://orcid.org/0000-0001-5503-1195) |
| **Pezhman Zarabadi-Poor**    | Department of Chemistry, University of Bath                                                                                     | pzarabadip [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:pzarabadip)           | [0000-0002-6377-7592 ![orcid logo]](https://orcid.org/0000-0002-6377-7592) |
| **Rachel Kurchin**           | Carnegie Mellon University                                                                                                      | rkurchin [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:rkurchin)               | [0000-0002-2147-4809 ![orcid logo]](https://orcid.org/0000-0002-2147-4809) |
| **Rees Chang**               | Cornell University                                                                                                              | rees-c [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:rees-c)                   |
| **Robert Dickson**           | University of Liverpool                                                                                                         | robertcdickson [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:robertcdickson)   | [0000-0003-3007-808X ![orcid logo]](https://orcid.org/0000-0003-3007-808X) |
| **Saurabh Bajaj**            | Micron Technology Inc.                                                                                                          | saurabh02 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:saurabh02)             |
| **Shreyas Cholia**           | Lawrence Berkeley National Laboratory                                                                                           | shreddd [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:shreddd)                 | [0000-0002-4775-8201 ![orcid logo]](https://orcid.org/0000-0002-4775-8201) |
| **Shuaishuai Yuan**          | McGill University                                                                                                               | ShuaishuaiYuan [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:ShuaishuaiYuan)   | [0000-0001-8999-5814 ![orcid logo]](https://orcid.org/0000-0001-8999-5814) |
| **Steven Zhu**               | UNNC                                                                                                                            | 755452800 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:755452800)             |
| **Sudarshan Vijay**          | University of California, Berkeley                                                                                              | sudarshanv01 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:sudarshanv01)       | [0000-0001-8242-0161 ![orcid logo]](https://orcid.org/0000-0001-8242-0161) |
| **Tam Mayeshiba**            | University of Wisconsin-Madison                                                                                                 | cmgtam [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:cmgtam)                   | [0000-0003-3445-7925 ![orcid logo]](https://orcid.org/0000-0003-3445-7925) |
| **Tim Holme**                | nan                                                                                                                             | bayesfactor [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:bayesfactor)         | [0000-0003-3789-3511 ![orcid logo]](https://orcid.org/0000-0003-3789-3511) |
| **Tonnam Balankura**         | Optum                                                                                                                           | tonnamb [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:tonnamb)                 |
| **Uthpala Herath**           | West Virginia University                                                                                                        | uthpalaherath [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:uthpalaherath)     | [0000-0002-4585-3002 ![orcid logo]](https://orcid.org/0000-0002-4585-3002) |
| **Viet-Anh Ha**              | University of Texas at Austin                                                                                                   | anhhv [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:anhhv)                     | [0000-0002-6665-1274 ![orcid logo]](https://orcid.org/0000-0002-6665-1274) |
| **Weitang Li**               | Tsinghua University                                                                                                             | liwt31 [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:liwt31)                   | [0000-0002-8739-641X ![orcid logo]](https://orcid.org/0000-0002-8739-641X) |
| **Xin Chen**                 | Institute of Applied Physics and Computational Mathematics                                                                      | Bismarrck [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:Bismarrck)             | [0000-0001-9643-0870 ![orcid logo]](https://orcid.org/0000-0001-9643-0870) |
| **Yohei Tamura**             | PKSHA                                                                                                                           | tamuhey [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:tamuhey)                 |
| **Yuta Suzuki**              | High Energy Accelerator Research Organization, SOKENDAI                                                                         | resnant [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:resnant)                 | [0000-0002-0019-4832 ![orcid logo]](https://orcid.org/0000-0002-0019-4832) |
| **Zhenbin Wang**             | University of California, San Diego                                                                                             | zbwang [![github logo]](https://github.com/materialsproject/pymatgen/pulls?q=is:pr+author:zbwang)                   |

## Thanks

Thanks also to:

[adam-kerrigan], [adengz], [albalu], [antonf-ekb], [as2362], [aykol], [benedictsaunders], [bernstei], [cajfisher], [ctoher], [czhengsci], [dcossey014], [dongsenfo], [dynikon], [eantono], [exenGT], [ExpHP], [flaviu-gostin], [frssp], [fyalcin], [gcheon], [gen4438], [GkAntonius], [hmlli], [jdagdelen], [johnson1228], [jonringer], [JosephMontoya-TRI], [JSelf42], [KazMorita], [KirbyBroderick], [kylebystrom], [ldamewood], [leicheng], [Liam-Deacon], [mamachra], [manaslkht], [marcoesters], [mdforti], [miaoliu], [mjwen], [mt-huebsch], [nathan-diodan], [naveensrinivasan], [nawagner], [ndardenne], [nishiyamat], [nkeilbart], [Nokimann], [orionarcher], [penicillin0], [pmla], [Qi-max], [qianchenqc], [rajeshsharma98], [renpj], [RoberTnf], [rpw199912j], [ruixingw], [sdacek], [shaunrong], [smheidrich], [sonium0], [thefrankwan], [Tinaatucsd], [tirkarthi], [tom-wood], [utopianf], [w6ye], [WardLT], [wardsimon], [wmdrichards], [wsyxbcl], [xivh], [yang-ruoxi], [yiming-xu], [YunxingZuo], [Zhuoying], [zooks97]

These are developers who have contributed via GitHub but have not filled out the form linked above.

[adam-kerrigan]: https://github.com/adam-kerrigan
[adengz]: https://github.com/adengz
[albalu]: https://github.com/albalu
[antonf-ekb]: https://github.com/antonf-ekb
[as2362]: https://github.com/as2362
[aykol]: https://github.com/aykol
[benedictsaunders]: https://github.com/benedictsaunders
[bernstei]: https://github.com/bernstei
[cajfisher]: https://github.com/cajfisher
[ctoher]: https://github.com/ctoher
[czhengsci]: https://github.com/czhengsci
[dcossey014]: https://github.com/dcossey014
[dongsenfo]: https://github.com/dongsenfo
[dynikon]: https://github.com/dynikon
[eantono]: https://github.com/eantono
[exenGT]: https://github.com/exenGT
[ExpHP]: https://github.com/ExpHP
[flaviu-gostin]: https://github.com/flaviu-gostin
[frssp]: https://github.com/frssp
[fyalcin]: https://github.com/fyalcin
[gcheon]: https://github.com/gcheon
[gen4438]: https://github.com/gen4438
[GkAntonius]: https://github.com/GkAntonius
[hmlli]: https://github.com/hmlli
[jdagdelen]: https://github.com/jdagdelen
[johnson1228]: https://github.com/johnson1228
[jonringer]: https://github.com/jonringer
[JosephMontoya-TRI]: https://github.com/JosephMontoya-TRI
[JSelf42]: https://github.com/JSelf42
[KazMorita]: https://github.com/KazMorita
[KirbyBroderick]: https://github.com/KirbyBroderick
[kylebystrom]: https://github.com/kylebystrom
[ldamewood]: https://github.com/ldamewood
[leicheng]: https://github.com/leicheng
[Liam-Deacon]: https://github.com/Liam-Deacon
[mamachra]: https://github.com/mamachra
[manaslkht]: https://github.com/manaslkht
[marcoesters]: https://github.com/marcoesters
[mdforti]: https://github.com/mdforti
[miaoliu]: https://github.com/miaoliu
[mjwen]: https://github.com/mjwen
[mt-huebsch]: https://github.com/mt-huebsch
[nathan-diodan]: https://github.com/nathan-diodan
[naveensrinivasan]: https://github.com/naveensrinivasan
[nawagner]: https://github.com/nawagner
[ndardenne]: https://github.com/ndardenne
[nishiyamat]: https://github.com/nishiyamat
[nkeilbart]: https://github.com/nkeilbart
[Nokimann]: https://github.com/Nokimann
[orionarcher]: https://github.com/orionarcher
[penicillin0]: https://github.com/penicillin0
[pmla]: https://github.com/pmla
[Qi-max]: https://github.com/Qi-max
[qianchenqc]: https://github.com/qianchenqc
[rajeshsharma98]: https://github.com/rajeshsharma98
[renpj]: https://github.com/renpj
[RoberTnf]: https://github.com/RoberTnf
[rpw199912j]: https://github.com/rpw199912j
[ruixingw]: https://github.com/ruixingw
[sdacek]: https://github.com/sdacek
[shaunrong]: https://github.com/shaunrong
[smheidrich]: https://github.com/smheidrich
[sonium0]: https://github.com/sonium0
[thefrankwan]: https://github.com/thefrankwan
[Tinaatucsd]: https://github.com/Tinaatucsd
[tirkarthi]: https://github.com/tirkarthi
[tom-wood]: https://github.com/tom-wood
[utopianf]: https://github.com/utopianf
[w6ye]: https://github.com/w6ye
[WardLT]: https://github.com/WardLT
[wardsimon]: https://github.com/wardsimon
[wmdrichards]: https://github.com/wmdrichards
[wsyxbcl]: https://github.com/wsyxbcl
[xivh]: https://github.com/xivh
[yang-ruoxi]: https://github.com/yang-ruoxi
[yiming-xu]: https://github.com/yiming-xu
[YunxingZuo]: https://github.com/YunxingZuo
[Zhuoying]: https://github.com/Zhuoying
[zooks97]: https://github.com/zooks97
[github logo]: https://cdnjs.cloudflare.com/ajax/libs/octicons/8.5.0/svg/mark-github.svg
[orcid logo]: assets/orcid.svg
