"""Check reading of a sample v_sim .ascii file, and I/O consistency"""

from ase.io import read

datafile = """\
Fichier Ni3Au
  1.60800000000000e+01  0.00000000000000e+00  1.60800000000000e+01
  0.00000000000000e+00  0.00000000000000e+00  1.60800000000000e+01
  
!This is a sample atomic file in ascii format
!All lines must contain at most 256 characters
!1st line is arbitrary
!2nd line must contain dxx dyx dyy values
!3rd line must contain dzx dzy dzz values
!All subsequent lines can be comment lines (ignored), i.e.
! empty, containing only blanks, or beginning with ! or with #
!After the mandatory 3 beginning lines, a non comment line must
! contain x y z name, giving the 3 coordinates and the name of the atom
!Please note that the name must contain at most 8 characters (non blank)
!Please also note that real values are in free format
! HOWEVER, (Fortran) format like 1.03D+05 is NOT SUPPORTED
!         and must be written    1.03E+05 (or 1.03e+05) 

  4.02000000000000e+00  4.02000000000000e+00  2.01000000000000e+00  Ni
  4.02000000000000e+00  4.02000000000000e+00  6.03000000000000e+00  Ni
  4.02000000000000e+00  4.02000000000000e+00  1.00500000000000e+01  Ni
  4.02000000000000e+00  4.02000000000000e+00  1.40700000000000e+01  Ni
  4.02000000000000e+00  8.04000000000000e+00  2.01000000000000e+00  Ni
  4.02000000000000e+00  8.04000000000000e+00  6.03000000000000e+00  Ni
  4.02000000000000e+00  8.04000000000000e+00  1.00500000000000e+01  Ni
  4.02000000000000e+00  8.04000000000000e+00  1.40700000000000e+01  Ni
  4.02000000000000e+00  1.20600000000000e+01  2.01000000000000e+00  Ni
  4.02000000000000e+00  1.20600000000000e+01  6.03000000000000e+00  Ni
  4.02000000000000e+00  1.20600000000000e+01  1.00500000000000e+01  Ni
  4.02000000000000e+00  1.20600000000000e+01  1.40700000000000e+01  Ni
  8.04000000000000e+00  4.02000000000000e+00  2.01000000000000e+00  Ni
  8.04000000000000e+00  4.02000000000000e+00  6.03000000000000e+00  Ni
  8.04000000000000e+00  4.02000000000000e+00  1.00500000000000e+01  Ni
  8.04000000000000e+00  4.02000000000000e+00  1.40700000000000e+01  Ni
  8.04000000000000e+00  8.04000000000000e+00  2.01000000000000e+00  Ni
  8.04000000000000e+00  8.04000000000000e+00  6.03000000000000e+00  Ni
  8.04000000000000e+00  8.04000000000000e+00  1.00500000000000e+01  Ni
  8.04000000000000e+00  8.04000000000000e+00  1.40700000000000e+01  Ni
  8.04000000000000e+00  1.20600000000000e+01  2.01000000000000e+00  Ni
  8.04000000000000e+00  1.20600000000000e+01  6.03000000000000e+00  Ni
  8.04000000000000e+00  1.20600000000000e+01  1.00500000000000e+01  Ni
  8.04000000000000e+00  1.20600000000000e+01  1.40700000000000e+01  Ni
  1.20600000000000e+01  4.02000000000000e+00  2.01000000000000e+00  Ni
  1.20600000000000e+01  4.02000000000000e+00  6.03000000000000e+00  Ni
  1.20600000000000e+01  4.02000000000000e+00  1.00500000000000e+01  Ni
  1.20600000000000e+01  4.02000000000000e+00  1.40700000000000e+01  Ni
  1.20600000000000e+01  8.04000000000000e+00  2.01000000000000e+00  Ni
  1.20600000000000e+01  8.04000000000000e+00  6.03000000000000e+00  Ni
  1.20600000000000e+01  8.04000000000000e+00  1.00500000000000e+01  Ni
  1.20600000000000e+01  8.04000000000000e+00  1.40700000000000e+01  Ni
  1.20600000000000e+01  1.20600000000000e+01  2.01000000000000e+00  Ni
  1.20600000000000e+01  1.20600000000000e+01  6.03000000000000e+00  Ni
  1.20600000000000e+01  1.20600000000000e+01  1.00500000000000e+01  Ni
  1.20600000000000e+01  1.20600000000000e+01  1.40700000000000e+01  Ni
  2.01000000000000e+00  4.02000000000000e+00  4.02000000000000e+00  Ni
  2.01000000000000e+00  4.02000000000000e+00  8.04000000000000e+00  Ni
  2.01000000000000e+00  4.02000000000000e+00  1.20600000000000e+01  Ni
  2.01000000000000e+00  8.04000000000000e+00  4.02000000000000e+00  Ni
  2.01000000000000e+00  8.04000000000000e+00  8.04000000000000e+00  Ni
  2.01000000000000e+00  8.04000000000000e+00  1.20600000000000e+01  Ni
  2.01000000000000e+00  1.20600000000000e+01  4.02000000000000e+00  Ni
  2.01000000000000e+00  1.20600000000000e+01  8.04000000000000e+00  Ni
  2.01000000000000e+00  1.20600000000000e+01  1.20600000000000e+01  Ni
  6.03000000000000e+00  4.02000000000000e+00  4.02000000000000e+00  Ni
  6.03000000000000e+00  4.02000000000000e+00  8.04000000000000e+00  Ni
  6.03000000000000e+00  4.02000000000000e+00  1.20600000000000e+01  Ni
  6.03000000000000e+00  8.04000000000000e+00  4.02000000000000e+00  Ni
  6.03000000000000e+00  8.04000000000000e+00  8.04000000000000e+00  Ni
  6.03000000000000e+00  8.04000000000000e+00  1.20600000000000e+01  Ni
  6.03000000000000e+00  1.20600000000000e+01  4.02000000000000e+00  Ni
  6.03000000000000e+00  1.20600000000000e+01  8.04000000000000e+00  Ni
  6.03000000000000e+00  1.20600000000000e+01  1.20600000000000e+01  Ni
  1.00500000000000e+01  4.02000000000000e+00  4.02000000000000e+00  Ni
  1.00500000000000e+01  4.02000000000000e+00  8.04000000000000e+00  Ni
  1.00500000000000e+01  4.02000000000000e+00  1.20600000000000e+01  Ni
  1.00500000000000e+01  8.04000000000000e+00  4.02000000000000e+00  Ni
  1.00500000000000e+01  8.04000000000000e+00  8.04000000000000e+00  Ni
  1.00500000000000e+01  8.04000000000000e+00  1.20600000000000e+01  Ni
  1.00500000000000e+01  1.20600000000000e+01  4.02000000000000e+00  Ni
  1.00500000000000e+01  1.20600000000000e+01  8.04000000000000e+00  Ni
  1.00500000000000e+01  1.20600000000000e+01  1.20600000000000e+01  Ni
  1.40700000000000e+01  4.02000000000000e+00  4.02000000000000e+00  Ni
  1.40700000000000e+01  4.02000000000000e+00  8.04000000000000e+00  Ni
  1.40700000000000e+01  4.02000000000000e+00  1.20600000000000e+01  Ni
  1.40700000000000e+01  8.04000000000000e+00  4.02000000000000e+00  Ni
  1.40700000000000e+01  8.04000000000000e+00  8.04000000000000e+00  Ni
  1.40700000000000e+01  8.04000000000000e+00  1.20600000000000e+01  Ni
  1.40700000000000e+01  1.20600000000000e+01  4.02000000000000e+00  Ni
  1.40700000000000e+01  1.20600000000000e+01  8.04000000000000e+00  Ni
  1.40700000000000e+01  1.20600000000000e+01  1.20600000000000e+01  Ni
  4.02000000000000e+00  2.01000000000000e+00  4.02000000000000e+00  Ni
  4.02000000000000e+00  2.01000000000000e+00  8.04000000000000e+00  Ni
  4.02000000000000e+00  2.01000000000000e+00  1.20600000000000e+01  Ni
  4.02000000000000e+00  6.03000000000000e+00  4.02000000000000e+00  Ni
  4.02000000000000e+00  6.03000000000000e+00  8.04000000000000e+00  Ni
  4.02000000000000e+00  6.03000000000000e+00  1.20600000000000e+01  Ni
  4.02000000000000e+00  1.00500000000000e+01  4.02000000000000e+00  Ni
  4.02000000000000e+00  1.00500000000000e+01  8.04000000000000e+00  Ni
  4.02000000000000e+00  1.00500000000000e+01  1.20600000000000e+01  Ni
  4.02000000000000e+00  1.40700000000000e+01  4.02000000000000e+00  Ni
  4.02000000000000e+00  1.40700000000000e+01  8.04000000000000e+00  Ni
  4.02000000000000e+00  1.40700000000000e+01  1.20600000000000e+01  Ni
  8.04000000000000e+00  2.01000000000000e+00  4.02000000000000e+00  Ni
  8.04000000000000e+00  2.01000000000000e+00  8.04000000000000e+00  Ni
  8.04000000000000e+00  2.01000000000000e+00  1.20600000000000e+01  Ni
  8.04000000000000e+00  6.03000000000000e+00  4.02000000000000e+00  Ni
  8.04000000000000e+00  6.03000000000000e+00  8.04000000000000e+00  Ni
  8.04000000000000e+00  6.03000000000000e+00  1.20600000000000e+01  Ni
  8.04000000000000e+00  1.00500000000000e+01  4.02000000000000e+00  Ni
  8.04000000000000e+00  1.00500000000000e+01  8.04000000000000e+00  Ni
  8.04000000000000e+00  1.00500000000000e+01  1.20600000000000e+01  Ni
  8.04000000000000e+00  1.40700000000000e+01  4.02000000000000e+00  Ni
  8.04000000000000e+00  1.40700000000000e+01  8.04000000000000e+00  Ni
  8.04000000000000e+00  1.40700000000000e+01  1.20600000000000e+01  Ni
  1.20600000000000e+01  2.01000000000000e+00  4.02000000000000e+00  Ni
  1.20600000000000e+01  2.01000000000000e+00  8.04000000000000e+00  Ni
  1.20600000000000e+01  2.01000000000000e+00  1.20600000000000e+01  Ni
  1.20600000000000e+01  6.03000000000000e+00  4.02000000000000e+00  Ni
  1.20600000000000e+01  6.03000000000000e+00  8.04000000000000e+00  Ni
  1.20600000000000e+01  6.03000000000000e+00  1.20600000000000e+01  Ni
  1.20600000000000e+01  1.00500000000000e+01  4.02000000000000e+00  Ni
  1.20600000000000e+01  1.00500000000000e+01  8.04000000000000e+00  Ni
  1.20600000000000e+01  1.00500000000000e+01  1.20600000000000e+01  Ni
  1.20600000000000e+01  1.40700000000000e+01  4.02000000000000e+00  Ni
  1.20600000000000e+01  1.40700000000000e+01  8.04000000000000e+00  Ni
  1.20600000000000e+01  1.40700000000000e+01  1.20600000000000e+01  Ni
  2.01000000000000e+00  2.01000000000000e+00  2.01000000000000e+00  Au
  2.01000000000000e+00  2.01000000000000e+00  6.03000000000000e+00  Au
  2.01000000000000e+00  2.01000000000000e+00  1.00500000000000e+01  Au
  2.01000000000000e+00  2.01000000000000e+00  1.40700000000000e+01  Au
  2.01000000000000e+00  6.03000000000000e+00  2.01000000000000e+00  Au
  2.01000000000000e+00  6.03000000000000e+00  6.03000000000000e+00  Au
  2.01000000000000e+00  6.03000000000000e+00  1.00500000000000e+01  Au
  2.01000000000000e+00  6.03000000000000e+00  1.40700000000000e+01  Au
  2.01000000000000e+00  1.00500000000000e+01  2.01000000000000e+00  Au
  2.01000000000000e+00  1.00500000000000e+01  6.03000000000000e+00  Au
  2.01000000000000e+00  1.00500000000000e+01  1.00500000000000e+01  Au
  2.01000000000000e+00  1.00500000000000e+01  1.40700000000000e+01  Au
  2.01000000000000e+00  1.40700000000000e+01  2.01000000000000e+00  Au
  2.01000000000000e+00  1.40700000000000e+01  6.03000000000000e+00  Au
  2.01000000000000e+00  1.40700000000000e+01  1.00500000000000e+01  Au
  2.01000000000000e+00  1.40700000000000e+01  1.40700000000000e+01  Au
  6.03000000000000e+00  2.01000000000000e+00  2.01000000000000e+00  Au
  6.03000000000000e+00  2.01000000000000e+00  6.03000000000000e+00  Au
  6.03000000000000e+00  2.01000000000000e+00  1.00500000000000e+01  Au
  6.03000000000000e+00  2.01000000000000e+00  1.40700000000000e+01  Au
  6.03000000000000e+00  6.03000000000000e+00  2.01000000000000e+00  Au
  6.03000000000000e+00  6.03000000000000e+00  6.03000000000000e+00  Au
  6.03000000000000e+00  6.03000000000000e+00  1.00500000000000e+01  Au
  6.03000000000000e+00  6.03000000000000e+00  1.40700000000000e+01  Au
  6.03000000000000e+00  1.00500000000000e+01  2.01000000000000e+00  Au
  6.03000000000000e+00  1.00500000000000e+01  6.03000000000000e+00  Au
  6.03000000000000e+00  1.00500000000000e+01  1.00500000000000e+01  Au
  6.03000000000000e+00  1.00500000000000e+01  1.40700000000000e+01  Au
  6.03000000000000e+00  1.40700000000000e+01  2.01000000000000e+00  Au
  6.03000000000000e+00  1.40700000000000e+01  6.03000000000000e+00  Au
  6.03000000000000e+00  1.40700000000000e+01  1.00500000000000e+01  Au
  6.03000000000000e+00  1.40700000000000e+01  1.40700000000000e+01  Au
  1.00500000000000e+01  2.01000000000000e+00  2.01000000000000e+00  Au
  1.00500000000000e+01  2.01000000000000e+00  6.03000000000000e+00  Au
  1.00500000000000e+01  2.01000000000000e+00  1.00500000000000e+01  Au
  1.00500000000000e+01  2.01000000000000e+00  1.40700000000000e+01  Au
  1.00500000000000e+01  6.03000000000000e+00  2.01000000000000e+00  Au
  1.00500000000000e+01  6.03000000000000e+00  6.03000000000000e+00  Au
  1.00500000000000e+01  6.03000000000000e+00  1.00500000000000e+01  Au
  1.00500000000000e+01  6.03000000000000e+00  1.40700000000000e+01  Au
  1.00500000000000e+01  1.00500000000000e+01  2.01000000000000e+00  Au
  1.00500000000000e+01  1.00500000000000e+01  6.03000000000000e+00  Au
  1.00500000000000e+01  1.00500000000000e+01  1.00500000000000e+01  Au
  1.00500000000000e+01  1.00500000000000e+01  1.40700000000000e+01  Au
  1.00500000000000e+01  1.40700000000000e+01  2.01000000000000e+00  Au
  1.00500000000000e+01  1.40700000000000e+01  6.03000000000000e+00  Au
  1.00500000000000e+01  1.40700000000000e+01  1.00500000000000e+01  Au
  1.00500000000000e+01  1.40700000000000e+01  1.40700000000000e+01  Au
  1.40700000000000e+01  2.01000000000000e+00  2.01000000000000e+00  Au
  1.40700000000000e+01  2.01000000000000e+00  6.03000000000000e+00  Au
  1.40700000000000e+01  2.01000000000000e+00  1.00500000000000e+01  Au
  1.40700000000000e+01  2.01000000000000e+00  1.40700000000000e+01  Au
  1.40700000000000e+01  6.03000000000000e+00  2.01000000000000e+00  Au
  1.40700000000000e+01  6.03000000000000e+00  6.03000000000000e+00  Au
  1.40700000000000e+01  6.03000000000000e+00  1.00500000000000e+01  Au
  1.40700000000000e+01  6.03000000000000e+00  1.40700000000000e+01  Au
  1.40700000000000e+01  1.00500000000000e+01  2.01000000000000e+00  Au
  1.40700000000000e+01  1.00500000000000e+01  6.03000000000000e+00  Au
  1.40700000000000e+01  1.00500000000000e+01  1.00500000000000e+01  Au
  1.40700000000000e+01  1.00500000000000e+01  1.40700000000000e+01  Au
  1.40700000000000e+01  1.40700000000000e+01  2.01000000000000e+00  Au
  1.40700000000000e+01  1.40700000000000e+01  6.03000000000000e+00  Au
  1.40700000000000e+01  1.40700000000000e+01  1.00500000000000e+01  Au
  1.40700000000000e+01  1.40700000000000e+01  1.40700000000000e+01  Au
"""


def test_v_sim():
    fname = 'demo.ascii'
    copy = 'demo2.ascii'

    with open(fname, 'w') as fd:
        fd.write(datafile)

    atoms = read(fname, format='v-sim')

    atoms.write(copy)
    atoms2 = read(copy)

    tol = 1e-6
    assert sum(abs((atoms.positions - atoms2.positions).ravel())) < tol
    assert sum(abs((atoms.cell - atoms2.cell).ravel())) < tol
