# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse

from .. import models


class QueryOperations(object):
    """QueryOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config

    def execute(
            self, app_id, body, custom_headers=None, raw=False, **operation_config):
        """Execute an Analytics query.

        Executes an Analytics query for data.
        [Here](https://dev.applicationinsights.io/documentation/Using-the-API/Query)
        is an example for using POST with an Analytics query.

        :param app_id: ID of the application. This is Application ID from the
         API Access settings blade in the Azure portal.
        :type app_id: str
        :param body: The Analytics query. Learn more about the [Analytics
         query
         syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/)
        :type body: ~azure.applicationinsights.models.QueryBody
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: QueryResults or ClientRawResponse if raw=true
        :rtype: ~azure.applicationinsights.models.QueryResults or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.applicationinsights.models.ErrorResponseException>`
        """
        # Construct URL
        url = self.execute.metadata['url']
        path_format_arguments = {
            'appId': self._serialize.url("app_id", app_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        body_content = self._serialize.body(body, 'QueryBody')

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise models.ErrorResponseException(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('QueryResults', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    execute.metadata = {'url': '/apps/{appId}/query'}
