# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class APIError(Model):
    """Error information returned by the API.

    :param error:
    :type error: ~azure.cognitiveservices.vision.contentmoderator.models.Error
    """

    _attribute_map = {
        'error': {'key': 'Error', 'type': 'Error'},
    }

    def __init__(self, **kwargs):
        super(APIError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class APIErrorException(HttpOperationError):
    """Server responsed with exception of type: 'APIError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(APIErrorException, self).__init__(deserialize, response, 'APIError', *args)


class Address(Model):
    """Address details.

    :param text: Detected Address.
    :type text: str
    :param index: Index(Location) of the Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Address, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.index = kwargs.get('index', None)


class Body(Model):
    """Body.

    :param name: Name of the list.
    :type name: str
    :param description: Description of the list.
    :type description: str
    :param metadata: Metadata of the list.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Body, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.metadata = kwargs.get('metadata', None)


class BodyModel(Model):
    """BodyModel.

    :param data_representation:  Default value: "URL" .
    :type data_representation: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'data_representation': {'key': 'DataRepresentation', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BodyModel, self).__init__(**kwargs)
        self.data_representation = kwargs.get('data_representation', "URL")
        self.value = kwargs.get('value', None)


class Candidate(Model):
    """OCR candidate text.

    :param text: The text found.
    :type text: str
    :param confidence: The confidence level.
    :type confidence: float
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'confidence': {'key': 'Confidence', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(Candidate, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.confidence = kwargs.get('confidence', None)


class Classification(Model):
    """The classification details of the text.

    :param category1: The category1 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category1:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory1
    :param category2: The category2 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category2:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory2
    :param category3: The category3 score details of the text. <a
     href="https://aka.ms/textClassifyCategories">Click here</a> for more
     details on category classification.
    :type category3:
     ~azure.cognitiveservices.vision.contentmoderator.models.ClassificationCategory3
    :param review_recommended: The review recommended flag.
    :type review_recommended: bool
    """

    _attribute_map = {
        'category1': {'key': 'Category1', 'type': 'ClassificationCategory1'},
        'category2': {'key': 'Category2', 'type': 'ClassificationCategory2'},
        'category3': {'key': 'Category3', 'type': 'ClassificationCategory3'},
        'review_recommended': {'key': 'ReviewRecommended', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Classification, self).__init__(**kwargs)
        self.category1 = kwargs.get('category1', None)
        self.category2 = kwargs.get('category2', None)
        self.category3 = kwargs.get('category3', None)
        self.review_recommended = kwargs.get('review_recommended', None)


class ClassificationCategory1(Model):
    """The category1 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category1 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClassificationCategory1, self).__init__(**kwargs)
        self.score = kwargs.get('score', None)


class ClassificationCategory2(Model):
    """The category2 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category2 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClassificationCategory2, self).__init__(**kwargs)
        self.score = kwargs.get('score', None)


class ClassificationCategory3(Model):
    """The category3 score details of the text. <a
    href="https://aka.ms/textClassifyCategories">Click here</a> for more
    details on category classification.

    :param score: The category3 score.
    :type score: float
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ClassificationCategory3, self).__init__(**kwargs)
        self.score = kwargs.get('score', None)


class Content(Model):
    """Content.

    All required parameters must be populated in order to send to Azure.

    :param content_value: Required. Content to evaluate for a job.
    :type content_value: str
    """

    _validation = {
        'content_value': {'required': True},
    }

    _attribute_map = {
        'content_value': {'key': 'ContentValue', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Content, self).__init__(**kwargs)
        self.content_value = kwargs.get('content_value', None)


class CreateReviewBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of the content. Possible values include:
     'Image', 'Text'
    :type type: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param content: Required. Content to review.
    :type content: str
    :param content_id: Required. Content Identifier.
    :type content_id: str
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateReviewBodyItemMetadataItem]
    """

    _validation = {
        'type': {'required': True},
        'content': {'required': True},
        'content_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[CreateReviewBodyItemMetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(CreateReviewBodyItem, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.content = kwargs.get('content', None)
        self.content_id = kwargs.get('content_id', None)
        self.callback_endpoint = kwargs.get('callback_endpoint', None)
        self.metadata = kwargs.get('metadata', None)


class CreateReviewBodyItemMetadataItem(Model):
    """CreateReviewBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateReviewBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class CreateVideoReviewsBodyItem(Model):
    """Schema items of the body.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param video_frames: Optional metadata details.
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemMetadataItem]
    :ivar type: Required. Type of the content. Default value: "Video" .
    :vartype type: str
    :param content: Required. Video content url to review.
    :type content: str
    :param content_id: Required. Content Identifier.
    :type content_id: str
    :param status: Required. Status of the
     video(Complete,Unpublished,Pending). Possible values include: 'Complete',
     'Unpublished', 'Pending'
    :type status: str or
     ~azure.cognitiveservices.vision.contentmoderator.models.enum
    :param timescale: Timescale of the video.
    :type timescale: int
    :param callback_endpoint: Optional CallbackEndpoint.
    :type callback_endpoint: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'content': {'required': True},
        'content_id': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'video_frames': {'key': 'VideoFrames', 'type': '[CreateVideoReviewsBodyItemVideoFramesItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemMetadataItem]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'timescale': {'key': 'Timescale', 'type': 'int'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    type = "Video"

    def __init__(self, **kwargs):
        super(CreateVideoReviewsBodyItem, self).__init__(**kwargs)
        self.video_frames = kwargs.get('video_frames', None)
        self.metadata = kwargs.get('metadata', None)
        self.content = kwargs.get('content', None)
        self.content_id = kwargs.get('content_id', None)
        self.status = kwargs.get('status', None)
        self.timescale = kwargs.get('timescale', None)
        self.callback_endpoint = kwargs.get('callback_endpoint', None)


class CreateVideoReviewsBodyItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateVideoReviewsBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class CreateVideoReviewsBodyItemVideoFramesItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItem.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Id of the frame.
    :type id: str
    :param timestamp: Required. Timestamp of the frame.
    :type timestamp: int
    :param frame_image: Required. Frame image Url.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'timestamp': {'key': 'Timestamp', 'type': 'int'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[CreateVideoReviewsBodyItemVideoFramesItemMetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(CreateVideoReviewsBodyItemVideoFramesItem, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.timestamp = kwargs.get('timestamp', None)
        self.frame_image = kwargs.get('frame_image', None)
        self.reviewer_result_tags = kwargs.get('reviewer_result_tags', None)
        self.metadata = kwargs.get('metadata', None)


class CreateVideoReviewsBodyItemVideoFramesItemMetadataItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateVideoReviewsBodyItemVideoFramesItemMetadataItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem(Model):
    """CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateVideoReviewsBodyItemVideoFramesItemReviewerResultTagsItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class DetectedLanguage(Model):
    """Detect language result.

    :param detected_language: The detected language.
    :type detected_language: str
    :param status: The detect language status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    """

    _attribute_map = {
        'detected_language': {'key': 'DetectedLanguage', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DetectedLanguage, self).__init__(**kwargs)
        self.detected_language = kwargs.get('detected_language', None)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class DetectedTerms(Model):
    """Detected Terms details.

    :param index: Index(Location) of the detected profanity term in the input
     text content.
    :type index: int
    :param original_index: Original Index(Location) of the detected profanity
     term in the input text content.
    :type original_index: int
    :param list_id: Matched Terms list Id.
    :type list_id: int
    :param term: Detected profanity term.
    :type term: str
    """

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'original_index': {'key': 'OriginalIndex', 'type': 'int'},
        'list_id': {'key': 'ListId', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DetectedTerms, self).__init__(**kwargs)
        self.index = kwargs.get('index', None)
        self.original_index = kwargs.get('original_index', None)
        self.list_id = kwargs.get('list_id', None)
        self.term = kwargs.get('term', None)


class Email(Model):
    """Email Address details.

    :param detected: Detected Email Address from the input text content.
    :type detected: str
    :param sub_type: Subtype of the detected Email Address.
    :type sub_type: str
    :param text: Email Address in the input text content.
    :type text: str
    :param index: Index(Location) of the Email address in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'detected': {'key': 'Detected', 'type': 'str'},
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Email, self).__init__(**kwargs)
        self.detected = kwargs.get('detected', None)
        self.sub_type = kwargs.get('sub_type', None)
        self.text = kwargs.get('text', None)
        self.index = kwargs.get('index', None)


class Error(Model):
    """Error body.

    :param code:
    :type code: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Evaluate(Model):
    """Evaluate response object.

    :param cache_id: The cache id.
    :type cache_id: str
    :param result: Evaluate result.
    :type result: bool
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param adult_classification_score: The adult classification score.
    :type adult_classification_score: float
    :param is_image_adult_classified: Indicates if an image is classified as
     adult.
    :type is_image_adult_classified: bool
    :param racy_classification_score: The racy classification score.
    :type racy_classification_score: float
    :param is_image_racy_classified: Indicates if the image is classified as
     racy.
    :type is_image_racy_classified: bool
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'adult_classification_score': {'key': 'AdultClassificationScore', 'type': 'float'},
        'is_image_adult_classified': {'key': 'IsImageAdultClassified', 'type': 'bool'},
        'racy_classification_score': {'key': 'RacyClassificationScore', 'type': 'float'},
        'is_image_racy_classified': {'key': 'IsImageRacyClassified', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, **kwargs):
        super(Evaluate, self).__init__(**kwargs)
        self.cache_id = kwargs.get('cache_id', None)
        self.result = kwargs.get('result', None)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.adult_classification_score = kwargs.get('adult_classification_score', None)
        self.is_image_adult_classified = kwargs.get('is_image_adult_classified', None)
        self.racy_classification_score = kwargs.get('racy_classification_score', None)
        self.is_image_racy_classified = kwargs.get('is_image_racy_classified', None)
        self.advanced_info = kwargs.get('advanced_info', None)
        self.status = kwargs.get('status', None)


class Face(Model):
    """Coordinates to the found face.

    :param bottom: The bottom coordinate.
    :type bottom: int
    :param left: The left coordinate.
    :type left: int
    :param right: The right coordinate.
    :type right: int
    :param top: The top coordinate.
    :type top: int
    """

    _attribute_map = {
        'bottom': {'key': 'Bottom', 'type': 'int'},
        'left': {'key': 'Left', 'type': 'int'},
        'right': {'key': 'Right', 'type': 'int'},
        'top': {'key': 'Top', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Face, self).__init__(**kwargs)
        self.bottom = kwargs.get('bottom', None)
        self.left = kwargs.get('left', None)
        self.right = kwargs.get('right', None)
        self.top = kwargs.get('top', None)


class FoundFaces(Model):
    """Request object the contains found faces.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param result: True if result was found.
    :type result: bool
    :param count: Number of faces found.
    :type count: int
    :param advanced_info: The advanced info.
    :type advanced_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param faces: The list of faces.
    :type faces:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Face]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'result': {'key': 'Result', 'type': 'bool'},
        'count': {'key': 'Count', 'type': 'int'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[KeyValuePair]'},
        'faces': {'key': 'Faces', 'type': '[Face]'},
    }

    def __init__(self, **kwargs):
        super(FoundFaces, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.cache_id = kwargs.get('cache_id', None)
        self.result = kwargs.get('result', None)
        self.count = kwargs.get('count', None)
        self.advanced_info = kwargs.get('advanced_info', None)
        self.faces = kwargs.get('faces', None)


class Frame(Model):
    """Video frame property details.

    :param timestamp: Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Frame image.
    :type frame_image: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param reviewer_result_tags: Reviewer result tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Tag]
    """

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[Tag]'},
    }

    def __init__(self, **kwargs):
        super(Frame, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)
        self.frame_image = kwargs.get('frame_image', None)
        self.metadata = kwargs.get('metadata', None)
        self.reviewer_result_tags = kwargs.get('reviewer_result_tags', None)


class Frames(Model):
    """The response for a Get Frames request.

    :param review_id: Id of the review.
    :type review_id: str
    :param video_frames:
    :type video_frames:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Frame]
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'video_frames': {'key': 'VideoFrames', 'type': '[Frame]'},
    }

    def __init__(self, **kwargs):
        super(Frames, self).__init__(**kwargs)
        self.review_id = kwargs.get('review_id', None)
        self.video_frames = kwargs.get('video_frames', None)


class IPA(Model):
    """IP Address details.

    :param sub_type: Subtype of the detected IP Address.
    :type sub_type: str
    :param text: Detected IP Address.
    :type text: str
    :param index: Index(Location) of the IP Address in the input text content.
    :type index: int
    """

    _attribute_map = {
        'sub_type': {'key': 'SubType', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(IPA, self).__init__(**kwargs)
        self.sub_type = kwargs.get('sub_type', None)
        self.text = kwargs.get('text', None)
        self.index = kwargs.get('index', None)


class Image(Model):
    """Image Properties.

    :param content_id: Content Id.
    :type content_id: str
    :param additional_info: Advanced info list.
    :type additional_info:
     list[~azure.cognitiveservices.vision.contentmoderator.models.ImageAdditionalInfoItem]
    :param status: Status details.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'additional_info': {'key': 'AdditionalInfo', 'type': '[ImageAdditionalInfoItem]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Image, self).__init__(**kwargs)
        self.content_id = kwargs.get('content_id', None)
        self.additional_info = kwargs.get('additional_info', None)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class ImageAdditionalInfoItem(Model):
    """ImageAdditionalInfoItem.

    :param key: Key parameter.
    :type key: str
    :param value: Value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageAdditionalInfoItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class ImageIds(Model):
    """Image Id properties.

    :param content_source: Source of the content.
    :type content_source: str
    :param content_ids: Id of the contents.
    :type content_ids: list[int]
    :param status: Get Image status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source': {'key': 'ContentSource', 'type': 'str'},
        'content_ids': {'key': 'ContentIds', 'type': '[int]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageIds, self).__init__(**kwargs)
        self.content_source = kwargs.get('content_source', None)
        self.content_ids = kwargs.get('content_ids', None)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class ImageList(Model):
    """Image List Properties.

    :param id: Image List Id.
    :type id: int
    :param name: Image List Name.
    :type name: str
    :param description: Description for image list.
    :type description: str
    :param metadata: Image List Metadata.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(ImageList, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.metadata = kwargs.get('metadata', None)


class Job(Model):
    """The Job object.

    :param id: The job id.
    :type id: str
    :param team_name: The team name associated with the job.
    :type team_name: str
    :param status: The status string (<Pending, Failed, Completed>).
    :type status: str
    :param workflow_id: The Id of the workflow.
    :type workflow_id: str
    :param type: Type of the content.
    :type type: str
    :param call_back_endpoint: The callback endpoint.
    :type call_back_endpoint: str
    :param review_id: Review Id if one is created.
    :type review_id: str
    :param result_meta_data: Array of KeyValue pairs.
    :type result_meta_data:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param job_execution_report: Job execution report- Array of KeyValue pairs
     object.
    :type job_execution_report:
     list[~azure.cognitiveservices.vision.contentmoderator.models.JobExecutionReportDetails]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'team_name': {'key': 'TeamName', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'workflow_id': {'key': 'WorkflowId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'call_back_endpoint': {'key': 'CallBackEndpoint', 'type': 'str'},
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'result_meta_data': {'key': 'ResultMetaData', 'type': '[KeyValuePair]'},
        'job_execution_report': {'key': 'JobExecutionReport', 'type': '[JobExecutionReportDetails]'},
    }

    def __init__(self, **kwargs):
        super(Job, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.team_name = kwargs.get('team_name', None)
        self.status = kwargs.get('status', None)
        self.workflow_id = kwargs.get('workflow_id', None)
        self.type = kwargs.get('type', None)
        self.call_back_endpoint = kwargs.get('call_back_endpoint', None)
        self.review_id = kwargs.get('review_id', None)
        self.result_meta_data = kwargs.get('result_meta_data', None)
        self.job_execution_report = kwargs.get('job_execution_report', None)


class JobExecutionReportDetails(Model):
    """Job Execution Report Values.

    :param ts: Time details.
    :type ts: str
    :param msg: Message details.
    :type msg: str
    """

    _attribute_map = {
        'ts': {'key': 'Ts', 'type': 'str'},
        'msg': {'key': 'Msg', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobExecutionReportDetails, self).__init__(**kwargs)
        self.ts = kwargs.get('ts', None)
        self.msg = kwargs.get('msg', None)


class JobId(Model):
    """JobId.

    :param job_id: Id of the created job.
    :type job_id: str
    """

    _attribute_map = {
        'job_id': {'key': 'JobId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobId, self).__init__(**kwargs)
        self.job_id = kwargs.get('job_id', None)


class JobListResult(Model):
    """The list of job ids.

    :param value: The job id.
    :type value: list[str]
    """

    _attribute_map = {
        'value': {'key': 'Value', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(JobListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class KeyValuePair(Model):
    """The key value pair object properties.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyValuePair, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class Match(Model):
    """The match details.

    :param score: Confidence score of the image match.
    :type score: float
    :param match_id: The match id.
    :type match_id: int
    :param source: The source.
    :type source: str
    :param tags: The tags for match details.
    :type tags: list[int]
    :param label: The label.
    :type label: str
    """

    _attribute_map = {
        'score': {'key': 'Score', 'type': 'float'},
        'match_id': {'key': 'MatchId', 'type': 'int'},
        'source': {'key': 'Source', 'type': 'str'},
        'tags': {'key': 'Tags', 'type': '[int]'},
        'label': {'key': 'Label', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Match, self).__init__(**kwargs)
        self.score = kwargs.get('score', None)
        self.match_id = kwargs.get('match_id', None)
        self.source = kwargs.get('source', None)
        self.tags = kwargs.get('tags', None)
        self.label = kwargs.get('label', None)


class MatchResponse(Model):
    """The response for a Match request.

    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param is_match: Indicates if there is a match.
    :type is_match: bool
    :param matches: The match details.
    :type matches:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Match]
    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    """

    _attribute_map = {
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheID', 'type': 'str'},
        'is_match': {'key': 'IsMatch', 'type': 'bool'},
        'matches': {'key': 'Matches', 'type': '[Match]'},
        'status': {'key': 'Status', 'type': 'Status'},
    }

    def __init__(self, **kwargs):
        super(MatchResponse, self).__init__(**kwargs)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.cache_id = kwargs.get('cache_id', None)
        self.is_match = kwargs.get('is_match', None)
        self.matches = kwargs.get('matches', None)
        self.status = kwargs.get('status', None)


class OCR(Model):
    """Contains the text found in image for the language specified.

    :param status: The evaluate status
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param tracking_id: The tracking id.
    :type tracking_id: str
    :param cache_id: The cache id.
    :type cache_id: str
    :param language: The ISO 639-3 code.
    :type language: str
    :param text: The found text.
    :type text: str
    :param candidates: The list of candidate text.
    :type candidates:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Candidate]
    """

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'Status'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
        'cache_id': {'key': 'CacheId', 'type': 'str'},
        'language': {'key': 'Language', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'candidates': {'key': 'Candidates', 'type': '[Candidate]'},
    }

    def __init__(self, **kwargs):
        super(OCR, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.metadata = kwargs.get('metadata', None)
        self.tracking_id = kwargs.get('tracking_id', None)
        self.cache_id = kwargs.get('cache_id', None)
        self.language = kwargs.get('language', None)
        self.text = kwargs.get('text', None)
        self.candidates = kwargs.get('candidates', None)


class PII(Model):
    """Personal Identifier Information details.

    :param email:
    :type email:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Email]
    :param ssn:
    :type ssn:
     list[~azure.cognitiveservices.vision.contentmoderator.models.SSN]
    :param ipa:
    :type ipa:
     list[~azure.cognitiveservices.vision.contentmoderator.models.IPA]
    :param phone:
    :type phone:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Phone]
    :param address:
    :type address:
     list[~azure.cognitiveservices.vision.contentmoderator.models.Address]
    """

    _attribute_map = {
        'email': {'key': 'Email', 'type': '[Email]'},
        'ssn': {'key': 'SSN', 'type': '[SSN]'},
        'ipa': {'key': 'IPA', 'type': '[IPA]'},
        'phone': {'key': 'Phone', 'type': '[Phone]'},
        'address': {'key': 'Address', 'type': '[Address]'},
    }

    def __init__(self, **kwargs):
        super(PII, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.ssn = kwargs.get('ssn', None)
        self.ipa = kwargs.get('ipa', None)
        self.phone = kwargs.get('phone', None)
        self.address = kwargs.get('address', None)


class Phone(Model):
    """Phone Property details.

    :param country_code: CountryCode of the detected Phone number.
    :type country_code: str
    :param text: Detected Phone number.
    :type text: str
    :param index: Index(Location) of the Phone number in the input text
     content.
    :type index: int
    """

    _attribute_map = {
        'country_code': {'key': 'CountryCode', 'type': 'str'},
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Phone, self).__init__(**kwargs)
        self.country_code = kwargs.get('country_code', None)
        self.text = kwargs.get('text', None)
        self.index = kwargs.get('index', None)


class RefreshIndex(Model):
    """Refresh Index Response.

    :param content_source_id: Content source Id.
    :type content_source_id: str
    :param is_update_success: Update success status.
    :type is_update_success: bool
    :param advanced_info: Advanced info list.
    :type advanced_info: list[dict[str, str]]
    :param status: Refresh index status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'content_source_id': {'key': 'ContentSourceId', 'type': 'str'},
        'is_update_success': {'key': 'IsUpdateSuccess', 'type': 'bool'},
        'advanced_info': {'key': 'AdvancedInfo', 'type': '[{str}]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RefreshIndex, self).__init__(**kwargs)
        self.content_source_id = kwargs.get('content_source_id', None)
        self.is_update_success = kwargs.get('is_update_success', None)
        self.advanced_info = kwargs.get('advanced_info', None)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class Review(Model):
    """The Review object.

    :param review_id: Id of the review.
    :type review_id: str
    :param sub_team: Name of the subteam.
    :type sub_team: str
    :param status: The status string (<Pending, Complete>).
    :type status: str
    :param reviewer_result_tags: Array of KeyValue with Reviewer set Tags.
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param created_by: The reviewer name.
    :type created_by: str
    :param metadata: Array of KeyValue.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.KeyValuePair]
    :param type: The type of content.
    :type type: str
    :param content: The content value.
    :type content: str
    :param content_id: Id of the content.
    :type content_id: str
    :param callback_endpoint: The callback endpoint.
    :type callback_endpoint: str
    """

    _attribute_map = {
        'review_id': {'key': 'ReviewId', 'type': 'str'},
        'sub_team': {'key': 'SubTeam', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[KeyValuePair]'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '[KeyValuePair]'},
        'type': {'key': 'Type', 'type': 'str'},
        'content': {'key': 'Content', 'type': 'str'},
        'content_id': {'key': 'ContentId', 'type': 'str'},
        'callback_endpoint': {'key': 'CallbackEndpoint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Review, self).__init__(**kwargs)
        self.review_id = kwargs.get('review_id', None)
        self.sub_team = kwargs.get('sub_team', None)
        self.status = kwargs.get('status', None)
        self.reviewer_result_tags = kwargs.get('reviewer_result_tags', None)
        self.created_by = kwargs.get('created_by', None)
        self.metadata = kwargs.get('metadata', None)
        self.type = kwargs.get('type', None)
        self.content = kwargs.get('content', None)
        self.content_id = kwargs.get('content_id', None)
        self.callback_endpoint = kwargs.get('callback_endpoint', None)


class SSN(Model):
    """Detected SSN details.

    :param text: Detected SSN in the input text content.
    :type text: str
    :param index: Index(Location) of the SSN in the input text content.
    :type index: int
    """

    _attribute_map = {
        'text': {'key': 'Text', 'type': 'str'},
        'index': {'key': 'Index', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(SSN, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.index = kwargs.get('index', None)


class Screen(Model):
    """The response for a Screen text request.

    :param original_text: The original text.
    :type original_text: str
    :param normalized_text: The normalized text.
    :type normalized_text: str
    :param auto_corrected_text: The autocorrected text
    :type auto_corrected_text: str
    :param misrepresentation: The misrepresentation text.
    :type misrepresentation: list[str]
    :param classification: The classification details of the text.
    :type classification:
     ~azure.cognitiveservices.vision.contentmoderator.models.Classification
    :param status: The evaluate status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param pii: Personal Identifier Information details.
    :type pii: ~azure.cognitiveservices.vision.contentmoderator.models.PII
    :param language: Language of the input text content.
    :type language: str
    :param terms:
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.DetectedTerms]
    :param tracking_id: Unique Content Moderator transaction Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'original_text': {'key': 'OriginalText', 'type': 'str'},
        'normalized_text': {'key': 'NormalizedText', 'type': 'str'},
        'auto_corrected_text': {'key': 'AutoCorrectedText', 'type': 'str'},
        'misrepresentation': {'key': 'Misrepresentation', 'type': '[str]'},
        'classification': {'key': 'Classification', 'type': 'Classification'},
        'status': {'key': 'Status', 'type': 'Status'},
        'pii': {'key': 'PII', 'type': 'PII'},
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[DetectedTerms]'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Screen, self).__init__(**kwargs)
        self.original_text = kwargs.get('original_text', None)
        self.normalized_text = kwargs.get('normalized_text', None)
        self.auto_corrected_text = kwargs.get('auto_corrected_text', None)
        self.misrepresentation = kwargs.get('misrepresentation', None)
        self.classification = kwargs.get('classification', None)
        self.status = kwargs.get('status', None)
        self.pii = kwargs.get('pii', None)
        self.language = kwargs.get('language', None)
        self.terms = kwargs.get('terms', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class Status(Model):
    """Status properties.

    :param code: Status code.
    :type code: int
    :param description: Status description.
    :type description: str
    :param exception: Exception status.
    :type exception: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'int'},
        'description': {'key': 'Description', 'type': 'str'},
        'exception': {'key': 'Exception', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Status, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.description = kwargs.get('description', None)
        self.exception = kwargs.get('exception', None)


class Tag(Model):
    """Tag details.

    :param key: The key parameter.
    :type key: str
    :param value: The value parameter.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Tag, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class TermList(Model):
    """Term List  Properties.

    :param id: Term list Id.
    :type id: int
    :param name: Term list name.
    :type name: str
    :param description: Description for term list.
    :type description: str
    :param metadata: Term list metadata.
    :type metadata: dict[str, str]
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'metadata': {'key': 'Metadata', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TermList, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.metadata = kwargs.get('metadata', None)


class Terms(Model):
    """Terms properties.

    :param data: Term data details.
    :type data:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsData
    :param paging: Paging details.
    :type paging:
     ~azure.cognitiveservices.vision.contentmoderator.models.TermsPaging
    """

    _attribute_map = {
        'data': {'key': 'Data', 'type': 'TermsData'},
        'paging': {'key': 'Paging', 'type': 'TermsPaging'},
    }

    def __init__(self, **kwargs):
        super(Terms, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.paging = kwargs.get('paging', None)


class TermsData(Model):
    """All term Id response properties.

    :param language: Language of the terms.
    :type language: str
    :param terms: List of terms.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TermsInList]
    :param status: Term Status.
    :type status:
     ~azure.cognitiveservices.vision.contentmoderator.models.Status
    :param tracking_id: Tracking Id.
    :type tracking_id: str
    """

    _attribute_map = {
        'language': {'key': 'Language', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TermsInList]'},
        'status': {'key': 'Status', 'type': 'Status'},
        'tracking_id': {'key': 'TrackingId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TermsData, self).__init__(**kwargs)
        self.language = kwargs.get('language', None)
        self.terms = kwargs.get('terms', None)
        self.status = kwargs.get('status', None)
        self.tracking_id = kwargs.get('tracking_id', None)


class TermsInList(Model):
    """Terms in list Id passed.

    :param term: Added term details.
    :type term: str
    """

    _attribute_map = {
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TermsInList, self).__init__(**kwargs)
        self.term = kwargs.get('term', None)


class TermsPaging(Model):
    """Paging details.

    :param total: Total details.
    :type total: int
    :param limit: Limit details.
    :type limit: int
    :param offset: Offset details.
    :type offset: int
    :param returned: Returned text details.
    :type returned: int
    """

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'limit': {'key': 'Limit', 'type': 'int'},
        'offset': {'key': 'Offset', 'type': 'int'},
        'returned': {'key': 'Returned', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TermsPaging, self).__init__(**kwargs)
        self.total = kwargs.get('total', None)
        self.limit = kwargs.get('limit', None)
        self.offset = kwargs.get('offset', None)
        self.returned = kwargs.get('returned', None)


class TranscriptModerationBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. Timestamp of the image.
    :type timestamp: str
    :param terms: Required. Optional metadata details.
    :type terms:
     list[~azure.cognitiveservices.vision.contentmoderator.models.TranscriptModerationBodyItemTermsItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'terms': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'terms': {'key': 'Terms', 'type': '[TranscriptModerationBodyItemTermsItem]'},
    }

    def __init__(self, **kwargs):
        super(TranscriptModerationBodyItem, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)
        self.terms = kwargs.get('terms', None)


class TranscriptModerationBodyItemTermsItem(Model):
    """TranscriptModerationBodyItemTermsItem.

    All required parameters must be populated in order to send to Azure.

    :param index: Required. Index of the word
    :type index: int
    :param term: Required. Detected word.
    :type term: str
    """

    _validation = {
        'index': {'required': True},
        'term': {'required': True},
    }

    _attribute_map = {
        'index': {'key': 'Index', 'type': 'int'},
        'term': {'key': 'Term', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TranscriptModerationBodyItemTermsItem, self).__init__(**kwargs)
        self.index = kwargs.get('index', None)
        self.term = kwargs.get('term', None)


class VideoFrameBodyItem(Model):
    """Schema items of the body.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. Timestamp of the frame.
    :type timestamp: str
    :param frame_image: Required. Content to review.
    :type frame_image: str
    :param reviewer_result_tags:
    :type reviewer_result_tags:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemReviewerResultTagsItem]
    :param metadata: Optional metadata details.
    :type metadata:
     list[~azure.cognitiveservices.vision.contentmoderator.models.VideoFrameBodyItemMetadataItem]
    """

    _validation = {
        'timestamp': {'required': True},
        'frame_image': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'Timestamp', 'type': 'str'},
        'frame_image': {'key': 'FrameImage', 'type': 'str'},
        'reviewer_result_tags': {'key': 'ReviewerResultTags', 'type': '[VideoFrameBodyItemReviewerResultTagsItem]'},
        'metadata': {'key': 'Metadata', 'type': '[VideoFrameBodyItemMetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(VideoFrameBodyItem, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)
        self.frame_image = kwargs.get('frame_image', None)
        self.reviewer_result_tags = kwargs.get('reviewer_result_tags', None)
        self.metadata = kwargs.get('metadata', None)


class VideoFrameBodyItemMetadataItem(Model):
    """VideoFrameBodyItemMetadataItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VideoFrameBodyItemMetadataItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class VideoFrameBodyItemReviewerResultTagsItem(Model):
    """VideoFrameBodyItemReviewerResultTagsItem.

    All required parameters must be populated in order to send to Azure.

    :param key: Required. Your key parameter.
    :type key: str
    :param value: Required. Your value parameter.
    :type value: str
    """

    _validation = {
        'key': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VideoFrameBodyItemReviewerResultTagsItem, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)
