# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import MicrosoftSupportConfiguration
from .operations import Operations
from .operations import ServicesOperations
from .operations import ProblemClassificationsOperations
from .operations import SupportTicketsOperations
from .operations import CommunicationsOperations
from .. import models


class MicrosoftSupport(object):
    """Microsoft Azure Support Resource Provider.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.support.aio.operations.Operations
    :ivar services: ServicesOperations operations
    :vartype services: azure.mgmt.support.aio.operations.ServicesOperations
    :ivar problem_classifications: ProblemClassificationsOperations operations
    :vartype problem_classifications: azure.mgmt.support.aio.operations.ProblemClassificationsOperations
    :ivar support_tickets: SupportTicketsOperations operations
    :vartype support_tickets: azure.mgmt.support.aio.operations.SupportTicketsOperations
    :ivar communications: CommunicationsOperations operations
    :vartype communications: azure.mgmt.support.aio.operations.CommunicationsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure subscription Id.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = MicrosoftSupportConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.services = ServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.problem_classifications = ProblemClassificationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.support_tickets = SupportTicketsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.communications = CommunicationsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "MicrosoftSupport":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
