# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar, Union


class EdgeOrderManagementClientOperationsMixin(object):

    def begin_create_address(
        self,
        address_name,  # type: str
        resource_group_name,  # type: str
        address_resource,  # type: "_models.AddressResource"
        **kwargs  # type: Any
    ):
        """Creates a new address with the specified parameters. Existing address can be updated with this
        API.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param address_resource: Address details from request body.
        :type address_resource: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either AddressResource or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_create_address')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_create_address'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_create_address(address_name, resource_group_name, address_resource, **kwargs)

    def begin_create_order_item(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        order_item_resource,  # type: "_models.OrderItemResource"
        **kwargs  # type: Any
    ):
        """Creates an order item. Existing order item cannot be updated with this api and should instead
        be updated with the Update order item API.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param order_item_resource: Order item details from request body.
        :type order_item_resource: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either OrderItemResource or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_create_order_item')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_create_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_create_order_item(order_item_name, resource_group_name, order_item_resource, **kwargs)

    def begin_delete_address_by_name(
        self,
        address_name,  # type: str
        resource_group_name,  # type: str
        **kwargs  # type: Any
    ):
        """Deletes an address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_delete_address_by_name')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_delete_address_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_delete_address_by_name(address_name, resource_group_name, **kwargs)

    def begin_delete_order_item_by_name(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        **kwargs  # type: Any
    ):
        """Deletes an order item.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_delete_order_item_by_name')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_delete_order_item_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_delete_order_item_by_name(order_item_name, resource_group_name, **kwargs)

    def begin_return_order_item(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        return_order_item_details,  # type: "_models.ReturnOrderItemDetails"
        **kwargs  # type: Any
    ):
        """Return order item.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param return_order_item_details: Return order item CurrentStatus.
        :type return_order_item_details: ~azure.mgmt.edgeorder.v2021_12_01.models.ReturnOrderItemDetails
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_return_order_item')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_return_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_return_order_item(order_item_name, resource_group_name, return_order_item_details, **kwargs)

    def begin_update_address(
        self,
        address_name,  # type: str
        resource_group_name,  # type: str
        address_update_parameter,  # type: "_models.AddressUpdateParameter"
        if_match=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Updates the properties of an existing address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param address_update_parameter: Address update parameters from request body.
        :type address_update_parameter: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressUpdateParameter
        :param if_match: Defines the If-Match condition. The patch will be performed only if the ETag
         of the job on the server matches this value.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either AddressResource or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_update_address')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_update_address'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_update_address(address_name, resource_group_name, address_update_parameter, if_match, **kwargs)

    def begin_update_order_item(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        order_item_update_parameter,  # type: "_models.OrderItemUpdateParameter"
        if_match=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Updates the properties of an existing order item.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param order_item_update_parameter: order item update parameters from request body.
        :type order_item_update_parameter: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemUpdateParameter
        :param if_match: Defines the If-Match condition. The patch will be performed only if the ETag
         of the order on the server matches this value.
        :type if_match: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of LROPoller that returns either OrderItemResource or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        api_version = self._get_api_version('begin_update_order_item')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'begin_update_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.begin_update_order_item(order_item_name, resource_group_name, order_item_update_parameter, if_match, **kwargs)

    def cancel_order_item(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        cancellation_reason,  # type: "_models.CancellationReason"
        **kwargs  # type: Any
    ):
        """Cancel order item.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param cancellation_reason: Reason for cancellation.
        :type cancellation_reason: ~azure.mgmt.edgeorder.v2021_12_01.models.CancellationReason
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('cancel_order_item')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'cancel_order_item'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.cancel_order_item(order_item_name, resource_group_name, cancellation_reason, **kwargs)

    def get_address_by_name(
        self,
        address_name,  # type: str
        resource_group_name,  # type: str
        **kwargs  # type: Any
    ):
        """Gets information about the specified address.

        :param address_name: The name of the address Resource within the specified resource group.
         address names must be between 3 and 24 characters in length and use any alphanumeric and
         underscore only.
        :type address_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AddressResource, or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.AddressResource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_address_by_name')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_address_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_address_by_name(address_name, resource_group_name, **kwargs)

    def get_order_by_name(
        self,
        order_name,  # type: str
        resource_group_name,  # type: str
        location,  # type: str
        **kwargs  # type: Any
    ):
        """Gets an order.

        :param order_name: The name of the order.
        :type order_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param location: The name of Azure region.
        :type location: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrderResource, or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderResource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_order_by_name')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_order_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_order_by_name(order_name, resource_group_name, location, **kwargs)

    def get_order_item_by_name(
        self,
        order_item_name,  # type: str
        resource_group_name,  # type: str
        expand=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Gets an order item.

        :param order_item_name: The name of the order item.
        :type order_item_name: str
        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively.
        :type expand: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: OrderItemResource, or the result of cls(response)
        :rtype: ~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResource
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('get_order_item_by_name')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'get_order_item_by_name'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.get_order_item_by_name(order_item_name, resource_group_name, expand, **kwargs)

    def list_addresses_at_resource_group_level(
        self,
        resource_group_name,  # type: str
        filter=None,  # type: Optional[str]
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists all the addresses available under the given resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param filter: $filter is supported to filter based on shipping address properties. Filter
         supports only equals operation.
        :type filter: str
        :param skip_token: $skipToken is supported on Get list of addresses, which provides the next
         page in the list of address.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AddressResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_addresses_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_addresses_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_addresses_at_resource_group_level(resource_group_name, filter, skip_token, **kwargs)

    def list_addresses_at_subscription_level(
        self,
        filter=None,  # type: Optional[str]
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists all the addresses available under the subscription.

        :param filter: $filter is supported to filter based on shipping address properties. Filter
         supports only equals operation.
        :type filter: str
        :param skip_token: $skipToken is supported on Get list of addresses, which provides the next
         page in the list of addresses.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AddressResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.AddressResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_addresses_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_addresses_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_addresses_at_subscription_level(filter, skip_token, **kwargs)

    def list_configurations(
        self,
        configurations_request,  # type: "_models.ConfigurationsRequest"
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """This method provides the list of configurations for the given product family, product line and
        product under subscription.

        :param configurations_request: Filters for showing the configurations.
        :type configurations_request: ~azure.mgmt.edgeorder.v2021_12_01.models.ConfigurationsRequest
        :param skip_token: $skipToken is supported on list of configurations, which provides the next
         page in the list of configurations.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Configurations or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.Configurations]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_configurations')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_configurations'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_configurations(configurations_request, skip_token, **kwargs)

    def list_operations(
        self,
        **kwargs  # type: Any
    ):
        """This method gets all the operations that are exposed for customer.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OperationListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OperationListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_operations')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_operations'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_operations(**kwargs)

    def list_order_at_resource_group_level(
        self,
        resource_group_name,  # type: str
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists order at resource group level.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param skip_token: $skipToken is supported on Get list of order, which provides the next page
         in the list of order.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_order_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_at_resource_group_level(resource_group_name, skip_token, **kwargs)

    def list_order_at_subscription_level(
        self,
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists order at subscription level.

        :param skip_token: $skipToken is supported on Get list of order, which provides the next page
         in the list of order.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_order_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_at_subscription_level(skip_token, **kwargs)

    def list_order_items_at_resource_group_level(
        self,
        resource_group_name,  # type: str
        filter=None,  # type: Optional[str]
        expand=None,  # type: Optional[str]
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists order item at resource group level.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
        :type resource_group_name: str
        :param filter: $filter is supported to filter based on order id. Filter supports only equals
         operation.
        :type filter: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively.
        :type expand: str
        :param skip_token: $skipToken is supported on Get list of order items, which provides the next
         page in the list of order items.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderItemResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_order_items_at_resource_group_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_items_at_resource_group_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_items_at_resource_group_level(resource_group_name, filter, expand, skip_token, **kwargs)

    def list_order_items_at_subscription_level(
        self,
        filter=None,  # type: Optional[str]
        expand=None,  # type: Optional[str]
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """Lists order item at subscription level.

        :param filter: $filter is supported to filter based on order id. Filter supports only equals
         operation.
        :type filter: str
        :param expand: $expand is supported on device details, forward shipping details and reverse
         shipping details parameters. Each of these can be provided as a comma separated list. Device
         Details for order item provides details on the devices of the product, Forward and Reverse
         Shipping details provide forward and reverse shipping details respectively.
        :type expand: str
        :param skip_token: $skipToken is supported on Get list of order items, which provides the next
         page in the list of order items.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either OrderItemResourceList or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.OrderItemResourceList]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_order_items_at_subscription_level')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_order_items_at_subscription_level'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_order_items_at_subscription_level(filter, expand, skip_token, **kwargs)

    def list_product_families(
        self,
        product_families_request,  # type: "_models.ProductFamiliesRequest"
        expand=None,  # type: Optional[str]
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """This method provides the list of product families for the given subscription.

        :param product_families_request: Filters for showing the product families.
        :type product_families_request: ~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamiliesRequest
        :param expand: $expand is supported on configurations parameter for product, which provides
         details on the configurations for the product.
        :type expand: str
        :param skip_token: $skipToken is supported on list of product families, which provides the next
         page in the list of product families.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProductFamilies or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamilies]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_product_families')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_product_families'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_product_families(product_families_request, expand, skip_token, **kwargs)

    def list_product_families_metadata(
        self,
        skip_token=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        """This method provides the list of product families metadata for the given subscription.

        :param skip_token: $skipToken is supported on list of product families metadata, which provides
         the next page in the list of product families metadata.
        :type skip_token: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ProductFamiliesMetadata or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.edgeorder.v2021_12_01.models.ProductFamiliesMetadata]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = self._get_api_version('list_product_families_metadata')
        if api_version == '2020-12-01-preview':
            from .v2020_12_01_preview.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        elif api_version == '2021-12-01':
            from .v2021_12_01.operations import EdgeOrderManagementClientOperationsMixin as OperationClass
        else:
            raise ValueError("API version {} does not have operation 'list_product_families_metadata'".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance._config = self._config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._serialize.client_side_validation = False
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        return mixin_instance.list_product_families_metadata(skip_token, **kwargs)
