# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._adaptive_network_hardenings_operations import (
    build_enforce_request,
    build_get_request,
    build_list_by_extended_resource_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AdaptiveNetworkHardeningsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.v2020_01_01.aio.SecurityCenter`'s
        :attr:`adaptive_network_hardenings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_extended_resource(
        self, resource_group_name: str, resource_namespace: str, resource_type: str, resource_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AdaptiveNetworkHardening"]:
        """Gets a list of Adaptive Network Hardenings resources in scope of an extended resource.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AdaptiveNetworkHardening or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardening]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AdaptiveNetworkHardeningsList]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_extended_resource_request(
                    resource_group_name=resource_group_name,
                    resource_namespace=resource_namespace,
                    resource_type=resource_type,
                    resource_name=resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_extended_resource.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AdaptiveNetworkHardeningsList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_extended_resource.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        resource_namespace: str,
        resource_type: str,
        resource_name: str,
        adaptive_network_hardening_resource_name: str,
        **kwargs: Any
    ) -> _models.AdaptiveNetworkHardening:
        """Gets a single Adaptive Network Hardening resource.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :param adaptive_network_hardening_resource_name: The name of the Adaptive Network Hardening
         resource. Required.
        :type adaptive_network_hardening_resource_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AdaptiveNetworkHardening or the result of cls(response)
        :rtype: ~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardening
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AdaptiveNetworkHardening]

        request = build_get_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            adaptive_network_hardening_resource_name=adaptive_network_hardening_resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AdaptiveNetworkHardening", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}"}  # type: ignore

    async def _enforce_initial(  # pylint: disable=inconsistent-return-statements
        self,
        resource_group_name: str,
        resource_namespace: str,
        resource_type: str,
        resource_name: str,
        adaptive_network_hardening_resource_name: str,
        body: Union[_models.AdaptiveNetworkHardeningEnforceRequest, IO],
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        adaptive_network_hardening_enforce_action = kwargs.pop(
            "adaptive_network_hardening_enforce_action", "enforce"
        )  # type: Literal["enforce"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "AdaptiveNetworkHardeningEnforceRequest")

        request = build_enforce_request(
            resource_group_name=resource_group_name,
            resource_namespace=resource_namespace,
            resource_type=resource_type,
            resource_name=resource_name,
            adaptive_network_hardening_resource_name=adaptive_network_hardening_resource_name,
            subscription_id=self._config.subscription_id,
            adaptive_network_hardening_enforce_action=adaptive_network_hardening_enforce_action,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._enforce_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    _enforce_initial.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}/{adaptiveNetworkHardeningEnforceAction}"}  # type: ignore

    @overload
    async def begin_enforce(
        self,
        resource_group_name: str,
        resource_namespace: str,
        resource_type: str,
        resource_name: str,
        adaptive_network_hardening_resource_name: str,
        body: _models.AdaptiveNetworkHardeningEnforceRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Enforces the given rules on the NSG(s) listed in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :param adaptive_network_hardening_resource_name: The name of the Adaptive Network Hardening
         resource. Required.
        :type adaptive_network_hardening_resource_name: str
        :param body: Required.
        :type body: ~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardeningEnforceRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword adaptive_network_hardening_enforce_action: Enforces the given rules on the NSG(s)
         listed in the request. Default value is "enforce". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype adaptive_network_hardening_enforce_action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_enforce(
        self,
        resource_group_name: str,
        resource_namespace: str,
        resource_type: str,
        resource_name: str,
        adaptive_network_hardening_resource_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Enforces the given rules on the NSG(s) listed in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :param adaptive_network_hardening_resource_name: The name of the Adaptive Network Hardening
         resource. Required.
        :type adaptive_network_hardening_resource_name: str
        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword adaptive_network_hardening_enforce_action: Enforces the given rules on the NSG(s)
         listed in the request. Default value is "enforce". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype adaptive_network_hardening_enforce_action: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_enforce(
        self,
        resource_group_name: str,
        resource_namespace: str,
        resource_type: str,
        resource_name: str,
        adaptive_network_hardening_resource_name: str,
        body: Union[_models.AdaptiveNetworkHardeningEnforceRequest, IO],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Enforces the given rules on the NSG(s) listed in the request.

        :param resource_group_name: The name of the resource group within the user's subscription. The
         name is case insensitive. Required.
        :type resource_group_name: str
        :param resource_namespace: The Namespace of the resource. Required.
        :type resource_namespace: str
        :param resource_type: The type of the resource. Required.
        :type resource_type: str
        :param resource_name: Name of the resource. Required.
        :type resource_name: str
        :param adaptive_network_hardening_resource_name: The name of the Adaptive Network Hardening
         resource. Required.
        :type adaptive_network_hardening_resource_name: str
        :param body: Is either a model type or a IO type. Required.
        :type body: ~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardeningEnforceRequest or
         IO
        :keyword adaptive_network_hardening_enforce_action: Enforces the given rules on the NSG(s)
         listed in the request. Default value is "enforce". Note that overriding this default value may
         result in unsupported behavior.
        :paramtype adaptive_network_hardening_enforce_action: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        adaptive_network_hardening_enforce_action = kwargs.pop(
            "adaptive_network_hardening_enforce_action", "enforce"
        )  # type: Literal["enforce"]
        api_version = kwargs.pop("api_version", _params.pop("api-version", "2020-01-01"))  # type: Literal["2020-01-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        polling = kwargs.pop("polling", True)  # type: Union[bool, AsyncPollingMethod]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._enforce_initial(  # type: ignore
                resource_group_name=resource_group_name,
                resource_namespace=resource_namespace,
                resource_type=resource_type,
                resource_name=resource_name,
                adaptive_network_hardening_resource_name=adaptive_network_hardening_resource_name,
                body=body,
                adaptive_network_hardening_enforce_action=adaptive_network_hardening_enforce_action,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})

        if polling is True:
            polling_method = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))  # type: AsyncPollingMethod
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_enforce.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/adaptiveNetworkHardenings/{adaptiveNetworkHardeningResourceName}/{adaptiveNetworkHardeningEnforceAction}"}  # type: ignore
