# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AuthenticationProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the multi-cloud connector."""

    #: Valid connector
    VALID = "Valid"
    #: Invalid connector
    INVALID = "Invalid"
    #: the connection has expired
    EXPIRED = "Expired"
    #: Incorrect policy of the connector
    INCORRECT_POLICY = "IncorrectPolicy"


class AuthenticationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connect to your cloud account, for AWS use either account credentials or role-based
    authentication. For GCP use account organization credentials.
    """

    #: AWS cloud account connector user credentials authentication
    AWS_CREDS = "awsCreds"
    #: AWS account connector assume role authentication
    AWS_ASSUME_ROLE = "awsAssumeRole"
    #: GCP account connector service to service authentication
    GCP_CREDENTIALS = "gcpCredentials"


class AutoProvision(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether or not to automatically install Azure Arc (hybrid compute) agents on machines."""

    #: Install missing Azure Arc agents on machines automatically
    ON = "On"
    #: Do not install Azure Arc agent on the machines automatically
    OFF = "Off"


class HybridComputeProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the service principal and its secret."""

    #: Valid service principal details.
    VALID = "Valid"
    #: Invalid service principal details.
    INVALID = "Invalid"
    #: the service principal details are expired
    EXPIRED = "Expired"


class PermissionProperty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A permission detected in the cloud account."""

    #: This permission provides read only access to AWS Security Hub resources.
    AWS_AWS_SECURITY_HUB_READ_ONLY_ACCESS = "AWS::AWSSecurityHubReadOnlyAccess"
    #: This permission grants access to read security configuration metadata.
    AWS_SECURITY_AUDIT = "AWS::SecurityAudit"
    #: The permission provides for EC2 Automation service to execute activities defined within
    #: Automation documents.
    AWS_AMAZON_SSM_AUTOMATION_ROLE = "AWS::AmazonSSMAutomationRole"
    #: This permission provides read only access to GCP Security Command Center.
    GCP_SECURITY_CENTER_ADMIN_VIEWER = "GCP::Security Center Admin Viewer"
