# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.core import PipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

from ._configuration import ServiceBusManagementClientConfiguration
from .operations import EntityOperations
from .operations import ServiceBusManagementClientOperationsMixin
from .operations import SubscriptionOperations
from .operations import RuleOperations
from .operations import NamespaceOperations
from . import models


class ServiceBusManagementClient(ServiceBusManagementClientOperationsMixin):
    """Azure Service Bus client for managing Queues, Topics, and Subscriptions.

    :ivar entity: EntityOperations operations
    :vartype entity: azure.servicebus.management._generated.operations.EntityOperations
    :ivar subscription: SubscriptionOperations operations
    :vartype subscription: azure.servicebus.management._generated.operations.SubscriptionOperations
    :ivar rule: RuleOperations operations
    :vartype rule: azure.servicebus.management._generated.operations.RuleOperations
    :ivar namespace: NamespaceOperations operations
    :vartype namespace: azure.servicebus.management._generated.operations.NamespaceOperations
    :param endpoint: The Service Bus fully qualified domain name.
    :type endpoint: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        endpoint,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        base_url = 'https://{endpoint}'
        self._config = ServiceBusManagementClientConfiguration(endpoint, **kwargs)
        self._client = PipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.entity = EntityOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.subscription = SubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.rule = RuleOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.namespace = NamespaceOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> ServiceBusManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
