# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, AsyncIterable, Callable, Dict, Generic, List, Optional, TypeVar, Union
import warnings

from ....aio._async_polling import AsyncDocumentTranslationLROPollingMethod, AsyncDocumentTranslationLROPoller
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.core.polling import AsyncNoPolling, AsyncPollingMethod

from ... import models as _models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class DocumentTranslationOperations:
    """DocumentTranslationOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.ai.translation.document.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def _start_translation_initial(
        self,
        inputs: List["_models.BatchRequest"],
        **kwargs: Any
    ) -> None:
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))

        _body = _models.StartTranslationDetails(inputs=inputs)
        content_type = kwargs.pop("content_type", "application/json")
        accept = "application/json"

        # Construct URL
        url = self._start_translation_initial.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(_body, 'StartTranslationDetails')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    _start_translation_initial.metadata = {'url': '/batches'}  # type: ignore

    async def begin_start_translation(
        self,
        inputs: List["_models.BatchRequest"],
        **kwargs: Any
    ) -> AsyncDocumentTranslationLROPoller[None]:
        """Submit a document translation request to the Document Translation service.

        Use this API to submit a bulk (batch) translation request to the Document Translation service.
        Each request can contain multiple documents and must contain a source and destination container
        for each document.

        The prefix and suffix filter (if supplied) are used to filter folders. The prefix is applied to
        the subpath after the container name.

        Glossaries / Translation memory can be included in the request and are applied by the service
        when the document is translated.

        If the glossary is invalid or unreachable during translation, an error is indicated in the
        document status.
        If a file with the same name already exists at the destination, it will be overwritten. The
        targetUrl for each target language must be unique.

        :param inputs: The input list of documents or folders containing documents.
        :type inputs: list[~azure.ai.translation.document.models.BatchRequest]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncDocumentTranslationLROPollingMethod.
         Pass in False for this operation to not poll, or pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
        :return: An instance of AsyncDocumentTranslationLROPoller that returns either None or the result of cls(response)
        :rtype: ~....aio._async_polling.AsyncDocumentTranslationLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._start_translation_initial(
                inputs=inputs,
                cls=lambda x,y,z: x,
                **kwargs
            )

        kwargs.pop('error_map', None)
        kwargs.pop('content_type', None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True: polling_method = AsyncDocumentTranslationLROPollingMethod(lro_delay, lro_options={'final-state-via': 'location'}, path_format_arguments=path_format_arguments,  **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncDocumentTranslationLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        else:
            return AsyncDocumentTranslationLROPoller(self._client, raw_result, get_long_running_output, polling_method)
    begin_start_translation.metadata = {'url': '/batches'}  # type: ignore

    def get_translations_status(
        self,
        top: Optional[int] = None,
        skip: Optional[int] = 0,
        maxpagesize: Optional[int] = 50,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        order_by: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.TranslationsStatus"]:
        """Returns a list of batch requests submitted and the status for each request.

        Returns a list of batch requests submitted and the status for each request.
        This list only contains batch requests submitted by the user (based on the resource).

        If the number of requests exceeds our paging limit, server-side paging is used. Paginated
        responses indicate a partial result and include a continuation token in the response.
        The absence of a continuation token means that no additional pages are available.

        $top, $skip and $maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        $top indicates the total number of records the user wants to be returned across all pages.
        $skip indicates the number of records to skip from the list of batches based on the sorting
        method specified.  By default, we sort by descending start time.
        $maxpagesize is the maximum items returned in a page.  If more items are requested via $top (or
        $top is not specified and there are more items to be returned), @nextLink will contain the link
        to the next page.

        $orderBy query parameter can be used to sort the returned list (ex "$orderBy=createdDateTimeUtc
        asc" or "$orderBy=createdDateTimeUtc desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled operations.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used combined or separately to specify
        a range of datetime to filter the returned list by.
        The supported filtering query parameters are (status, ids, createdDateTimeUtcStart,
        createdDateTimeUtcEnd).

        The server honors the values specified by the client. However, clients must be prepared to
        handle responses that contain a different page size or contain a continuation token.

        When both $top and $skip are included, the server should first apply $skip and then $top on the
        collection.
        Note: If the server can't honor $top and/or $skip, the server must return an error to the
        client informing about it instead of just ignoring the query options.
        This reduces the risk of the client making assumptions about the data returned.

        :param top: $top indicates the total number of records the user wants to be returned across all
         pages.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options.
        :type top: int
        :param skip: $skip indicates the number of records to skip from the list of records held by the
         server based on the sorting method specified.  By default, we sort by descending start time.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options.
        :type skip: int
        :param maxpagesize: $maxpagesize is the maximum items returned in a page.  If more items are
         requested via $top (or $top is not specified and there are more items to be returned),
         @nextLink will contain the link to the next page.

         Clients MAY request server-driven paging with a specific page size by specifying a
         $maxpagesize preference. The server SHOULD honor this preference if the specified page size is
         smaller than the server's default page size.
        :type maxpagesize: int
        :param ids: Ids to use in filtering.
        :type ids: list[str]
        :param statuses: Statuses to use in filtering.
        :type statuses: list[str]
        :param created_date_time_utc_start: the start datetime to get items after.
        :type created_date_time_utc_start: ~datetime.datetime
        :param created_date_time_utc_end: the end datetime to get items before.
        :type created_date_time_utc_end: ~datetime.datetime
        :param order_by: the sorting query for the collection (ex: 'CreatedDateTimeUtc asc',
         'CreatedDateTimeUtc desc').
        :type order_by: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either TranslationsStatus or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models.TranslationsStatus]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TranslationsStatus"]
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_translations_status.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', maximum=2147483647, minimum=0)
                if skip is not None:
                    query_parameters['$skip'] = self._serialize.query("skip", skip, 'int', maximum=2147483647, minimum=0)
                if maxpagesize is not None:
                    query_parameters['$maxpagesize'] = self._serialize.query("maxpagesize", maxpagesize, 'int', maximum=100, minimum=1)
                if ids is not None:
                    query_parameters['ids'] = self._serialize.query("ids", ids, '[str]', div=',')
                if statuses is not None:
                    query_parameters['statuses'] = self._serialize.query("statuses", statuses, '[str]', div=',')
                if created_date_time_utc_start is not None:
                    query_parameters['createdDateTimeUtcStart'] = self._serialize.query("created_date_time_utc_start", created_date_time_utc_start, 'iso-8601')
                if created_date_time_utc_end is not None:
                    query_parameters['createdDateTimeUtcEnd'] = self._serialize.query("created_date_time_utc_end", created_date_time_utc_end, 'iso-8601')
                if order_by is not None:
                    query_parameters['$orderBy'] = self._serialize.query("order_by", order_by, '[str]', div=',')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('TranslationsStatus', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_translations_status.metadata = {'url': '/batches'}  # type: ignore

    async def get_document_status(
        self,
        id: str,
        document_id: str,
        **kwargs: Any
    ) -> "_models.DocumentStatus":
        """Returns the status for a specific document.

        Returns the translation status for a specific document based on the request Id and document Id.

        :param id: Format - uuid.  The batch id.
        :type id: str
        :param document_id: Format - uuid.  The document id.
        :type document_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DocumentStatus, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.DocumentStatus
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DocumentStatus"]
        error_map = {
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            404: lambda response: ResourceNotFoundError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.get_document_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'id': self._serialize.url("id", id, 'str'),
            'documentId': self._serialize.url("document_id", document_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('DocumentStatus', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_document_status.metadata = {'url': '/batches/{id}/documents/{documentId}'}  # type: ignore

    async def get_translation_status(
        self,
        id: str,
        **kwargs: Any
    ) -> "_models.TranslationStatus":
        """Returns the status for a document translation request.

        Returns the status for a document translation request.
        The status includes the overall request status, as well as the status for documents that are
        being translated as part of that request.

        :param id: Format - uuid.  The operation id.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TranslationStatus, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TranslationStatus"]
        error_map = {
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            404: lambda response: ResourceNotFoundError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.get_translation_status.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('TranslationStatus', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_translation_status.metadata = {'url': '/batches/{id}'}  # type: ignore

    async def cancel_translation(
        self,
        id: str,
        **kwargs: Any
    ) -> "_models.TranslationStatus":
        """Cancel a currently processing or queued translation.

        Cancel a currently processing or queued translation.
        Cancel a currently processing or queued translation.
        A translation will not be cancelled if it is already completed or failed or cancelling. A bad
        request will be returned.
        All documents that have completed translation will not be cancelled and will be charged.
        All pending documents will be cancelled if possible.

        :param id: Format - uuid.  The operation-id.
        :type id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: TranslationStatus, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.TranslationStatus
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.TranslationStatus"]
        error_map = {
            409: ResourceExistsError,
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            404: lambda response: ResourceNotFoundError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.cancel_translation.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize('TranslationStatus', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    cancel_translation.metadata = {'url': '/batches/{id}'}  # type: ignore

    def get_documents_status(
        self,
        id: str,
        top: Optional[int] = None,
        skip: Optional[int] = 0,
        maxpagesize: Optional[int] = 50,
        ids: Optional[List[str]] = None,
        statuses: Optional[List[str]] = None,
        created_date_time_utc_start: Optional[datetime.datetime] = None,
        created_date_time_utc_end: Optional[datetime.datetime] = None,
        order_by: Optional[List[str]] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.DocumentsStatus"]:
        """Returns the status for all documents in a batch document translation request.

        Returns the status for all documents in a batch document translation request.

        If the number of documents in the response exceeds our paging limit, server-side paging is
        used.
        Paginated responses indicate a partial result and include a continuation token in the response.
        The absence of a continuation token means that no additional pages are available.

        $top, $skip and $maxpagesize query parameters can be used to specify a number of results to
        return and an offset for the collection.

        $top indicates the total number of records the user wants to be returned across all pages.
        $skip indicates the number of records to skip from the list of document status held by the
        server based on the sorting method specified.  By default, we sort by descending start time.
        $maxpagesize is the maximum items returned in a page.  If more items are requested via $top (or
        $top is not specified and there are more items to be returned), @nextLink will contain the link
        to the next page.

        $orderBy query parameter can be used to sort the returned list (ex "$orderBy=createdDateTimeUtc
        asc" or "$orderBy=createdDateTimeUtc desc").
        The default sorting is descending by createdDateTimeUtc.
        Some query parameters can be used to filter the returned list (ex:
        "status=Succeeded,Cancelled") will only return succeeded and cancelled documents.
        createdDateTimeUtcStart and createdDateTimeUtcEnd can be used combined or separately to specify
        a range of datetime to filter the returned list by.
        The supported filtering query parameters are (status, ids, createdDateTimeUtcStart,
        createdDateTimeUtcEnd).

        When both $top and $skip are included, the server should first apply $skip and then $top on the
        collection.
        Note: If the server can't honor $top and/or $skip, the server must return an error to the
        client informing about it instead of just ignoring the query options.
        This reduces the risk of the client making assumptions about the data returned.

        :param id: Format - uuid.  The operation id.
        :type id: str
        :param top: $top indicates the total number of records the user wants to be returned across all
         pages.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options.
        :type top: int
        :param skip: $skip indicates the number of records to skip from the list of records held by the
         server based on the sorting method specified.  By default, we sort by descending start time.

         Clients MAY use $top and $skip query parameters to specify a number of results to return and
         an offset into the collection.
         When both $top and $skip are given by a client, the server SHOULD first apply $skip and then
         $top on the collection.

         Note: If the server can't honor $top and/or $skip, the server MUST return an error to the
         client informing about it instead of just ignoring the query options.
        :type skip: int
        :param maxpagesize: $maxpagesize is the maximum items returned in a page.  If more items are
         requested via $top (or $top is not specified and there are more items to be returned),
         @nextLink will contain the link to the next page.

         Clients MAY request server-driven paging with a specific page size by specifying a
         $maxpagesize preference. The server SHOULD honor this preference if the specified page size is
         smaller than the server's default page size.
        :type maxpagesize: int
        :param ids: Ids to use in filtering.
        :type ids: list[str]
        :param statuses: Statuses to use in filtering.
        :type statuses: list[str]
        :param created_date_time_utc_start: the start datetime to get items after.
        :type created_date_time_utc_start: ~datetime.datetime
        :param created_date_time_utc_end: the end datetime to get items before.
        :type created_date_time_utc_end: ~datetime.datetime
        :param order_by: the sorting query for the collection (ex: 'CreatedDateTimeUtc asc',
         'CreatedDateTimeUtc desc').
        :type order_by: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DocumentsStatus or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.ai.translation.document.models.DocumentsStatus]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DocumentsStatus"]
        error_map = {
            409: ResourceExistsError,
            400: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            401: lambda response: ClientAuthenticationError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            404: lambda response: ResourceNotFoundError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

            if not next_link:
                # Construct URL
                url = self.get_documents_status.metadata['url']  # type: ignore
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'id': self._serialize.url("id", id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if top is not None:
                    query_parameters['$top'] = self._serialize.query("top", top, 'int', maximum=2147483647, minimum=0)
                if skip is not None:
                    query_parameters['$skip'] = self._serialize.query("skip", skip, 'int', maximum=2147483647, minimum=0)
                if maxpagesize is not None:
                    query_parameters['$maxpagesize'] = self._serialize.query("maxpagesize", maxpagesize, 'int', maximum=100, minimum=1)
                if ids is not None:
                    query_parameters['ids'] = self._serialize.query("ids", ids, '[str]', div=',')
                if statuses is not None:
                    query_parameters['statuses'] = self._serialize.query("statuses", statuses, '[str]', div=',')
                if created_date_time_utc_start is not None:
                    query_parameters['createdDateTimeUtcStart'] = self._serialize.query("created_date_time_utc_start", created_date_time_utc_start, 'iso-8601')
                if created_date_time_utc_end is not None:
                    query_parameters['createdDateTimeUtcEnd'] = self._serialize.query("created_date_time_utc_end", created_date_time_utc_end, 'iso-8601')
                if order_by is not None:
                    query_parameters['$orderBy'] = self._serialize.query("order_by", order_by, '[str]', div=',')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                    'id': self._serialize.url("id", id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('DocumentsStatus', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    get_documents_status.metadata = {'url': '/batches/{id}/documents'}  # type: ignore

    async def get_supported_document_formats(
        self,
        **kwargs: Any
    ) -> "_models.SupportedFileFormats":
        """Returns a list of supported document formats.

        The list of supported document formats supported by the Document Translation service.
        The list includes the common file extension, as well as the content-type if using the upload
        API.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SupportedFileFormats, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.SupportedFileFormats
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SupportedFileFormats"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.get_supported_document_formats.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))
        deserialized = self._deserialize('SupportedFileFormats', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_supported_document_formats.metadata = {'url': '/documents/formats'}  # type: ignore

    async def get_supported_glossary_formats(
        self,
        **kwargs: Any
    ) -> "_models.SupportedFileFormats":
        """Returns the list of supported glossary formats.

        The list of supported glossary formats supported by the Document Translation service.
        The list includes the common file extension used.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SupportedFileFormats, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.SupportedFileFormats
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SupportedFileFormats"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.get_supported_glossary_formats.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))
        deserialized = self._deserialize('SupportedFileFormats', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_supported_glossary_formats.metadata = {'url': '/glossaries/formats'}  # type: ignore

    async def get_supported_storage_sources(
        self,
        **kwargs: Any
    ) -> "_models.SupportedStorageSources":
        """Returns a list of supported storage sources.

        Returns a list of storage sources/options supported by the Document Translation service.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SupportedStorageSources, or the result of cls(response)
        :rtype: ~azure.ai.translation.document.models.SupportedStorageSources
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SupportedStorageSources"]
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            429: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            500: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
            503: lambda response: HttpResponseError(response=response, model=self._deserialize(_models.TranslationErrorResponse, response)),
        }
        error_map.update(kwargs.pop('error_map', {}))
        accept = "application/json"

        # Construct URL
        url = self.get_supported_storage_sources.metadata['url']  # type: ignore
        path_format_arguments = {
            'endpoint': self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = self._serialize.header("accept", accept, 'str')

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers['Retry-After']=self._deserialize('int', response.headers.get('Retry-After'))
        deserialized = self._deserialize('SupportedStorageSources', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_supported_storage_sources.metadata = {'url': '/storagesources'}  # type: ignore
