# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dataprotection import DataProtectionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataProtectionMgmtBackupVaultsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataProtectionMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_get(self, resource_group):
        response = self.client.backup_vaults.get(
            resource_group_name=resource_group.name,
            vault_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_begin_create_or_update(self, resource_group):
        response = self.client.backup_vaults.begin_create_or_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            parameters={
                "location": "str",
                "properties": {
                    "storageSettings": [{"datastoreType": "str", "type": "str"}],
                    "bcdrSecurityLevel": "str",
                    "featureSettings": {
                        "crossRegionRestoreSettings": {"state": "str"},
                        "crossSubscriptionRestoreSettings": {"state": "str"},
                    },
                    "isVaultProtectedByResourceGuard": bool,
                    "monitoringSettings": {"azureMonitorAlertSettings": {"alertsForAllJobFailures": "str"}},
                    "provisioningState": "str",
                    "replicatedRegions": ["str"],
                    "resourceGuardOperationRequests": ["str"],
                    "resourceMoveDetails": {
                        "completionTimeUtc": "str",
                        "operationId": "str",
                        "sourceResourcePath": "str",
                        "startTimeUtc": "str",
                        "targetResourcePath": "str",
                    },
                    "resourceMoveState": "str",
                    "secureScore": "str",
                    "securitySettings": {
                        "encryptionSettings": {
                            "infrastructureEncryption": "str",
                            "kekIdentity": {"identityId": "str", "identityType": "str"},
                            "keyVaultProperties": {"keyUri": "str"},
                            "state": "str",
                        },
                        "immutabilitySettings": {"state": "str"},
                        "softDeleteSettings": {"retentionDurationInDays": 0.0, "state": "str"},
                    },
                },
                "eTag": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_begin_update(self, resource_group):
        response = self.client.backup_vaults.begin_update(
            resource_group_name=resource_group.name,
            vault_name="str",
            parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "featureSettings": {
                        "crossRegionRestoreSettings": {"state": "str"},
                        "crossSubscriptionRestoreSettings": {"state": "str"},
                    },
                    "monitoringSettings": {"azureMonitorAlertSettings": {"alertsForAllJobFailures": "str"}},
                    "resourceGuardOperationRequests": ["str"],
                    "securitySettings": {
                        "encryptionSettings": {
                            "infrastructureEncryption": "str",
                            "kekIdentity": {"identityId": "str", "identityType": "str"},
                            "keyVaultProperties": {"keyUri": "str"},
                            "state": "str",
                        },
                        "immutabilitySettings": {"state": "str"},
                        "softDeleteSettings": {"retentionDurationInDays": 0.0, "state": "str"},
                    },
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_begin_delete(self, resource_group):
        response = self.client.backup_vaults.begin_delete(
            resource_group_name=resource_group.name,
            vault_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_get_in_subscription(self, resource_group):
        response = self.client.backup_vaults.get_in_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_get_in_resource_group(self, resource_group):
        response = self.client.backup_vaults.get_in_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_backup_vaults_check_name_availability(self, resource_group):
        response = self.client.backup_vaults.check_name_availability(
            resource_group_name=resource_group.name,
            location="str",
            parameters={"name": "str", "type": "str"},
        )

        # please add some check logic here by yourself
        # ...
