# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.mysqlflexibleservers.aio import MySQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMySQLManagementConfigurationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MySQLManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_list_by_server(self, resource_group):
        response = self.client.configurations.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2024-12-30",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_get(self, resource_group):
        response = await self.client.configurations.get(
            resource_group_name=resource_group.name,
            server_name="str",
            configuration_name="str",
            api_version="2024-12-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.configurations.begin_create_or_update(
                resource_group_name=resource_group.name,
                server_name="str",
                configuration_name="str",
                parameters={
                    "allowedValues": "str",
                    "currentValue": "str",
                    "dataType": "str",
                    "defaultValue": "str",
                    "description": "str",
                    "documentationLink": "str",
                    "id": "str",
                    "isConfigPendingRestart": "str",
                    "isDynamicConfig": "str",
                    "isReadOnly": "str",
                    "name": "str",
                    "source": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                    "value": "str",
                },
                api_version="2024-12-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_begin_update(self, resource_group):
        response = await (
            await self.client.configurations.begin_update(
                resource_group_name=resource_group.name,
                server_name="str",
                configuration_name="str",
                parameters={
                    "allowedValues": "str",
                    "currentValue": "str",
                    "dataType": "str",
                    "defaultValue": "str",
                    "description": "str",
                    "documentationLink": "str",
                    "id": "str",
                    "isConfigPendingRestart": "str",
                    "isDynamicConfig": "str",
                    "isReadOnly": "str",
                    "name": "str",
                    "source": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                    "value": "str",
                },
                api_version="2024-12-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_configurations_begin_batch_update(self, resource_group):
        response = await (
            await self.client.configurations.begin_batch_update(
                resource_group_name=resource_group.name,
                server_name="str",
                parameters={"resetAllToDefault": "str", "value": [{"name": "str", "source": "str", "value": "str"}]},
                api_version="2024-12-30",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
