# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.neonpostgres import NeonPostgresMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-neonpostgres
# USAGE
    python organizations_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = NeonPostgresMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.organizations.begin_update(
        resource_group_name="rgneon",
        organization_name="test-org",
        properties={
            "properties": {
                "companyDetails": {
                    "businessPhone": "hucxvzcvpaupqjkgb",
                    "companyName": "xtul",
                    "country": "ycmyjdcpyjieemfrthfyxdlvn",
                    "domain": "snoshqumfsthyofpnrsgyjhszvgtj",
                    "numberOfEmployees": 12,
                    "officeAddress": "icirtoqmmozijk",
                },
                "partnerOrganizationProperties": {
                    "organizationId": "fynmpcbivqkwqdfhrmsyusjd",
                    "organizationName": "entity-name",
                    "singleSignOnProperties": {
                        "aadDomains": ["mdzbelaiphukhe"],
                        "enterpriseAppId": "urtjzjfr",
                        "singleSignOnState": "Initial",
                        "singleSignOnUrl": "gcmlwvtxcsjozitm",
                    },
                },
                "projectProperties": {
                    "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                    "branch": {
                        "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                        "databaseName": "duhxebzhd",
                        "databases": [
                            {
                                "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                                "branchId": "orfdwdmzvfvlnrgussvcvoek",
                                "entityName": "entity-name",
                                "ownerName": "odmbeg",
                            }
                        ],
                        "endpoints": [
                            {
                                "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                                "branchId": "rzsyrhpfbydxtfkpaa",
                                "endpointType": "read_only",
                                "entityName": "entity-name",
                                "projectId": "rtvdeeflqzlrpfzhjqhcsfbldw",
                            }
                        ],
                        "entityName": "entity-name",
                        "parentId": "entity-id",
                        "projectId": "oik",
                        "roleName": "qrrairsupyosxnqotdwhbpc",
                        "roles": [
                            {
                                "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                                "branchId": "wxbojkmdgaggkfiwqfakdkbyztm",
                                "entityName": "entity-name",
                                "isSuperUser": True,
                                "permissions": ["myucqecpjriewzohxvadgkhiudnyx"],
                            }
                        ],
                    },
                    "databases": [
                        {
                            "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                            "branchId": "orfdwdmzvfvlnrgussvcvoek",
                            "entityName": "entity-name",
                            "ownerName": "odmbeg",
                        }
                    ],
                    "defaultEndpointSettings": {"autoscalingLimitMaxCu": 4, "autoscalingLimitMinCu": 8},
                    "endpoints": [
                        {
                            "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                            "branchId": "rzsyrhpfbydxtfkpaa",
                            "endpointType": "read_only",
                            "entityName": "entity-name",
                            "projectId": "rtvdeeflqzlrpfzhjqhcsfbldw",
                        }
                    ],
                    "entityName": "entity-name",
                    "historyRetention": 16,
                    "pgVersion": 16,
                    "regionId": "vxvmjwuttpiakirzdf",
                    "roles": [
                        {
                            "attributes": [{"name": "trhvzyvaqy", "value": "evpkgsskyavybxwwssm"}],
                            "branchId": "wxbojkmdgaggkfiwqfakdkbyztm",
                            "entityName": "entity-name",
                            "isSuperUser": True,
                            "permissions": ["myucqecpjriewzohxvadgkhiudnyx"],
                        }
                    ],
                    "storage": 23,
                },
                "userDetails": {
                    "emailAddress": "test@contoso.com",
                    "firstName": "zhelh",
                    "lastName": "zbdhouyeozylnerrc",
                    "phoneNumber": "zmejenytglrmjnt",
                    "upn": "mixcikvxlnhkfugetqlngz",
                },
            },
            "tags": {"key609": "qyosjypklxtiamqebd"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-03-01/Organizations_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
