# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementFirewallPoliciesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_begin_delete(self, resource_group):
        response = await (
            await self.client.firewall_policies.begin_delete(
                resource_group_name=resource_group.name,
                firewall_policy_name="str",
                api_version="2024-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_get(self, resource_group):
        response = await self.client.firewall_policies.get(
            resource_group_name=resource_group.name,
            firewall_policy_name="str",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.firewall_policies.begin_create_or_update(
                resource_group_name=resource_group.name,
                firewall_policy_name="str",
                parameters={
                    "basePolicy": {"id": "str"},
                    "childPolicies": [{"id": "str"}],
                    "dnsSettings": {"enableProxy": bool, "requireProxyForNetworkRules": bool, "servers": ["str"]},
                    "etag": "str",
                    "explicitProxy": {
                        "enableExplicitProxy": bool,
                        "enablePacFile": bool,
                        "httpPort": 0,
                        "httpsPort": 0,
                        "pacFile": "str",
                        "pacFilePort": 0,
                    },
                    "firewalls": [{"id": "str"}],
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "insights": {
                        "isEnabled": bool,
                        "logAnalyticsResources": {
                            "defaultWorkspaceId": {"id": "str"},
                            "workspaces": [{"region": "str", "workspaceId": {"id": "str"}}],
                        },
                        "retentionDays": 0,
                    },
                    "intrusionDetection": {
                        "configuration": {
                            "bypassTrafficSettings": [
                                {
                                    "description": "str",
                                    "destinationAddresses": ["str"],
                                    "destinationIpGroups": ["str"],
                                    "destinationPorts": ["str"],
                                    "name": "str",
                                    "protocol": "str",
                                    "sourceAddresses": ["str"],
                                    "sourceIpGroups": ["str"],
                                }
                            ],
                            "privateRanges": ["str"],
                            "signatureOverrides": [{"id": "str", "mode": "str"}],
                        },
                        "mode": "str",
                        "profile": "str",
                    },
                    "location": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "ruleCollectionGroups": [{"id": "str"}],
                    "size": "str",
                    "sku": {"tier": "str"},
                    "snat": {"autoLearnPrivateRanges": "str", "privateRanges": ["str"]},
                    "sql": {"allowSqlRedirect": bool},
                    "tags": {"str": "str"},
                    "threatIntelMode": "str",
                    "threatIntelWhitelist": {"fqdns": ["str"], "ipAddresses": ["str"]},
                    "transportSecurity": {"certificateAuthority": {"keyVaultSecretId": "str", "name": "str"}},
                    "type": "str",
                },
                api_version="2024-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_update_tags(self, resource_group):
        response = await self.client.firewall_policies.update_tags(
            resource_group_name=resource_group.name,
            firewall_policy_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_list(self, resource_group):
        response = self.client.firewall_policies.list(
            resource_group_name=resource_group.name,
            api_version="2024-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewall_policies_list_all(self, resource_group):
        response = self.client.firewall_policies.list_all(
            api_version="2024-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
