# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw.aio import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtFirewallsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_list_by_subscription(self, resource_group):
        response = self.client.firewalls.list_by_subscription(
            api_version="2025-10-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_list_by_resource_group(self, resource_group):
        response = self.client.firewalls.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-10-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_get(self, resource_group):
        response = await self.client.firewalls.get(
            resource_group_name=resource_group.name,
            firewall_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.firewalls.begin_create_or_update(
                resource_group_name=resource_group.name,
                firewall_name="str",
                resource={
                    "dnsSettings": {
                        "dnsServers": [{"address": "str", "resourceId": "str"}],
                        "enableDnsProxy": "str",
                        "enabledDnsType": "str",
                    },
                    "location": "str",
                    "marketplaceDetails": {
                        "offerId": "str",
                        "publisherId": "str",
                        "marketplaceSubscriptionId": "str",
                        "marketplaceSubscriptionStatus": "str",
                    },
                    "networkProfile": {
                        "enableEgressNat": "str",
                        "networkType": "str",
                        "publicIps": [{"address": "str", "resourceId": "str"}],
                        "egressNatIp": [{"address": "str", "resourceId": "str"}],
                        "privateSourceNatRulesDestination": ["str"],
                        "trustedRanges": ["str"],
                        "vnetConfiguration": {
                            "trustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "unTrustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "vnet": {"addressSpace": "str", "resourceId": "str"},
                            "ipOfTrustSubnetForUdr": {"address": "str", "resourceId": "str"},
                        },
                        "vwanConfiguration": {
                            "vHub": {"addressSpace": "str", "resourceId": "str"},
                            "ipOfTrustSubnetForUdr": {"address": "str", "resourceId": "str"},
                            "networkVirtualApplianceId": "str",
                            "trustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "unTrustSubnet": {"addressSpace": "str", "resourceId": "str"},
                        },
                    },
                    "planData": {
                        "billingCycle": "str",
                        "planId": "str",
                        "effectiveDate": "2020-02-20 00:00:00",
                        "usageType": "str",
                    },
                    "associatedRulestack": {"location": "str", "resourceId": "str", "rulestackId": "str"},
                    "frontEndSettings": [
                        {
                            "backendConfiguration": {"address": {"address": "str", "resourceId": "str"}, "port": "str"},
                            "frontendConfiguration": {
                                "address": {"address": "str", "resourceId": "str"},
                                "port": "str",
                            },
                            "name": "str",
                            "protocol": "str",
                        }
                    ],
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "isPanoramaManaged": "str",
                    "isStrataCloudManaged": "str",
                    "name": "str",
                    "panEtag": "str",
                    "panoramaConfig": {
                        "configString": "str",
                        "cgName": "str",
                        "dgName": "str",
                        "hostName": "str",
                        "panoramaServer": "str",
                        "panoramaServer2": "str",
                        "tplName": "str",
                        "vmAuthKey": "str",
                    },
                    "provisioningState": "str",
                    "strataCloudManagerConfig": {"cloudManagerName": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_update(self, resource_group):
        response = await self.client.firewalls.update(
            resource_group_name=resource_group.name,
            firewall_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "associatedRulestack": {"location": "str", "resourceId": "str", "rulestackId": "str"},
                    "dnsSettings": {
                        "dnsServers": [{"address": "str", "resourceId": "str"}],
                        "enableDnsProxy": "str",
                        "enabledDnsType": "str",
                    },
                    "frontEndSettings": [
                        {
                            "backendConfiguration": {"address": {"address": "str", "resourceId": "str"}, "port": "str"},
                            "frontendConfiguration": {
                                "address": {"address": "str", "resourceId": "str"},
                                "port": "str",
                            },
                            "name": "str",
                            "protocol": "str",
                        }
                    ],
                    "isPanoramaManaged": "str",
                    "isStrataCloudManaged": "str",
                    "marketplaceDetails": {
                        "offerId": "str",
                        "publisherId": "str",
                        "marketplaceSubscriptionId": "str",
                        "marketplaceSubscriptionStatus": "str",
                    },
                    "networkProfile": {
                        "enableEgressNat": "str",
                        "networkType": "str",
                        "publicIps": [{"address": "str", "resourceId": "str"}],
                        "egressNatIp": [{"address": "str", "resourceId": "str"}],
                        "privateSourceNatRulesDestination": ["str"],
                        "trustedRanges": ["str"],
                        "vnetConfiguration": {
                            "trustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "unTrustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "vnet": {"addressSpace": "str", "resourceId": "str"},
                            "ipOfTrustSubnetForUdr": {"address": "str", "resourceId": "str"},
                        },
                        "vwanConfiguration": {
                            "vHub": {"addressSpace": "str", "resourceId": "str"},
                            "ipOfTrustSubnetForUdr": {"address": "str", "resourceId": "str"},
                            "networkVirtualApplianceId": "str",
                            "trustSubnet": {"addressSpace": "str", "resourceId": "str"},
                            "unTrustSubnet": {"addressSpace": "str", "resourceId": "str"},
                        },
                    },
                    "panEtag": "str",
                    "panoramaConfig": {
                        "configString": "str",
                        "cgName": "str",
                        "dgName": "str",
                        "hostName": "str",
                        "panoramaServer": "str",
                        "panoramaServer2": "str",
                        "tplName": "str",
                        "vmAuthKey": "str",
                    },
                    "planData": {
                        "billingCycle": "str",
                        "planId": "str",
                        "effectiveDate": "2020-02-20 00:00:00",
                        "usageType": "str",
                    },
                    "strataCloudManagerConfig": {"cloudManagerName": "str"},
                },
                "tags": {"str": "str"},
            },
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_begin_delete(self, resource_group):
        response = await (
            await self.client.firewalls.begin_delete(
                resource_group_name=resource_group.name,
                firewall_name="str",
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_get_global_rulestack(self, resource_group):
        response = await self.client.firewalls.get_global_rulestack(
            resource_group_name=resource_group.name,
            firewall_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_get_log_profile(self, resource_group):
        response = await self.client.firewalls.get_log_profile(
            resource_group_name=resource_group.name,
            firewall_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_get_support_info(self, resource_group):
        response = await self.client.firewalls.get_support_info(
            resource_group_name=resource_group.name,
            firewall_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_firewalls_save_log_profile(self, resource_group):
        response = await self.client.firewalls.save_log_profile(
            resource_group_name=resource_group.name,
            firewall_name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...
