# Code of Conduct

Diversity is one of our huge strengths, but it can also lead to communication issues. To support a welcoming environment
for all, regardless of individual differences, we have a few ground rules that we ask people to adhere to when they
participate in this community. These rules apply equally to founders, organizers, contributors, users and affiliates —
in short, to all participants.

This isn’t an exhaustive list of things that you must do, or can’t do. Rather, take it in the spirit in which it’s
intended. It’s a guide to make it easier to enrich all of us and the technical communities in which we participate, and
which we represent.

## Our Pledge

We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for
everyone, regardless of background or identity. This includes, but is not limited to, members of any race, ethnicity,
culture, national origin, color, immigration status, social and economic class, educational level, sex, sexual
orientation, gender identity and expression, age, size, family status, political belief, religion, level of experience,
and mental or physical ability.

We pledge to be respectful. Not all of us will agree all the time, but disagreement is no excuse for poor behavior and
poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a
personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a
productive one. Members of the PyQtGraph community should be respectful when dealing with each other as well as with
people outside the community.

We pledge to be welcoming, supportive, kind and professional. We pledge to act and interact in ways that contribute to
an open, diverse, inclusive, and healthy community. We pledge not insult or put down other participants, individually or
as a group. Harassment and other exclusionary behavior aren’t acceptable.

## Examples

Examples of behavior that contributes to a positive environment for our community include:

* Demonstrating empathy and kindness toward other people
* Being respectful of differing opinions, viewpoints, and experiences
* Giving and gracefully accepting constructive feedback
* Accepting responsibility and apologizing to those affected by our mistakes, and learning from the experience
* Focusing on what is best not just for us as individuals, but for the overall community

Examples of unacceptable behavior include:

* Violent threats or language directed against another person.
* Discriminatory jokes and language.
* Posting sexually explicit or violent material.
* Posting (or threatening to post) other people’s personally identifying information ("doxing").
* Personal insults, especially those using racist or sexist terms.
* Unwelcome sexual attention.
* Repeated harassment of others. In general, if someone asks you to stop, then stop.
* Advocating for, or encouraging, any of the above behavior.

## Where does this code of conduct apply

This Code of Conduct applies within all online community spaces, official organized meetups, and when an individual is
officially representing the community in public spaces, online or offline.

## What to do in case of violations

If you believe someone is violating the code of conduct, we ask that you report it by contacting any of the following
individuals, being sure to include mention of your message being about a "PyQtGraph conduct violation":

* Ognyan Moore @j9ac9k <ognyan.moore@gmail.com>
* Martin Chase @outofculture <outofculture@gmail.com>
* Nathan Jessurun @ntjess <ntjessu@gmail.com>

All complaints will be reviewed and investigated promptly and fairly. All reports will be kept confidential. In some
cases, we may determine that a public statement will need to be made. If that’s the case, the identities of all victims
and reporters will remain confidential unless those individuals instruct us otherwise.

If you believe anyone is in physical danger, please notify appropriate law enforcement first. If you are unsure which
law enforcement agency is appropriate, please include this in your report and we will attempt to notify them.

### What to include in the report

* Your contact information (so we can get in touch with you if we need to follow up)
* Names of any individuals involved (real names, nicknames, or pseudonyms). If there were other witnesses besides you,
  please try to include them as well.
* When and where the incident occurred. Please be as specific as possible.
* Your account of what occurred. If there is a publicly available record (e.g., a mailing list archive or a public chat
  logger) please include a link. Our Slack is currently on a free plan that does not retain more than 10,000 messages of
  history, if an incident occurred on Slack please take a screenshot so it is not lost.
* Any extra context you believe existed for the incident.
* Whether you believe this incident is ongoing.
* Any other information you believe we should have.

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of acceptable behavior and will take
appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Community leaders have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits,
issues, and other contributions that are not aligned to this Code of Conduct, and will communicate reasons for
moderation decisions when appropriate. This removal should be as transparent as possible, with information available in
the same scope of context as the original moderated content, linking to an incident report, the acting moderators,
and/or this document as appropriate.

All community leaders are obligated to respect the privacy and security of the reporter of any incident.

Upon receiving a report of misconduct, the staff must review the incident and determine the following:

* What happened.
* Whether this event constitutes a code of conduct violation.
* Who the bad actor(s) was.
* Whether this is an ongoing situation.
* If any previous disiplinary measures are relevent and in effect.
* If there is a threat to anyone’s physical safety.
* What impact this has had on the community.

After the conduct committee has a complete account of the events they need to make a decision as to how to resolve the
case. Resolutions might include:

* Nothing (if we determine no violation occurred).
* A private reprimand from the staff to the individual(s) involved, providing clarity around the nature of the
  violation, and an explanation of why the behavior was inappropriate.
* A request for a public or private apology.
* A public reprimand.
* An imposed vacation (for example, asking someone to "take a week off" from Slack).
* A permanent or temporary ban from some or all PyQtGraph spaces (Slack, github, mailing list or events) or from
  communicating, in public or in private, with some are all of the members of our community.
* Contacting law enforcement.

A response must be sent within one week to the person who filed the report with either a resolution or an explanation of
why the situation is not yet resolved.

A Code of Conduct transparency report will then be published
to [the PyQtGraph users' list](https://groups.google.com/g/pyqtgraph) with anonymized information about any violations
that might have occurred. This report should be handled with care not to divulge personally identifying information
about victims, reporters, and violators, and should serve as a means to ensure that members will be comfortable
reporting violations and that our community will be kept accountable for supporting and encouraging safe spaces.

## Attribution

This Code of Conduct is adapted from
the [Contributor Covenant, version 2.0](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html) and
the [PuPPy Code of Conduct](https://www.pspython.com/pages/code-of-conduct/).
