# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class ConnectionPolicyTargetTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .targets.create(target="https://example.com")

        values = {'Target': "https://example.com", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/ConnectionPolicies/NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Targets',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "connection_policy_sid": "NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "friendly_name",
                "target": "sip:sip-box.com:1234",
                "priority": 1,
                "weight": 20,
                "enabled": true,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:36Z",
                "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets/NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets.create(target="https://example.com")

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/ConnectionPolicies/NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Targets/NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "connection_policy_sid": "NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "friendly_name",
                "target": "sip:sip-box.com:1234",
                "priority": 1,
                "weight": 20,
                "enabled": true,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets/NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .targets.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/ConnectionPolicies/NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Targets',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "targets"
                },
                "targets": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "connection_policy_sid": "NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "friendly_name",
                        "target": "sip:sip-box.com:1234",
                        "priority": 1,
                        "weight": 20,
                        "enabled": true,
                        "date_created": "2020-03-18T23:31:36Z",
                        "date_updated": "2020-03-18T23:31:37Z",
                        "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets/NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets.list()

        self.assertIsNotNone(actual)

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "targets"
                },
                "targets": []
            }
            '''
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets.list()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/ConnectionPolicies/NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Targets/NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "connection_policy_sid": "NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "updated_name",
                "target": "sip:sip-updated.com:4321",
                "priority": 2,
                "weight": 10,
                "enabled": false,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/ConnectionPolicies/NYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa/Targets/NEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://voice.twilio.com/v1/ConnectionPolicies/NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX/Targets/NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.voice.v1.connection_policies("NYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX") \
                                     .targets("NEXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
