# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.trusthub.v1.trust_products.trust_products_channel_endpoint_assignment import TrustProductsChannelEndpointAssignmentList
from twilio.rest.trusthub.v1.trust_products.trust_products_entity_assignments import TrustProductsEntityAssignmentsList
from twilio.rest.trusthub.v1.trust_products.trust_products_evaluations import TrustProductsEvaluationsList


class TrustProductsList(ListResource):

    def __init__(self, version):
        """
        Initialize the TrustProductsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsList
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsList
        """
        super(TrustProductsList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/TrustProducts'.format(**self._solution)

    def create(self, friendly_name, email, policy_sid,
               status_callback=values.unset):
        """
        Create the TrustProductsInstance

        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode email: The email address
        :param unicode policy_sid: The unique string of a policy.
        :param unicode status_callback: The URL we call to inform your application of status changes.

        :returns: The created TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        data = values.of({
            'FriendlyName': friendly_name,
            'Email': email,
            'PolicySid': policy_sid,
            'StatusCallback': status_callback,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return TrustProductsInstance(self._version, payload, )

    def stream(self, status=values.unset, friendly_name=values.unset,
               policy_sid=values.unset, limit=None, page_size=None):
        """
        Streams TrustProductsInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param TrustProductsInstance.Status status: The verification status of the Customer-Profile resource
        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode policy_sid: The unique string of a policy.
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trusthub.v1.trust_products.TrustProductsInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(
            status=status,
            friendly_name=friendly_name,
            policy_sid=policy_sid,
            page_size=limits['page_size'],
        )

        return self._version.stream(page, limits['limit'])

    def list(self, status=values.unset, friendly_name=values.unset,
             policy_sid=values.unset, limit=None, page_size=None):
        """
        Lists TrustProductsInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param TrustProductsInstance.Status status: The verification status of the Customer-Profile resource
        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode policy_sid: The unique string of a policy.
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.trusthub.v1.trust_products.TrustProductsInstance]
        """
        return list(self.stream(
            status=status,
            friendly_name=friendly_name,
            policy_sid=policy_sid,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, status=values.unset, friendly_name=values.unset,
             policy_sid=values.unset, page_token=values.unset,
             page_number=values.unset, page_size=values.unset):
        """
        Retrieve a single page of TrustProductsInstance records from the API.
        Request is executed immediately

        :param TrustProductsInstance.Status status: The verification status of the Customer-Profile resource
        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode policy_sid: The unique string of a policy.
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsPage
        """
        data = values.of({
            'Status': status,
            'FriendlyName': friendly_name,
            'PolicySid': policy_sid,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return TrustProductsPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of TrustProductsInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return TrustProductsPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a TrustProductsContext

        :param sid: The unique string that identifies the resource.

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        """
        return TrustProductsContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a TrustProductsContext

        :param sid: The unique string that identifies the resource.

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        """
        return TrustProductsContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trusthub.V1.TrustProductsList>'


class TrustProductsPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the TrustProductsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsPage
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsPage
        """
        super(TrustProductsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TrustProductsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        return TrustProductsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Trusthub.V1.TrustProductsPage>'


class TrustProductsContext(InstanceContext):

    def __init__(self, version, sid):
        """
        Initialize the TrustProductsContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the resource.

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        """
        super(TrustProductsContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/TrustProducts/{sid}'.format(**self._solution)

        # Dependents
        self._trust_products_entity_assignments = None
        self._trust_products_evaluations = None
        self._trust_products_channel_endpoint_assignment = None

    def fetch(self):
        """
        Fetch the TrustProductsInstance

        :returns: The fetched TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return TrustProductsInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, status=values.unset, status_callback=values.unset,
               friendly_name=values.unset, email=values.unset):
        """
        Update the TrustProductsInstance

        :param TrustProductsInstance.Status status: The verification status of the Customer-Profile resource
        :param unicode status_callback: The URL we call to inform your application of status changes.
        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode email: The email address

        :returns: The updated TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        data = values.of({
            'Status': status,
            'StatusCallback': status_callback,
            'FriendlyName': friendly_name,
            'Email': email,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return TrustProductsInstance(self._version, payload, sid=self._solution['sid'], )

    def delete(self):
        """
        Deletes the TrustProductsInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    @property
    def trust_products_entity_assignments(self):
        """
        Access the trust_products_entity_assignments

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_entity_assignments.TrustProductsEntityAssignmentsList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_entity_assignments.TrustProductsEntityAssignmentsList
        """
        if self._trust_products_entity_assignments is None:
            self._trust_products_entity_assignments = TrustProductsEntityAssignmentsList(
                self._version,
                trust_product_sid=self._solution['sid'],
            )
        return self._trust_products_entity_assignments

    @property
    def trust_products_evaluations(self):
        """
        Access the trust_products_evaluations

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_evaluations.TrustProductsEvaluationsList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_evaluations.TrustProductsEvaluationsList
        """
        if self._trust_products_evaluations is None:
            self._trust_products_evaluations = TrustProductsEvaluationsList(
                self._version,
                trust_product_sid=self._solution['sid'],
            )
        return self._trust_products_evaluations

    @property
    def trust_products_channel_endpoint_assignment(self):
        """
        Access the trust_products_channel_endpoint_assignment

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_channel_endpoint_assignment.TrustProductsChannelEndpointAssignmentList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_channel_endpoint_assignment.TrustProductsChannelEndpointAssignmentList
        """
        if self._trust_products_channel_endpoint_assignment is None:
            self._trust_products_channel_endpoint_assignment = TrustProductsChannelEndpointAssignmentList(
                self._version,
                trust_product_sid=self._solution['sid'],
            )
        return self._trust_products_channel_endpoint_assignment

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trusthub.V1.TrustProductsContext {}>'.format(context)


class TrustProductsInstance(InstanceResource):

    class Status(object):
        DRAFT = "draft"
        PENDING_REVIEW = "pending-review"
        IN_REVIEW = "in-review"
        TWILIO_REJECTED = "twilio-rejected"
        TWILIO_APPROVED = "twilio-approved"

    class EndUserType(object):
        INDIVIDUAL = "individual"
        BUSINESS = "business"

    def __init__(self, version, payload, sid=None):
        """
        Initialize the TrustProductsInstance

        :returns: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        super(TrustProductsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'policy_sid': payload.get('policy_sid'),
            'friendly_name': payload.get('friendly_name'),
            'status': payload.get('status'),
            'valid_until': deserialize.iso8601_datetime(payload.get('valid_until')),
            'email': payload.get('email'),
            'status_callback': payload.get('status_callback'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: TrustProductsContext for this TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsContext
        """
        if self._context is None:
            self._context = TrustProductsContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def policy_sid(self):
        """
        :returns: The unique string of a policy.
        :rtype: unicode
        """
        return self._properties['policy_sid']

    @property
    def friendly_name(self):
        """
        :returns: The string that you assigned to describe the resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def status(self):
        """
        :returns: The verification status of the Customer-Profile resource
        :rtype: TrustProductsInstance.Status
        """
        return self._properties['status']

    @property
    def valid_until(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource will be valid until.
        :rtype: datetime
        """
        return self._properties['valid_until']

    @property
    def email(self):
        """
        :returns: The email address
        :rtype: unicode
        """
        return self._properties['email']

    @property
    def status_callback(self):
        """
        :returns: The URL we call to inform your application of status changes.
        :rtype: unicode
        """
        return self._properties['status_callback']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Customer-Profile resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The URLs of the Assigned Items of the Customer-Profile resource
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the TrustProductsInstance

        :returns: The fetched TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        return self._proxy.fetch()

    def update(self, status=values.unset, status_callback=values.unset,
               friendly_name=values.unset, email=values.unset):
        """
        Update the TrustProductsInstance

        :param TrustProductsInstance.Status status: The verification status of the Customer-Profile resource
        :param unicode status_callback: The URL we call to inform your application of status changes.
        :param unicode friendly_name: The string that you assigned to describe the resource
        :param unicode email: The email address

        :returns: The updated TrustProductsInstance
        :rtype: twilio.rest.trusthub.v1.trust_products.TrustProductsInstance
        """
        return self._proxy.update(
            status=status,
            status_callback=status_callback,
            friendly_name=friendly_name,
            email=email,
        )

    def delete(self):
        """
        Deletes the TrustProductsInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    @property
    def trust_products_entity_assignments(self):
        """
        Access the trust_products_entity_assignments

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_entity_assignments.TrustProductsEntityAssignmentsList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_entity_assignments.TrustProductsEntityAssignmentsList
        """
        return self._proxy.trust_products_entity_assignments

    @property
    def trust_products_evaluations(self):
        """
        Access the trust_products_evaluations

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_evaluations.TrustProductsEvaluationsList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_evaluations.TrustProductsEvaluationsList
        """
        return self._proxy.trust_products_evaluations

    @property
    def trust_products_channel_endpoint_assignment(self):
        """
        Access the trust_products_channel_endpoint_assignment

        :returns: twilio.rest.trusthub.v1.trust_products.trust_products_channel_endpoint_assignment.TrustProductsChannelEndpointAssignmentList
        :rtype: twilio.rest.trusthub.v1.trust_products.trust_products_channel_endpoint_assignment.TrustProductsChannelEndpointAssignmentList
        """
        return self._proxy.trust_products_channel_endpoint_assignment

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Trusthub.V1.TrustProductsInstance {}>'.format(context)
