% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{read_hdf5_biom}
\alias{read_hdf5_biom}
\title{Read in a biom-format vs 2 file, returning a \code{list}.}
\usage{
read_hdf5_biom(biom_file)
}
\arguments{
\item{biom_file}{(Required). A biom object that is going to be written to file
 as a proper biom formatted file, adhering to
 \href{http://biom-format.org/documentation/biom_format.html}{the biom-format definition}.}
}
\value{
Nothing. The first argument, \code{x}, is written to a file.
}
\description{
This function is meant only to be used if the user knows the file is
a particular version / hdf5 format. Otherwise, the `read_biom` file should be used.
}
\examples{
biom_file <- system.file("extdata", "rich_sparse_otu_table_hdf5.biom", package = "biomformat")
x = read_hdf5_biom(biom_file)
x = biom(x)
outfile = tempfile()
write_biom(x, outfile)
y = read_biom(outfile)
identical(observation_metadata(x),observation_metadata(y))
identical(sample_metadata(x),sample_metadata(y))
identical(biom_data(x), biom_data(y))
}
\references{
\url{http://biom-format.org/}
}
\seealso{
Function to create a biom object from R data,
\code{\link{make_biom}}.

Definition of the
\code{\link{biom-class}}.

The \code{\link{read_hdf5_biom}} import function.

Accessor functions like \code{\link{header}}.
}

