% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{from_DelayedArray_to_simple_seed_class}
\alias{from_DelayedArray_to_simple_seed_class}
\title{Coerce DelayedArray to its 'simple seed' form}
\usage{
from_DelayedArray_to_simple_seed_class(x, drop = FALSE, do_transpose = TRUE)
}
\arguments{
\item{x}{A \linkS4class{DelayedArray}}

\item{drop}{If \code{TRUE} the result is coerced to the lowest possible dimension}

\item{do_transpose}{Should transposed input be physically transposed?}
}
\value{
An object of the same class as \code{seedClass(x)}.
}
\description{
Coerce DelayedArray to its 'simple seed' form
}
\details{
Like \code{DelayedArray:::.from_DelayedArray_to_array} but returning an
object of the same class as \code{seedClass(x)} instead of an \emph{array}. In
doing so, all delayed operations are realised (including subsetting).
}
\note{
Can be more efficient to leave the transpose implicit
(\code{do_transpose = FALSE}) and switch from a \verb{row*()} method to a \verb{col*()}
method (or vice versa).

Only works on \linkS4class{DelayedArray} objects with 'simple seeds'
}
\keyword{internal}
