% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowDiffs.R
\name{rowDiffs}
\alias{rowDiffs}
\alias{rowDiffs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowDiffs,ANY-method}
\alias{colDiffs}
\alias{colDiffs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colDiffs,ANY-method}
\title{Calculates the difference between each element of a row (column) of a
matrix-like object}
\usage{
rowDiffs(x, rows = NULL, cols = NULL, lag = 1L, differences = 1L, ...)

\S4method{rowDiffs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, lag = 1L, differences = 1L, dim. = dim(x), ...)

\S4method{rowDiffs}{ANY}(x, rows = NULL, cols = NULL, lag = 1L, differences = 1L, ...)

colDiffs(x, rows = NULL, cols = NULL, lag = 1L, differences = 1L, ...)

\S4method{colDiffs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, lag = 1L, differences = 1L, dim. = dim(x), ...)

\S4method{colDiffs}{ANY}(x, rows = NULL, cols = NULL, lag = 1L, differences = 1L, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{lag}{An integer specifying the lag.}

\item{differences}{An integer specifying the order of difference.}

\item{...}{Additional arguments passed to specific methods.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}} with one column
(row) less than x: \eqn{Nx(K-1)} or \eqn{(N-1)xK}.
}
\description{
Calculates the difference between each element of a row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowDiffs}
/ \code{matrixStats::colDiffs}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowDiffs(mat)
  colDiffs(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowDiffs}()} and
\code{matrixStats::\link[matrixStats:rowDiffs]{colDiffs}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item \code{base::\link{diff}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
