% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\name{readCdrDesignData}
\alias{readCdrDesignData}
\title{Read .CSV containing CDR 'Design Data' extract}
\usage{
readCdrDesignData(cdrDesignData)
}
\arguments{
\item{cdrDesignData}{Path to the .CSV file containing the content extracted from the CDR's 'Design Data' tab}
}
\value{
A data frame containing the contents of the CDR 'Design Data' tab.
}
\description{
Return a data frame containing the contents of the 'Design Data' tab
                extracted from a CDR spreadsheet. The extract, a .CSV file, must be
                manually prepared in advance (see 'details' section in the
                buildCodesetAnnotation() help page for more info).
}
\examples{
path <- system.file("extdata", "CDR", "CDR-DesignData.csv", package="NanoStringQCPro")
cdr <- readCdrDesignData(path)

}
\author{
Robert Ziman
}
