% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findFocal.R
\name{findFocal}
\alias{findFocal}
\title{Find focal amplifications}
\usage{
findFocal(seg, max.size = 3e+06, cn.diff = 2, min.amp.cn = 5)
}
\arguments{
\item{seg}{Segmentation data.}

\item{max.size}{Cutoff for focal in base pairs.}

\item{cn.diff}{Minimum copy number delta between neighboring segments.}

\item{min.amp.cn}{Minimum amplification integer copy number. Segments with
lower copy number are not tested.}
}
\value{
\code{logical(n)}, indicating for all n segments whether they are
focally amplified or not.
}
\description{
Function to find focal amplifications in segmented data.  This is
automatically called in \code{\link{runAbsoluteCN}}.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal_tiny.txt", 
    package="PureCN")
tumor.coverage.file <- system.file("extdata", "example_tumor_tiny.txt", 
    package="PureCN")
vcf.file <- system.file("extdata", "example.vcf.gz", 
    package="PureCN")
interval.file <- system.file("extdata", "example_intervals_tiny.txt", 
    package="PureCN")

# The max.candidate.solutions, max.ploidy and test.purity parameters are set to
# non-default values to speed-up this example.  This is not a good idea for real
# samples.
ret <-runAbsoluteCN(normal.coverage.file=normal.coverage.file, 
    tumor.coverage.file=tumor.coverage.file, vcf.file=vcf.file, genome="hg19", 
    sampleid="Sample1", interval.file=interval.file,
    max.candidate.solutions=1, max.ploidy=4, test.purity=seq(0.3,0.7,by=0.05), 
    args.focal=list(max.size = 2e+06), fun.focal=findFocal)

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
