% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickPseudotime.R
\name{quickPseudotime}
\alias{quickPseudotime}
\title{Quick MST-based pseudotime}
\usage{
quickPseudotime(
  x,
  clusters,
  use = 1,
  outgroup = FALSE,
  outscale = 3,
  start = NULL
)
}
\arguments{
\item{x}{A named list of numeric matrices containing dimensionality reduction results.
All matrices should have the same number of cells, i.e., rows.
Alternatively, a \linkS4class{SingleCellExperiment} containing such results in its \code{\link{reducedDims}}.}

\item{clusters}{A factor of length equal to the number of cells in \code{x},
specifying the cluster assignment for each cell.}

\item{use}{Integer scalar or string specifying the entry of \code{x} to use for MST construction and pseudotime calculations.}

\item{outgroup, outscale}{Arguments passed to \code{\link{createClusterMST}}.}

\item{start}{Arguments passed to \code{\link{orderClusterMST}}.}
}
\value{
A \linkS4class{List} containing:
\itemize{
\item \code{centered}, a list of numeric matrices containing the averaged coordinates for each cluster.
Each matrix corresponds to a dimensionality reduction result in \code{x}.
\item \code{mst}, a \link{graph} object containing the cluster-level MST computed on the coordinates from \code{use}.
\item \code{ordering}, a numeric matrix of pseudotimes for various paths through the MST computed from \code{use}.
\item \code{connected}, a list of data.frames containing the edge coordinates between centers.
Each data.frame corresponds to a dimensionality reduction result in \code{x}.
}
}
\description{
A convenience wrapper to quickly compute a minimum spanning tree (MST) on the cluster centroids
to obtain a pseudotime ordering of the cells.
This function is now deprecated as it has been moved to the \pkg{TSCAN} package itself.
}
\details{
This function simply calls, in order:
\itemize{
\item \code{\link{rowsum}}, to compute the average low-dimensional coordinates for each cluster.
\item \code{\link{createClusterMST}} on the average coordinates specified by \code{use}.
\item \code{\link{orderClusterMST}} on the average and per-cell coordinates specified by \code{use}.
\item \code{\link{connectClusterMST}} on the average coordinates for all entries of \code{x}.
}
}
\examples{
# Mocking up some data:
library(scuttle)
sce <- mockSCE(ncells=500)
sce <- logNormCounts(sce)
sce <- scater::runPCA(sce)
clusters <- clusterSNNGraph(sce, use.dimred="PCA")

# Quickly computing the pseudotime:
out <- quickPseudotime(sce, clusters, use="PCA")
out$mst
head(out$ordering)

}
\seealso{
\code{\link{createClusterMST}} and friends, for the functions that do the actual work.
}
\author{
Aaron Lun
}
