% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZeiselBrainData.R
\name{ZeiselBrainData}
\alias{ZeiselBrainData}
\title{Obtain the Zeisel brain data}
\usage{
ZeiselBrainData(ensembl = FALSE, location = TRUE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of UMI counts.
}
\description{
Obtain the mouse brain single-cell RNA-seq dataset from Zeisel et al. (2015).
}
\details{
Row data contains a single \code{"featureType"} field describing the type of each feature
(endogenous genes, mitochondrial genes, spike-in transcripts and repeats).
Spike-ins and repeats are stored as separate entries in the \code{\link{altExps}}.

Column metadata is provided in the same form as supplied in \url{http://linnarssonlab.org/cortex/}.
This contains information such as the cell diameter and the published cell type annotations.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

Spike-in metadata is added using \code{\link{ERCCSpikeInConcentrations}},
with molecule counts computed using a volume of 9 nL per cell at a dilution of 1:20000.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/zeisel-brain}.
}
\examples{
sce <- ZeiselBrainData()

}
\references{
Zeisel A et al. (2015). 
Brain structure. Cell types in the mouse cortex and hippocampus revealed by single-cell RNA-seq. 
\emph{Science} 347(6226), 1138-42.
}
\author{
Aaron Lun
}
