% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assays.R
\docType{methods}
\name{SCE-assays}
\alias{SCE-assays}
\alias{counts}
\alias{counts<-}
\alias{counts,SingleCellExperiment-method}
\alias{counts<-,SingleCellExperiment-method}
\alias{normcounts}
\alias{normcounts<-}
\alias{normcounts,SingleCellExperiment-method}
\alias{normcounts<-,SingleCellExperiment-method}
\alias{logcounts}
\alias{logcounts<-}
\alias{logcounts,SingleCellExperiment-method}
\alias{logcounts<-,SingleCellExperiment-method}
\alias{cpm}
\alias{cpm<-}
\alias{cpm,SingleCellExperiment-method}
\alias{cpm<-,SingleCellExperiment-method}
\alias{tpm}
\alias{tpm<-}
\alias{tpm,SingleCellExperiment-method}
\alias{tpm<-,SingleCellExperiment-method}
\alias{weights}
\alias{weights<-}
\alias{weights,SingleCellExperiment-method}
\alias{weights<-,SingleCellExperiment-method}
\title{Named assay getters and setters}
\description{
These are methods for getting or setting \code{assay(sce, i=X, ...)} 
where \code{sce} is a \linkS4class{SingleCellExperiment} object and \code{X} is the name of the method.
For example, \code{counts} will get or set \code{X="counts"}.
This provides some convenience for users as well as encouraging standardization of assay names across packages.
}
\section{Available methods}{

In the following code snippets, \code{x} is a \linkS4class{SingleCellExperiment} object,
\code{value} is a matrix-like object with the same dimensions as \code{x},
and \code{...} are further arguments passed to \code{\link{assay}} (for the getter) or \code{\link{assay<-}} (for the setter).
\describe{
\item{\code{counts(x, ...)}, \code{counts(x, ...) <- value}:}{
Get or set a matrix of raw count data, e.g., number of reads or transcripts.
}
\item{\code{normcounts(x, ...)}, \code{normcounts(x, ...) <- value}:}{
Get or set a matrix of normalized values on the same scale as the original counts.
For example, counts divided by cell-specific size factors that are centred at unity.
}
\item{\code{logcounts(x, ...)}, \code{logcounts(x, ...) <- value}:}{
Get or set a matrix of log-transformed counts or count-like values.
In most cases, this will be defined as log-transformed \code{normcounts}, e.g., using log base 2 and a pseudo-count of 1.
}
\item{\code{cpm(x, ...)}, \code{cpm(x, ...) <- value}:}{
Get or set a matrix of counts-per-million values.
This is the read count for each gene in each cell, divided by the library size of each cell in millions.
}
\item{\code{tpm(x, ...)}, \code{tpm(x, ...) <- value}:}{
Get or set a matrix of transcripts-per-million values.
This is the number of transcripts for each gene in each cell, divided by the total number of transcripts in that cell (in millions).
}
\item{\code{weights(x, ...)}, \code{weights(x, ...) <- value}:}{
Get or set a matrix of weights, e.g., observational weights to be used in differential expression analysis.
}
}
}

\examples{
example(SingleCellExperiment, echo=FALSE) # Using the class example
counts(sce) <- matrix(rnorm(nrow(sce)*ncol(sce)), ncol=ncol(sce))
dim(counts(sce))

# One possible way of computing normalized "counts"
sf <- 2^rnorm(ncol(sce))
sf <- sf/mean(sf)
normcounts(sce) <- t(t(counts(sce))/sf)
dim(normcounts(sce))

# One possible way of computing log-counts
logcounts(sce) <- log2(normcounts(sce)+1)
dim(normcounts(sce))

}
\seealso{
\code{\link{assay}} and \code{\link{assay<-}}, for the wrapped methods.
}
\author{
Aaron Lun
}
