% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colMeans2,xgCMatrix-method}
\alias{colMeans2,xgCMatrix-method}
\alias{rowMeans2,xgCMatrix-method}
\title{Calculates the mean for each row (column) of a matrix-like object}
\usage{
\S4method{colMeans2}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE)

\S4method{rowMeans2}{xgCMatrix}(x, rows = NULL, cols = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the mean for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowMeans2}
/ \code{matrixStats::colMeans2}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowMeans2(mat)
  colMeans2(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowMeans2}()} and
\code{matrixStats::\link[matrixStats:rowMeans2]{colMeans2}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \code{\link[base:colSums]{rowMeans}()} for the
corresponding function in base R.
\item For variance estimates, see \code{\link[MatrixGenerics]{rowVars}()}.
\item See also the base R version \code{base::\link{rowMeans}()}.
}
}
