% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostepsva.build.R
\name{twostepsva.build}
\alias{twostepsva.build}
\title{A function for estimating surrogate variables with the two step approach of Leek and Storey 2007}
\usage{
twostepsva.build(dat, mod, n.sv)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{mod}{The model matrix being used to fit the data}

\item{n.sv}{The number of surogate variables to estimate}
}
\value{
sv The estimated surrogate variables, one in each column

pprob.gam: A vector of the posterior probabilities each gene is affected by heterogeneity

pprob.b A vector of the posterior probabilities each gene is affected by mod (this is always null for the two-step approach)

n.sv The number of significant surrogate variables
}
\description{
This function is the implementation of the two step approach for estimating surrogate
variables proposed by Leek and Storey 2007 PLoS Genetics. This function is primarily
included for backwards compatibility. Newer versions of the sva algorithm are available
through \code{\link{sva}}, \code{\link{svaseq}}, with low level functionality available
through \code{\link{irwsva.build}} and \code{\link{ssva}}.
}
\examples{
library(bladderbatch)
library(limma)
data(bladderdata)
dat <- bladderEset

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)

n.sv = num.sv(edata,mod,method="leek")
svatwostep <- twostepsva.build(edata,mod,n.sv)

}
