% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{TCGAquery_recount2}
\alias{TCGAquery_recount2}
\title{Query gene counts of TCGA and GTEx data from the Recount2 project}
\usage{
TCGAquery_recount2(project, tissue = c())
}
\arguments{
\item{project}{is a string denoting which project the user wants. Options are "tcga" and "gtex"}

\item{tissue}{a vector of tissue(s) to download. Options are "adipose tissue", "adrenal", "gland", "bladder","blood", "blood vessel", "bone marrow", "brain", "breast","cervix uteri", "colon", "esophagus", "fallopian tube","heart", "kidney", "liver", "lung", "muscle", "nerve", "ovary","pancreas", "pituitary", "prostate", "salivary", "gland", "skin", "small intestine", "spleen", "stomach", "testis", "thyroid", "uterus", "vagina"}
}
\value{
List with $subtypes attribute as a dataframe with barcodes, samples, subtypes, and colors. The $filtered attribute is returned as filtered samples with no subtype info
}
\description{
TCGArecount2_query queries and downloads data produced by the Recount2 project. User can specify which project and which tissue to query
}
\examples{
\dontrun{
 brain.rec<-TCGAquery_recount2(project = "gtex", tissue = "brain")
}
}
