% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tximeta.R
\docType{package}
\name{tximeta-package}
\alias{tximeta-package}
\title{Import transcript-level quantification data with automatic metadata}
\description{
The tximeta package imports abundances (TPM), estimated counts,
and effective lengths from Salmon, alevin, or other quantification
tools, and will output a SummarizedExperiment object. For Salmon
and alevin quantification directories, \code{tximeta} will
try to identify the correct provenance of the reference transcripts
and automatically attach the transcript ranges to the
SummarizedExperiment, to facilitate downstream integration with
other datasets. The automatic identification of reference transcripts
should work out-of-the-box for human or mouse transcriptomes from
the sources: GENCODE, Ensembl, or RefSeq.
}
\details{
The main functions are:
\itemize{
\item \code{\link{tximeta}} - with key argument: \code{coldata}
\item \code{\link{summarizeToGene}} - summarize quants to gene-level
\item \code{\link{retrieveDb}} - retrieve the transcript database
\item \code{\link{addIds}} - add transcript or gene ID (see \code{gene} argument)
\item \code{\link{addExons}} - convert from GRanges to GRangesList
}

All software-related questions should be posted to the Bioconductor Support Site:

\url{https://support.bioconductor.org}

The code can be viewed at the GitHub repository,
which also lists the contributor code of conduct:

\url{https://github.com/mikelove/tximeta}
}
\references{
\strong{tximeta} reference:

Michael I. Love, Charlotte Soneson, Peter F. Hickey, Lisa K. Johnson
N. Tessa Pierce, Lori Shepherd, Martin Morgan, Rob Patro (2020)
Tximeta: reference sequence checksums for provenance identification
in RNA-seq. PLOS Computational Biology.
\url{https://doi.org/10.1371/journal.pcbi.1007664}

\strong{tximport} reference (the effective length offset and counts-from-abundance):

Charlotte Soneson, Michael I. Love, Mark D. Robinson (2015)
Differential analyses for RNA-seq: transcript-level estimates
improve gene-level inferences. F1000Research.
\url{http://doi.org/10.12688/f1000research.7563}
}
\author{
Michael I. Love, Charlotte Soneson, Peter Hickey, Rob Patro
}
\keyword{package}
