% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation-package.R
\docType{package}
\name{animation-package}
\alias{animation-package}
\alias{animation}
\title{A Gallery of Animations in Statistics and Utilities to Create Animations}
\description{
This package contains a variety functions for animations in statistics which
could probably aid in teaching statistics and data analysis; it also has
several utilities to export R animations to other formats.
}
\details{
This package mainly makes use of HTML & JavaScript and R windows graphics
devices (such as \code{\link{x11}}) to demonstrate animations in statistics;
other kinds of output such as Flash (SWF) or GIF animations or PDF animations
are also available if required software packages have been installed. See
below for details on each type of animation.
}
\note{
Bug reports and feature requests can be sent to
  \url{https://github.com/yihui/animation/issues}.
}
\section{On-screen Animations}{
 It's natural and easy to create an animation
  in R using the windows graphics device, e.g. in \code{x11()} or
  \code{windows()}. A basic scheme is like the Example 1 (see below).

  On-screen animations do not depend on any third-party software, but the
  rendering speed of the windows graphics devices is often slow, so the
  animation might not be smooth (especially under Linux and Mac OS).
}

\section{HTML Pages}{
 The generation of HTML animation pages does not rely on
  any third-party software either, and we only need a web browser to watch
  the animation. See \code{\link{saveHTML}}.

  The HTML interface is just like a movie player -- it comes with a series of
  buttons to control the animation (play, stop, next, previous, ...).

  This HTML approach is flexible enough to be used even in Rweb, which means
  we do not really have to install R to create animations! There is a demo in
  \code{system.file('misc', 'Rweb', 'demo.html', package = 'animation')}. We
  can use \code{\link{saveHTML}} to create animations directly in Rweb; this
  can be helpful when we do not have R or cannot install R.
}

\section{GIF Animations}{
 If ImageMagick or GraphicsMagick has been installed,
  we can use \code{\link{im.convert}} or \code{\link{gm.convert}} to create a
  GIF animation (combining several R plots together), or use
  \code{\link{saveGIF}} to create a GIF animation from an R code chunk.
}

\section{Flash Animations}{
 If SWF Tools has been installed, we can use
  \code{\link{saveSWF}} to create a Flash animation (again, combining R
  plots).
}

\section{PDF Animations}{
 If LaTeX is present in the system, we can use
  \code{\link{saveLatex}} to insert animations into a PDF document and watch
  the animation using the Adobe reader.

  The animation is created by the LaTeX package \code{animate}.
}

\section{Video}{
 The function \code{\link{saveVideo}} can use FFmpeg to
  convert images to various video formats (e.g. \file{mp4}, \file{avi} and
  \file{wmv}, etc).
}

\references{
Examples at \url{https://yihui.org/animation/example/animation-package/}

  The associated website for this package:
  \url{https://yihui.org/animation}

  Yihui Xie and Xiaoyue Cheng. animation: A package for statistical
  animations. \emph{R News}, \bold{8}(2):23--27, October 2008.  URL:
  \url{https://CRAN.R-project.org/doc/Rnews/Rnews_2008-2.pdf}

  (NB: some functions mentioned in the above article have been slightly
  modified; see the help pages for the up-to-date usage.)

  Yihui Xie (2013). animation: An R Package for Creating Animations and
  Demonstrating Statistical Methods. \emph{Journal of Statistical Software},
  \bold{53}(1), 1-27. URL \doi{10.18637/jss.v053.i01}.
}
\seealso{
\code{\link{saveHTML}}, \code{\link{saveGIF}},
  \code{\link{saveSWF}}, \code{\link{saveVideo}}, \code{\link{saveLatex}}
}
\author{
Yihui Xie
}
